// *****************************************************************************
//
//     Copyright (c) 2019, Pleora Technologies Inc., All rights reserved.
//
// *****************************************************************************

#ifndef __PVH264DECODER_H__
#define __PVH264DECODER_H__

#include <PvCodecLib.h>
#include <PvBuffer.h>


#ifdef WIN32
struct IMFSample;
#endif

namespace PvCodecLib
{
    class IH264Decoder;
}


class PV_CODEC_API PvH264Decoder
{
public:

    PvH264Decoder();
    ~PvH264Decoder();

    bool IsAvailable() const;

    PvResult Reset();
    PvResult Process( const IPvH264AccessUnit *aAccessUnit );
    PvResult Retrieve( PvImage *aImage );
#ifdef WIN32
    PvResult Retrieve( IMFSample *aSample );
#endif

    void GetLastError( PvString &aString ) const;
    void ResetLastError();

private:

    PvCodecLib::IH264Decoder *mThis;

    // Not implemented
    PvH264Decoder( const PvH264Decoder & );
    const PvH264Decoder &operator=( const PvH264Decoder & );

};


#endif
