# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.1.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.



'''
The eBUS Python SDK consists of two main modules, eBUS Receive for Host Applications and eBUS Edge for Sensor Devices.


eBUS Receive for Host Applications

eBUS Receive manages high-speed reception of images or data into buffers for hand-off to the end application for further analysis.
Developers can write applications that run on a host computer to seamlessly control and configure an unlimited number of GigE Vision or USB3 Vision and GenICam compliant sensors.


eBUS Edge for Sensor Devices

eBUS Edge is a software implementation of a full device level GigE Vision transmitter, without requiring any additional hardware.
Adding eBUS Edge to a CPU software stack turns it into a fully compliant GigE Vision device that supports image transmission and enables the device to respond to control requests from a host controller. 
eBUS Edge is GigE Vision and GenICam compliant, meaning end-users can use any standards-compliant third-party image processing system.


Copyright (c) 2023, Pleora Technologies Inc., All rights reserved.
'''




from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _ebus_python
else:
    import _ebus_python

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import weakref

class PvResult(object):
    r"""
    Result information.

    The #PvResult class provides information about the success or failure of the
    methods you use.

    Most successful methods return #PvResult::Code::OK, however, there are exceptions:

    Some methods return immediately, but the ultimate success of the method
    may not be know for some time after (several seconds or more).
    These methods return #PvResult::Code::PENDING. Pending operations are considered successful.

    **To use result codes (best coding practices):**
     - Call a method.
     - Test the result for success. Use #IsSuccess, #IsOK, or test against specific #PvResult::Code values.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*

        Constructor.

        |

        *Overload 2:*

        Constructor intializing the object to a specific status code.

        :type aCode: int, in
        :param aCode: Code to assign to the #PvResult object on construction.

        |

        *Overload 3:*

        Constructor intializing the object to a specific status code and OS code.

        :type aCode: int, in
        :param aCode: Code to assign to the #PvResult object on construction.
        :type aOSCode: int, in
        :param aOSCode: OS code to assign to the #PvResult object on construction.

        |

        *Overload 4:*

        Constructor initializing the object to a specific status code and description.

        :type aCode: int, in
        :param aCode:      Code to assign to the #PvResult object on construction.
        :type aDescription: str, in
        :param aDescription: Description to assign to the #PvResult object on construction.

        |

        *Overload 5:*

        Constructor initializing the object to a specific status code, OS code and description.

        :type aCode: int, in
        :param aCode:        Code to assign to the #PvResult object on construction.
        :type aOSCode: int, in
        :param aOSCode:      OS code to assign to the #PvResult object on construction.
        :type aDescription: str, in
        :param aDescription: Description to assign to the #PvResult object on construction.

        |

        *Overload 6:*

        Copy constructor.

        :type aResult: :py:class:`PvResult`, in
        :param aResult: PvResult used to call the copy constructor.
        """
        _ebus_python.PvResult_swiginit(self, _ebus_python.new_PvResult(*args))
    __swig_destroy__ = _ebus_python.delete_PvResult

    def __eq__(self, *args):
        r"""
        *Overload 1:*

        Equality operator. Returns true if both #PvResult objects contain the same code.

        :type aB: :py:class:`PvResult`, in
        :param aB:

        :rtype: boolean
        :return: True if the result codes are equal; otherwise, false.

        |

        *Overload 2:*

        Equality operator. Returns true if this #PvResult contains aCode.

        :type aCode: int, in
        :param aCode:

        :rtype: boolean
        :return: True if the result codes are equal; otherwise, false.
        """
        return _ebus_python.PvResult___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        *Overload 1:*

        Inequality operator, works on #PvResult objects.
        :type aB: :py:class:`PvResult`, in
        :param aB:

        :rtype: boolean
        :return: True if the result codes *aren't* equal; otherwise, false.

        |

        *Overload 2:*

        Inequality operator, works on this #PvResult and aCode.

        :type aCode: int, in
        :param aCode: The result code.

        :rtype: boolean
        :return: True if the result codes *aren't* equal; otherwise, false.
        """
        return _ebus_python.PvResult___ne__(self, *args)

    def __ior__(self, aB):
        r"""
        Or-equal operator.

        :type aB: :py:class:`PvResult`, in
        :param aB: operand.

        :rtype: :py:class:`PvResult`
        :return: The result of this #PvResult or-ed with aB.
        """
        return _ebus_python.PvResult___ior__(self, aB)

    def SetCode(self, aIn):
        r"""
        Assigns a specific error code to this #PvResult.

        :type aIn: int, in
        :param aIn:    Sets a code for the result.
        """
        return _ebus_python.PvResult_SetCode(self, aIn)

    def GetCode(self):
        r"""
        Get the result code.

        :rtype: int
        :return: The result code.
        """
        return _ebus_python.PvResult_GetCode(self)

    def GetCodeString(self):
        r"""
        Get the result code in the form of a string.

        :rtype: str
        :return: A string that is the direct translation of the result code.
        """
        return _ebus_python.PvResult_GetCodeString(self)

    def GetDescription(self):
        r"""
        Get the result description.

        :rtype: str
        :return: A string that provides human-readable information about the result.
        """
        return _ebus_python.PvResult_GetDescription(self)

    def SetDescription(self, aDescription):
        r"""
        Assigns a specific description to this #PvResult.

        :type aDescription: str, in
        :param aDescription:      Sets a description for the result.
        """
        return _ebus_python.PvResult_SetDescription(self, aDescription)

    def HasDescription(self):
        r"""
        Returns true if the result has a valid description that can be retrieved with #PvResult::GetDescription.

        :rtype: boolean
        :return: True if the result has a valid description.
        """
        return _ebus_python.PvResult_HasDescription(self)

    def IsFailure(self):
        r"""
        Test for a failed result.

        :rtype: boolean
        :return: True if the result is other than PvResult::Code::OK or PvResult::Code::PENDING; otherwise, false.
        """
        return _ebus_python.PvResult_IsFailure(self)

    def IsOK(self):
        r"""
        Test for a successful result

        :rtype: boolean
        :return: True if the result is PvResult::Code::OK; otherwise, false.
        """
        return _ebus_python.PvResult_IsOK(self)

    def IsPending(self):
        r"""
        Test for a pending result.

        :rtype: boolean
        :return: True if the result is PvResult::Code::PENDING; otherwise, false.
        """
        return _ebus_python.PvResult_IsPending(self)

    def IsSuccess(self):
        r"""
        Test for a successful result.

        Methods for testing result codes include:
         - #IsSuccess (this one)
         - #IsFailure
         - #IsOK
         - #IsPending

        :rtype: boolean
        :return: True if the result is PvResult::Code::OK or PvResult::Code::PENDING; otherwise, false.
        """
        return _ebus_python.PvResult_IsSuccess(self)

    def GetInternalCode(self):
        r"""
        Returns the internal error code of the error.

        This method can be used to retrieve the internal error code that was
        mapped to the public error code contained in the PvResult.

        The user is not expected to be able to interpret this error code. It
        can be used in order to provide more information to Pleora support personnel.

        :rtype: int
        :return: Internal error code.
        """
        return _ebus_python.PvResult_GetInternalCode(self)

    def GetOSCode(self):
        r"""
        Retrieves the internal OS code that may have triggered the error.

        The user is not expected to be able to interpret this error code, it can
        widely vary based on the platform or even API that generated it. It can be
        used in order to provide more information to Pleora support personnel.

        :rtype: int
        :return: Internal OS code.
        """
        return _ebus_python.PvResult_GetOSCode(self)

# Register PvResult in _ebus_python:
_ebus_python.PvResult_swigregister(PvResult)
PV_OK = _ebus_python.PV_OK
PV_NOT_INITIALIZED = _ebus_python.PV_NOT_INITIALIZED
PV_NOT_FOUND = _ebus_python.PV_NOT_FOUND
PV_CANNOT_OPEN_FILE = _ebus_python.PV_CANNOT_OPEN_FILE
PV_NO_MORE_ITEM = _ebus_python.PV_NO_MORE_ITEM
PV_NOT_CONNECTED = _ebus_python.PV_NOT_CONNECTED
PV_STATE_ERROR = _ebus_python.PV_STATE_ERROR
PV_THREAD_ERROR = _ebus_python.PV_THREAD_ERROR
PV_INVALID_DATA_FORMAT = _ebus_python.PV_INVALID_DATA_FORMAT
PV_ABORTED = _ebus_python.PV_ABORTED
PV_NOT_ENOUGH_MEMORY = _ebus_python.PV_NOT_ENOUGH_MEMORY
PV_GENERIC_ERROR = _ebus_python.PV_GENERIC_ERROR
PV_INVALID_PARAMETER = _ebus_python.PV_INVALID_PARAMETER
PV_CANCEL = _ebus_python.PV_CANCEL
PV_PENDING = _ebus_python.PV_PENDING
PV_TIMEOUT = _ebus_python.PV_TIMEOUT
PV_NO_LICENSE = _ebus_python.PV_NO_LICENSE
PV_GENICAM_XML_ERROR = _ebus_python.PV_GENICAM_XML_ERROR
PV_CANT_READ_MANIFEST = _ebus_python.PV_CANT_READ_MANIFEST
PV_NOT_IMPLEMENTED = _ebus_python.PV_NOT_IMPLEMENTED
PV_NOT_SUPPORTED = _ebus_python.PV_NOT_SUPPORTED
PV_FILE_ERROR = _ebus_python.PV_FILE_ERROR
PV_ERR_OVERFLOW = _ebus_python.PV_ERR_OVERFLOW
PV_IMAGE_ERROR = _ebus_python.PV_IMAGE_ERROR
PV_MISSING_PACKETS = _ebus_python.PV_MISSING_PACKETS
PV_BUFFER_TOO_SMALL = _ebus_python.PV_BUFFER_TOO_SMALL
PV_TOO_MANY_RESENDS = _ebus_python.PV_TOO_MANY_RESENDS
PV_RESENDS_FAILURE = _ebus_python.PV_RESENDS_FAILURE
PV_TOO_MANY_CONSECUTIVE_RESENDS = _ebus_python.PV_TOO_MANY_CONSECUTIVE_RESENDS
PV_AUTO_ABORTED = _ebus_python.PV_AUTO_ABORTED
PV_BAD_VERSION = _ebus_python.PV_BAD_VERSION
PV_NO_MORE_ENTRY = _ebus_python.PV_NO_MORE_ENTRY
PV_NO_AVAILABLE_DATA = _ebus_python.PV_NO_AVAILABLE_DATA
PV_NETWORK_ERROR = _ebus_python.PV_NETWORK_ERROR
PV_RESYNC = _ebus_python.PV_RESYNC
PV_BUSY = _ebus_python.PV_BUSY
PV_CORRUPTED_DATA = _ebus_python.PV_CORRUPTED_DATA
class PvString(object):
    r""" String class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*

        Default constructor.

        |

        *Overload 2:*

        Copy constructor.

        :type aValue: str, in
        :param aValue: The string you want to initialize this #PvString with.

        |

        *Overload 3:*

        Constructor.

        :type aValue: string, in
        :param aValue: The string you want to initialize this #PvString with.

        |

        *Overload 4:*

        Constructor.

        :type aValue: string, in
        :param aValue: The string you want to initialize this #PvString with.
        :type aN: int, in
        :param aN: The size to resize this #PvString with.

        |

        *Overload 5:*

        Constructor.

        :type aValue: wchar_t, in
        :param aValue: The string you want to initialize this #PvString with.
        """
        _ebus_python.PvString_swiginit(self, _ebus_python.new_PvString(*args))
    __swig_destroy__ = _ebus_python.delete_PvString

    def __iadd__(self, aValue):
        r"""
        Concatenation operator.

        :type aValue: str, in
        :param aValue: The string to be appended to the current string.

        :rtype: str
        :return: This updated #PvString.
        """
        return _ebus_python.PvString___iadd__(self, aValue)

    def __eq__(self, *args):
        r"""
        *Overload 1:*

        Test for equality with a multibyte string.

        Case sensitive.

        :type aValue: string, in
        :param aValue: The The string to compare against.

        :rtype: boolean
        :return: True if the strings are equal; otherwise, false.

        |

        *Overload 2:*

        Test for equality with a unicode string.

        Case sensitive.

        :type aValue: wchar_t, in
        :param aValue: The string to compare against.

        :rtype: boolean
        :return: True if the strings are equal; otherwise, false.

        |

        *Overload 3:*

        Test for equality with another #PvString object.

        Case sensitive.

        :type aValue: str, in
        :param aValue:  The string to compare against.

        :rtype: boolean
        :return: True if the strings are the same; otherwise, false.
        """
        return _ebus_python.PvString___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        *Overload 1:*

        Test for inequality with a multibyte string.

        Case sensitive.

        :type aValue: string, in
        :param aValue: The string to compare against.

        :rtype: boolean
        :return: True if the strings are *not* equal; otherwise, false.

        |

        *Overload 2:*

        Test for inequality with a unicode string.

        Case sensitive.

        :type aValue: wchar_t, in
        :param aValue: The string to compare against.

        :rtype: boolean
        :return: True if the strings are *not* equal; otherwise, false.

        |

        *Overload 3:*

        Test for inequality with another #PvString object.

        Case sensitive.

        :type aValue: str, in
        :param aValue: The string to compare against.

        :rtype: boolean
        :return: True if the strings are *not* equal; otherwise, false.
        """
        return _ebus_python.PvString___ne__(self, *args)

    def GetAscii(self):
        r"""
        Get the string in ASCII format.

        Do not store. Copy the string if needed out of the current context.

        :rtype: string
        :return: The string, converted to ASCII.

        See also: GetUnicode
        """
        return _ebus_python.PvString_GetAscii(self)

    def GetUnicode(self):
        r"""
        Get the string in Unicode format.

        Do not store. Copy the string if needed out of the current context.

        :rtype: wchar_t
        :return: The string, converted to Unicode.

        See also: GetAscii
        """
        return _ebus_python.PvString_GetUnicode(self)

    def GetLength(self):
        r"""
        Get the string's length.

        :rtype: int
        :return: The length of the string, in characters.
        """
        return _ebus_python.PvString_GetLength(self)

    def __str__(self):
        return _ebus_python.PvString___str__(self)

# Register PvString in _ebus_python:
_ebus_python.PvString_swigregister(PvString)
PvLogLevelEnum = _ebus_python.PvLogLevelEnum 
PvLogLevelUnknown = _ebus_python.PvLogLevelUnknown
PvLogLevelInfo = _ebus_python.PvLogLevelInfo
PvLogLevelError = _ebus_python.PvLogLevelError
PvLogLevelWarning = _ebus_python.PvLogLevelWarning
PvLogLevelCritical = _ebus_python.PvLogLevelCritical
PvLogLevelDebug = _ebus_python.PvLogLevelDebug
class PvLogger(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, aCategory):
        _ebus_python.PvLogger_swiginit(self, _ebus_python.new_PvLogger(aCategory))
    __swig_destroy__ = _ebus_python.delete_PvLogger

    def LogInfo(self, aMessage):
        """
        LogInfo(self, aMessage)

        Log at info level.

        :type aMessage: str, in
        :param aMessage: Message to log.
        """
        from sys import _getframe as __swig_getframe
        f = __swig_getframe(1)

        return _ebus_python.PvLogger_LogInfo(self, f.f_code.co_filename, f.f_lineno, f.f_code.co_name, aMessage)



    def LogError(self, aMessage):
        """
        LogError(self, aMessage)

        Log at error level.

        :type aMessage: str, in
        :param aMessage: Message to log.
        """
        from sys import _getframe as __swig_getframe
        f = __swig_getframe(1)
        return _ebus_python.PvLogger_LogError(self, f.f_code.co_filename, f.f_lineno, f.f_code.co_name, aMessage)



    def LogWarning(self, aMessage):
        """
        LogWarning(self, aMessage)

        Log at warning level.

        :type aMessage: str, in
        :param aMessage: Message to log.
        """
        from sys import _getframe as __swig_getframe
        f = __swig_getframe(1)
        return _ebus_python.PvLogger_LogWarning(self, f.f_code.co_filename, f.f_lineno, f.f_code.co_name, aMessage)



    def LogCritical(self, aMessage):
        """
        LogCritical(self, aMessage)

        Log at critical level.

        :type aMessage: str, in
        :param aMessage: Message to log.
        """
        from sys import _getframe as __swig_getframe
        f = __swig_getframe(1)
        return _ebus_python.PvLogger_LogCritical(self, f.f_code.co_filename, f.f_lineno, f.f_code.co_name, aMessage)



    def LogDebug(self, aMessage):
        """
        LogDebug(self, aMessage)

        Log at debug level.

        :type aMessage: str, in
        :param aMessage: Message to log.
        """
        from sys import _getframe as __swig_getframe
        f = __swig_getframe(1)
        return _ebus_python.PvLogger_LogDebug(self, f.f_code.co_filename, f.f_lineno, f.f_code.co_name, aMessage)



    def SetLogPriority(self, aLevel):
        return _ebus_python.PvLogger_SetLogPriority(self, aLevel)

    def GetLogPriority(self):
        return _ebus_python.PvLogger_GetLogPriority(self)

# Register PvLogger in _ebus_python:
_ebus_python.PvLogger_swigregister(PvLogger)
class PvLogSink(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        if self.__class__ == PvLogSink:
            _self = None
        else:
            _self = self
        _ebus_python.PvLogSink_swiginit(self, _ebus_python.new_PvLogSink(_self, ))
    __swig_destroy__ = _ebus_python.delete_PvLogSink

    def Log(self, aLevel, aFile, aLine, aFunction, aCategory, aMessage):
        return _ebus_python.PvLogSink_Log(self, aLevel, aFile, aLine, aFunction, aCategory, aMessage)
    def __disown__(self):
        self.this.disown()
        _ebus_python.disown_PvLogSink(self)
        return weakref.proxy(self)

# Register PvLogSink in _ebus_python:
_ebus_python.PvLogSink_swigregister(PvLogSink)
PVPIXELMONO = _ebus_python.PVPIXELMONO
PVPIXELRGB = _ebus_python.PVPIXELRGB
PVPIXELCOLOR = _ebus_python.PVPIXELCOLOR
PVPIXELCUSTOM = _ebus_python.PVPIXELCUSTOM
PVPIXELCOLORMASK = _ebus_python.PVPIXELCOLORMASK
PVPIXEL1BIT = _ebus_python.PVPIXEL1BIT
PVPIXEL2BIT = _ebus_python.PVPIXEL2BIT
PVPIXEL4BIT = _ebus_python.PVPIXEL4BIT
PVPIXEL8BIT = _ebus_python.PVPIXEL8BIT
PVPIXEL10BIT = _ebus_python.PVPIXEL10BIT
PVPIXEL12BIT = _ebus_python.PVPIXEL12BIT
PVPIXEL14BIT = _ebus_python.PVPIXEL14BIT
PVPIXEL16BIT = _ebus_python.PVPIXEL16BIT
PVPIXEL20BIT = _ebus_python.PVPIXEL20BIT
PVPIXEL24BIT = _ebus_python.PVPIXEL24BIT
PVPIXEL30BIT = _ebus_python.PVPIXEL30BIT
PVPIXEL32BIT = _ebus_python.PVPIXEL32BIT
PVPIXEL36BIT = _ebus_python.PVPIXEL36BIT
PVPIXEL40BIT = _ebus_python.PVPIXEL40BIT
PVPIXEL48BIT = _ebus_python.PVPIXEL48BIT
PVPIXEL64BIT = _ebus_python.PVPIXEL64BIT
PVPIXEL96BIT = _ebus_python.PVPIXEL96BIT
PVBITSPERPIXELMASK = _ebus_python.PVBITSPERPIXELMASK
PVPIXELIDMASK = _ebus_python.PVPIXELIDMASK
PvPixelType = _ebus_python.PvPixelType 
PvPixelUndefined = _ebus_python.PvPixelUndefined
PvPixelMono8 = _ebus_python.PvPixelMono8
PvPixelMono8s = _ebus_python.PvPixelMono8s
PvPixelMono10 = _ebus_python.PvPixelMono10
PvPixelMono10Packed = _ebus_python.PvPixelMono10Packed
PvPixelMono12 = _ebus_python.PvPixelMono12
PvPixelMono12Packed = _ebus_python.PvPixelMono12Packed
PvPixelMono16 = _ebus_python.PvPixelMono16
PvPixelBayerGR8 = _ebus_python.PvPixelBayerGR8
PvPixelBayerRG8 = _ebus_python.PvPixelBayerRG8
PvPixelBayerGB8 = _ebus_python.PvPixelBayerGB8
PvPixelBayerBG8 = _ebus_python.PvPixelBayerBG8
PvPixelBayerGR10 = _ebus_python.PvPixelBayerGR10
PvPixelBayerRG10 = _ebus_python.PvPixelBayerRG10
PvPixelBayerGB10 = _ebus_python.PvPixelBayerGB10
PvPixelBayerBG10 = _ebus_python.PvPixelBayerBG10
PvPixelBayerGR12 = _ebus_python.PvPixelBayerGR12
PvPixelBayerRG12 = _ebus_python.PvPixelBayerRG12
PvPixelBayerGB12 = _ebus_python.PvPixelBayerGB12
PvPixelBayerBG12 = _ebus_python.PvPixelBayerBG12
PvPixelRGB8 = _ebus_python.PvPixelRGB8
PvPixelBGR8 = _ebus_python.PvPixelBGR8
PvPixelRGBa8 = _ebus_python.PvPixelRGBa8
PvPixelBGRa8 = _ebus_python.PvPixelBGRa8
PvPixelRGB10 = _ebus_python.PvPixelRGB10
PvPixelBGR10 = _ebus_python.PvPixelBGR10
PvPixelRGB12 = _ebus_python.PvPixelRGB12
PvPixelBGR12 = _ebus_python.PvPixelBGR12
PvPixelRGB10V1Packed = _ebus_python.PvPixelRGB10V1Packed
PvPixelRGB10p32 = _ebus_python.PvPixelRGB10p32
PvPixelYUV411_8_UYYVYY = _ebus_python.PvPixelYUV411_8_UYYVYY
PvPixelYUV422_8_UYVY = _ebus_python.PvPixelYUV422_8_UYVY
PvPixelYUV8_UYV = _ebus_python.PvPixelYUV8_UYV
PvPixelRGB8_Planar = _ebus_python.PvPixelRGB8_Planar
PvPixelRGB10_Planar = _ebus_python.PvPixelRGB10_Planar
PvPixelRGB12_Planar = _ebus_python.PvPixelRGB12_Planar
PvPixelRGB16_Planar = _ebus_python.PvPixelRGB16_Planar
PvPixelMono14 = _ebus_python.PvPixelMono14
PvPixelBayerGR10Packed = _ebus_python.PvPixelBayerGR10Packed
PvPixelBayerRG10Packed = _ebus_python.PvPixelBayerRG10Packed
PvPixelBayerGB10Packed = _ebus_python.PvPixelBayerGB10Packed
PvPixelBayerBG10Packed = _ebus_python.PvPixelBayerBG10Packed
PvPixelBayerGR12Packed = _ebus_python.PvPixelBayerGR12Packed
PvPixelBayerRG12Packed = _ebus_python.PvPixelBayerRG12Packed
PvPixelBayerGB12Packed = _ebus_python.PvPixelBayerGB12Packed
PvPixelBayerBG12Packed = _ebus_python.PvPixelBayerBG12Packed
PvPixelBayerGR16 = _ebus_python.PvPixelBayerGR16
PvPixelBayerRG16 = _ebus_python.PvPixelBayerRG16
PvPixelBayerGB16 = _ebus_python.PvPixelBayerGB16
PvPixelBayerBG16 = _ebus_python.PvPixelBayerBG16
PvPixelYUV422_8 = _ebus_python.PvPixelYUV422_8
PvPixelRGB16 = _ebus_python.PvPixelRGB16
PvPixelRGB12V1Packed = _ebus_python.PvPixelRGB12V1Packed
PvPixelRGB565p = _ebus_python.PvPixelRGB565p
PvPixelBGR565p = _ebus_python.PvPixelBGR565p
PvPixelMono1p = _ebus_python.PvPixelMono1p
PvPixelMono2p = _ebus_python.PvPixelMono2p
PvPixelMono4p = _ebus_python.PvPixelMono4p
PvPixelYCbCr8_CbYCr = _ebus_python.PvPixelYCbCr8_CbYCr
PvPixelYCbCr422_8 = _ebus_python.PvPixelYCbCr422_8
PvPixelYCbCr411_8_CbYYCrYY = _ebus_python.PvPixelYCbCr411_8_CbYYCrYY
PvPixelYCbCr601_8_CbYCr = _ebus_python.PvPixelYCbCr601_8_CbYCr
PvPixelYCbCr601_422_8 = _ebus_python.PvPixelYCbCr601_422_8
PvPixelYCbCr601_411_8_CbYYCrYY = _ebus_python.PvPixelYCbCr601_411_8_CbYYCrYY
PvPixelYCbCr709_8_CbYCr = _ebus_python.PvPixelYCbCr709_8_CbYCr
PvPixelYCbCr709_422_8 = _ebus_python.PvPixelYCbCr709_422_8
PvPixelYCbCr709_411_8_CbYYCrYY = _ebus_python.PvPixelYCbCr709_411_8_CbYYCrYY
PvPixelYCbCr422_8_CbYCrY = _ebus_python.PvPixelYCbCr422_8_CbYCrY
PvPixelYCbCr601_422_8_CbYCrY = _ebus_python.PvPixelYCbCr601_422_8_CbYCrY
PvPixelYCbCr709_422_8_CbYCrY = _ebus_python.PvPixelYCbCr709_422_8_CbYCrY
PvPixelMono10p = _ebus_python.PvPixelMono10p
PvPixelMono12p = _ebus_python.PvPixelMono12p
PvPixelBGR10p = _ebus_python.PvPixelBGR10p
PvPixelBGR12p = _ebus_python.PvPixelBGR12p
PvPixelBGR14 = _ebus_python.PvPixelBGR14
PvPixelBGR16 = _ebus_python.PvPixelBGR16
PvPixelBGRa10 = _ebus_python.PvPixelBGRa10
PvPixelBGRa10p = _ebus_python.PvPixelBGRa10p
PvPixelBGRa12 = _ebus_python.PvPixelBGRa12
PvPixelBGRa12p = _ebus_python.PvPixelBGRa12p
PvPixelBGRa14 = _ebus_python.PvPixelBGRa14
PvPixelBGRa16 = _ebus_python.PvPixelBGRa16
PvPixelRGB10p = _ebus_python.PvPixelRGB10p
PvPixelBayerBG10p = _ebus_python.PvPixelBayerBG10p
PvPixelBayerBG12p = _ebus_python.PvPixelBayerBG12p
PvPixelBayerGB10p = _ebus_python.PvPixelBayerGB10p
PvPixelBayerGB12p = _ebus_python.PvPixelBayerGB12p
PvPixelBayerGR10p = _ebus_python.PvPixelBayerGR10p
PvPixelBayerGR12p = _ebus_python.PvPixelBayerGR12p
PvPixelBayerRG10p = _ebus_python.PvPixelBayerRG10p
PvPixelBayerRG12p = _ebus_python.PvPixelBayerRG12p
PvPixelYCbCr411_8 = _ebus_python.PvPixelYCbCr411_8
PvPixelYCbCr8 = _ebus_python.PvPixelYCbCr8
PvPixelRGB12p = _ebus_python.PvPixelRGB12p
PvPixelRGB14 = _ebus_python.PvPixelRGB14
PvPixelRGBa10 = _ebus_python.PvPixelRGBa10
PvPixelRGBa10p = _ebus_python.PvPixelRGBa10p
PvPixelRGBa12 = _ebus_python.PvPixelRGBa12
PvPixelRGBa12p = _ebus_python.PvPixelRGBa12p
PvPixelRGBa14 = _ebus_python.PvPixelRGBa14
PvPixelRGBa16 = _ebus_python.PvPixelRGBa16
PvPixelYCbCr422_10 = _ebus_python.PvPixelYCbCr422_10
PvPixelYCbCr422_12 = _ebus_python.PvPixelYCbCr422_12
PvPixelSCF1WBWG8 = _ebus_python.PvPixelSCF1WBWG8
PvPixelSCF1WBWG10 = _ebus_python.PvPixelSCF1WBWG10
PvPixelSCF1WBWG10p = _ebus_python.PvPixelSCF1WBWG10p
PvPixelSCF1WBWG12 = _ebus_python.PvPixelSCF1WBWG12
PvPixelSCF1WBWG12p = _ebus_python.PvPixelSCF1WBWG12p
PvPixelSCF1WBWG14 = _ebus_python.PvPixelSCF1WBWG14
PvPixelSCF1WBWG16 = _ebus_python.PvPixelSCF1WBWG16
PvPixelSCF1WGWB8 = _ebus_python.PvPixelSCF1WGWB8
PvPixelSCF1WGWB10 = _ebus_python.PvPixelSCF1WGWB10
PvPixelSCF1WGWB10p = _ebus_python.PvPixelSCF1WGWB10p
PvPixelSCF1WGWB12 = _ebus_python.PvPixelSCF1WGWB12
PvPixelSCF1WGWB12p = _ebus_python.PvPixelSCF1WGWB12p
PvPixelSCF1WGWB14 = _ebus_python.PvPixelSCF1WGWB14
PvPixelSCF1WGWB16 = _ebus_python.PvPixelSCF1WGWB16
PvPixelSCF1WGWR8 = _ebus_python.PvPixelSCF1WGWR8
PvPixelSCF1WGWR10 = _ebus_python.PvPixelSCF1WGWR10
PvPixelSCF1WGWR10p = _ebus_python.PvPixelSCF1WGWR10p
PvPixelSCF1WGWR12 = _ebus_python.PvPixelSCF1WGWR12
PvPixelSCF1WGWR12p = _ebus_python.PvPixelSCF1WGWR12p
PvPixelSCF1WGWR14 = _ebus_python.PvPixelSCF1WGWR14
PvPixelSCF1WGWR16 = _ebus_python.PvPixelSCF1WGWR16
PvPixelSCF1WRWG8 = _ebus_python.PvPixelSCF1WRWG8
PvPixelSCF1WRWG10 = _ebus_python.PvPixelSCF1WRWG10
PvPixelSCF1WRWG10p = _ebus_python.PvPixelSCF1WRWG10p
PvPixelSCF1WRWG12 = _ebus_python.PvPixelSCF1WRWG12
PvPixelSCF1WRWG12p = _ebus_python.PvPixelSCF1WRWG12p
PvPixelSCF1WRWG14 = _ebus_python.PvPixelSCF1WRWG14
PvPixelSCF1WRWG16 = _ebus_python.PvPixelSCF1WRWG16
PvPixelYCbCr10_CbYCr = _ebus_python.PvPixelYCbCr10_CbYCr
PvPixelYCbCr10p_CbYCr = _ebus_python.PvPixelYCbCr10p_CbYCr
PvPixelYCbCr12_CbYCr = _ebus_python.PvPixelYCbCr12_CbYCr
PvPixelYCbCr12p_CbYCr = _ebus_python.PvPixelYCbCr12p_CbYCr
PvPixelYCbCr422_10p = _ebus_python.PvPixelYCbCr422_10p
PvPixelYCbCr422_12p = _ebus_python.PvPixelYCbCr422_12p
PvPixelYCbCr601_10_CbYCr = _ebus_python.PvPixelYCbCr601_10_CbYCr
PvPixelYCbCr601_10p_CbYCr = _ebus_python.PvPixelYCbCr601_10p_CbYCr
PvPixelYCbCr601_12_CbYCr = _ebus_python.PvPixelYCbCr601_12_CbYCr
PvPixelYCbCr601_12p_CbYCr = _ebus_python.PvPixelYCbCr601_12p_CbYCr
PvPixelYCbCr601_422_10 = _ebus_python.PvPixelYCbCr601_422_10
PvPixelYCbCr601_422_10p = _ebus_python.PvPixelYCbCr601_422_10p
PvPixelYCbCr601_422_12 = _ebus_python.PvPixelYCbCr601_422_12
PvPixelYCbCr601_422_12p = _ebus_python.PvPixelYCbCr601_422_12p
PvPixelYCbCr709_10_CbYCr = _ebus_python.PvPixelYCbCr709_10_CbYCr
PvPixelYCbCr709_10p_CbYCr = _ebus_python.PvPixelYCbCr709_10p_CbYCr
PvPixelYCbCr709_12_CbYCr = _ebus_python.PvPixelYCbCr709_12_CbYCr
PvPixelYCbCr709_12p_CbYCr = _ebus_python.PvPixelYCbCr709_12p_CbYCr
PvPixelYCbCr709_422_10 = _ebus_python.PvPixelYCbCr709_422_10
PvPixelYCbCr709_422_10p = _ebus_python.PvPixelYCbCr709_422_10p
PvPixelYCbCr709_422_12 = _ebus_python.PvPixelYCbCr709_422_12
PvPixelYCbCr709_422_12p = _ebus_python.PvPixelYCbCr709_422_12p
PvPixelYCbCr422_10_CbYCrY = _ebus_python.PvPixelYCbCr422_10_CbYCrY
PvPixelYCbCr422_10p_CbYCrY = _ebus_python.PvPixelYCbCr422_10p_CbYCrY
PvPixelYCbCr422_12_CbYCrY = _ebus_python.PvPixelYCbCr422_12_CbYCrY
PvPixelYCbCr422_12p_CbYCrY = _ebus_python.PvPixelYCbCr422_12p_CbYCrY
PvPixelYCbCr601_422_10_CbYCrY = _ebus_python.PvPixelYCbCr601_422_10_CbYCrY
PvPixelYCbCr601_422_10p_CbYCrY = _ebus_python.PvPixelYCbCr601_422_10p_CbYCrY
PvPixelYCbCr601_422_12_CbYCrY = _ebus_python.PvPixelYCbCr601_422_12_CbYCrY
PvPixelYCbCr601_422_12p_CbYCrY = _ebus_python.PvPixelYCbCr601_422_12p_CbYCrY
PvPixelYCbCr709_422_10_CbYCrY = _ebus_python.PvPixelYCbCr709_422_10_CbYCrY
PvPixelYCbCr709_422_10p_CbYCrY = _ebus_python.PvPixelYCbCr709_422_10p_CbYCrY
PvPixelYCbCr709_422_12_CbYCrY = _ebus_python.PvPixelYCbCr709_422_12_CbYCrY
PvPixelYCbCr709_422_12p_CbYCrY = _ebus_python.PvPixelYCbCr709_422_12p_CbYCrY
PvPixelBiColorRGBG8 = _ebus_python.PvPixelBiColorRGBG8
PvPixelBiColorBGRG8 = _ebus_python.PvPixelBiColorBGRG8
PvPixelBiColorRGBG10 = _ebus_python.PvPixelBiColorRGBG10
PvPixelBiColorRGBG10p = _ebus_python.PvPixelBiColorRGBG10p
PvPixelBiColorBGRG10 = _ebus_python.PvPixelBiColorBGRG10
PvPixelBiColorBGRG10p = _ebus_python.PvPixelBiColorBGRG10p
PvPixelBiColorRGBG12 = _ebus_python.PvPixelBiColorRGBG12
PvPixelBiColorRGBG12p = _ebus_python.PvPixelBiColorRGBG12p
PvPixelBiColorBGRG12 = _ebus_python.PvPixelBiColorBGRG12
PvPixelBiColorBGRG12p = _ebus_python.PvPixelBiColorBGRG12p
PvPixelCoord3D_A8 = _ebus_python.PvPixelCoord3D_A8
PvPixelCoord3D_B8 = _ebus_python.PvPixelCoord3D_B8
PvPixelCoord3D_C8 = _ebus_python.PvPixelCoord3D_C8
PvPixelCoord3D_ABC8 = _ebus_python.PvPixelCoord3D_ABC8
PvPixelCoord3D_ABC8_Planar = _ebus_python.PvPixelCoord3D_ABC8_Planar
PvPixelCoord3D_AC8 = _ebus_python.PvPixelCoord3D_AC8
PvPixelCoord3D_AC8_Planar = _ebus_python.PvPixelCoord3D_AC8_Planar
PvPixelCoord3D_A16 = _ebus_python.PvPixelCoord3D_A16
PvPixelCoord3D_B16 = _ebus_python.PvPixelCoord3D_B16
PvPixelCoord3D_C16 = _ebus_python.PvPixelCoord3D_C16
PvPixelCoord3D_ABC16 = _ebus_python.PvPixelCoord3D_ABC16
PvPixelCoord3D_ABC16_Planar = _ebus_python.PvPixelCoord3D_ABC16_Planar
PvPixelCoord3D_AC16 = _ebus_python.PvPixelCoord3D_AC16
PvPixelCoord3D_AC16_Planar = _ebus_python.PvPixelCoord3D_AC16_Planar
PvPixelCoord3D_A32f = _ebus_python.PvPixelCoord3D_A32f
PvPixelCoord3D_B32f = _ebus_python.PvPixelCoord3D_B32f
PvPixelCoord3D_C32f = _ebus_python.PvPixelCoord3D_C32f
PvPixelCoord3D_ABC32f = _ebus_python.PvPixelCoord3D_ABC32f
PvPixelCoord3D_ABC32f_Planar = _ebus_python.PvPixelCoord3D_ABC32f_Planar
PvPixelCoord3D_AC32f = _ebus_python.PvPixelCoord3D_AC32f
PvPixelCoord3D_AC32f_Planar = _ebus_python.PvPixelCoord3D_AC32f_Planar
PvPixelConfidence1 = _ebus_python.PvPixelConfidence1
PvPixelConfidence1p = _ebus_python.PvPixelConfidence1p
PvPixelConfidence8 = _ebus_python.PvPixelConfidence8
PvPixelConfidence16 = _ebus_python.PvPixelConfidence16
PvPixelConfidence32f = _ebus_python.PvPixelConfidence32f
PvPixelR8 = _ebus_python.PvPixelR8
PvPixelR10 = _ebus_python.PvPixelR10
PvPixelR12 = _ebus_python.PvPixelR12
PvPixelR16 = _ebus_python.PvPixelR16
PvPixelG8 = _ebus_python.PvPixelG8
PvPixelG10 = _ebus_python.PvPixelG10
PvPixelG12 = _ebus_python.PvPixelG12
PvPixelG16 = _ebus_python.PvPixelG16
PvPixelB8 = _ebus_python.PvPixelB8
PvPixelB10 = _ebus_python.PvPixelB10
PvPixelB12 = _ebus_python.PvPixelB12
PvPixelB16 = _ebus_python.PvPixelB16
PvPixelCoord3D_A10p = _ebus_python.PvPixelCoord3D_A10p
PvPixelCoord3D_B10p = _ebus_python.PvPixelCoord3D_B10p
PvPixelCoord3D_C10p = _ebus_python.PvPixelCoord3D_C10p
PvPixelCoord3D_A12p = _ebus_python.PvPixelCoord3D_A12p
PvPixelCoord3D_B12p = _ebus_python.PvPixelCoord3D_B12p
PvPixelCoord3D_C12p = _ebus_python.PvPixelCoord3D_C12p
PvPixelCoord3D_ABC10p = _ebus_python.PvPixelCoord3D_ABC10p
PvPixelCoord3D_ABC10p_Planar = _ebus_python.PvPixelCoord3D_ABC10p_Planar
PvPixelCoord3D_ABC12p = _ebus_python.PvPixelCoord3D_ABC12p
PvPixelCoord3D_ABC12p_Planar = _ebus_python.PvPixelCoord3D_ABC12p_Planar
PvPixelCoord3D_AC10p = _ebus_python.PvPixelCoord3D_AC10p
PvPixelCoord3D_AC10p_Planar = _ebus_python.PvPixelCoord3D_AC10p_Planar
PvPixelCoord3D_AC12p = _ebus_python.PvPixelCoord3D_AC12p
PvPixelCoord3D_AC12p_Planar = _ebus_python.PvPixelCoord3D_AC12p_Planar
PvPixelMono14p = _ebus_python.PvPixelMono14p
PvPixelBayerGR14p = _ebus_python.PvPixelBayerGR14p
PvPixelBayerRG14p = _ebus_python.PvPixelBayerRG14p
PvPixelBayerGB14p = _ebus_python.PvPixelBayerGB14p
PvPixelBayerBG14p = _ebus_python.PvPixelBayerBG14p
PvPixelBayerGR14 = _ebus_python.PvPixelBayerGR14
PvPixelBayerRG14 = _ebus_python.PvPixelBayerRG14
PvPixelBayerGB14 = _ebus_python.PvPixelBayerGB14
PvPixelBayerBG14 = _ebus_python.PvPixelBayerBG14
PvPixelBayerGR4p = _ebus_python.PvPixelBayerGR4p
PvPixelBayerRG4p = _ebus_python.PvPixelBayerRG4p
PvPixelBayerGB4p = _ebus_python.PvPixelBayerGB4p
PvPixelBayerBG4p = _ebus_python.PvPixelBayerBG4p
PvPixelMono32 = _ebus_python.PvPixelMono32

def PvGetPixelBitCount(aType):
    r"""
    Returns the size of one pixel of a specific pixel type, in bits.

    :type aType: int, in
    :param aType:  GigE Vision pixel type. See Enum #PvPixelType.

    :rtype: int
    :return: Size, in bits
    """
    return _ebus_python.PvGetPixelBitCount(aType)
PvPayloadType = _ebus_python.PvPayloadType 
PvPayloadTypeUndefined = _ebus_python.PvPayloadTypeUndefined
PvPayloadTypeNone = _ebus_python.PvPayloadTypeNone
PvPayloadTypeImage = _ebus_python.PvPayloadTypeImage
PvPayloadTypeRawData = _ebus_python.PvPayloadTypeRawData
PvPayloadTypeFile = _ebus_python.PvPayloadTypeFile
PvPayloadTypeChunkData = _ebus_python.PvPayloadTypeChunkData
PvPayloadTypeExtendedChunkData = _ebus_python.PvPayloadTypeExtendedChunkData
PvPayloadTypeJPEG = _ebus_python.PvPayloadTypeJPEG
PvPayloadTypeJPEG2000 = _ebus_python.PvPayloadTypeJPEG2000
PvPayloadTypeH264 = _ebus_python.PvPayloadTypeH264
PvPayloadTypeMultiZoneImage = _ebus_python.PvPayloadTypeMultiZoneImage
PvPayloadTypeMultiPart = _ebus_python.PvPayloadTypeMultiPart
PvPayloadTypeDeviceSpecificBase = _ebus_python.PvPayloadTypeDeviceSpecificBase
PvPayloadTypePleoraCompressed = _ebus_python.PvPayloadTypePleoraCompressed
class IPvChunkData(object):
    r""" Generic chunk data interface."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_IPvChunkData

    def ResetChunks(self):
        r"""
        See #PvBuffer::ResetChunks

        Same as PvBuffer equivalent. Provided with this interface for convenience.
        """
        return _ebus_python.IPvChunkData_ResetChunks(self)

    def AddChunk(self, aID, aData):
        r"""
        AddChunk(self, aID, aData) -> PvResult
        Add chunk data to the buffer payload section by specifying the ID of the chunk data.
        See :func:`PvBuffer.ResetChunks` for more information.

        :type aID: int, in
        :param aID: Chunk data ID for aIndex.
        :type aData: python bytes object, in
        :param aData: Payload data of the chunk data. Python bytes object. 

        :rtype: :py:class:`PvResult`
        :returns: 
            A PvResult is used to capture the success or failure of the operation:
             - :py:const:`~PvResultCode.PV_OK`
             - :py:const:`~PvResultCode.PV_BUFFER_TOO_SMALL` There is not enough space in the buffer to add the chunk data.
             - :py:const:`~PvResultCode.PV_INVALID_PARAMETER` One of the input arguments is invalid.

        """
        return _ebus_python.IPvChunkData_AddChunk(self, aID, aData)

    def SetChunkLayoutID(self, aChunkLayoutID):
        r"""
        Set the chunk data layout ID.

        :type aChunkLayoutID: int, in
        :param aChunkLayoutID: Chunk data layout ID.
        """
        return _ebus_python.IPvChunkData_SetChunkLayoutID(self, aChunkLayoutID)

    def HasChunks(self):
        r"""
        Returns true if the buffer has data chunks.

        Unlike GetChunkCount, chunks do not need to be parsed or resolved
        with this method.

        :rtype: boolean
        :return: True if the buffer holds data chunks, false if not.
        """
        return _ebus_python.IPvChunkData_HasChunks(self)

    def GetChunkCount(self):
        r"""
        See #PvBuffer::GetChunkCount.

        Same as PvBuffer equivalent. Provided with this interface for convenience.

        :rtype: int
        :return: Data chunks count. 0 if no chunks are available.
        """
        return _ebus_python.IPvChunkData_GetChunkCount(self)

    def GetChunkIDByIndex(self, aIndex):
        r"""
        GetChunkIDByIndex(self, aIndex) -> PvResult, int
        Returns a tuple of PvResult and the ID of a chunk based on its index.

        If the index is out of range or the PvBuffer does not have any data chunk, 0 is returned in ID.

        :type aIndex: int, in
        :param aIndex: Data chunk Index.

        :rtype:  Tuple(:py:class:`PvResult`, int)
        :returns:  
            Tuple composed of (result, chunkID):
             - PvResult representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_NOT_FOUND` if the index is out of range or the buffer does not have any chunks
             - chunkID: 
                - Chunk ID.

        """
        return _ebus_python.IPvChunkData_GetChunkIDByIndex(self, aIndex)

    def GetChunkSizeByIndex(self, aIndex):
        r"""
        See #PvBuffer::GetChunkSizeByIndex.

        Same as PvBuffer equivalent. Provided with this interface for convenience.

        :type aIndex: int, in
        :param aIndex: Data chunk index.

        :rtype: int
        :return: Data chunk size. 0 if the index is out of range.
        """
        return _ebus_python.IPvChunkData_GetChunkSizeByIndex(self, aIndex)

    def GetChunkSizeByID(self, aID):
        r"""
        See #PvBuffer::GetChunkSizeByID.

        Same as PvBuffer equivalent. Provided with this interface for convenience.

        :type aID: int, in
        :param aID: Data chunk ID.

        :rtype: int
        :return: Data chunk size. 0 if the chunk ID is not found.
        """
        return _ebus_python.IPvChunkData_GetChunkSizeByID(self, aID)

    def GetChunkRawDataByIndex(self, aIndex):
        r"""
        GetChunkRawDataByIndex(self, aIndex) -> ndarray
        See PvBuffer::GetChunkRawDataByIndex.
        Same as PvBuffer equivalent. Provided with this interface for convenience.

        :type aIndex: int, in
        :param aIndex: Data chunk index.

        :rtype: ndarray
        :returns: A 1-dimensional python numpy array with dtype np.uint8 describing the chunk data. Empty if the index is out of range.

        """
        return _ebus_python.IPvChunkData_GetChunkRawDataByIndex(self, aIndex)

    def GetChunkRawDataByID(self, aID):
        r"""
        GetChunkRawDataByIndex(self, aIndex) -> ndarray
        See :func:`PvBuffer.GetChunkRawDataByIndex`.
        Same as PvBuffer equivalent. Provided with this interface for convenience.

        :type aIndex: int, in
        :param aIndex: Data chunk index.

        :rtype: ndarray
        :returns: A 1-dimensional python numpy array with dtype np.uint8 describing the chunk data. Empty if the index is out of range.

        """
        return _ebus_python.IPvChunkData_GetChunkRawDataByID(self, aID)

    def GetChunkLayoutID(self):
        r"""
        Get the chunk data layout ID.

        :rtype: int
        :return: The current chunk data layout ID.
        """
        return _ebus_python.IPvChunkData_GetChunkLayoutID(self)

    def GetChunkDataSize(self):
        r"""
        Returns the current chunk data size.

        In a transmission context this method returns how many bytes are used for extra chunk data.
        It includes the chunk headers for all chunk data and if applicable the chunk header
        for the main chunk (typically the image).

        This method has no use in a reception context where the data receiver delivers the buffer.
        Use either the direct chunk access methods or the GenApi interface of the device to
        access chunk data.

        :rtype: int
        :return: Chunk data size in bytes.
        """
        return _ebus_python.IPvChunkData_GetChunkDataSize(self)

    def GetChunkDataCapacity(self):
        r"""
        Returns the current chunk data capacity.

        In a transmission context where you create the buffer, memory is allocated for
        chunks. This method returns how many bytes can still be added as chunk data.

        One chunk is always made of 8-bytes of headers plus the chunk data length. You
        also need to reserve another 8-bytes for the main chunk (typically the image) unless
        you buffer only contains chunk data.

        This method has no use in a reception context where the data receiver delivers the buffer.
        Use either the direct chunk access methods or the GenApi interface of the device to
        access chunk data.

        :rtype: int
        :return: Chunk data capacity.
        """
        return _ebus_python.IPvChunkData_GetChunkDataCapacity(self)

# Register IPvChunkData in _ebus_python:
_ebus_python.IPvChunkData_swigregister(IPvChunkData)
class PvChunkData(IPvChunkData):
    r"""
    Raw data interface to a PvBuffer.

    A #PvBuffer represents a generic buffer with no specific payload type. If the payload type
    is chunk data, the user can obtain a pointer to a PvChunkData buffer interface through #PvBuffer::GetChunkData.

    This #PvChunkData pointer is owned by the PvBuffer and does not need to be released
    after use. It is valid as long as the PvBuffer exists.

    To use in a receiver context, retrieve PvBuffer from PvStream or PvPipeline and when #PvBuffer::GetPayloadType
    is PvPayloadChunkData use #PvBuffer::GetChunkData to retrieve a pointer to this interface. Use the various
    chunk methods in this class to access the chunk data by ID or index or alternatively attach the PvBuffer
    to the GenApi interface of the transmitter with #PvGenParameterArray::AttachDataChunks to access the chunk data
    using GenApi.

    To use in a transmitter context, create a PvBuffer, set its payload type to PvPayloadChunkData with SetPayloadType,
    use #PvBuffer::GetChunkData to retrieve a point to this interface, use PvChunkData::Alloc to allocate enough
    memory for all chunks and their headers (64 bytes per chunk for the headers) and then add chunks to the buffer
    using #PvChunkData::AddChunk. Use PvTransmitterGEV to transmit the buffer.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_PvChunkData

    def GetChunkDataPayloadLength(self):
        r"""
        Get the chunk data payload length specified in the trailer information of this block.

        :rtype: int
        :return: The payload length specified in the trailer information of this block.
        """
        return _ebus_python.PvChunkData_GetChunkDataPayloadLength(self)

    def Alloc(self, aMaximumChunkLength):
        r"""
        Allocates memory for this #PvChunkData.

        Allocs a PvChunkData of specific payload length. No extra data can or need to be priovisioned
        for chunks as the whole payload is made of chunks.

        :type aMaximumChunkLength: int, in
        :param aMaximumChunkLength: Maximum size in bytes to store chunk data (must include extra 64 bits for each chunk header).

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_ENOUGH_MEMORY
        """
        return _ebus_python.PvChunkData_Alloc(self, aMaximumChunkLength)

    def Free(self):
        r""" Frees (de-allocates) the buffer's internal memory."""
        return _ebus_python.PvChunkData_Free(self)

    def Attach(self, aRawBuffer):
        r"""
        Attach(self, aRawBuffer) -> PvResult
        Attach this :py:class:`PvChunkData` to an external memory buffer.

        :type aRawBuffer: ndarray, in
        :param aRawBuffer: A 1-dimensional python numpy array with dtype np.uint8 to use as a buffer.

        :rtype: :py:class:`PvResult`
        :returns: 
            Includes:
             - :py:const:`~PvResultCode.PV_OK`
             - :py:const:`~PvResultCode.PV_INVALID_PARAMETER`

        See also: Detach

        """
        return _ebus_python.PvChunkData_Attach(self, aRawBuffer)

    def Detach(self):
        r"""
        Detach(self) -> ndarray
        Releases an attached memory buffer.
        Does nothing other then resetting the memory buffer pointer to NULL.

        :rtype: ndarray
        :returns: The previously attached numpy array. See :py:func:`PvChunkData.Attach`.

        See also: Attach

        """
        return _ebus_python.PvChunkData_Detach(self)

# Register PvChunkData in _ebus_python:
_ebus_python.PvChunkData_swigregister(PvChunkData)
class PvRawData(object):
    r"""
    Raw data interface to a PvBuffer.

    A #PvBuffer represents a generic buffer with no specific payload type. If the payload type
    is raw data, the user can obtain a pointer to a PvRawData buffer interface through #PvBuffer::GetRawData.

    This #PvRawData pointer is owned by the PvBuffer and does not need to be released
    after use. It is valid as long as the PvBuffer exists.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_PvRawData

    def GetPayloadLength(self):
        r"""
        Get the payload length specified in the leader information of this block

        If you wish to construct a buffer with payload type "Raw Data",
        simply call #PvRawData::Alloc or #PvRawData::Attach and the payload length field
        will be set automatically at the time the block is transmitted.

        :rtype: int
        :return: The payload length specified in the leader information of this block
        """
        return _ebus_python.PvRawData_GetPayloadLength(self)

    def Alloc(self, aPayloadLength, aMaximumChunkLength=0):
        r"""
        Allocates memory for this #PvRawData.

        Allocs a PvRawData of specific payload length

        :type aPayloadLength: int, in
        :param aPayloadLength:        The payload length of the raw data, in pixels. See #GetPayloadLength.
        :type aMaximumChunkLength: int, in, optional
        :param aMaximumChunkLength:   Maximum size in bytes to store chunks ( must include extra 64 bits by chunks for headers ).

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_ENOUGH_MEMORY
        """
        return _ebus_python.PvRawData_Alloc(self, aPayloadLength, aMaximumChunkLength)

    def Free(self):
        r"""
        Frees (de-allocates) the buffer's internal memory.

        See also: Alloc
        """
        return _ebus_python.PvRawData_Free(self)

    def Attach(self, aRawBuffer, aMaximumChunkLength=0):
        r"""
        Attach(self, aRawBuffer, aMaximumChunkLength) -> PvResultAttach(self, aRawBuffer, aMaximumChunkLength) -> PvResult
        Attach this :py:class:`PvRawData` to an external memory buffer.

        :type aRawBuffer: ndarray, in
        :param aRawBuffer: A 1-dimensional python numpy array with dtype np.uint8 to use as a raw buffer.
        :type aMaximumChunkLength: int, in
        :param aMaximumChunkLength: Maximum size in bytes to store chunks ( must include extra 64 bits by chunks for headers ).

        :rtype: :py:class:`PvResult`
        :returns: 
            Includes:
             - :py:const:`~PvResultCode.PV_NOT_FOUND`
             - :py:const:`~PvResultCode.PV_INVALID_PARAMETER`

        """
        return _ebus_python.PvRawData_Attach(self, aRawBuffer, aMaximumChunkLength)

    def Detach(self):
        r"""
        Detach(self) -> ndarray
        Releases an attached memory buffer.

        Does nothing other then resetting the memory buffer pointer to NULL.

        :rtype: ndarray
        :returns: The previously attached numpy array. See :py:func:`PvRawData.Attach`.

        See also: :func:`PvRawData.Attach`

        """
        return _ebus_python.PvRawData_Detach(self)

# Register PvRawData in _ebus_python:
_ebus_python.PvRawData_swigregister(PvRawData)
class IPvImage(object):
    r""" Generic image interface."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_IPvImage

    def GetDataPointer(self, *args):
        r"""
        GetDataPointer(self) -> ndarray
        Get the numpy aray describing the image's data.

        The GetDataPointer method returns a numpy array describing the buffer.
        The number of channels determine the dimensions, the dtype of the ndarray is determined by the number of bits per pixel.

         - Any packed pixel format (10 bits/pixel, 12 bits/pixel... etc) is described as a 1-dimensional numpy array with dtype np.uint8. The user is in charge of unpacking if needed.
         - Unpacked Mono and Bayer images are described as a 2-dimensional numpy array with shape (height,width), the dtype of the array is either np.uint8 or np.uint16 based on the actual bits/pixel.
         - Unpacked RGB, YUV or YCbCr images are described as a 3-dimensional numpy array with shape (height, width, channels), the dtype of the array is either np.uint8 or np.uint16.
           For example, PvPixelYUV422_8_UYVY has shape (height, width, 2) with dtype np.uint8, PvPixelYCbCr8_CbYCr has shape (height, width, 3) with dtype np.uint8, PvPixelBGR16 has shape (height, width, 3) with dtype np.uint16.

        :rtype: ndarray
        :returns: A numpy array pointing to the image data.

        """
        return _ebus_python.IPvImage_GetDataPointer(self, *args)

    def GetImageSize(self):
        r"""
        Actual image size within the payload or buffer.

        Uses the GEV leader for the actual width.
        Uses the GEV trailer for line count which is the actual height.

        :rtype: int
        :return: The actual image size within the payload or buffer
        """
        return _ebus_python.IPvImage_GetImageSize(self)

    def GetWidth(self):
        r"""
        Get the image's width.

        :rtype: int
        :return: The image's width in pixels.
        """
        return _ebus_python.IPvImage_GetWidth(self)

    def GetHeight(self):
        r"""
        Get the image's height.

        :rtype: int
        :return: The image's height, in pixels.
        """
        return _ebus_python.IPvImage_GetHeight(self)

    def GetPixelType(self):
        r"""
        The buffer's pixel type.

        :rtype: int
        :return: The pixel type. The pixel depth, colorspace, and other information are coded into the value.
        """
        return _ebus_python.IPvImage_GetPixelType(self)

    def GetBitsPerPixel(self):
        r"""
        Returns how many bits are required to hold a pixel using the current buffer's pixel type

        :rtype: int
        :return: Bits per pixel for the current buffer's pixel type.
        """
        return _ebus_python.IPvImage_GetBitsPerPixel(self)

    def GetOffsetX(self):
        r"""
        Get the image's horizontal offset.

        :rtype: int
        :return: The image's horizontal offset, in pixels.
        """
        return _ebus_python.IPvImage_GetOffsetX(self)

    def GetOffsetY(self):
        r"""
        Get the image's vertical offset.

        :rtype: int
        :return: The image's vertical offset, in pixels.
        """
        return _ebus_python.IPvImage_GetOffsetY(self)

    def GetPaddingX(self):
        r"""
        Get the horizontal image padding.

        Images lines could be grabbed in increments of, let's say, 32 bytes. For an image 511 bytes across,
        the video interface adds a meaningless byte to make the line total 512 bytes (divisible by 32).
        In this case, the *paddingX* value would be 1 (byte).

        Other devices may have different requirements on line length. Divible by 4, 8, 16, etc.
        or no specific limitations or requirements.

        :rtype: int
        :return: The horizontal image padding, in bytes; the number of bytes at the end of an image's line
                    that contain meaningless data.
        """
        return _ebus_python.IPvImage_GetPaddingX(self)

    def GetPaddingY(self):
        r"""
        Get the vertical image padding.

        Additional bytes appended at the end of an image.

        See #GetPaddingX.

        :rtype: int
        :return: The vertical image padding, in bytes.

        See also: GetPaddingX
        """
        return _ebus_python.IPvImage_GetPaddingY(self)

    def GetBlockID(self):
        r"""
        Return the block ID.

        This method returns the block ID. The GigE Vision or USB3 Vision transmitter typically increments
        the value by 1 for each new image. You can use this value to ensure the
        blocks are in order and that none are missing. The value is unsigned and wraps
        around to 1 (skipping 0) when it reaches 65536.

        :rtype: int
        :return: The block ID
        """
        return _ebus_python.IPvImage_GetBlockID(self)

    def GetTimestamp(self):
        r"""
        Get the image's timestamp.

        With hardware timestamps and GigE Vision devices, the device defines the timestamp tick frequency. The effective value
        can be retrieved from the GenApi interface of the device.

        With hardware timestamps and USB3 Vision devices, timestamps are always defined in nanoseconds.

        With software timestamps the timestamps are in micro seconds.

        Use the PvStream GenApi interface to configure whether hardware or software time stamps are used.

        :rtype: int
        :return: The image's hardware timestamp; For Pleora devices, this is the value of the relative
            timestamp clock when the grabber began receiving data from the camera head - on the rising edge of the FVAL.
        """
        return _ebus_python.IPvImage_GetTimestamp(self)

    def GetReceptionTime(self):
        r"""
        Get the buffer's reception timestamp.

        :rtype: int
        :return: The buffer's reception time on the host, in micro seconds. Not an absolute time value.
        """
        return _ebus_python.IPvImage_GetReceptionTime(self)

# Register IPvImage in _ebus_python:
_ebus_python.IPvImage_swigregister(IPvImage)
class PvImage(IPvImage):
    r"""
    Image interface to a PvBuffer.

    A #PvBuffer represents a generic buffer with no specific payload type. If the payload type
    is image, the user can obtain a pointer to a PvImage buffer interface through #PvBuffer::GetImage.

    This #PvImage pointer is owned by the PvBuffer and does not need to be released
    after use. It is valid as long as the PvBuffer exists.

    ##  id="accessing"Accessing image specific data

    **To determinate the payload type and access image specific data:**
        - Retrieve the #PvPayloadType using #PvBuffer::GetPayloadType
        - If #PvPayloadType is PvPayloadTypeImage, retrieve #PvImage pointer from your #PvBuffer
        - Access image specific data through the #PvImage pointer, like #PvImage::GetWidth, #PvImage::GetHeight, etc.
        - There is no need to release or delete the #PvImage pointer. It is valid as long as the #PvBuffer exists.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def GetMaximumChunkLength(self):
        r"""
        Returns the maximum chunk length possible for the currently allocated memory vs image attributes.

        :rtype: int
        :return: Maximum chunk length, in bytes.
        """
        return _ebus_python.PvImage_GetMaximumChunkLength(self)

    @staticmethod
    def GetPixelSize(aPixelType):
        r"""
        Static method returning the pixel size in bits for a specific pixel type

        :type aPixelType: int, in
        :param aPixelType: Pixel type.

        :rtype: int
        :return: Pixel size, in bits.
        """
        return _ebus_python.PvImage_GetPixelSize(aPixelType)

    @staticmethod
    def IsPixelColor(aPixelType):
        r"""
        Static method returning whether a pixel type is color or not

        :type aPixelType: int, in
        :param aPixelType: Pixel type.

        :rtype: boolean
        :return: True if color.
        """
        return _ebus_python.PvImage_IsPixelColor(aPixelType)

    @staticmethod
    def IsPixelHighRes(aPixelType):
        r"""
        Static method returning whether a pixel type is higher than 8-bit per channel or not

        10, 12, 14 and 16-bit pixel type are considered high resolution. RGB8 counts as 8 so
        high resolution here means per channel.

        :type aPixelType: int, in
        :param aPixelType: Pixel type.

        :rtype: boolean
        :return: True if higher than 8 bit per channel.
        """
        return _ebus_python.PvImage_IsPixelHighRes(aPixelType)

    @staticmethod
    def GetBitsPerComponent(aPixelType):
        r"""
        Static method returning the number of bit per components for a pixel type.

        PvPixelMono8 and PvPixelRGBa8 would be 8. Mono16, PvPixelRGB16, PvPixelBayerRG16
        would be 16, etc.

        :type aPixelType: int, in
        :param aPixelType: Pixel type.

        :rtype: int
        :return: True if higher than 8 bit per channel.
        """
        return _ebus_python.PvImage_GetBitsPerComponent(aPixelType)

    @staticmethod
    def PixelTypeToString(aPixelType):
        r"""
        Static method returning a string representation of a pixel type.

        :type aPixelType: int, in
        :param aPixelType: Pixel type.

        :rtype: str
        :return: String representation of the pixel type.
        """
        return _ebus_python.PvImage_PixelTypeToString(aPixelType)

    def GetRequiredSize(self):
        r"""
        Gets the size of buffer required to hold the acquired image.

        This attribute is valid if the last image acquisition was successful or if it
        failed because the buffer was too small. It can be used to re-allocate the acquisition
        buffers if the acquisition failed because the buffer was too small.

        The required size is only computed for the last image - based on the number
        of lines as provided in the GigE Vision or USB3 Vision streaming protocol trailer.

        It is possible that with devices outputting images of varying length (like line
        scan cameras) that the last image required size may be smaller than the maximum
        possible size.

        In order to be 100% sure of allocating buffers correctly, you should either hard code
        the buffer size to known big enough sizes or use the device GenICam GevPayloadSize
        parameter for dynamic cases.

        :rtype: int
        :return: The size, in bytes, required to hold the image in this buffer.
        """
        return _ebus_python.PvImage_GetRequiredSize(self)

    def GetEffectiveImageSize(self):
        r"""
        Effective image size.

        Uses same size x and y as GetImageSize() but excludes all padding.

        :rtype: int
        :return: The effective image size
        """
        return _ebus_python.PvImage_GetEffectiveImageSize(self)

    def SetOffsetX(self, aValue):
        r"""
        Sets the Offset X attribute of the image.

        :type aValue: int, in
        :param aValue: New value.
        """
        return _ebus_python.PvImage_SetOffsetX(self, aValue)

    def SetOffsetY(self, aValue):
        r"""
        Sets the Offset X attribute of the image.

        :type aValue: int, in
        :param aValue: New value.
        """
        return _ebus_python.PvImage_SetOffsetY(self, aValue)

    def IsAllocated(self):
        return _ebus_python.PvImage_IsAllocated(self)

    def IsAttached(self):
        return _ebus_python.PvImage_IsAttached(self)

    def Alloc(self, aSizeX, aSizeY, aPixelType, aPaddingX=0, aPaddingY=0, aMaximumChunkLength=0):
        r"""
        Allocates memory for this #PvImage.

        Allocs a PvImage of specific width, height and pixel format

        :type aSizeX: int, in
        :param aSizeX: The width of the image, in pixels. See #GetWidth.
        :type aSizeY: int, in
        :param aSizeY: The height of the image, in pixels. See #GetHeight.
        :type aPixelType: int, in
        :param aPixelType: The GEV pixel type from which the pixel depth is extracted. For supported pixel types, see PvPixelType.h.
        :type aPaddingX: int, in, optional
        :param aPaddingX: The horizontal padding of the image, in pixels. See #GetPaddingX.
        :type aPaddingY: int, in, optional
        :param aPaddingY: The vertical padding of the image, in pixels. See #GetPaddingY.
        :type aMaximumChunkLength: int, in, optional
        :param aMaximumChunkLength: The chunk size in bytes.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_ENOUGH_MEMORY
        """
        return _ebus_python.PvImage_Alloc(self, aSizeX, aSizeY, aPixelType, aPaddingX, aPaddingY, aMaximumChunkLength)

    def Free(self):
        r"""
        Frees (de-allocates) the buffer's internal memory.

        See also: Alloc
        """
        return _ebus_python.PvImage_Free(self)

    def Attach(self, aRawBuffer, aPixelType, aPaddingX=0, aPaddingY=0, aMaximumChunkLength=0):
        r"""
        Attach(self, aRawBuffer, aPixelType, aPaddingX, aPaddingY, aMaximumChunkLength) -> PvResultAttach(self, aRawBuffer, aPixelType, aPaddingX, aPaddingY, aMaximumChunkLength) -> PvResultAttach(self, aRawBuffer, aPixelType, aPaddingX, aPaddingY, aMaximumChunkLength) -> PvResultAttach(self, aRawBuffer, aPixelType, aPaddingX, aPaddingY, aMaximumChunkLength) -> PvResult
        Attach this :py:class:`PvImage` to an external memory buffer.

        :type aRawBuffer: ndarray, in
        :param aRawBuffer: A numpy ndarray of 2-D (height, width) or 3-D (height, width, channels) to use as an image buffer.
        :type aPixelType: PvPixelType, in
        :param aPixelType: See :func:`PvBuffer.Alloc`.
        :type aPaddingX: int, in
        :param aPaddingX: See :func:`PvBuffer.Alloc`.
        :type aPaddingY: int, in
        :param aPaddingY: See :func:`PvBuffer.Alloc`.
        :type aMaximumChunkLength: int, in
        :param aMaximumChunkLength: See :func:`PvBuffer.Alloc`.

        :rtype: :py:class:`PvResult`
        :returns: 
            Includes:
             - :py:const:`~PvResultCode.PV_NOT_FOUND`
             - :py:const:`~PvResultCode.PV_INVALID_PARAMETER`

        """
        return _ebus_python.PvImage_Attach(self, aRawBuffer, aPixelType, aPaddingX, aPaddingY, aMaximumChunkLength)

    def Detach(self):
        r"""
        Detach(self) -> ndarray
        Releases an attached memory buffer.

        Does nothing other then resetting the memory buffer pointer to NULL.

        :rtype: ndarray
        :returns: The previously attached numpy array. See :py:func:`PvImage.Attach`.

        See also: Attach

        """
        return _ebus_python.PvImage_Detach(self)

    def IsPartialLineMissing(self):
        r"""
        If true, the grabber (on the device) was missing at least one pixel in at least one of the lines when the frame was grabbed.

        :rtype: boolean
        :return: True if at least one pixel was missing, false otherwise
        """
        return _ebus_python.PvImage_IsPartialLineMissing(self)

    def IsFullLineMissing(self):
        r"""
        If true, the grabber (on the device) was missing at least one line when the frame was grabbed.

        :rtype: boolean
        :return: True if full lines were missing, false otherwise
        """
        return _ebus_python.PvImage_IsFullLineMissing(self)

    def SetEOFByLineCount(self, aValue=True):
        r"""
        Simulates the EOFByLineCount used by Pleora video interfaces.

        :type aValue: boolean, in, optional
        :param aValue:      True to enable, false to disable
        """
        return _ebus_python.PvImage_SetEOFByLineCount(self, aValue)

    def IsEOFByLineCount(self):
        r"""
        End of Frame by Line Count status bit.

        :rtype: boolean
        :return: True if previous frame was NOT the last one of a sequence of sub frames. False otherwise.
        """
        return _ebus_python.PvImage_IsEOFByLineCount(self)

    def IsInterlacedEven(self):
        r"""
        The image contained in the #PvImage is an interlaced Even field.

        :rtype: boolean
        :return: True interlaced Even field. False otherwise.
        """
        return _ebus_python.PvImage_IsInterlacedEven(self)

    def IsInterlacedOdd(self):
        r"""
        The image contained in the #PvImage is an interlaced Odd field.

        :rtype: boolean
        :return: True interlaced Odd field. False otherwise.
        """
        return _ebus_python.PvImage_IsInterlacedOdd(self)

    def IsImageDropped(self):
        r"""
        Image dropped status bit.

        :rtype: boolean
        :return: True if the previous frame was dropped. False otherwise.
        """
        return _ebus_python.PvImage_IsImageDropped(self)

    def IsDataOverrun(self):
        r"""
        Data overrun status bit.

        :rtype: boolean
        :return: True if there was a data overrun. False otherwise.
        """
        return _ebus_python.PvImage_IsDataOverrun(self)

    def GetBuffer(self):
        r"""
        Returns the PvBuffer this PvImage belongs to.

        :rtype: :py:class:`PvBuffer`
        :return: Pointer to a PvBuffer.
        """
        return _ebus_python.PvImage_GetBuffer(self)

    def HasWatermark(self):
        r"""
        Returns the watermark tag.

        A watermark is applied onto the image if the system is not provided with a valid eBUS receiver license.

        Use this method to check if a watermark was applied to the image or not.

        :rtype: boolean
        :return: The watermark tag.
        """
        return _ebus_python.PvImage_HasWatermark(self)
    __swig_destroy__ = _ebus_python.delete_PvImage

# Register PvImage in _ebus_python:
_ebus_python.PvImage_swigregister(PvImage)
class PvBuffer(IPvChunkData):
    r"""
    Represents a block of GigE Vision or USB3 Vision data in memory

    A PvBuffer object is typically used to receive data from a GigE Vision or USB3 Vision transmitter or to transmit data to a GigE Vision receiver.
    To learn about receiving data from a GigE Vision or USB3 Vision transmitter, see #PvStream.
    To learn about transmitting GigE Vision data to a GigE Vision receiver, see #PvTransmitterGEV.

    A block of GigE Vision or USB3 Vision data has an associated payload which can be an image, raw data, file, chunk data, extended chunk data or device specific.

    In order to access the payload specific data, use methods like #PvBuffer::GetImage in order to get a pointer
    to an interface giving you access to payload specific methods and properties.

    The current payload type of a #PvBuffer can be determined by using the #PvBuffer::GetPayloadType method.

    In this section:
        - Creating and configuring buffers ("#configuring")
        - Accessing payload type specific data ("#accessing")
        - Processing images ("#processing")

    ##  id="configuring"Creating and configuring buffers

    **To create and configure buffers:**
        - Create several buffers using the default constructor.
        - Set the size of the buffer. The method you use depends on whether you want to use
            an internally or externally controlled block of memory:
            - To use memory that the #PvBuffer object allocates and owns, use #Alloc.
            - To use memory that you control (external to the #PvBuffer object), use  #Attach.

    ##  id="accessing"Accessing payload type specific data

    **To determine the payload type and access payload type specific data:**
        - Retrieve the #PvPayloadType using #PvBuffer::GetPayloadType
        - If #PvPayloadType is #PvPayloadTypeImage, retrieve #PvImage pointer from your #PvBuffer
        - Access image specific data through the #PvImage pointer, like #PvImage::GetWidth, #PvImage::GetHeight, etc.
        - There is no need to release or delete the #PvImage pointer. It is valid as long as the #PvBuffer exists.

    ##  id="processing"Processing images

    **To process an image:**
        - Retrieve a #PvImage interface to the buffer use #GetImage
        - Test the success of the image acquisition. Use the *aOperationResult* parameter in #PvStream::RetrieveBuffer or #PvBuffer::GetOperationResult
        - Process the image using your own code. You may process the image in place, if you wish. Use:
            - #PvImage::GetAcquiredSize
            - #PvImage::GetHeight and #PvImage::GetWidth
            - #PvImage::GetOffsetX and #PvImage::GetOffsetY
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, aPayloadType=PvPayloadTypeImage):
        r"""
        Constructor.

        :type aPayloadType: int, in, optional
        :param aPayloadType: The block type (default PvPayloadTypeImage).
        """
        _ebus_python.PvBuffer_swiginit(self, _ebus_python.new_PvBuffer(aPayloadType))
    __swig_destroy__ = _ebus_python.delete_PvBuffer

    def GetPayloadType(self):
        r"""
        Returns the payload type currently used by the buffer

        If data chunks are available, the buffer payload type is the same as if no data chunks
        were available. Use GetChunkCount to determine if chunks are available.

        :rtype: int
        :return: PvPayloadType The current payload type for the #PvBuffer. See #PvPayloadType enum.
        """
        return _ebus_python.PvBuffer_GetPayloadType(self)

    def GetImage(self, *args):
        r"""
        *Overload 1:*

        Returns the #PvImage interface to the buffer.

        If the payload type of the #PvBuffer is PvPayloadTypeImage, a pointer to
        the #PvImage interface of the buffer is returned.

        If the payload type of the #PvBuffer is NOT PvPayloadTypeImage, a NULL
        pointer is returned.

        This #PvImage pointer is owned by the PvBuffer and does not need to be released
        after use. It is valid as long as the PvBuffer exists.

        :rtype: :py:class:`PvImage`
        :return: Pointer to #PvImage interface or NULL, depending on payload type.

        |

        *Overload 2:*

        Returns the #PvImage interface to the buffer.

        Const version.

        :rtype: :py:class:`PvImage`
        :return: Pointer to #PvImage interface or NULL, depending on payload type.
        """
        return _ebus_python.PvBuffer_GetImage(self, *args)

    def GetRawData(self, *args):
        r"""
        *Overload 1:*

        Returns the #PvRawData interface to the buffer.

        If the payload type of the #PvBuffer is PvPayloadTypeRawData, a pointer to
        the #PvRawData interface of the buffer is returned.

        If the payload type of the #PvBuffer is NOT PvPayloadTypeRawData, a NULL
        pointer is returned.

        This #PvRawData pointer is owned by the PvBuffer and does not need to be released
        after use. It is valid as long as the PvBuffer exists.

        :rtype: :py:class:`PvRawData`
        :return: Pointer to #PvRawData interface or NULL, depending on payload type.

        |

        *Overload 2:*

        Returns the #PvRawData interface to the buffer.

        Const version.

        :rtype: :py:class:`PvRawData`
        :return: Pointer to #PvRawData interface or NULL, depending on payload type.
        """
        return _ebus_python.PvBuffer_GetRawData(self, *args)

    def GetPleoraCompressed(self, *args):
        r"""
        *Overload 1:*

        Returns the #PvPleoraCompressed interface to the buffer.

        If the payload type of the #PvBuffer is PvPayloadTypePleoraCompressed, a pointer to
        the #PvPleoraCompressed interface of the buffer is returned.

        If the payload type of the #PvBuffer is NOT PvPayloadTypePleoraCompressed, a NULL
        pointer is returned.

        This #PvPleoraCompressed pointer is owned by the PvBuffer and does not need to be released
        after use. It is valid as long as the PvBuffer exists.

        :rtype: PvPleoraCompressed
        :return: Pointer to #PvPleoraCompressed interface or NULL, depending on payload type.

        |

        *Overload 2:*

        Returns the #PvPleoraCompressed interface to the buffer.

        Const version.

        :rtype: PvPleoraCompressed
        :return: Pointer to #PvPleoraCompressed interface or NULL, depending on payload type.
        """
        return _ebus_python.PvBuffer_GetPleoraCompressed(self, *args)

    def GetChunkData(self, *args):
        r"""
        *Overload 1:*

        Returns the #PvChunkData interface to the buffer.

        If the payload type of the #PvBuffer is PvPayloadTypeChunkData, a pointer to
        the #PvChunkData interface of the buffer is returned.

        If the payload type of the #PvBuffer is NOT PvPayloadTypeChunkData, a NULL
        pointer is returned.

        This #PvChunkData pointer is owned by the PvBuffer and does not need to be released
        after use. It is valid as long as the PvBuffer exists.

        :rtype: :py:class:`PvChunkData`
        :return: Pointer to #PvChunkData interface or NULL, depending on payload type.

        |

        *Overload 2:*

        Returns the #PvChunkData interface to the buffer.

        Const version.

        :rtype: :py:class:`PvChunkData`
        :return: Pointer to #PvChunkData interface or NULL, depending on payload type.
        """
        return _ebus_python.PvBuffer_GetChunkData(self, *args)

    def GetMultiPartContainer(self, *args):
        r"""
        *Overload 1:*

        Returns the #PvChunkData interface to the buffer.

        If the payload type of the #PvBuffer is PvPayloadTypeCunkData, a pointer to
        the #PvChunkData interface of the buffer is returned.

        If the payload type of the #PvBuffer is NOT PvPayloadTypeChunkData, a NULL
        pointer is returned.

        This #PvChunkData pointer is owned by the PvBuffer and does not need to be released
        after use. It is valid as long as the PvBuffer exists.

        :rtype: :py:class:`IPvMultiPartContainer`
        :return: Pointer to #PvChunkData interface or NULL, depending on payload type.

        |

        *Overload 2:*

        Returns the #PvChunkData interface to the buffer.

        Const version.

        :rtype: :py:class:`IPvMultiPartContainer`
        :return: Pointer to #PvChunkData interface or NULL, depending on payload type.
        """
        return _ebus_python.PvBuffer_GetMultiPartContainer(self, *args)

    def GetH264AccessUnit(self, *args):
        r"""
        *Overload 1:*

        Returns the #IPvH264AccessUnit interface to the buffer.

        If the payload type of the #PvBuffer is PvPayloadTypeH264, a pointer to
        the #IPvH264AccessUnit interface of the buffer is returned.

        If the payload type of the #PvBuffer is NOT #IPvH264AccessUnit, a NULL
        pointer is returned.

        This #IPvH264AccessUnit pointer is owned by the PvBuffer and does not need to be released
        after use. It is valid as long as the PvBuffer exists.

        :rtype: IPvH264AccessUnit
        :return: Pointer to #IPvH264AccessUnit interface or NULL, depending on payload type.

        |

        *Overload 2:*

        Returns the #IPvH264AccessUnit interface to the buffer.

        Const version.

        :rtype: IPvH264AccessUnit
        :return: Pointer to #IPvH264AccessUnit interface or NULL, depending on payload type.
        """
        return _ebus_python.PvBuffer_GetH264AccessUnit(self, *args)

    def GetDataPointer(self, *args):
        r"""
        GetDataPointer(self) -> ndarray
        Get the numpy array describing the buffer data.

        The GetDataPointer method returns a numpy array describing the buffer data. To set
        the memory location, use :func:`PvBuffer.Alloc` or :func:`PvBuffer.Attach`.

        :rtype: ndarray
        :returns: A 1-dimensional python numpy array with dtype np.uint8 describing the buffer data.

        """
        return _ebus_python.PvBuffer_GetDataPointer(self, *args)

    def GetID(self):
        r"""
        Get the buffer's ID.

        See #SetID.

        :rtype: int
        :return: The buffer's ID. See #SetID.
        """
        return _ebus_python.PvBuffer_GetID(self)

    def SetID(self, aValue):
        r"""
        Set the buffer's ID.

        The #SetID method lets you assign an arbitrary number to a buffer. When you retrieve the buffer
        later, you can also recover the number you assigned.

        The ID is completely arbitrary and solely available for your own use. It can be useful to
        keep track of buffers in an application.

        :param aID: The buffer's ID.
        """
        return _ebus_python.PvBuffer_SetID(self, aValue)

    def IsExtendedID(self):
        r"""
        Check if the buffer is currently in extended ID mode.

        When the extended ID mode is not enabled, the maximum block ID is 0xFFFFFF
        and the maximum packet ID is 0xFFFFFF as per the GEV 1.X specification.
        When the extended ID mode is enabled, the maximum block ID is 0xFFFFFFFFFFFFFFFF
        and the maximum packet ID is 0xFFFFFFFF as per the GEV 2.X specification.

        When a PvBuffer is received, the extended ID mode is initialized based on the information
        received by #PvStream. When a PvBuffer is sent, the extended ID mode will be initialized by
        the #PvTransmitterGEV::PvTransmitterGEV according to its configuration.

        :rtype: boolean
        :return: true if the extended if mode is in usage:
        """
        return _ebus_python.PvBuffer_IsExtendedID(self)

    def IsAttached(self):
        r"""
        Returns true if the buffer has been attached (instead of allocated)

        :rtype: boolean
        :return: True if attached.
        """
        return _ebus_python.PvBuffer_IsAttached(self)

    def IsAllocated(self):
        r"""
        Returns true if the buffer has been attached (instead of attached)

        :rtype: boolean
        :return: True if allocated.
        """
        return _ebus_python.PvBuffer_IsAllocated(self)

    def GetAcquiredSize(self):
        r"""
        Gets the size in bytes of the block received by the data receiver including, if present, additional chunk data and headers, optional padding.

        :rtype: int
        :return: The size, in bytes, of bytes received for this buffer.
        """
        return _ebus_python.PvBuffer_GetAcquiredSize(self)

    def GetRequiredSize(self):
        r"""
        Gets the size of buffer required to hold the acquired block including, if present, additional chunk data and headers, padding.

        :rtype: int
        :return: The size, in bytes, required to hold the block in this buffer.
        """
        return _ebus_python.PvBuffer_GetRequiredSize(self)

    def GetSize(self):
        r"""
        Get the buffer's allocated or attached size (total capacity) in bytes.

        :rtype: int
        :return: The buffer's (allocated or attached) size in bytes
        """
        return _ebus_python.PvBuffer_GetSize(self)

    def Reset(self, aPayloadType=PvPayloadTypeImage):
        r"""
        Reconstruct the object with a new payload type.

        :type aPayloadType: int, in, optional
        :param aPayloadType: The payload type to reset the buffer to.

        :rtype: :py:class:`PvResult`
        :return: #PvResult::Code::OK if successful.
        """
        return _ebus_python.PvBuffer_Reset(self, aPayloadType)

    def Alloc(self, aSize):
        r"""
        Allocates memory for this #PvBuffer.

        :type aSize: int, in
        :param aSize:  The size of the buffer, in bytes.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_ENOUGH_MEMORY
        """
        return _ebus_python.PvBuffer_Alloc(self, aSize)

    def AllocChunk(self, aSize):
        r"""
        Alloc a separate space for chunk data in this #PvBuffer.

        Designed for use when attaching external data buffers that cannot
        be resized to accomodate chunk data.

        :type aSize: int, in
        :param aSize:    The size, in bytes, required for the buffer.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER

        See also: FreeChunk
        """
        return _ebus_python.PvBuffer_AllocChunk(self, aSize)

    def Free(self):
        r"""
        Frees (de-allocates) the buffer's internal memory.

        See also: Alloc
        """
        return _ebus_python.PvBuffer_Free(self)

    def FreeChunk(self):
        r"""
        Frees (de-allocates) an attached memory buffer of chunk data.

        See also: AllocChunk
        """
        return _ebus_python.PvBuffer_FreeChunk(self)

    def Attach(self, aBuffer):
        r"""
        Attach(self, aBuffer) -> PvResult
        Attach this :py:class:`PvBuffer` to an external memory buffer.

        To use an internal memory buffer, use :func:`PvBuffer.Alloc`.

        :type aBuffer: ndarray, in
        :param aBuffer: A 1-dimensional python numpy array with dtype np.uint8 to use as a buffer.

        :rtype: :py:class:`PvResult`
        :returns: 
            Includes:
             - :py:const:`~PvResultCode.PV_OK`
             - :py:const:`~PvResultCode.PV_INVALID_PARAMETER`

        See also: Detach

        """
        return _ebus_python.PvBuffer_Attach(self, aBuffer)

    def Detach(self):
        r"""
        Detach(self) -> ndarray
        Releases an attached memory buffer.
        Does nothing other then resetting the memory buffer pointer to NULL.

        :rtype: ndarray
        :returns: The previously attached numpy array. See :py:func:`PvBuffer.Attach`.

        See also: Attach

        """
        return _ebus_python.PvBuffer_Detach(self)

    def GetBlockID(self):
        r"""
        Return the block ID.

        This method returns the block ID. The GigE Vision or USB3 Vision transmitter typically increments
        the value by 1 for each new image. You can use this value to ensure the
        blocks are in order and that none are missing. The value is unsigned and wraps
        around to 1 (skipping 0) when it reaches 65536 (for legacy 16bit Block ID mode)
        or 2^64 (for 64 bit Extended Block ID mode).

        :rtype: int
        :return: The block ID
        """
        return _ebus_python.PvBuffer_GetBlockID(self)

    def GetOperationResult(self):
        r"""
        Returns the value of aOperationResult when this buffer was last received through a PvStream.

        Buffers with BUFFER_TOO_SMALL, ABORTED, NOT_CONNECTED and NO_MORE_ITEM operation results are never returned to
        the user with PvPipeline. PvPipeline handles these operation results internally without returning the buffers.
        Buffers with these operation results can only reach the user when using PvStream directly.

        :rtype: :py:class:`PvResult`
        :return: 
               Result of the acquisition operation; Includes:
                - #PvResult::Code::NOT_INITIALIZED
                - #PvResult::Code::OK
                - #PvResult::Code::TIMEOUT
                - #PvResult::Code::ABORTED
                - #PvResult::Code::MISSING_PACKETS
                - #PvResult::Code::BUFFER_TOO_SMALL:
                - #PvResult::Code::IMAGE_ERROR for images with grabber issues like data overrun or missing lines (complete or partial)
                - #PvResult::Code::RESENDS_FAILURE
                - #PvResult::Code::TOO_MANY_RESENDS
                - #PvResult::Code::TOO_MANY_CONSECUTIVE_RESENDS
                - #PvResult::Code::INVALID_DATA_FORMAT
                - #PvResult::Code::AUTO_ABORTED
                - #PvResult::Code::ERR_OVERFLOW

        See also: #PvStream::RetrieveBuffer, #PvPipeline::RetrieveNextBuffer
        """
        return _ebus_python.PvBuffer_GetOperationResult(self)

    def GetTimestamp(self):
        r"""
        Get the buffer's timestamp.

        With hardware timestamps and GigE Vision devices, the device defines the timestamp tick frequency. The effective value
        can be retrieved from the GenApi interface of the device.

        With hardware timestamps and USB3 Vision devices, timestamps are always defined in nanoseconds.

        With software timestamps the timestamps are in micro seconds.

        Use the PvStream GenApi interface to configure whether hardware or software time stamps are used.

        :rtype: int
        :return: The buffer's hardware timestamp; For Pleora devices, this is the value of the relative
            timestamp clock when the grabber began receiving data from the camera head - on the rising edge of the FVAL.
        """
        return _ebus_python.PvBuffer_GetTimestamp(self)

    def GetReceptionTime(self):
        r"""
        Get the buffer's reception timestamp.

        :rtype: int
        :return: The buffer's reception time on the host, in micro seconds. Not an absolute time value.
        """
        return _ebus_python.PvBuffer_GetReceptionTime(self)

    def GetDuration(self):
        r"""
        Get the buffer's duration.

        Buffer duration when applicable. Typically used by stream decoders to control
        frame rate of a sequence of frames.

        :rtype: int
        :return: Buffer duration.
        """
        return _ebus_python.PvBuffer_GetDuration(self)

    def SetTimestamp(self, aTimestamp):
        r"""
        Set the timestamp to place in the block leader.

        When transmitting blocks to a GigE Vision receiver, by default, the timestamp on outgoing blocks is zero.
        However, the calling application may set a timestamp on the outgoing blocks if desired by calling #SetTimestamp.

        :type aTimestamp: int
        :param aTimestamp: The timestamp to set in the block leader

        :rtype: :py:class:`PvResult`
        :return: #PvResult::Code::OK if successful.
        """
        return _ebus_python.PvBuffer_SetTimestamp(self, aTimestamp)

    def SetDuration(self, aDuration):
        r"""
        Set the duration of the buffer in the context of a stream.

        :type aDuration: int, in
        :param aDuration: Duration of the buffer.

        :rtype: :py:class:`PvResult`
        :return: #PvResult::Code::OK if successful.
        """
        return _ebus_python.PvBuffer_SetDuration(self, aDuration)

    def SetBlockID(self, aBlockID):
        r"""
        Sets the block ID of a buffer.

        Should only be used for creating synthetic test PvBuffers or copies of a PvBuffer which caries
        some information over from the original.

        :type aBlockID: int
        :param aBlockID: Block ID to assign to the buffer.

        :rtype: :py:class:`PvResult`
        :return: #PvResult::Code::OK if successful.
        """
        return _ebus_python.PvBuffer_SetBlockID(self, aBlockID)

    def SetReceptionTime(self, aReceptionTime):
        r"""
        Sets the reception time of a buffer.

        Should only be used for creating synthetic test PvBuffers or copies of a PvBuffer which caries
        some information over from the original.

        :type aReceptionTime: int
        :param aReceptionTime: Reception tiome to assign to the buffer.

        :rtype: :py:class:`PvResult`
        :return: #PvResult::Code::OK if successful.
        """
        return _ebus_python.PvBuffer_SetReceptionTime(self, aReceptionTime)

    def GetPacketsRecoveredCount(self):
        r"""
        The number of lost packets successfully recovered  by packet resend requests. Duplicate received packets are not counted.

        :rtype: int
        :return: The expected resend count
        """
        return _ebus_python.PvBuffer_GetPacketsRecoveredCount(self)

    def GetPacketsRecoveredSingleResendCount(self):
        r"""
        The number of lost packets successfully recovered  by packet resend requests without any resend request retries.

        :rtype: int
        :return: The expected resend count
        """
        return _ebus_python.PvBuffer_GetPacketsRecoveredSingleResendCount(self)

    def GetResendGroupRequestedCount(self):
        r"""
        The number of resend requests issued by the data receiver.

        :rtype: int
        :return: The resend requested count
        """
        return _ebus_python.PvBuffer_GetResendGroupRequestedCount(self)

    def GetResendPacketRequestedCount(self):
        r"""
        The number of packets the data receiver requests with ResendGroupRequested.

        :rtype: int
        :return: The received resend requested packet count
        """
        return _ebus_python.PvBuffer_GetResendPacketRequestedCount(self)

    def GetLostPacketCount(self):
        r"""
        Packets that were not successfully delivered when this PvBuffer was filled by the data receiver.

        :rtype: int
        :return: The lost packet count
        """
        return _ebus_python.PvBuffer_GetLostPacketCount(self)

    def GetIgnoredPacketCount(self):
        r"""
        Packets received that were ignored when this buffer was filled by the data receiver.

        :rtype: int
        :return: The ignored packet count
        """
        return _ebus_python.PvBuffer_GetIgnoredPacketCount(self)

    def GetRedundantPacketCount(self):
        r"""
        Number of packets received more than once

        :rtype: int
        :return: The redundant packet count
        """
        return _ebus_python.PvBuffer_GetRedundantPacketCount(self)

    def GetPacketOutOfOrderCount(self):
        r"""
        Number of packets received out of order

        :rtype: int
        :return: The packet out of order count
        """
        return _ebus_python.PvBuffer_GetPacketOutOfOrderCount(self)

    def GetMissingPacketIdsCount(self):
        r"""
        GetMissingPacketIdsCount() -> PvResult, int
        Get the number of missing packet groups that represent unpopulated areas of memory in this buffer

        Notes: This is an advanced feature that requires knowledge of how GigE Vision data is transmitted.

        Does not apply to USB3 Vision devices which do not have the concept of packet resends.

        When receiving data from a GigE Vision transmitter, network conditions may prevent the successful delivery
        of all the data for a given block. Although the eBUS data receiver provides a mechanism for requesting
        lost packets, there are cases when it is desirable to ignore missing packets and make use of a buffer that
        contains missing information. In some cases, there are portions of a block that are less important and can thus
        be disregarded. #GetMissingPacketIdsCount and #GetMissingPacketIds can provide information about
        which packets were lost. To use this feature take note of the following procedure:

            - Enable the feature that causes the data receiver to keep track of missing packets
                (see the EnableMissingPacketsList property of #PvStream).
            - Optionally disable the mechanism that requests lost packets
                (see the RequestMissingPackets property of #PvStream).
            - Check the operation result when a new block is received (see #PvBuffer::GetOperationResult).
            - If the operation result is #PvResult::Code::MISSING_PACKETS, call #GetMissingPacketIdsCount to determine how many groups of packets are missing.
            - Iterate through the missing packet groups using #GetMissingPacketIds.
            - Note that there is no particular order to the missing packet groups that are returned.
            - Take note of the packet size set on the GigE Vision transmitter from which you are receiving
                to determine the areas of the payload where information is missing.

        :rtype:  Tuple(:py:class:`PvResult`, int)
        :returns:  
            Tuple composed of (result, count):
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.NOT_IMPLEMENTED`
             - count:
                - The number of missing packet groups that represent unpopulated areas of memory in this buffer


        """
        return _ebus_python.PvBuffer_GetMissingPacketIdsCount(self)

    def GetMissingPacketIds(self, aIndex):
        r"""
        GetMissingPacketIds(self, aIndex) -> PvResult, int, int
        Get a missing packet group that represents an unpopulated area of memory in this buffer

        Notes: This is an advanced feature that requires knowledge of how GigE Vision data is transmitted.

        Refer to #GetMissingPacketIdsCount for further details on how this feature is used.

        Does not apply to USB3 Vision devices which do not have the concept of packet resends.

        :type aIndex: int
        :param aIndex: The index of the missing packet group being retrieved.

        :rtype:  Tuple(:py:class:`PvResult`, int, int)
        :returns:  
            Tuple composed of (result, low, high):
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.NOT_IMPLEMENTED`
             - low:
                - The first packet of a range of missing packets.
             - high:
                - The last packet of a range of missing packets. A value of 0xFFFFFF ( or 0xFFFFFFFF for ExtendedID )
                    indicates that the last packet of the block went missing and therefore the actual size of the block is unknown.


        """
        return _ebus_python.PvBuffer_GetMissingPacketIds(self, aIndex)

    def ResetChunks(self):
        r"""
        Resets the internal chunk state.

        Used when creating PvBuffer with chunks for transmission. This method should always be called
        before adding the first chunk block to a buffer. It removes chunk data from the previous
        sequence of AddChunk.

        If you are adding more than one chunk block to a buffer, you would normally perform this
        sequence for every buffer setup for transmission:

        1. lBuffer.ResetChunks();
        2. lBuffer.SetChunkLayoutID( CHUNKLAYOUTID );
        3. lBuffer.AddChunk( CHUNKID1, lData1 );
        4. lBuffer.AddChunk( CHUNKID2, lData2 );


        """
        return _ebus_python.PvBuffer_ResetChunks(self)

    def AddChunk(self, aID, aData):
        r"""
        AddChunk(self, aID, aData) -> PvResult
        Add chunk data to the buffer.
        Add chunk data to the buffer payload section by specifying the ID of the chunk data.
        See :func:`PvBuffer.ResetChunks` for more information.

        :type aID: int, in
        :param aID: Chunk data ID for aIndex.
        :type aData: python bytes object, in
        :param aData: 
            - Python bytes object containing chunk data. 
            - Payload data can be formatted with struct.pack. eg. data = struct.pack("<I32s", some_int, some_string)

        :rtype: :py:class:`PvResult`
        :returns: 
            A PvResult is used to capture the success or failure of the operation:
             - :py:const:`~PvResultCode.PV_OK`
             - :py:const:`~PvResultCode.PV_BUFFER_TOO_SMALL` There is not enough space in the buffer to add the chunk data.
             - :py:const:`~PvResultCode.PV_INVALID_PARAMETER` One of the input arguments is invalid.

        """
        return _ebus_python.PvBuffer_AddChunk(self, aID, aData)

    def SetChunkLayoutID(self, aChunkLayoutID):
        r"""
        Set the chunk data layout ID.

        :type aChunkLayoutID: int, in
        :param aChunkLayoutID: Chunk data layout ID.
        """
        return _ebus_python.PvBuffer_SetChunkLayoutID(self, aChunkLayoutID)

    def HasChunks(self):
        r"""
        Returns true if the buffer has data chunks.

        Unlike GetChunkCount, chunks do not need to be parsed or resolved
        with this method.

        :rtype: boolean
        :return: True if the buffer holds data chunks, false if not.
        """
        return _ebus_python.PvBuffer_HasChunks(self)

    def GetChunkCount(self):
        r"""
        Returns the number of data chunks in the PvBuffer.

        If no data chunks are available, 0 is returned.

        Counting chunks requires the chunks to be parsed and resolved which has a
        performance hit.

        If you need to access chunks directly, you need to use this method to enumerate
        the chunks. If you access the chunks through GenICam, just use HasChunks to see
        if you need to attach the buffer the GenICam parameter array of the device.

        :rtype: int
        :return: Data chunks count. 0 if no chunks are available.
        """
        return _ebus_python.PvBuffer_GetChunkCount(self)

    def GetChunkIDByIndex(self, aIndex):
        r"""
        GetChunkIDByIndex(self, aIndex) -> PvResult, int
        Returns a tuple of PvResult and the ID of a chunk based on its index.

        If the index is out of range or the PvBuffer does not have any data chunk, 0 is returned in ID.

        :type aIndex: int, in
        :param aIndex: Data chunk Index.

        :rtype:  Tuple(:py:class:`PvResult`, int)
        :returns:  
            Tuple composed of (result, chunkID):
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_NOT_FOUND` if the index is out of range or the buffer does not have any chunks
             - chunkID: 
                - Chunk ID.

        """
        return _ebus_python.PvBuffer_GetChunkIDByIndex(self, aIndex)

    def GetChunkSizeByIndex(self, aIndex):
        r"""
        Returns the size in bytes of the data chunk at zero-based aIndex.

        Chunks are enumerated from the end of the payload data to its beginning.
        If the index is out of range or the PvBuffer does not have any data
        chunk 0 is returned.

        :type aIndex: int, in
        :param aIndex: Data chunk index.

        :rtype: int
        :return: Data chunk size. 0 if the index is out of range.
        """
        return _ebus_python.PvBuffer_GetChunkSizeByIndex(self, aIndex)

    def GetChunkSizeByID(self, aID):
        r"""
        Returns the size in bytes of the data chunk identified by aID.

        If the aID chunk is not found or the PvBuffer does not have any
        chunks 0 is returned.

        :type aID: int, in
        :param aID: Data chunk ID.

        :rtype: int
        :return: Data chunk size. 0 if the chunk ID is not found.
        """
        return _ebus_python.PvBuffer_GetChunkSizeByID(self, aID)

    def GetChunkRawDataByIndex(self, aIndex):
        r"""
        GetChunkRawDataByIndex(self, aIndex) -> ndarray
        Returns a numpy array pointing to the data chunk at zero-based aIndex.

        Chunks are enumerated from the end of the payload data to its beginning.
        If the index is out of range or the PvBuffer does not have any data
        chunk an empty array is returned.

        :type aIndex: int, in
        :param aIndex: Data chunk index.

        :rtype: ndarray
        :returns: A 1-dimensional python numpy array with dtype np.uint8 describing the chunk data. Empty if the index is out of range.

        """
        return _ebus_python.PvBuffer_GetChunkRawDataByIndex(self, aIndex)

    def GetChunkRawDataByID(self, aID):
        r"""
        GetChunkRawDataByID(self, aID) -> ndarray
        Returns a const pointer to the data chunk with its ID matching aID.

        If the aID chunk is not found or the PvBuffer does not have any chunks
        NULL is returned.

        :type aID: int, in
        :param aID: Data chunk ID.

        :rtype: ndarray
        :returns: A 1-dimensional python numpy array with dtype np.uint8 describing the chunk data. Empty if the chunk ID is not found.

        """
        return _ebus_python.PvBuffer_GetChunkRawDataByID(self, aID)

    def GetPayloadSize(self):
        r"""
        Returns payload size in bytes, excluding any extra padding.

        Gets the size in bytes of the block received by the data receiver including,
        if present, additional chunk data and headers.

        Different than GetAcquiredSize as it does not include optional additional padding
        when data chunks are present.

        If data chunks are not present, this method returns the same value as GetAcquiredSize
        as extra padding is only an issue when data chunks are present.

        This method is required in order to parse the chunk data using GenICam.

        :rtype: int
        :return: Payload size in bytes, excluding any extra padding.
        """
        return _ebus_python.PvBuffer_GetPayloadSize(self)

    def GetChunkLayoutID(self):
        r"""
        Get the chunk data layout ID.

        :rtype: int
        :return: The current chunk data layout ID.
        """
        return _ebus_python.PvBuffer_GetChunkLayoutID(self)

    def GetChunkDataSize(self):
        r"""
        Returns the current chunk data size.

        In a transmission context this method returns how many bytes are used for extra chunk data.
        It includes the chunk headers for all chunk data and if applicable the chunk header
        for the main chunk (typically the image).

        This method has no use in a reception context where the data receiver delivers the buffer.
        Use either the direct chunk access methods or the GenApi interface of the device to
        access chunk data.

        :rtype: int
        :return: Chunk data size in bytes.
        """
        return _ebus_python.PvBuffer_GetChunkDataSize(self)

    def GetChunkDataCapacity(self):
        r"""
        Returns the current chunk data capacity.

        In a transmission context where you create the buffer, memory is allocated for
        chunks. This method returns how many bytes can still be added as chunk data.

        One chunk is always made of 8-bytes of headers plus the chunk data length. You
        also need to reserve another 8-bytes for the main chunk (typically the image) unless
        you buffer only contains chunk data.

        This method has no use in a reception context where the data receiver delivers the buffer.
        Use either the direct chunk access methods or the GenApi interface of the device to
        access chunk data.

        :rtype: int
        :return: Chunk data capacity.
        """
        return _ebus_python.PvBuffer_GetChunkDataCapacity(self)

    def IsHeaderValid(self):
        r"""
        Returns whether this buffer has valid header (GVSP) information.

        If the buffer header is not valid (missing) the buffer has to be manipulated
        with extreme caution. To start with, it is impossible to confirm the payload type.
        The timestamp and other shared header information is not valid. Finally, information
        specific to some payload types (like with, height, pixel format, etc. for the image
        payload type) is not available or valid this buffer.

        When a buffer is attached or allocated for use other than receiving GVSP data,
        this attribute evaluates to true in order to appear as valid.

        :rtype: boolean
        :return: True if the GVSP header is valid.
        """
        return _ebus_python.PvBuffer_IsHeaderValid(self)

    def IsTrailerValid(self):
        r"""
        Returns whether this buffer has valid trailer (GVSP) information.

        If the buffer trailer is not valid (missing) some information about the buffer
        could be missing. As an example, the image payload type confirms the number
        of lines received in the trailer.

        When a buffer is attached or allocated for use other than receiving GVSP data,
        this attribute evaluates to true in order to appear as valid.

        :rtype: boolean
        :return: True if the GVSP header is valid.
        """
        return _ebus_python.PvBuffer_IsTrailerValid(self)

    def IsLargeLeaderTrailerEnabled(self):
        r"""
        Returns whether this buffer has large data leader and data trailer enabled.

        If the buffer is used for Multi-Part streaming, the maximum allowed number of parts is limited by
        whether Large data leader and trailer is enabled.

        :rtype: boolean
        :return: True if the Large Data Leader and Trailer is enabled on the buffer which contains Multi-part.
        """
        return _ebus_python.PvBuffer_IsLargeLeaderTrailerEnabled(self)

    def __eq__(self, *args):
        return _ebus_python.PvBuffer___eq__(self, *args)

    def __hash__(self):
        return _ebus_python.PvBuffer___hash__(self)

# Register PvBuffer in _ebus_python:
_ebus_python.PvBuffer_swigregister(PvBuffer)
class IPvMultiPartContainerReader(object):
    r"""
    Interface used to read from a multi-part container.

    To receive and access multi-part data from a GigE Vision device, use a PvStream or
    PvPipeline to receive buffers and then use PvBuffer::GetMultiPartContainer to retrieve
    an IPvMultiPartContainerReader or IPvMultiPartContainer interface.

    Each part is represented by a multi-part section that can be accessed through
    an IPvMultiPartSection interface.

    Retrieve the section count with GetPartCount and then access the individual sections
    with the GetPart or operator[] of this interface.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_IPvMultiPartContainerReader

    def GetPartCount(self):
        r"""
        Part count of the multi-part container.

        :rtype: int
        :return: Part count.
        """
        return _ebus_python.IPvMultiPartContainerReader_GetPartCount(self)

    def GetPart(self, *args):
        r"""
        *Overload 1:*

        Indexed part (section) const accessor.

        :param [in]: aIndex Zero-based index of the part.

        :rtype: :py:class:`IPvMultiPartSection`
        :return: Returns a const section interface from its index.

        |

        *Overload 2:*

        Indexed part (section) accessor.

        :param [in]: aIndex Zero-based index of the part.

        :rtype: :py:class:`IPvMultiPartSection`
        :return: Returns a section interface from its index.
        """
        return _ebus_python.IPvMultiPartContainerReader_GetPart(self, *args)

# Register IPvMultiPartContainerReader in _ebus_python:
_ebus_python.IPvMultiPartContainerReader_swigregister(IPvMultiPartContainerReader)
class IPvMultiPartContainerWriter(IPvMultiPartContainerReader):
    r"""
    Interface used to write to a multi-part container.

    This interface is used to create a multi-part PvBuffer than can be transmitted using PvSoftDeviceGEV.

    A multi-part buffer would typically be prepared for transmission by:
        - Creating a PvBuffer by specifying a payload type of PvPayloadTypeMultiPart to the constructor.
        - Retrieving the IPvMultiPartContainerWriter interface using PvBuffer::GetMultiPartContainer.
        - Defining the parts using the #AddImagePart, #AddJPEGPart and #AddChunkPart methods.
        - Allocating/attaching memory using either #AllocAllParts or a mix of #AllocPart and #AttachPart.
        - Filling the part data using IPvMultiPartContainerReader and IPvMultiPartSection.
        - Using the #Validate method to make sure the multi-part container is valid.
        - Transmitting the part from a streaming source of PvSoftDeviceGEV.

    Adding parts with this interface only creates the part definition in the part index of the container.
    Memory then needs to be allocated or attached for all parts. Make sure to call #Validate after defining
    the parts and allocating or attaching memory to make sure the multi-part container is properly setup.

    You can either have no data chunk part of one chunk part and that part needs to be the last part. Use
    The #IPvChunkData interface to the section to define the chunk data and confirm the chunk length using
    #SetPartFinalLength to confirm the chunk data length.

    See SoftGEVDeviceMultiPart C++ eBUS SDK sample for more information.

    GigE Vision restricts the maximum part count to 10. This limitation comes from the part index size
    in the context of the maximum GVSP header size.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_IPvMultiPartContainerWriter

    def Reset(self):
        r""" Resets the multi-part container index to empty - no parts."""
        return _ebus_python.IPvMultiPartContainerWriter_Reset(self)

    def AddImagePart(self, aDataType, aWidth, aMaxHeight, aPixelType, aOffsetX=0, aOffsetY=0, aPaddingX=0):
        r"""
        Adds an image part to the index of a multi-part container.

        Calling this method only defines a new image in the multi-part container index. Memory needs to be allocated or attached
        using the AllocAllParts, AllocPart or AttachPart methods.

        The height is initially defined as maximum height. It is possible to later call SetPartFinalImageHeight to confirm
        the effective height of the image, as long as the confirmed height is less or equal to the maximum height defined here.
        This allows linescan-like scenario where the final height of the image is not known when the image part is defined
        and its memory allocated or attached.

        :param [in]: aDataType Image data type. Must be between PvMultiPart2DImage and PvMultiPartConfidenceMap, inclusive.
        :param [in]: aWidth Width of the image, in pixels.
        :param [in]: aMaxHeight Height of the image, in pixels.
        :param [in]: aPixelType Pixel type of the image.
        :param [in]: aOffsetX Offset X of the image, in pixels.
        :param [in]: aOffsetY Offset Y of the image, in pixels.
        :param [in]: aPaddingX Padding X of the image, in bytes.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_PARAMETER aDataType does not represent an image, aWidth is zero or aHeight is zero.
                - #PvResult::Code::NOT_SUPPORTED if the PvBuffer accessed from this interfaced is not defined as a multi-part buffer.
                - #PvResult::Code::ERR_OVERFLOW if the maximum number of parts supported by the GigE Vision specification has already been reached.
                - #PvResult::Code::STATE_ERROR if the previously added part is of type chunk data which is only valid as the last part.
        """
        return _ebus_python.IPvMultiPartContainerWriter_AddImagePart(self, aDataType, aWidth, aMaxHeight, aPixelType, aOffsetX, aOffsetY, aPaddingX)

    def AddJPEGPart(self, aDataType, aMaxLength, aFlag, aTimestampTickFrequency, aDataFormat):
        r"""
        Adds a JPEG part to the index of a multi-part container.

        Calling this method only defines a new JPEG image in the multi-part container index. Memory needs to be allocated or attached
        using the AllocAllParts, AllocPart or AttachPart methods.

        The length is initially defined as maximum length, in bytes. It is possible to later call SetPartFinalLength to confirm
        the effective length of the compressed image, as long as the confirmed length is less or equal to the maximum length defined here.
        This allows reserving memory for the worse-case compression scenario and defining the real compressed image length when putting the
        part together before transmission.

        :param [in]: aDataType Multi-part data type. Either PvMultiPartJPEGImage or PvMultiPartJPEG2000Image.
        :param [in]: aMaxLength Maximum length for the compressed image. Defined here as worse-case compression, exact size later confirmed with SetPartFinalLength.
        :param [in]: aFlag JPEG flags.
        :param [in]: aTimestampTickFrequency Timestamp tick frequency. Can be used with JPEG2000 to turn buffer timestamp into real time units.
        :param [in]: aDataFormat JPEG data format.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::NOT_SUPPORTED if the PvBuffer accessed from this interfaced is not defined as a multi-part buffer.
                - #PvResult::Code::ERR_OVERFLOW if the maximum number of parts supported by the GigE Vision specification has already been reached.
                - #PvResult::Code::STATE_ERROR  if the previously added part is of type chunk data which is only valid as the last part.
        """
        return _ebus_python.IPvMultiPartContainerWriter_AddJPEGPart(self, aDataType, aMaxLength, aFlag, aTimestampTickFrequency, aDataFormat)

    def AddChunkPart(self, aMaxLength, aChunkLayoutID):
        r"""
        Adds a chunk data part to the index of a multi-part container.

        The chunk data section is always last in a multi-part container. There can only be one chunk data
        section for a multi-part container. A chunk data section can contain one or more chunks.

        :param [in]: aMaxLength Maximum length for chunk data.
        :param [in]: aChunkLayoutID Chunk layoud ID for the chunk data.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::NOT_SUPPORTED if the PvBuffer accessed from this interfaced is not defined as a multi-part buffer.
                - #PvResult::Code::ERR_OVERFLOW if the maximum number of parts supported by the GigE Vision specification has already been reached.
                - #PvResult::Code::STATE_ERROR  if the previously added part is of type chunk data which is only valid as the last part.
        """
        return _ebus_python.IPvMultiPartContainerWriter_AddChunkPart(self, aMaxLength, aChunkLayoutID)

    def SetPartIDs(self, aIndex, aSourceID, aDataPurposeID, aRegionID):
        r"""
        Sets the source, data purpose and region IDs of a part.

        See #IPvMultiPartSection for more information about these IDs.

        If this method is not called after adding a part to the multi-part container index, all IDs are zero.

        :type aIndex: int
        :param aIndex: [in] Zero-based index of the part.
        :type aSourceID: int
        :param aSourceID: [in] Source ID to assign to the part
        :type aDataPurposeID: int
        :param aDataPurposeID: [in] Data purpose ID to assign to the part.
        :type aRegionID: int
        :param aRegionID: [in] Region ID to assign to the part.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_DATA_FORMAT if the indexed part is chunk data (which does not have these IDs defined) or if the buffer is not defined as multi-part.
                - #PvResult::Code::INVALID_PARAMETER if aIndex is out of range.
        """
        return _ebus_python.IPvMultiPartContainerWriter_SetPartIDs(self, aIndex, aSourceID, aDataPurposeID, aRegionID)

    def SetPartZoneInfo(self, aIndex, aAdditionalZones, aZoneDirectionMask):
        r"""
        Sets the zone info of a part.

        See #IPvMultiPartSection for more information about zone info.

        If this method is not called after adding a part to the multi-part container index, the number of additional zones
        and direction mask are both set to zero.

        :type aIndex: int
        :param aIndex: [in] Zero-based index of the part.
        :type aAdditionalZones: uint8_t
        :param aAdditionalZones: [in] Number of additional zones for this part.
        :type aZoneDirectionMask: int
        :param aZoneDirectionMask: [in] Zone direction  of for all zones of this part.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_DATA_FORMAT if the indexed part is chunk data (which does not have these IDs defined) or if the buffer is not defined as multi-part.
                - #PvResult::Code::INVALID_PARAMETER if aIndex is out of range.
        """
        return _ebus_python.IPvMultiPartContainerWriter_SetPartZoneInfo(self, aIndex, aAdditionalZones, aZoneDirectionMask)

    def AllocAllParts(self):
        r"""
        Allocates memory for all parts defined by the part index of the multi-part container.

        With this method all parts are allocated as a single contiguous memory buffer.

        Memory is allocated based on each parts definition: image size is inferred from width, max height, pixel format and padding X.
        JPEG from the maximum length. Chunk from the maximum chunk length.

        If memory was allocated for all parts or individual parts, it is freed before being re-allocated. If memory
        was attached for any part, it is simply detached.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::STATE_ERROR if no parts are currently defined.
                - #PvResult::Code::ERR_OVERFLOW if more memory is required than currently supported by the PvBuffer class.
        """
        return _ebus_python.IPvMultiPartContainerWriter_AllocAllParts(self)

    def AllocPart(self, aIndex):
        r"""
        Allocates memory for one of the parts as defined by the index of the part.

        If memory has been previously allocated for all parts, new memory for this part alone is allocated
        and used instead. Unused memory for the part is still reserved in the contiguous buffer.

        Memory is allocated based on each parts definition: image size is inferred from width, max height, pixel format and padding X.
        JPEG from the maximum length. Chunk from the maximum chunk length.

        :type aIndex: int
        :param aIndex: [in] Zero-based index of the part.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_PARAMETER if aIndex is out of range.
        """
        return _ebus_python.IPvMultiPartContainerWriter_AllocPart(self, aIndex)

    def AttachPart(self, aIndex, aBuffer):
        r"""
        AttachPart(self, aIndex, aBuffer) -> PvResult
        Attaches a part to an external memory buffer..

        :type aIndex: int, in
        :param aIndex: Zero-based index of the part.
        :type aBuffer: ndarray, in
        :param aBuffer: A 1-dimensional python numpy array with dtype np.uint8 to use as the external memory buffer.

        :rtype: :py:class:`PvResult`
        :returns: 
            Includes:
             - :py:const:`~PvResultCode.PV_NOT_FOUND`
             - :py:const:`~PvResultCode.PV_INVALID_PARAMETER`

        """
        return _ebus_python.IPvMultiPartContainerWriter_AttachPart(self, aIndex, aBuffer)

    def SetPartFinalLength(self, aIndex, aLength):
        r"""
        Sets the final length of a part.

        Used to confirm final length of JPEG and chunk data parts. If this method is not called, the part length is assumed
        to be the full maximum part length as defined in AddJPEGPart or AddChunkPart.

        See AddJPEGPart and AddChunkPart for more information.

        :type aIndex: int
        :param aIndex: [in] Zero-based index of the part.
        :type aLength: int
        :param aLength: [in] aLength Final length of the part.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_PARAMETER if aIndex is out of range, aLength is bigger than the maximum part length or the part is an image.
        """
        return _ebus_python.IPvMultiPartContainerWriter_SetPartFinalLength(self, aIndex, aLength)

    def SetPartFinalImageHeight(self, aIndex, aHeight):
        r"""
        Sets the final height of an image part.

        Used to confirm final height of image parts. If this method is not called, the image height is assumed
        to be the full maximum image height as defined in AddImagePart.

        See AddImagePart for more information.

        :type aIndex: int
        :param aIndex: [in] Zero-based index of the part.
        :type aHeight: int
        :param aHeight: [in] Final height of the part.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_PARAMETER if aIndex is out of range.

            - #PvResult::Code::INVALID_PARAMETER if aIndex is out of range, aHeight is bigger than the maximum height for this part or the part is not an image.
        """
        return _ebus_python.IPvMultiPartContainerWriter_SetPartFinalImageHeight(self, aIndex, aHeight)

    def Validate(self):
        r"""
        Validates the part index and allocated/attached part memory.

        This method goes through all parts defined in the part index of this container and makes sure
        that enough memory is allocated or attached to each individual part. It can also fail if not part
        has been defined.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_PARAMETER if aIndex is out of range.
        """
        return _ebus_python.IPvMultiPartContainerWriter_Validate(self)

# Register IPvMultiPartContainerWriter in _ebus_python:
_ebus_python.IPvMultiPartContainerWriter_swigregister(IPvMultiPartContainerWriter)
class IPvMultiPartContainer(IPvMultiPartContainerWriter):
    r"""
    Interface to a multi-part container.

    Implements both IPvMultiPartContainerReader and IPvMultiPartContainerWriter.

    See IPvMultiPartContainerReader for more information on how to access a multi-part
    buffer as received from a GigE Vision source.

    See IPvMultiPartContainerWriter for more information on how to create and populate
    a multi-part buffer in order to transmit it from a GigE Vision source.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_IPvMultiPartContainer

# Register IPvMultiPartContainer in _ebus_python:
_ebus_python.IPvMultiPartContainer_swigregister(IPvMultiPartContainer)
class IPvImageJPEG(object):
    r"""
    Generic interface to a JPEG image.

    Preliminary JPEG support in the context of GigE Vision multi-part support. The data
    is provided as-received and the eBUS SDK does not currently offer more support for
    JPEG payloads.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_IPvImageJPEG

    def GetDataPointer(self, *args):
        r"""
        GetDataPointer(self) -> ndarray
        Get the numpy array describing the buffer data.

        The GetDataPointer method returns a numpy array describing the buffer data.

        :rtype: ndarray
        :returns: A 1-dimensional python numpy array with dtype np.uint8 describing the buffer data.`

        """
        return _ebus_python.IPvImageJPEG_GetDataPointer(self, *args)

    def GetFlag(self):
        r"""
        Returns the native JPEG flags of the compressed image.

        :rtype: uint8_t
        :return: JPEG flags of the image.
        """
        return _ebus_python.IPvImageJPEG_GetFlag(self)

    def GetTimestampTickFrequency(self):
        r"""
        Returns the timetstamp tick frequency as provided in the GVSP header.

        :rtype: int
        :return: Timestamp tick frequency.
        """
        return _ebus_python.IPvImageJPEG_GetTimestampTickFrequency(self)

    def GetDataFormat(self):
        r"""
        Returns the JPEG data format.

        :rtype: int
        :return: JPEG data format.
        """
        return _ebus_python.IPvImageJPEG_GetDataFormat(self)

    def GetDataSize(self):
        r"""
        Returns the JPEG data size.

        :rtype: int
        :return: JPEG data size.
        """
        return _ebus_python.IPvImageJPEG_GetDataSize(self)

# Register IPvImageJPEG in _ebus_python:
_ebus_python.IPvImageJPEG_swigregister(IPvImageJPEG)
PvMultiPartDataType = _ebus_python.PvMultiPartDataType 
PvMultiPartInvalid = _ebus_python.PvMultiPartInvalid
PvMultiPart2DImage = _ebus_python.PvMultiPart2DImage
PvMultiPart2DPlaneOfBiPlanar = _ebus_python.PvMultiPart2DPlaneOfBiPlanar
PvMultiPart2DPlaneOfTriPlanar = _ebus_python.PvMultiPart2DPlaneOfTriPlanar
PvMultiPart2DPlaneOfQuadPlanar = _ebus_python.PvMultiPart2DPlaneOfQuadPlanar
PvMultiPart3DImage = _ebus_python.PvMultiPart3DImage
PvMultiPart3DPlaneOfBiPlanar = _ebus_python.PvMultiPart3DPlaneOfBiPlanar
PvMultiPart3DPlaneOfTriPlanar = _ebus_python.PvMultiPart3DPlaneOfTriPlanar
PvMultiPart3DPlaneOfQuadPlanar = _ebus_python.PvMultiPart3DPlaneOfQuadPlanar
PvMultiPartConfidenceMap = _ebus_python.PvMultiPartConfidenceMap
PvMultiPartChunkData = _ebus_python.PvMultiPartChunkData
PvMultiPartJPEGImage = _ebus_python.PvMultiPartJPEGImage
PvMultiPartJPEG2000Image = _ebus_python.PvMultiPartJPEG2000Image
PvComponentType = _ebus_python.PvComponentType 
PvComponentUndefined = _ebus_python.PvComponentUndefined
PvComponentIntensity = _ebus_python.PvComponentIntensity
PvComponentInfrared = _ebus_python.PvComponentInfrared
PvComponentUltraviolet = _ebus_python.PvComponentUltraviolet
PvComponentRange = _ebus_python.PvComponentRange
PvComponentReflectance = _ebus_python.PvComponentReflectance
PvComponentConfidence = _ebus_python.PvComponentConfidence
PvComponentScatter = _ebus_python.PvComponentScatter
PvComponentDisparity = _ebus_python.PvComponentDisparity
PvComponentMultispectral = _ebus_python.PvComponentMultispectral
class IPvMultiPartSection(object):
    r""" One section (part) of a multi-part container."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_IPvMultiPartSection

    def GetDataPointer(self, *args):
        r"""
        GetDataPointer(self) -> ndarray
        Get the numpy array describing the section's buffer data.

        The GetDataPointer method returns a numpy array describing the buffer data.

        :rtype: ndarray
        :returns: A 1-dimensional python numpy array with dtype np.uint8 describing the buffer data.`

        """
        return _ebus_python.IPvMultiPartSection_GetDataPointer(self, *args)

    def GetSize(self):
        r"""
        Returns the section's maximum possible data size in bytes.

        :rtype: int
        :return: Maximum possible data size in bytes.
        """
        return _ebus_python.IPvMultiPartSection_GetSize(self)

    def GetEffectiveSize(self):
        r"""
        Returns the section's maximum possible data size in bytes.

        :rtype: int
        :return: Maximum possible data size in bytes.
        """
        return _ebus_python.IPvMultiPartSection_GetEffectiveSize(self)

    def GetDataType(self):
        r"""
        Returns the data type of the section.

        :rtype: int
        :return: Section data type.
        """
        return _ebus_python.IPvMultiPartSection_GetDataType(self)

    def GetImage(self):
        r"""
        Returns an IPvImage interface to the section.

        Returns a point to an IPvImage interface to the section if the section is
        PvMultiPart2DImage, PvMultiPart2DPlaneOfBiPlanar, PvMultiPart2DPlaneOfTriPlanar,
        PvMultiPart2DPlaneOfQuadPlanar, PvMultiPart3DImage, PvMultiPart3DPlaneOfBiPlanar,
        PvMultiPart3DPlaneOfTriPlanar, PvMultiPart3DPlaneOfQuadPlanar or PvMultiPartConfidenceMap.

        Return NULL if any other data type.

        The returned pointer is owned by the section. The caller must not attempt to
        free or delete it.

        :rtype: :py:class:`IPvImage`
        :return: IPvImage interface to the section.
        """
        return _ebus_python.IPvMultiPartSection_GetImage(self)

    def GetJPEG(self):
        r"""
        Returns an IPvImageJPEG interface to the section.

        Returns a point to an IPvImageJPEG interface to the section if the section is
        PvMultiPartJPEGImage or PvMultiPartJPEGImage2000.

        Return NULL if any other data type.

        The returned pointer is owned by the section. The caller must not attempt to
        free or delete it.

        :rtype: :py:class:`IPvImageJPEG`
        :return: IPvImageJPEG interface to the section.
        """
        return _ebus_python.IPvMultiPartSection_GetJPEG(self)

    def GetChunkData(self):
        r"""
        Returns an IPvChunkData interface to the section.

        Returns a point to an IPvChunkData interface to the section if the section is
        PvMultiPartChunkData.

        Return NULL if any other data type.

        The returned pointer is owned by the section. The caller must not attempt to
        free or delete it.

        The chunk data section is always last in a multi-part container.

        :rtype: :py:class:`IPvChunkData`
        :return: IPvChunkData interface to the section.
        """
        return _ebus_python.IPvMultiPartSection_GetChunkData(self)

    def GetSourceID(self):
        r"""
        Returns the source ID of the section.

        The source ID is an integer used to identify data produced by the same source.

        See GigE Vision specification for more information on sources in the multi-part context.

        :rtype: int
        :return: Source ID of the section.
        """
        return _ebus_python.IPvMultiPartSection_GetSourceID(self)

    def GetDataPurposeID(self):
        r"""
        Returns the data purpose ID of the section.

        The data purpose ID is integer used to tag parts having a different purpose. Different color planes would share the same
        Data Purpose ID, while a 3D data and validity mask parts would use different Data Purpose ID.

        See GigE Vision specification for more information on the data purpose ID in the multi-part context.

        :rtype: int
        :return: Data purpose ID of the section.
        """
        return _ebus_python.IPvMultiPartSection_GetDataPurposeID(self)

    def GetRegionID(self):
        r"""
        Returns the region ID of the section.

        The registion ID is an integer used to tag parts that belong to the same region.
        This can be used when data from different regions is transmitted in the same block.

        See GigE Vision specification for more information on the region ID in the multi-part context.

        :rtype: int
        :return: Region ID of the section.
        """
        return _ebus_python.IPvMultiPartSection_GetRegionID(self)

    def GetAdditionalZones(self):
        r"""
        Returns additional zone count of the section.

        Reports the number of additional zones in the data part. The number of zones (contiguous bands) is
        equal to the value of this field plus one (0 indexed value).

        See GigE Vision specification for more information on zones in the multi-part context.

        :rtype: int
        :return: Addtional zone count for the section.
        """
        return _ebus_python.IPvMultiPartSection_GetAdditionalZones(self)

    def GetZoneDirectionMask(self):
        r"""
        Returns the zone direction mask of the section.

        Reports the transmission direction of each zone. bit 0 (msb)
            - Direction of zone 0. Reports the transmission direction of zone ID 0. When set to zero, the zone is
                transmitted top-down (lowest data addresses first). Otherwise, it is transmitted bottom-up (highest data addresses first). bit 1
            - Direction of zone 1. Reports the transmission direction of zone ID 1. When set to zero, the zone is transmitted top-down
                (lowest data addresses first). Otherwise, it is transmitted bottom up (highest data addresses first).
            - ...

        See GigE Vision specification for more information on zones in the multi-part context.

        :rtype: int
        :return: Zone direction mask of the section.
        """
        return _ebus_python.IPvMultiPartSection_GetZoneDirectionMask(self)

# Register IPvMultiPartSection in _ebus_python:
_ebus_python.IPvMultiPartSection_swigregister(IPvMultiPartSection)
PvEncodingEnum = _ebus_python.PvEncodingEnum 
PvEncodingUnknown = _ebus_python.PvEncodingUnknown
PvEncodingPTC1 = _ebus_python.PvEncodingPTC1
PvBayerFilterType = _ebus_python.PvBayerFilterType 
PvBayerFilterSimple = _ebus_python.PvBayerFilterSimple
PvBayerFilter3X3 = _ebus_python.PvBayerFilter3X3
class PvBufferConverter(object):
    r"""
    Used to convert a #PvBuffer to another pixel type.

    **To change an image's format:**

        - Acquire an image. See #PvStream::RetrieveBuffer.
        - Create an image-format converter (#PvBufferConverter object). Use #PvBufferConverter::PvBufferConverter.
        - Test if you can convert your image to your preferred pixel type. Use #IsConversionSupported.
            For your source pixel type, use #PvImage::GetPixelType; for your destination, select an enumeration from
            PvPixelType.h.
        - Create a destination buffer. See #PvBuffer (you define the destination image's pixel type during this step).
        - Optionally, configure options like Bayer filtering, use #SetBayerFilter.
        - Convert the image to the new pixel type. Use #Convert.

    Consult the #PvPixelType documentation in order to find which pixel types are supported as conversion destinations.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, aMaxNumberOfThreads=-1):
        r"""
        Constructor.

        :type aMaxNumberOfThreads: int, in, optional
        :param aMaxNumberOfThreads: Maximum number of threads the buffer converter
                                            is allowed to use in order to speed up conversion.
                                            If 0 or smaller than 0, one thread per processor
                                            is assumed. Threads have no specific processor
                                            affinity.
        """
        _ebus_python.PvBufferConverter_swiginit(self, _ebus_python.new_PvBufferConverter(aMaxNumberOfThreads))
    __swig_destroy__ = _ebus_python.delete_PvBufferConverter

    @staticmethod
    def IsConversionSupported(aSource, aDestination):
        r"""
        Test if a pixel type can be converted to another type.

        Converting from one pixel type to another isn't a trivial mathematical
        calculation - all conversions require specialized, dedicated algorithms.

        The #IsConversionSupported method tests if
        the #Convert method has an available conversion algorithm.

        :type aSource: int, in
        :param aSource:       The original pixel type. For available
                                      pixel types, see PvPixelType.h.
        :type aDestination: int, in
        :param aDestination:  The new pixel type. See *aSource*.

        :rtype: boolean
        :return: True if #Convert has an available conversion algorithm;
                    otherwise, false.
        """
        return _ebus_python.PvBufferConverter_IsConversionSupported(aSource, aDestination)

    def Convert(self, *args):
        r"""
        Convert(*args) -> PvResult, PvBuffer

        To convert the Pixel Type, you should create a destination image/buffer
        and define the destination image's pixel type first before calling this API.

        *Overload 1:*

        Convert a buffer from one format to another.

        :type aSource: :py:class:`PvBuffer`, in
        :param aSource:            The original image/buffer.
        :type aDestination: :py:class:`PvBuffer`, in
        :param aDestination:            The destination image/buffer to convert to.
        :type aReallocIfNeeded: boolean, in, optional
        :param aReallocIfNeeded:   Depending on the conversion, the memory footprint
                                            of the new image may be greater than aDestination
                                            current size. By setting this parameter to true, the
                                            buffer is re-allocated if aDestination is too small.
                                            If aDestination memory buffer is not owned by the
                                            #PvBuffer and is too small, #Convert fails.
        :type aFlipY: boolean, in, optional
        :param aFlipY:              When performing the conversion, flips the image on its Y axis.

        :rtype:  Tuple(:py:class:`PvResult`, :py:class:`PvBuffer`)
        :return:  
            Tuple composed of (result, pvbuffer_destination)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR`
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER`
             - pvbuffer_destination: 
                - The aDestination PvBuffer object containing the converted data.

        |

        *Overload 2:*

        Convert a buffer from one format to another.

        :type aSource: :py:class:`IPvImage`, in
        :param aSource:            The original image.
        :type aDestination: :py:class:`IPvImage`, in
        :param aDestination:            The destination image to convert to.
        :type aReallocIfNeeded: boolean, in, optional
        :param aReallocIfNeeded:   Depending on the conversion, the memory footprint
                                            of the new image may be greater than aDestination
                                            current size. By setting this parameter to true, the
                                            buffer is re-allocated if aDestination is too small.
                                            If aDestination memory buffer is not owned by the
                                            #PvBuffer and is too small, #Convert fails.
        :type aFlipY: boolean, in, optional
        :param aFlipY:              When performing the conversion, flips the image on its Y axis.

        :rtype:  Tuple(:py:class:`PvResult`, :py:class:`PvBuffer`)
        :return:  
            Tuple composed of (result, pvbuffer_destination)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR`
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER`
             - pvbuffer_destination: 
                - The aDestination PvBuffer object containing the converted data.

        """
        return _ebus_python.PvBufferConverter_Convert(self, *args)

    def GetBayerFilter(self):
        r"""
        Retrieves current optional Bayer filtering.

        See #SetBayerFilter

        :rtype: int
        :return: The Bayer filter's type; a #PvBayerFilterType enumeration.
        """
        return _ebus_python.PvBufferConverter_GetBayerFilter(self)

    def SetBayerFilter(self, aFilter):
        r"""
        Set the optional Bayer filtering for this converter.

        Of course, only applies if the #Convert method uses a #PvBuffer having a
        Bayer pixel type. Simply ignored otherwise.

        :type aFilter: int, in
        :param aFilter:   The new filter settings; a #PvBayerFilterType enumeration.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
        """
        return _ebus_python.PvBufferConverter_SetBayerFilter(self, aFilter)

    def ResetRGBFilter(self):
        r"""
        Resets the RGB filter used for conversion (if any)

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
        """
        return _ebus_python.PvBufferConverter_ResetRGBFilter(self)

    def SetRGBFilter(self, aFilter):
        r"""
        Assigns a RGB filter to be used during conversion

        :type aFilter: :py:class:`PvBufferConverterRGBFilter`, in
        :param aFilter:   The RGB filter to be used during conversion.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
        """
        return _ebus_python.PvBufferConverter_SetRGBFilter(self, aFilter)

    def GetConversionThreadsPriority(self):
        r"""
        Get the priority of the threads doing the conversion in background

        See #SetConversionThreadsPriority for details about the meaning of the values returned

        :rtype: int
        :return: The priority of the thread
        """
        return _ebus_python.PvBufferConverter_GetConversionThreadsPriority(self)

    def SetConversionThreadsPriority(self, aPriority):
        r"""
        Set the priority of the threads doing the conversion

        By default one conversion thread is created for each processing core of the system.
        We only allow setting priority for the threads of one converter object as a group.

        If you change the thread priorities, it may alterate the stability of the system. For this reason,
        if you report a bug to Pleora, ensure to clearly mention that you change threads priorities.

        See #GetConversionThreadsPriority

        :type aPriority: int, in
        :param aPriority:   See #PvPipeline::SetBufferHandlingThreadPriority for description of the supported values

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
                - #PvResult::Code::THREAD_ERROR
        """
        return _ebus_python.PvBufferConverter_SetConversionThreadsPriority(self, aPriority)

# Register PvBufferConverter in _ebus_python:
_ebus_python.PvBufferConverter_swigregister(PvBufferConverter)
class PvBufferConverterRGBFilter(object):
    r"""
    Contains a RGB filter configuration that can be used with a PvBufferConverter.

    **To configure an RGB filter (manual):**
        - Create an RGB filter controller.
        - Set the filter's values. Use SetGain* and SetOffset* methods. See #SetGainB.

    **To configure a white balance filter (automatic):**
        - Create an RGB filter object.
        - Calculate and apply white-balance settings. Use #WhiteBalance.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" Constructor."""
        _ebus_python.PvBufferConverterRGBFilter_swiginit(self, _ebus_python.new_PvBufferConverterRGBFilter())
    __swig_destroy__ = _ebus_python.delete_PvBufferConverterRGBFilter

    def GetGainR(self):
        r"""
        Get the filter's gain (red).

        See #SetGainB.

        :rtype: float
        :return: See #SetGainB.
        """
        return _ebus_python.PvBufferConverterRGBFilter_GetGainR(self)

    def GetGainG(self):
        r"""
        Get the filter's gain (green).

        See #SetGainB.

        :rtype: float
        :return: See #SetGainB.
        """
        return _ebus_python.PvBufferConverterRGBFilter_GetGainG(self)

    def GetGainB(self):
        r"""
        Get the filter's gain (blue).

        See #SetGainB.

        :rtype: float
        :return: See #SetGainB.
        """
        return _ebus_python.PvBufferConverterRGBFilter_GetGainB(self)

    def SetGainR(self, aValue):
        r"""
        Set the filter's gain (red)

        See #SetGainB.

        :type aValue: float, in
        :param aValue:  See #SetGainB.
        """
        return _ebus_python.PvBufferConverterRGBFilter_SetGainR(self, aValue)

    def SetGainG(self, aValue):
        r"""
        Set the filter's gain (green)

        See #SetGainB.

        :type aValue: float, in
        :param aValue:  See #SetGainB.
        """
        return _ebus_python.PvBufferConverterRGBFilter_SetGainG(self, aValue)

    def SetGainB(self, aValue):
        r"""
         Set the filter's gain (blue).

         The SetGain* and SetOffset methods let you control the
         transformation made by the filter, for the colors
         red, green, and blue.

         The transformation uses the form:

        *x'* = *kx* + y

         where:
             - *x'* is the modified color level (for one of red, blue, or green)
             - *x* is the original color level (for one of red, blue, or green)
             - *k* is the level multiplier
             - *y* is the offset

         To set a filter's values, use:
             - #SetGainB
             - #SetGainG
             - #SetGainR
             - #SetOffsetB
             - #SetOffsetG
             - #SetOffsetR

         To get a filter's values, use:
             - #GetGainB
             - #GetGainG
             - #GetGainR
             - #GetOffsetB
             - #GetOffsetG
             - #GetOffsetR


         :type aValue: float, in
         :param aValue:  The new gain (blue).
        """
        return _ebus_python.PvBufferConverterRGBFilter_SetGainB(self, aValue)

    def GetOffsetR(self):
        r"""
        Get the filter's offset (red).

        See #SetGainB.

        :rtype: int
        :return: See #SetGainB.
        """
        return _ebus_python.PvBufferConverterRGBFilter_GetOffsetR(self)

    def GetOffsetG(self):
        r"""
        Get the filter's offset (green).

        See #SetGainB.

        :rtype: int
        :return: See #SetGainB.
        """
        return _ebus_python.PvBufferConverterRGBFilter_GetOffsetG(self)

    def GetOffsetB(self):
        r"""
        Get the filter's offset (blue).

        See #SetGainB.

        :rtype: int
        :return: See #SetGainB.
        """
        return _ebus_python.PvBufferConverterRGBFilter_GetOffsetB(self)

    def SetOffsetR(self, aValue):
        r"""
        Set the filter's offset (red)

        See #SetGainB.

        :type aValue: int, in
        :param aValue:  See #SetGainB.
        """
        return _ebus_python.PvBufferConverterRGBFilter_SetOffsetR(self, aValue)

    def SetOffsetG(self, aValue):
        r"""
        Set the filter's offset (green)

        See #SetGainB.

        :type aValue: int, in
        :param aValue:  See #SetGainB.
        """
        return _ebus_python.PvBufferConverterRGBFilter_SetOffsetG(self, aValue)

    def SetOffsetB(self, aValue):
        r"""
        Set the filter's offset (blue)

        See #SetGainB.

        :type aValue: int, in
        :param aValue:  See #SetGainB.
        """
        return _ebus_python.PvBufferConverterRGBFilter_SetOffsetB(self, aValue)

    def WhiteBalance(self, aBuffer):
        r"""
        Calculate white-balance gains.

        The #WhiteBalance method receives an image and calculates
        appropriate gains to white-balance the image. This method
        sets the gains as if having called #SetGainB, #SetGainG, and #SetGainR.

        Internally, the #WhiteBalance method uses the following procedure:
            - Calculate the average colors in the image: Bavg, Gavg, Ravg.
            - Select the maximum of the three averages: Max = max (Bavg, Gavg, Ravg).
            - Set the new gains, where:
                - Bgain = Max / Bavg
                - Ggain = Max / Gavg
                - Rgain = Max / Ravg

        The #WhiteBalance method produces the best results for images that have an even mix of dark and light tones,
        and an even mix of colors.

        :type aBuffer: :py:class:`PvBuffer`, in
        :param aBuffer:   The sample image; the image upon which to base the
                                   white-balance settings.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER,
        """
        return _ebus_python.PvBufferConverterRGBFilter_WhiteBalance(self, aBuffer)

    def Reset(self):
        r"""
        Reset the RGB filter configuration.

        This method resets the RGB filter configuration (#PvBufferConverterRGBFilter) to its default values.

        Gains are set to 1; offsets, to 0. After a reset, applying the filter doesn't change the image.
        """
        return _ebus_python.PvBufferConverterRGBFilter_Reset(self)

# Register PvBufferConverterRGBFilter in _ebus_python:
_ebus_python.PvBufferConverterRGBFilter_swigregister(PvBufferConverterRGBFilter)
class PvCompressionFilter(object):
    r""" Filter used for image compression."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" Constructor."""
        _ebus_python.PvCompressionFilter_swiginit(self, _ebus_python.new_PvCompressionFilter())
    __swig_destroy__ = _ebus_python.delete_PvCompressionFilter

    def Execute(self, aIn, aOut):
        r"""
        Convert(*args) -> PvResult, PvBuffer

        To compress an image using Pleora Compression, you should create a destination buffer first
        before calling this API.

        Execute Pleora compression on a PvBuffer that is an image.

        :type aIn: :py:class:`PvBuffer`, in
        :param aIn:            The original image buffer.
        :type aOut: :py:class:`PvBuffer`, in
        :param aOut:           The buffer with the Pleora compressed data.

        :rtype:  Tuple(:py:class:`PvResult`, :py:class:`PvBuffer`)
        :return:
            Tuple composed of (result, aOut)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER`
             - aOut:
                - The aOut PvBuffer object containing the compressed data.

        """
        return _ebus_python.PvCompressionFilter_Execute(self, aIn, aOut)

    def SetThreadCount(self, aCount):
        r"""
        Sets the maximum of threads to use for compression. Not supported for compression.

        :type aCount: int
        :param aCount: [in] How many threads to use for compression.

        :rtype: :py:class:`PvResult`
        :return: Includes:
            - #PvResult::Code::NOT_SUPPORTED the compression filter does not support multi-threading.
        """
        return _ebus_python.PvCompressionFilter_SetThreadCount(self, aCount)

    def GetThreadCount(self):
        r"""
        Returns how many threads are used for compression.

        :rtype: int
        :return: How many threads are used for compression.
        """
        return _ebus_python.PvCompressionFilter_GetThreadCount(self)

    def GetThreadsPriority(self, aPriority):
        r"""
        Gets the thread priority of the filter's worker threads.

        :type aPriority: int
        :param aPriority: [out] Output reference to the worker threads priority.

        :rtype: :py:class:`PvResult`
        :return: Includes:
            - #PvResult::Code::OK
            - #PvResult::Code::NOT_SUPPORTED if the filter does not support multi-threading.
        """
        return _ebus_python.PvCompressionFilter_GetThreadsPriority(self, aPriority)

    def SetThreadsPriority(self, aPriority):
        r"""
        Sets the thread priority of the filter's worker threads.

        Only one worker thread is created.
        Setting thread priority isn't supported.

        :rtype: :py:class:`PvResult`
        :return: Includes:
            - #PvResult::Code::OK
            - #PvResult::Code::NOT_SUPPORTED if the filter does not support multi-threading.
            - #PvResult::Code::INVALID_PARAMETER if aPriority maps to nothing on the target system.
        """
        return _ebus_python.PvCompressionFilter_SetThreadsPriority(self, aPriority)

    def SetEncoding(self, aValue):
        r"""
        Sets the encoding used when compressing the image.

        :type aValue: int
        :param aValue: [in] Encoding to be used by the filter.

        :rtype: :py:class:`PvResult`
        :return: Includes:
            - #PvResult::Code::OK
            - #PvResult::Code::NOT_SUPPORTED if the requested encoding is not supported.
        """
        return _ebus_python.PvCompressionFilter_SetEncoding(self, aValue)

    def GetEncoding(self):
        r""" Returns the encoding used when compressing the image."""
        return _ebus_python.PvCompressionFilter_GetEncoding(self)

# Register PvCompressionFilter in _ebus_python:
_ebus_python.PvCompressionFilter_swigregister(PvCompressionFilter)
class PvDecompressionFilter(object):
    r""" Filter used for image decompression."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" Constructor."""
        _ebus_python.PvDecompressionFilter_swiginit(self, _ebus_python.new_PvDecompressionFilter())
    __swig_destroy__ = _ebus_python.delete_PvDecompressionFilter

    def Execute(self, aIn, aOut):
        r"""
        Convert(*args) -> PvResult, PvBuffer

        To decompress the Pleora Compressed data, you should create a destination buffer first
        before calling this API.

        Execute decompression on a Pleora compressed buffer.

        :type aIn: :py:class:`PvBuffer`, in
        :param aIn:            The original Pleora compressed buffer.
        :type aOut: :py:class:`PvBuffer`, in
        :param aOut:           The buffer for the decompressed image.

        :rtype:  Tuple(:py:class:`PvResult`, :py:class:`PvBuffer`)
        :return:
            Tuple composed of (result, aOut)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER`
                - :py:const:`~PvResultCode.PV_NOT_SUPPORTED`
                - :py:const:`~PvResultCode.PV_IMAGE_ERROR`
             - aOut:
                - The aOut PvBuffer object containing the decompressed image.

        """
        return _ebus_python.PvDecompressionFilter_Execute(self, aIn, aOut)

    def SetThreadCount(self, aCount):
        r"""
        Sets the maximum of threads to use for decompression.

        :type aCount: int
        :param aCount: [in] How many threads to use for decompression. Min: 1, Max: 64.

        :rtype: :py:class:`PvResult`
        :return: Includes:
            - #PvResult::Code::OK
            - #PvResult::Code::INVALID_PARAMETER if aCount is not valid.
            - #PvResult::Code::NOT_ENOUGH_MEMORY if all threads could not be allocated.
            - #PvResult::Code::NOT_SUPPORTED if the filter does not support multi-threading.
        """
        return _ebus_python.PvDecompressionFilter_SetThreadCount(self, aCount)

    def GetThreadCount(self):
        r"""
        Returns how many threads are used for decompression.

        :rtype: int
        :return: How many threads are used for decompression.
        """
        return _ebus_python.PvDecompressionFilter_GetThreadCount(self)

    def GetThreadsPriority(self, aPriority):
        r"""
        Gets the thread priority of the filter's worker threads.

        :type aPriority: int
        :param aPriority: [out] Output reference to the worker threads priority.

        :rtype: :py:class:`PvResult`
        :return: Includes:
            - #PvResult::Code::OK
            - #PvResult::Code::NOT_SUPPORTED if the filter does not support multi-threading.
        """
        return _ebus_python.PvDecompressionFilter_GetThreadsPriority(self, aPriority)

    def SetThreadsPriority(self, aPriority):
        r"""
        Sets the thread priority of the filter's worker threads.

        The default is  3 - THREAD_PRIORITY_NORMAL, see PvPipeline::SetBufferHandlingThreadPriority().
        We only allow setting priority for the threads of one converter object as a group.
        By default one worker thread is created for half of the total number of logical CPUs of the system.

        If you change the thread priorities, it may alterate the stability of the system. For this reason,
        if you report a bug to Pleora, ensure to clearly mention that you change threads priorities.

        :rtype: :py:class:`PvResult`
        :return: Includes:
            - #PvResult::Code::OK
            - #PvResult::Code::NOT_SUPPORTED if the filter does not support multi-threading.
            - #PvResult::Code::INVALID_PARAMETER if aPriority maps to nothing on the target system.
        """
        return _ebus_python.PvDecompressionFilter_SetThreadsPriority(self, aPriority)

    @staticmethod
    def IsCompressed(aIn):
        r"""
        Returns true if the buffer can be decompressed using an object of this class.

        :type aIn: :py:class:`PvBuffer`
        :param aIn: [in] Buffer to inspect.

        :rtype: boolean
        :return: True if the buffer can be decompressed.
        """
        return _ebus_python.PvDecompressionFilter_IsCompressed(aIn)

    @staticmethod
    def GetOutputFormatFor(aIn):
        r"""
        Convert(*args) -> PvResult, PvPixelType, int, int

        Retrieve image format from Pleora compressed header.

        :type aIn: :py:class:`PvBuffer`, in
        :param aIn:            The Pleora compressed buffer.

        :rtype:  Tuple(:py:class:`PvResult`, PvPixelType, int, int)
        :return:
            Tuple composed of (result, aPixelType, aWidth, aHeight)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER`
                - :py:const:`~PvResultCode.PV_NOT_SUPPORTED`
                - :py:const:`~PvResultCode.PV_IMAGE_ERROR`
             - aPixelType:
                - The pixel type of the compressed image.
             - aWidth:
                - The width of the compressed image.
             - aHeight:
                - The height of the compressed image.

        """
        return _ebus_python.PvDecompressionFilter_GetOutputFormatFor(aIn)

# Register PvDecompressionFilter in _ebus_python:
_ebus_python.PvDecompressionFilter_swigregister(PvDecompressionFilter)
PvGenVisibility = _ebus_python.PvGenVisibility 
PvGenVisibilityBeginner = _ebus_python.PvGenVisibilityBeginner
PvGenVisibilityExpert = _ebus_python.PvGenVisibilityExpert
PvGenVisibilityGuru = _ebus_python.PvGenVisibilityGuru
PvGenVisibilityInvisible = _ebus_python.PvGenVisibilityInvisible
PvGenVisibilityUndefined = _ebus_python.PvGenVisibilityUndefined
PvGenType = _ebus_python.PvGenType 
PvGenTypeInteger = _ebus_python.PvGenTypeInteger
PvGenTypeEnum = _ebus_python.PvGenTypeEnum
PvGenTypeBoolean = _ebus_python.PvGenTypeBoolean
PvGenTypeString = _ebus_python.PvGenTypeString
PvGenTypeCommand = _ebus_python.PvGenTypeCommand
PvGenTypeFloat = _ebus_python.PvGenTypeFloat
PvGenTypeRegister = _ebus_python.PvGenTypeRegister
PvGenTypeUndefined = _ebus_python.PvGenTypeUndefined
PvGenRepresentation = _ebus_python.PvGenRepresentation 
PvGenRepresentationLinear = _ebus_python.PvGenRepresentationLinear
PvGenRepresentationLogarithmic = _ebus_python.PvGenRepresentationLogarithmic
PvGenRepresentationBoolean = _ebus_python.PvGenRepresentationBoolean
PvGenRepresentationPureNumber = _ebus_python.PvGenRepresentationPureNumber
PvGenRepresentationHexNumber = _ebus_python.PvGenRepresentationHexNumber
PvGenRepresentationIPV4Address = _ebus_python.PvGenRepresentationIPV4Address
PvGenRepresentationMACAddress = _ebus_python.PvGenRepresentationMACAddress
PvGenRepresentationUndefined = _ebus_python.PvGenRepresentationUndefined
PvGenNameSpace = _ebus_python.PvGenNameSpace 
PvGenNameSpaceStandard = _ebus_python.PvGenNameSpaceStandard
PvGenNameSpaceCustom = _ebus_python.PvGenNameSpaceCustom
PvGenNameSpaceUndefined = _ebus_python.PvGenNameSpaceUndefined
PvGenAccessMode = _ebus_python.PvGenAccessMode 
PvGenAccessModeReadOnly = _ebus_python.PvGenAccessModeReadOnly
PvGenAccessModeReadWrite = _ebus_python.PvGenAccessModeReadWrite
PvGenAccessModeWriteOnly = _ebus_python.PvGenAccessModeWriteOnly
PvGenAccessModeNotImplemented = _ebus_python.PvGenAccessModeNotImplemented
PvGenAccessModeNotAvailable = _ebus_python.PvGenAccessModeNotAvailable
PvGenAccessModeUndefined = _ebus_python.PvGenAccessModeUndefined
PvGenCache = _ebus_python.PvGenCache 
PvGenCacheWriteThrough = _ebus_python.PvGenCacheWriteThrough
PvGenCacheWriteAround = _ebus_python.PvGenCacheWriteAround
PvGenCacheNone = _ebus_python.PvGenCacheNone
PvGenCacheUndefined = _ebus_python.PvGenCacheUndefined
PvGenRefresh = _ebus_python.PvGenRefresh 
PvGenRefreshInvalid = _ebus_python.PvGenRefreshInvalid
PvGenRefreshPolling = _ebus_python.PvGenRefreshPolling
PvGenRefreshAuto = _ebus_python.PvGenRefreshAuto
PvGenRefreshManual = _ebus_python.PvGenRefreshManual
PvGenEndianness = _ebus_python.PvGenEndianness 
PvGenEndiannessInvalid = _ebus_python.PvGenEndiannessInvalid
PvGenEndiannessLittle = _ebus_python.PvGenEndiannessLittle
PvGenEndiannessBig = _ebus_python.PvGenEndiannessBig
PvGenSign = _ebus_python.PvGenSign 
PvGenSignUndefined = _ebus_python.PvGenSignUndefined
PvGenSignUnsigned = _ebus_python.PvGenSignUnsigned
PvGenSignSigned = _ebus_python.PvGenSignSigned
class PvGenParameterArray(object):
    r"""
    GenICam feature array

    ##  id="controlling"Controlling features (programmatically)

    **To control features:**
        - Get the list of features. Use one of the following:
            - #PvDevice::GetParameters (Parameters used to control the GigE Vision device to which you are connected)
            - #PvDevice::GetCommunicationParameters (Parameters used to define how PvDevice connects to and communicates with the device - see Device Communication Parameters (GEV ("devicecommunicationGEV.html")/U3V ("devicecommunicationU3V.html"))
            - #PvStream::GetParameters (Parameters used to define how PvStream receives data from a GigE Vision transmitter - see Stream Parameters (GEV ("streamparametersGEV.html")/U3V ("streamparametersU3V.html"))
        - Get a feature. Use #Get.
        - Get the feature's type. Use #PvGenParameter::GetType.
        - Optionally:
            - Get/Set the feature's value. Use the GetValue/SetValue method for the feature's type (e.g. #PvGenInteger::GetValue, #PvGenFloat::SetValue, etc.)
            - If the feature is a command, activate it. Use #PvGenCommand::Execute.


    ##  id="controllingGUI"Controlling features (using a GUI)

    **To control features (using a GUI):**
        - See GenICam browser dialog documentation.

    ## Running code when a feature's value changes

    In some cases, you may want to know when a feature value or attribute changes without using CPU-intensive polling
    to regularly check (and re-check) the feature's value.

    **To create a callback that runs when the feature's value changes:**
        - Get the feature. See Controlling features ("#controlling").
        - Create a subclass of #PvGenEventSink.
        - Call #PvGenParameter::RegisterEventSink to be notified when that parameter is updated.
        - In your new class, override #PvGenEventSink::OnParameterUpdate.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" Constructor."""
        _ebus_python.PvGenParameterArray_swiginit(self, _ebus_python.new_PvGenParameterArray())
    __swig_destroy__ = _ebus_python.delete_PvGenParameterArray

    def GetCount(self):
        r"""
        Get the number of parameters (#PvGenParameter objects) in the array.


        :rtype: int
        :return: The number of parameters (#PvGenParameter objects) in the array.
        """
        return _ebus_python.PvGenParameterArray_GetCount(self)

    def Get(self, *args):
        r"""
        *Overload 1:*

        Get a parameter (#PvGenParameter object) from the array (using array position).

        :type aIndex: int, in
        :param aIndex:  The parameter's position in the array. The valid range for *aIndex*
                                is:  0 =< *aIndex* < #GetCount.

        :rtype: :py:class:`PvGenParameter`
        :return: The parameter (#PvGenParameter object), or NULL if the index is out of bounds.

        |

        *Overload 2:*

        Get a parameter (#PvGenParameter object) from the array (using parameter name).

        :type aName: str, in
        :param aName:  The parameter's name. See #PvGenParameter::GetName.

        :rtype: :py:class:`PvGenParameter`
        :return: The parameter (#PvGenParameter object), or NULL if the name does not match any paramaters in the array.
        """
        return _ebus_python.PvGenParameterArray_Get(self, *args)

    def __getitem__(self, *args):
        r"""
        *Overload 1:*

        Get a parameter (#PvGenParameter object) from the array (using array position).

        :type aIndex: int, in
        :param aIndex:  The parameter's position in the array. The valid range for *aIndex*
                                is:  0 =< *aIndex* < #GetCount.

        :rtype: :py:class:`PvGenParameter`
        :return: The parameter (#PvGenParameter object), or NULL if the index is out of bounds.

        |

        *Overload 2:*

        Get a parameter (#PvGenParameter object) from the array (using parameter name).

        :type aName: str, in
        :param aName:  The parameter's name. See #PvGenParameter::GetName.

        :rtype: :py:class:`PvGenParameter`
        :return: The parameter (#PvGenParameter object), or NULL if the name does not match any paramaters in the array.
        """
        return _ebus_python.PvGenParameterArray___getitem__(self, *args)

    def GetCategoryCount(self):
        r"""
        Get the number of categories (#PvGenCategory objects) in the array.

        :rtype: int
        :return: The number of categories (#PvGenCategory objects) in the array.
        """
        return _ebus_python.PvGenParameterArray_GetCategoryCount(self)

    def GetCategory(self, *args):
        r"""
        *Overload 1:*

        Get a category (#PvGenCategory object) from the array (using array position).

        :type aIndex: int, in
        :param aIndex:  The category's position in the array. The valid range for *aIndex*
                                is:  0 =< *aIndex* < #GetCategoryCount.

        :rtype: :py:class:`PvGenCategory`
        :return: The parameter (#PvGenCategory object), or NULL if the index is out of bounds.

        |

        *Overload 2:*

        Get a category (#PvGenCategory object) from the array (using category name).

        :type aName: str, in
        :param aName:  The category's name. See PvGenCategory::GetName.

        :rtype: :py:class:`PvGenCategory`
        :return: The category (#PvGenCategory object), or NULL if the name does not match any categories in the array.
        """
        return _ebus_python.PvGenParameterArray_GetCategory(self, *args)

    def InvalidateCache(self):
        r"""
        Invalidates the cache of the GenICam parameter array.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::GENERIC_ERROR (Use #PvResult::GetDescription to get more information.)
        """
        return _ebus_python.PvGenParameterArray_InvalidateCache(self)

    def GetNodeMap(self):
        r"""
        Returns the interface of the GenApi node map wrapped by this PvGenParameterArray

        :rtype: PV_GENAPI_NS::INodeMap
        :return: Interface of the GenApi node map wrapped by this PvGenPArameterArray

        For advanced use only.

        GenApi headers and link libraries are not provided
        with the eBUS SDK. In order to use the GenApi node map provided by this
        method, install the GenApi SDK.
        """
        return _ebus_python.PvGenParameterArray_GetNodeMap(self)

    def GetInteger(self, aName):
        r"""
        Helper method returning a PvGenParameter casted as a PvGenInteger.

        Returns NULL if the parameter does not exist in the node map or the
        parameter is not an integer.

        :type aName: str, in
        :param aName: Name of the parameter.

        :rtype: :py:class:`PvGenInteger`
        :return: PvGenInteger parameter pointer from the parameter array.
        """
        return _ebus_python.PvGenParameterArray_GetInteger(self, aName)

    def GetFloat(self, aName):
        r"""
        Helper method returning a PvGenParameter casted as a PvGenFloat.

        Returns NULL if the parameter does not exist in the node map or the
        parameter is not a float.

        :type aName: str, in
        :param aName: Name of the parameter.

        :rtype: :py:class:`PvGenFloat`
        :return: PvGenFloat parameter pointer from the parameter array.
        """
        return _ebus_python.PvGenParameterArray_GetFloat(self, aName)

    def GetEnum(self, aName):
        r"""
        Helper method returning a PvGenParameter casted as a PvGenEnum.

        Returns NULL if the parameter does not exist in the node map or the
        parameter is not an enumeration.

        :type aName: str, in
        :param aName: Name of the parameter.

        :rtype: :py:class:`PvGenEnum`
        :return: PvGenEnum parameter pointer from the parameter array.
        """
        return _ebus_python.PvGenParameterArray_GetEnum(self, aName)

    def GetBoolean(self, aName):
        r"""
        Helper method returning a PvGenParameter casted as a PvGenBoolean.

        Returns NULL if the parameter does not exist in the node map or the
        parameter is not a boolean.

        :type aName: str, in
        :param aName: Name of the parameter.

        :rtype: :py:class:`PvGenBoolean`
        :return: PvGenBoolean parameter pointer from the parameter array.
        """
        return _ebus_python.PvGenParameterArray_GetBoolean(self, aName)

    def GetCommand(self, aName):
        r"""
        Helper method returning a PvGenParameter casted as a PvGenCommand.

        Returns NULL if the parameter does not exist in the node map or the
        parameter is not a command.

        :type aName: str, in
        :param aName: Name of the parameter.

        :rtype: :py:class:`PvGenCommand`
        :return: PvGenBoolean parameter pointer from the parameter array.
        """
        return _ebus_python.PvGenParameterArray_GetCommand(self, aName)

    def GetString(self, aName):
        r"""
        Helper method returning a PvGenParameter casted as a PvGenString.

        Returns NULL if the parameter does not exist in the node map or the
        parameter is not a string.

        :type aName: str, in
        :param aName: Name of the parameter.

        :rtype: :py:class:`PvGenString`
        :return: PvGenString parameter pointer from the parameter array.
        """
        return _ebus_python.PvGenParameterArray_GetString(self, aName)

    def GetRegister(self, aName):
        r"""
        Helper method returning a PvGenParameter casted as a PvGenRegister.

        Returns NULL if the parameter does not exist in the node map or the
        parameter is not a register.

        :type aName: str, in
        :param aName: Name of the parameter.

        :rtype: :py:class:`PvGenRegister`
        :return: PvGenRegister parameter pointer from the parameter array.
        """
        return _ebus_python.PvGenParameterArray_GetRegister(self, aName)

    def GetIntegerValue(self, aName):
        r"""
        PvGenParameterArray::GetIntegerValue( aName ) -> PvResult, int
        Helper method used to directly read an integer parameter value of this parameter array.

        :type aName: str, in
        :param aName:  Name of the parameter to read the value from.

        :rtype: Tuple(:py:class:`PvResult`, int)
        :returns:
            Tuple composed of (result, intValue)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.NOT_FOUND` if the parameter does not exist or is not the right type
                - Any other error code from #PvGenInteger::GetValue
             - intValue: 
                - Value read from the parameter.

        """
        return _ebus_python.PvGenParameterArray_GetIntegerValue(self, aName)

    def SetIntegerValue(self, aName, aValue):
        r"""
        Helper method used to directly write an integer parameter value of this parameter array.

        :type aName: str, in
        :param aName:  Name of the parameter to write the value to.
        :type aValue: int, out
        :param aValue: Value written to the parameter.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_FOUND if the parameter does not exist or is not the right type
                - Any other error code from #PvGenInteger::SetValue
        """
        return _ebus_python.PvGenParameterArray_SetIntegerValue(self, aName, aValue)

    def GetFloatValue(self, aName):
        r"""
        PvGenParameterArray::GetFloatValue( aName ) -> PvResult, float
        Helper method used to directly read a float parameter value of this parameter array.

        :type aName: str, in
        :param aName:  Name of the parameter to read the value from.

        :rtype: Tuple(:py:class:`PvResult`, float)
        :returns:
            Tuple composed of (result, floatValue)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.NOT_FOUND` if the parameter does not exist or is not the right type
                - Any other error code from #PvGenFloat::GetValue
             - floatValue: 
                - Value read from the parameter.

        """
        return _ebus_python.PvGenParameterArray_GetFloatValue(self, aName)

    def SetFloatValue(self, aName, aValue):
        r"""
        Helper method used to directly write a float parameter value of this parameter array.

        :type aName: str, in
        :param aName:  Name of the parameter to write the value to.
        :type aValue: float, out
        :param aValue: Value written to the parameter.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_FOUND if the parameter does not exist or is not the right type
                - Any other error code from #PvGenFloat::SetValue
        """
        return _ebus_python.PvGenParameterArray_SetFloatValue(self, aName, aValue)

    def SetEnumValue(self, *args):
        r"""
        *Overload 1:*

        Helper method used to directly write an enumeration parameter value (as a string) of this parameter array.

        :type aName: str, in
        :param aName:  Name of the parameter to write the value to.
        :type aValue: str, in
        :param aValue: Value written to the parameter.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_FOUND if the parameter does not exist or is not the right type
                - Any other error code from #PvGenEnum::SetValue

        |

        *Overload 2:*

        Helper method used to directly write an enumeration parameter value (as an integer) of this parameter array.

        :type aName: str, in
        :param aName:  Name of the parameter to write the value to.
        :type aValue: int, in
        :param aValue: Value written to the parameter.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_FOUND if the parameter does not exist or is not the right type
                - Any other error code from #PvGenEnum::SetValue
        """
        return _ebus_python.PvGenParameterArray_SetEnumValue(self, *args)

    def GetBooleanValue(self, aName):
        r"""
        PvGenParameterArray::GetBooleanValue( aName ) -> PvResult, bool
        Helper method used to directly read a boolean parameter value of this parameter array.

        :type aName: str, in
        :param aName:  Name of the parameter to read the value from.

        :rtype: Tuple(:py:class:`PvResult`, bool)
        :returns:
            Tuple composed of (result, value)
             - resuult representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.NOT_FOUND` if the parameter does not exist or is not the right type
                - Any other error code from :py:func:`PvGenBoolean::GetValue`
             - value: 
                - Value read from the parameter.

        """
        return _ebus_python.PvGenParameterArray_GetBooleanValue(self, aName)

    def SetBooleanValue(self, aName, aValue):
        r"""
        Helper method used to directly write a boolean parameter value of this parameter array.

        :type aName: str, in
        :param aName:  Name of the parameter to write the value to.
        :type aValue: boolean, out
        :param aValue: Value written to the parameter.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_FOUND if the parameter does not exist or is not the right type
                - Any other error code from #PvGenBoolean::SetValue
        """
        return _ebus_python.PvGenParameterArray_SetBooleanValue(self, aName, aValue)

    def GetStringValue(self, aName):
        r"""
        PvGenParameterArray::GetStringValue( aName ) -> PvResult, str
        Helper method used to directly read a string parameter value of this parameter array.

        :type aName: str, in
        :param aName:  Name of the parameter to read the value from.

        :rtype: Tuple(:py:class:`PvResult`, str)
        :returns:
            Tuple composed of (result, value)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.NOT_FOUND` if the parameter does not exist or is not the right type
                - Any other error code from #PvGenString::GetValue
             - value: 
                - Value read from the parameter.

        """
        return _ebus_python.PvGenParameterArray_GetStringValue(self, aName)

    def SetStringValue(self, aName, aValue):
        r"""
        Helper method used to directly write a string parameter value of this parameter array.

        :type aName: str, in
        :param aName:  Name of the parameter to write the value to.
        :type aValue: str, out
        :param aValue: Value written to the parameter.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_FOUND if the parameter does not exist or is not the right type
                - Any other error code from #PvGenString::SetValue
        """
        return _ebus_python.PvGenParameterArray_SetStringValue(self, aName, aValue)

    def ExecuteCommand(self, aName):
        r"""
        Helper method used to directly execute a command parameter of this parameter array.

        :type aName: str, in
        :param aName:  Name of the parameter to execute.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_FOUND if the parameter does not exist or is not the right type
                - Any other error code from #PvGenCommand::Execute
        """
        return _ebus_python.PvGenParameterArray_ExecuteCommand(self, aName)

    def GetIntegerRange(self, aName):
        r"""
        PvGenParameterArray::GetIntegerRange( aName ) -> PvResult, int, int
        Helper method used to directly retrieve the range of an integer parameter.

        :type aName: str, in
        :param aName:  Name of the parameter to read the value from.

        :raises RuntimeError:  An error occurred. See exception text.

        :rtype: Tuple(:py:class:`PvResult`, int, int)
        :returns:
            A tuple composed of (result, min, max):
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.NOT_FOUND` if the parameter does not exist or is not the right type
                - Any other error code from #PvGenInteger::GetMin or #PvGenInteger::GetMax
             - min: 
                - The minimum of the range in int.
             - max: 
                - The maximum of the range in int.

        """
        return _ebus_python.PvGenParameterArray_GetIntegerRange(self, aName)

    def GetFloatRange(self, aName):
        r"""
        PvGenParameterArray::GetFloatRange( aName ) -> PvResult, float, float
        Helper method used to directly retrieve the range of a float parameter.

        :type aName: str, in
        :param aName:  Name of the parameter to read the value from.

        :rtype: Tuple(:py:class:`PvResult`, float, float)
        :returns:
            A tuple composed of (result, min, max):
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.NOT_FOUND` if the parameter does not exist or is not the right type
                - Any other error code from #PvGenFloat::GetMin or #PvGenFloat::GetMax
             - min: 
                - The minimum of the range in float.
             - max: 
                - The maximum of the range in float.

        """
        return _ebus_python.PvGenParameterArray_GetFloatRange(self, aName)

    def AttachDataChunks(self, aBuffer):
        r"""
        PvGenParameterArray::AttachDataChunks( aBuffer ) -> PvResult
        Attaches a payload containing data chunks to a GenICam node map.
        from the buffer matching chunk IDs in the node map are available through the node map once the buffer is attached.

        Using GenICam instead of the PvBuffer raw chunk methods access allows to access the chunks as structured data,
        as long as the chunks are described in the GenICam XML file of the device.

        :type aBuffer: ndarray, in
        :param aBuffer:  A 1-dimensional python numpy array with dtype np.uint8 containing buffer data (usually :py:func:`PvBuffer::GetRawData`)

        :rtype: :py:class:`PvResult`
        :returns: 
            Includes:
                - PV_OK: Success.
                - PV_INVALID_PARAMETER: aBuffer is NULL or aBufferLength is 0.
                - PV_INVALID_DATA_FORMAT: the chunk layout is invalid and has been rejected by GenApi.
                - PV_GENERIC_ERROR: if an error happened within GenApi. Use #PvResult::GetDescription to get more information.

        """
        return _ebus_python.PvGenParameterArray_AttachDataChunks(self, aBuffer)

    def DetachDataChunks(self):
        r"""
        Detach previously attached data chunks.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK: Success
                - #PvResult::Code::GENERIC_ERROR: if an error happened within GenApi. Use #PvResult::GetDescription to get more information.
        """
        return _ebus_python.PvGenParameterArray_DetachDataChunks(self)

    def GetAccessMode(self):
        r"""
        Returns the access mode of the port of the GenICam node map.

        :rtype: int
        :return: 
               Includes:
                - PvGenAccessModeReadOnly
                - PvGenAccessModeReadWrite
                - PvGenAccessModeNotAvailable
        """
        return _ebus_python.PvGenParameterArray_GetAccessMode(self)

    def Poll(self):
        r"""
        Invalidates nodes having reach their defined polling time since last update.

        Goes through all parameters having polling times defined and invalidates those that need to
        be invalidated based on the last time they were invalidated.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK: Success
                - #PvResult::Code::GENERIC_ERROR: if an error happened within GenApi. Use #PvResult::GetDescription to get more information.
        """
        return _ebus_python.PvGenParameterArray_Poll(self)

    def GetEnumValueString(self, aName):
        r"""
        PvGenParameterArray::GetEnumValueString( aName ) -> PvResult, str
        Helper method used to directly read an enumeration parameter value (as a string) of this parameter array.

        :type aName: str, in
        :param aName:  Name of the parameter to read the value from.

        :rtype: Tuple(:py:class:`PvResult`, str)
        :returns:
            Tuple composed of (result, valueString)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.NOT_FOUND` if the parameter does not exist or is not the right type
                - Any other error code from :py:func:`PvGenEnum::GetValueString`
             - valueString: 
                - Value read from the parameter, string representation.

        """
        return _ebus_python.PvGenParameterArray_GetEnumValueString(self, aName)

    def GetEnumValueInt(self, aName):
        r"""
        PvGenParameterArray::GetEnumValueInt( aName ) -> PvResult, int
        Helper method used to directly read an enumeration parameter value (as an integer) of this parameter array.

        :type aName: str, in
        :param aName:  Name of the parameter to read the value from.

        :rtype: Tuple(:py:class:`PvResult`, int)
        :returns:
            Tuple composed of (result, valueInt)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.NOT_FOUND` if the parameter does not exist or is not the right type
                - Any other error code from :py:func:`PvGenEnum::GetValueInt`
             - valueInt: 
                - Value read from the parameter, integer representation.

        """
        return _ebus_python.PvGenParameterArray_GetEnumValueInt(self, aName)

# Register PvGenParameterArray in _ebus_python:
_ebus_python.PvGenParameterArray_swigregister(PvGenParameterArray)
class PvGenParameterList(object):
    r"""
    Class used to hold a group of PvGenParameter pointers.

    Unlike the #PvGenParameterArray, this class does not wrap a node map. It
    only contains pointers to #PvGenParameter objects living in a
    #PvGenParameterArray of their own.

    To use this class, see #PvGenParameter GetSelectedParameters and GetSelectingParameters.
    It is used by the eBUS SDK to return a list of pointers to parameters whithin a
    PvGenParameterArray.

    The list can be accessed iteratively with GetFirst and GetNext or randomly with GetSize,
    GetItem or the operator[].

    ### How to use PvGenParameterList with PvGenParameter

    .. code-block:: c++

        PvGenParameter *lGenParameter = // ...get a parameter from a PvGenParameterArray

        PvGenParameterList lList;
        lGenParameter->GetSelectedParameters( lList );

        PvGenParameter *lP = lList.GetFirst();
        while ( lP != NULL )
        {
       ...
            Do something with lP
           ...

           lP = lList.GetNext();
        }
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" Constructor"""
        _ebus_python.PvGenParameterList_swiginit(self, _ebus_python.new_PvGenParameterList())
    __swig_destroy__ = _ebus_python.delete_PvGenParameterList

    def Clear(self):
        r""" Clears the parameter list"""
        return _ebus_python.PvGenParameterList_Clear(self)

    def Add(self, aParameter):
        r"""
        Adds an item to the parameter list.

        Notes: Adding an item in the list resets the #GetFirst, #GetNext internal iterator.

        :type aParameter: :py:class:`PvGenParameter`, in
        :param aParameter: The PvGenParameter pointer to add to the list.
        """
        return _ebus_python.PvGenParameterList_Add(self, aParameter)

    def GetSize(self):
        r"""
        Returns the size of the list.

        :rtype: int
        :return: The size, or count of items contained in the list.
        """
        return _ebus_python.PvGenParameterList_GetSize(self)

    def GetItem(self, aIndex):
        r"""
        Returns a specific item from the list.

        :rtype: :py:class:`PvGenParameter`
        :return: Index of the requested PvGenParameter pointer.

        :type aIndex: int, in
        :param aIndex: of the item to get.
        """
        return _ebus_python.PvGenParameterList_GetItem(self, aIndex)

    def __getitem__(self, aIndex):
        r"""
        [] operator.

        :rtype: :py:class:`PvGenParameter`
        :return: Index of the requested PvGenParameter pointer.

        :type aIndex: int, in
        :param aIndex: of the item to get.
        """
        return _ebus_python.PvGenParameterList___getitem__(self, aIndex)

    def GetFirst(self):
        r"""
        Returns the first item of the list.

        Sets the internal iterator to the first item. Subsequent calls
        to #GetNext can be used to scroll through the list.

        :rtype: :py:class:`PvGenParameter`
        :return: Pointer to the first item in the list, NULL if the list is empty.
        """
        return _ebus_python.PvGenParameterList_GetFirst(self)

    def GetNext(self):
        r"""
        Returns the next item in the list.

        Calling this method advances the internal iterator to the
        next item in the list.

        NULL is returned if the end of the list is reached.

        If #GetFirst is not called before #GetNext, the first call to
        #GetNext returns the first item in the list.

        :rtype: :py:class:`PvGenParameter`
        :return: Pointer to the next item in the list. NULL if the end of the list is reached.
        """
        return _ebus_python.PvGenParameterList_GetNext(self)

# Register PvGenParameterList in _ebus_python:
_ebus_python.PvGenParameterList_swigregister(PvGenParameterList)
class PvGenCategory(object):
    r""" GenICam category."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def GetName(self):
        r"""
        PvGenCategory::GetName() -> PvResult, str

        Get the category's name.

        :rtype: Tuple(:py:class:`PvResult`, str)
        :return:
            Tuple composed of (result, name):
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - name: 
                - The category's name. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenCategory_GetName(self)

    def GetToolTip(self):
        r"""
        PvGenCategory::GetToolTip() -> PvResult, str

        Get the category's tool tip.

        :rtype: Tuple(:py:class:`PvResult`, str)
        :return:
            Tuple composed of (result, tooltip):
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - tooltip: 
                - The category's tool tip. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenCategory_GetToolTip(self)

    def GetDescription(self):
        r"""
        PvGenCategory::GetDescription() -> PvResult, str

        Get the feature's Description.

        :rtype: Tuple(:py:class:`PvResult`, str)
        :return:
            Tuple composed of (result, description)
             - resultrepresenting the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - description: 
                - The feature's Description. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenCategory_GetDescription(self)

    def GetDisplayName(self):
        r"""
        PvGenCategory::GetDisplayName() -> PvResult, str

        Get the category's display name; a name that can be used to identify a category in a user-interface
        context instead of #GetName. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        :rtype: Tuple(:py:class:`PvResult`, str)
        :return:
            Tuple composed of (result, displayname)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - displayname: 
                - The feature's display name.

        """
        return _ebus_python.PvGenCategory_GetDisplayName(self)

    def GetNameSpace(self):
        r"""
        PvGenCategory::GetNameSpace() -> PvResult, int

        Get the category's name space.

        :rtype: Tuple(:py:class:`PvResult`, int)
        :return:
            Tuple composed of (result, namespace)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - namespace: 
                - PvGenNameSpace, the category's name space. See #PvGenNameSpace Enum. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenCategory_GetNameSpace(self)

    def GetVisibility(self):
        r"""
        PvGenCategory::GetVisibility() -> PvResult, int

        Get the category's recommended user level (visibility).

        :rtype: Tuple(:py:class:`PvResult`, int)
        :return:
            Tuple composed of (result, visibility)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - visibility: 
                - PvGenVisibility, the category's recommended user level. See #PvGenVisibility Enum. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenCategory_GetVisibility(self)

    def IsVisible(self, aCurrentVisibility):
        r"""
        PvGenCategory::IsVisible( aCurrentVisibility ) -> PvResult, bool
        Test if the category is visible at the specified visibilty level.

        :rtype: Tuple(:py:class:`PvResult`, bool)
        :return:
            Tuple composed of (result, IsVisible)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - IsVisible: 
                - True if the category is visible at the specified visibilty level.

        """
        return _ebus_python.PvGenCategory_IsVisible(self, aCurrentVisibility)

    def IsImplemented(self):
        r"""
        PvGenCategory::IsImplemented() -> PvResult, bool
        Test if the category is implemented.
        Typically the IsImplemented attribute does not change during the lifetime of a category.
        However some GenICam interfaces are using using IsImplemented in order to activate hidden or
        advanced features.

        :rtype: Tuple(:py:class:`PvResult`, bool)
        :return:
            Tuple composed of (result, IsImplemented)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - IsImplemented: 
                - True if the parameter is currently implemented; otherwise, false.

        """
        return _ebus_python.PvGenCategory_IsImplemented(self)

    def GetNode(self):
        r"""
        Returns the GenApi node wrapped by this PvGenCategory

        :rtype: PV_GENAPI_NS::INode
        :return: GenApi node wrapped by this PvGenCategory

        For advanced use only.

        GenApi headers and link libraries are not provided
        with the eBUS SDK. In order to use the GenApi node provided by this
        method, install the GenApi SDK.
        """
        return _ebus_python.PvGenCategory_GetNode(self)

# Register PvGenCategory in _ebus_python:
_ebus_python.PvGenCategory_swigregister(PvGenCategory)
class PvGenParameter(object):
    r""" Base class for all GenICam feature types."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def GetName(self):
        r"""
        PvGenParameters::GetName() -> PvResult, str

        Get the parameter's name.

        :rtype: Tuple(:py:class:`PvResult`, str)
        :return:
            Tuple composed of (result, name)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - name: 
                - The parameter's name.

        """
        return _ebus_python.PvGenParameter_GetName(self)

    def GetType(self):
        r"""
        PvGenParameters::GetType() -> PvResult, int

        Get the parameter's type.

        :rtype: Tuple(:py:class:`PvResult`, int)
        :return:
            Tuple composed of (result, type)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - type: 
                - The parameter's type; See #PvGenType Enum. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenParameter_GetType(self)

    def GetCategory(self):
        r"""
        PvGenParameters::GetCategory() -> PvResult, str

        Get the parameter's category.

        :rtype: Tuple(:py:class:`PvResult`, str)
        :return:
            Tuple composed of (result, category)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - category: 
                - The parameter's category. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenParameter_GetCategory(self)

    def GetToolTip(self):
        r"""
        PvGenParameters::GetToolTip() -> PvResult, str

        Get the parameter's tool tip.

        :rtype: Tuple(:py:class:`PvResult`, str)
        :return:
            Tuple composed of (result, tooltip)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - tooltip: 
                - The parameter's tool tip; typically a brief description of how to use the parameter. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenParameter_GetToolTip(self)

    def GetDescription(self):
        r"""
        PvGenParameters::GetDescription() -> PvResult, str

        Get the parameter's description.

        :rtype: Tuple(:py:class:`PvResult`, str)
        :return:
            Tuple composed of (result, description)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - description: 
                - The parameter's description; typically a long description of what the parameter is. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenParameter_GetDescription(self)

    def GetDisplayName(self):
        r"""
        PvGenParameters::GetDisplayName() -> PvResult, str

        Get the parameter's display name.

        :rtype: Tuple(:py:class:`PvResult`, str)
        :return:
            Tuple composed of (result, displayname)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - displayname: 
                - The parameter's display name; a name that can be used to identify a parameter in a user-interface context instead of #GetName. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenParameter_GetDisplayName(self)

    def GetNameSpace(self):
        r"""
        PvGenParameters::GetNameSpace() -> PvResult, int

        Get the parameter's name space.

        :rtype: Tuple(:py:class:`PvResult`, int)
        :return:
            Tuple composed of (result, namespacec)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - namespace: 
                - The parameter's name space. See #PvGenNameSpace Enum. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenParameter_GetNameSpace(self)

    def IsValueCached(self):
        r"""
        PvGenParameters::IsValueCached() -> PvResult, bool

        Test if the parameter's value is cached in the PC.

        :rtype: Tuple(:py:class:`PvResult`, bool)
        :return:
            Tuple composed of (result, IsValueCached)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - IsValueCached: 
                - True if the PC keeps a cached version of the parameter's value; 
                - False if the value must be retrieved from the video interface each time it's requested.

        """
        return _ebus_python.PvGenParameter_IsValueCached(self)

    def IsPersistent(self):
        r"""
        PvGenParameters::IsPersistent() -> PvResult bool

        Test if the parameter is to be considered when saving the state of a GenICam interface to disk.

        The #IsPersistent tests if the feature's persistence attribute is true. 

        Features that might not be persistent:
            - Features such as a clock's current value and others that are meaningless shortly after the value is retrieved. 
            - Some network configuration settings.
            - Etc.

        :rtype: Tuple(:py:class:`PvResult`, bool)
        :return:
            Tuple composed of (result, IsPersistent)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - IsPersistent: 
                - True if the parameter's value is persistent; otherwise, false.

        """
        return _ebus_python.PvGenParameter_IsPersistent(self)

    def IsImplemented(self):
        r"""
        PvGenParameters::IsImplemented() -> PvResult, bool

        Test if the parameter is implemented.

        Typically the IsImplemented attribute does not change during the lifetime of a parameter.

        However some GenICam interfaces are using IsImplemented in order to activate hidden or advanced features.

        :rtype: Tuple(:py:class:`PvResult`, bool)
        :return:
            Tuple composed of (result, IsImplemented)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - IsImplemented: 
                - True if the parameter is implemented; otherwise, false.

        """
        return _ebus_python.PvGenParameter_IsImplemented(self)

    def IsAvailable(self):
        r"""
        PvGenParameters::IsAvailable() -> PvResult, bool

        Test if the parameter is currently available, but may be available latter on.

        :rtype: Tuple(:py:class:`PvResult`, bool)
        :return:
            Tuple composed of (result, IsAvailable)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - IsAvailable: 
                - True if the parameter is currently available; otherwise, false.

        """
        return _ebus_python.PvGenParameter_IsAvailable(self)

    def IsWritable(self):
        r"""
        PvGenParameters::IsWritable() -> PvResult, bool

        Test if the parameter is writable.

        :rtype: Tuple(:py:class:`PvResult`, bool)
        :return:
            Tuple composed of (result, IsWritable)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - IsWritable: 
                - True if the parameter is currently writable; otherwise, false.

        """
        return _ebus_python.PvGenParameter_IsWritable(self)

    def IsReadable(self):
        r"""
        PvGenParameters::IsReadable() -> PvResult, bool

        Test if the parameter is readable.

        'Readable' is an attribute in the GenICam specification; in practice most parameters are readable.

        :rtype: Tuple(:py:class:`PvResult`, bool)
        :return:
            Tuple composed of (result, IsReadable)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - IsReadable: 
                - True if the parameter is currently readable; otherwise, false.

        """
        return _ebus_python.PvGenParameter_IsReadable(self)

    def IsStreamable(self):
        r"""
        PvGenParameters::IsStreamable() -> PvResult, bool

        Test if the parameter is streamable.

        'Streamable' is an attribute in the GenICam specification; If true, it means the parameter should be considered for persistence.

        :rtype: Tuple(:py:class:`PvResult`, bool)
        :return:
            Tuple composed of (result, IsStreamable)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - IsStreamable: 
                - True if the parameter to be considered for persistence; otherwise, false.

        """
        return _ebus_python.PvGenParameter_IsStreamable(self)

    def GetVisibility(self):
        r"""
        PvGenParameters::GetVisibility() -> PvResult, int
        Get the parameter's recommended user level (visibility)

        :rtype: Tuple(:py:class:`PvResult`, int)
        :return:
            Tuple composed of (result, visibility)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - visibility: 
                - PvGenVisibility, the parameter's recommended user level; See #PvGenVisibility Enum.

        """
        return _ebus_python.PvGenParameter_GetVisibility(self)

    def IsVisible(self, aCurrentVisibility):
        r"""
        PvGenParameters::IsVisible( aCurrentVisibility ) -> PvResult, bool
        Test if the parameter is visible at the specified visibilty level.

        :type aCurrentVisibility: int, in
        :param aCurrentVisibility:  PvGenVisibility, the category's recommended user level (visibility). See #PvGenVisibility Enum.

        :rtype: Tuple(:py:class:`PvResult`, bool)
        :return:
            Tuple composed of (result, IsVisible)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - IsVisible: 
                - True if the parameter is visible; otherwise, false.

        """
        return _ebus_python.PvGenParameter_IsVisible(self, aCurrentVisibility)

    def IsSelector(self):
        r"""
        PvGenParameters::IsSelector() -> PvResult, bool
        Queries whether this parameter is a selector or not.

        :rtype: Tuple(:py:class:`PvResult`, bool)
        :return:
            Tuple composed of (result, IsSelector)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - IsSelector: 
                - True if the parameter is a selector. False if not.

        """
        return _ebus_python.PvGenParameter_IsSelector(self)

    def GetSelectedParameters(self):
        r"""
        PvGenParameters::GetSelectedParameters() -> PvResult, PvGenParameterList
        Returns all parameters selected by this parameter.

        :rtype: Tuple(:py:class:`PvResult`, :py:class:`PvGenParameterList`)
        :return:
            Tuple composed of (result, parameterList)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - parameterList: 
                - #PvGenParameterList (output) where this method copies selected parameter.

        """
        return _ebus_python.PvGenParameter_GetSelectedParameters(self)

    def GetSelectingParameters(self):
        r"""
        PvGenParameters::GetSelectingParameters() -> PvResult, PvGenParameterList
        Returns all selectors for this parameter.

        :rtype: Tuple(:py:class:`PvResult`, :py:class:`PvGenParameterList`)
        :return:
            Tuple composed of (result, parameterList)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - parameterList: 
                - #PvGenParameterList (output) where this method copies selector parameter.

        """
        return _ebus_python.PvGenParameter_GetSelectingParameters(self)

    def RegisterEventSink(self, aEventSink):
        r"""
        Register an event sink interface that will be used for callbacks on this parameter.

        Event sinks are automatically unregistered when the #PvGenParameter object is destroyed
        (even if #UnregisterEventSink wasn't called).

        :type aEventSink: :py:class:`PvGenEventSink`, in
        :param aEventSink:  The event sink.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
                - #PvResult::Code::GENERIC_ERROR
        """
        return _ebus_python.PvGenParameter_RegisterEventSink(self, aEventSink)

    def UnregisterEventSink(self, aEventSink):
        r"""
        Unregister an event sink.

        :type aEventSink: :py:class:`PvGenEventSink`, in
        :param aEventSink: See #RegisterEventSink

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_FOUND
                - #PvResult::Code::INVALID_PARAMETER
        """
        return _ebus_python.PvGenParameter_UnregisterEventSink(self, aEventSink)

    def ToString(self):
        r"""
        PvGenParameters::ToString() -> PvResult, str
        Gets the parameter value as a string.
        Typically used for UI, persistence.

        :rtype: Tuple(:py:class:`PvResult`, str)
        :return:
            Tuple composed of (result, stringValue)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - stringValue: 
                - A string representing the parameter value.

        """
        return _ebus_python.PvGenParameter_ToString(self)

    def FromString(self, aValue):
        r"""
        Sets the parameter value from a string.

        :type aValue: str, in
        :param aValue:  A string representing the new value to set the parameter to.

        Typically used for UI, persistence.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::GENERIC_ERROR (Use #PvResult::GetDescription to get more information.)
        """
        return _ebus_python.PvGenParameter_FromString(self, aValue)

    def GetNode(self):
        r"""
        Returns the GenApi node wrapped by this PvGenParameter

        :rtype: PV_GENAPI_NS::INode
        :return: GenApi node wrapped by this PvGenPArameter

        For advanced use only.

        GenApi headers and link libraries are not provided
        with the eBUS SDK. In order to use the GenApi node provided by this
        method, install the GenApi SDK.
        """
        return _ebus_python.PvGenParameter_GetNode(self)

    def GetUpdatesEnabled(self):
        r"""
        Returns true if parameter update notifications are temporarily disabled.

        :rtype: boolean
        :return: True if they are disabled, false if not.
        """
        return _ebus_python.PvGenParameter_GetUpdatesEnabled(self)

    def SetUpdatesEnabled(self, aEnabled):
        r"""
        Temporarily disable (or re-enable) parameter update notifications.

        :type aEnabled: boolean, in
        :param aEnabled: False to disable, true to re-enable.
        """
        return _ebus_python.PvGenParameter_SetUpdatesEnabled(self, aEnabled)

# Register PvGenParameter in _ebus_python:
_ebus_python.PvGenParameter_swigregister(PvGenParameter)
class PvGenEventSink(object):
    r"""
    Observer interface for an observable PvGenParameter object

    To use #PvGenEventSink, see #PvGenParameter::RegisterEventSink.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def OnParameterUpdate(self, aParameter):
        r"""
         Callback that is invoked when a feature's value is updated.

        :type aParameter: :py:class:`PvGenParameter`, in
        :param aParameter:  The feature that was updated.
        """
        return _ebus_python.PvGenEventSink_OnParameterUpdate(self, aParameter)
    __swig_destroy__ = _ebus_python.delete_PvGenEventSink

# Register PvGenEventSink in _ebus_python:
_ebus_python.PvGenEventSink_swigregister(PvGenEventSink)
class PvGenBoolean(PvGenParameter):
    r"""
    GenICam feature: Boolean. A feature which can either be true or false.

    To use this class, see #PvGenParameter.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def SetValue(self, aValue):
        r"""
        Set the feature's value.

        :type aValue: boolean, in
        :param aValue:  The feature's new value.

        :rtype: :py:class:`PvResult`
        :return: Includes:
            	- #PvResult::Code::OK
            	- #PvResult::Code::GENERIC_ERROR (Use #PvResult::GetDescription to get more information.)
        """
        return _ebus_python.PvGenBoolean_SetValue(self, aValue)

    def GetValue(self):
        r"""
        PvGenBoolean::GetValue() -> PvResult, int

        Get the feature's value.

        :rtype: Tuple(:py:class:`PvResult`, int)
        :return:
            Tuple composed of (result, value):
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - value: 
                - The feature's new value. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenBoolean_GetValue(self)

# Register PvGenBoolean in _ebus_python:
_ebus_python.PvGenBoolean_swigregister(PvGenBoolean)
class PvGenCommand(PvGenParameter):
    r"""
    GenICam feature: Command. A feature which can only be activated.

    To use this class, see #PvGenParameter.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Execute(self):
        r"""
        Activate the feature.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
            	- #PvResult::Code::OK
            	- #PvResult::Code::GENERIC_ERROR (Use #PvResult::GetDescription to get more information.)
        """
        return _ebus_python.PvGenCommand_Execute(self)

    def IsDone(self):
        r"""
        PvGenCommand::IsDone() -> PvResult, bool

        Query whether the command is executed.

        :rtype: Tuple(:py:class:`PvResult`, bool)
        :return:
            Tuple composed of (result, IsDone)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - IsDone: 
                - True if the command has completed its execution. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenCommand_IsDone(self)

# Register PvGenCommand in _ebus_python:
_ebus_python.PvGenCommand_swigregister(PvGenCommand)
class PvGenEnum(PvGenParameter):
    r"""
    GenICam feature: Enumeration. A feature which can take one of many defined values.

    #PvGenEnum is a list of selectable values. In a UI, #PvGenEnum objects are
    typically represented as dropdown lists.

    Each list entry is a #PvGenEnumEntry object.

    Thus, the enumeration list might be represented as:


    +--------------+-------------+------------+
    |List position | Entry value | Entry name |
    +--------------+-------------+------------+
    |0             | 5           | Orange     |
    +--------------+-------------+------------+
    |1             | 4           | Apple      |
    +--------------+-------------+------------+
    |2             | 99          | Watermelon |
    +--------------+-------------+------------+


    However, the UI presents only a selection of entry names (Orange, etc.); the list
    position and entry values are hidden. The entry names are always unique.

    Enumerations can't be set to any arbitrary value; they can only be set
    to a value of an entry on the list.
    If a user selected Orange, you could set the new value in the following ways:

    	- Set the entry value directly with #SetValue ( 5 ).
    	- Set the entry value by the name with #SetValue ( "Orange" ).
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def SetValue(self, *args):
        r"""
        *Overload 1:*

        Set the feature's value.

        :type aValue: int, in
        :param aValue: The enumerator entry's feature's value (#PvGenEnumEntry::GetValue).

        :rtype: :py:class:`PvResult`
        :return: See #GetEntriesCount.

        |

        *Overload 2:*

        Set feature's value.

        :type aValue: str, in
        :param aValue: The enumerator entry's name (#PvGenEnumEntry::GetName).

        :rtype: :py:class:`PvResult`
        :return: See #GetEntriesCount.
        """
        return _ebus_python.PvGenEnum_SetValue(self, *args)

    def GetEntriesCount(self):
        r"""
        PvGenEnum::GetEntriesCount() -> PvResult, int

        Get the number of enumaration entries.

        :rtype: Tuple(:py:class:`PvResult`, int)
        :return:
            Tuple composed of (result, count)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - count: 
                - The number of enumeration entries. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenEnum_GetEntriesCount(self)

    def GetEntryByName(self, aEntryName):
        r"""
        PvGenEnum::GetEntryByName( aEntryName ) -> PvResult, int

        Query whether the command is executed.

        :type aEntryName: str, in
        :param aEntryName:  The enumeration entry's name (See #PvGenEnumEntry::GetName).

        :rtype: Tuple(:py:class:`PvResult`, int)
        :return:
            Tuple composed of (result, entry)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - entry: 
                - PvGenEnumEntry, the enumeration entry. See #PvGenEnumEntry Enum. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenEnum_GetEntryByName(self, aEntryName)

    def GetEntryByIndex(self, aIndex):
        r"""
        PvGenEnum::GetEntryByIndex( aIndex ) -> PvResult, int

        Get an enumeration entry (by list position).

        The enumeration entry's position in the list. The enumerator (#PvGenEnum object) has a list that ranges
        from 0 to PvGenEnum::GetEntriesCount.

        :type aIndex: int, in
        :param aIndex:  The enumeration entry's position in list (PvGenEnumEntry::GetEntriesCount).

        :rtype: Tuple(:py:class:`PvResult`, int)
        :return:
            Tuple composed of (result, entry)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - entry: 
                - PvGenEnumEntry, the enumeration entry. See #PvGenEnumEntry Enum. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenEnum_GetEntryByIndex(self, aIndex)

    def GetEntryByValue(self, aValue):
        r"""
        PvGenEnum::GetEntryByValue( aValue ) -> PvResult, int

        Get an enumeration entry (by value).

        :type aValue: int, in
        :param aValue:  The enumeration entry's value (PvGenEnumEntry::GetValue).

        :rtype: Tuple(:py:class:`PvResult`, int)
        :return:
            Tuple composed of (result, entry)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - entry: 
                - PvGenEnumEntry, the enumeration entry. See #PvGenEnumEntry Enum. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenEnum_GetEntryByValue(self, aValue)

    def GetValueString(self):
        r"""
        PvGenEnum::GetValueString() -> PvResult, str

        Get the feature's value (as a string).

        :rtype: Tuple(:py:class:`PvResult`, str)
        :return:
            Tuple composed of (result, valuestring)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - valuestring: 
                - The feature's value in string (equivalent to PvGenEnumEntry::GetValueString). (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenEnum_GetValueString(self)

    def GetValueInt(self):
        r"""
        PvGenEnum::GetValueInt() -> PvResult, int

        Get the feature's value (as an integer).

        :rtype: Tuple(:py:class:`PvResult`, int)
        :return:
            Tuple composed of (result, valueint)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - valueint: 
                - The feature's value in int (equivalent to PvGenEnumEntry::GetValueInt). (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenEnum_GetValueInt(self)

# Register PvGenEnum in _ebus_python:
_ebus_python.PvGenEnum_swigregister(PvGenEnum)
class PvGenEnumEntry(object):
    r"""
    GenICam feature: Enumeration entry

    To use #PvGenEnumEntry, see #PvGenEnum.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def GetValue(self):
        r"""
        PvGenEnumEntry::GetValue() -> PvResult, int

        Get the enumeration entry's value.

        :rtype: Tuple(:py:class:`PvResult`, int)
        :return:
            Tuple composed of (result, value)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - value: 
                - The enumeration entry's value. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenEnumEntry_GetValue(self)

    def GetName(self):
        r"""
        PvGenEnumEntry::GetName() -> PvResult, str

        Get the enumeration entry's name.

        :rtype: Tuple(:py:class:`PvResult`, str)
        :return:
            Tuple composed of (result, name)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - name: 
                - The The enumeration entry's name. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenEnumEntry_GetName(self)

    def GetToolTip(self):
        r"""
        PvGenEnumEntry::GetToolTip() -> PvResult, str

        Get a short description of the enum entry.

        :rtype: Tuple(:py:class:`PvResult`, str)
        :return:
            Tuple composed of (result, tooltip)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - tooltip: 
                - A short description of the enum entry. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenEnumEntry_GetToolTip(self)

    def GetDescription(self):
        r"""
        PvGenEnumEntry::GetDescription() -> PvResult, str

        Get a longer description of the enum entry.

        :rtype: Tuple(:py:class:`PvResult`, str)
        :return:
            Tuple composed of (result, description)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - description: 
                - A longer description of the enum entry. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenEnumEntry_GetDescription(self)

    def GetVisibility(self):
        r"""
        PvGenEnumEntry::GetVisibility() -> PvResult, int

        Get the enumeration entry's current visibility level.

        See #PvGenParameter::GetVisibility.

        :rtype: Tuple(:py:class:`PvResult`, int)
        :return:
            Tuple composed of (result, visibility)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - visibility: 
                - see #PvGenVisibility Enum. See #PvGenParameter::GetVisibility. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenEnumEntry_GetVisibility(self)

    def GetDisplayName(self):
        r"""
        PvGenEnumEntry::GetDisplayName() -> PvResult, str
        Get the enum entry's display name.

        :raises RuntimeError:  An error occurred. See exception text.

        :rtype: Tuple(:py:class:`PvResult`, str)
        :return:
            Tuple composed of (result, displayname)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - displayname: 
                - The enum entry's display name; a name that can be used to identify an enum entry in a 
                    user-interface context instead of #GetName. 
                    (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenEnumEntry_GetDisplayName(self)

    def GetNameSpace(self):
        r"""
        PvGenEnumEntry::GetNameSpace() -> PvResult, int
        Get the enum enty's name space.

        :rtype: Tuple(:py:class:`PvResult`, int)
        :return:
            Tuple composed of (result, namespace)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - namespace: 
                - PvGenNameSpace, The enum entry's name space. See #PvGenNameSpace Enum. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenEnumEntry_GetNameSpace(self)

    def IsVisible(self, aVisibility):
        r"""
        PvGenEnumEntry::IsVisible( aVisibility ) -> PvResult, bool
        Test if the parameter is visible at the specified visibilty level.

        :type aVisibility: int, in
        :param aVisibility:  See #PvGenVisibility Enum.

        :rtype: Tuple(:py:class:`PvResult`, bool)
        :return:
            Tuple composed of (result, IsVisible)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - IsVisible: 
                - True if the parameter is visible at the specified visibilty level.

        """
        return _ebus_python.PvGenEnumEntry_IsVisible(self, aVisibility)

    def IsAvailable(self):
        r"""
        PvGenEnumEntry::IsAvailable() -> PvResult, bool
        Test if the enumeration entry is currently available.

        :rtype: Tuple(:py:class:`PvResult`, bool)
        :return:
            Tuple composed of (result, IsAvailable)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - IsAvailable: 
                - True if the enumeration entry is currently available.

        """
        return _ebus_python.PvGenEnumEntry_IsAvailable(self)

# Register PvGenEnumEntry in _ebus_python:
_ebus_python.PvGenEnumEntry_swigregister(PvGenEnumEntry)
class PvGenFloat(PvGenParameter):
    r"""
    GenICam feature: Float

    To use this class, see #PvGenParameter.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def SetValue(self, aValue):
        r"""
        Set the feature's value.

        :type aValue: float, in
        :param aValue: The feature's new value.


        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::GENERIC_ERROR (Use #PvResult::GetDescription to get more information.)
        """
        return _ebus_python.PvGenFloat_SetValue(self, aValue)

    def GetValue(self):
        r"""
        PvGenFloat::GetValue() -> PvResult, float
        Get the feature's value.

        :rtype: Tuple(:py:class:`PvResult`, float)
        :return:
            Tuple composed of (result, value)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - value: 
                - The feature's value. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenFloat_GetValue(self)

    def GetMin(self):
        r"""
        PvGenFloat::GetMin() -> PvResult, float
        Get the feature's limits (minimum).

        :rtype: Tuple(:py:class:`PvResult`, float)
        :return:
            Tuple composed of (result, min)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - min: 
                - The feature's minimum allowable value. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenFloat_GetMin(self)

    def GetMax(self):
        r"""
        PvGenFloat::GetMax() -> PvResult, float
        Get the feature's limits (maximum).

        :rtype: Tuple(:py:class:`PvResult`, float)
        :return:
            Tuple composed of (result, max)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - max: 
                - The feature's maximum allowable value. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenFloat_GetMax(self)

    def GetRepresentation(self):
        r"""
        PvGenFloat::GetRepresentation() -> PvResult, int
        Get the feature's suggested presentation format.

        :rtype: Tuple(:py:class:`PvResult`, int)
        :return:
            Tuple composed of (result, representation)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - representation: 
                - The feature's suggested presentation format; See #PvGenRepresentation Enum.

        """
        return _ebus_python.PvGenFloat_GetRepresentation(self)

    def GetUnit(self):
        r"""
        PvGenFloat::GetUnit() -> PvResult, str
        Get the feature's measurement unit.
        The #GetUnit method returns a string with the units for the feature. For example, 
        the string might contain "pixels", "bytes", "ms", and so on. The string
        is informational and has no intrinsic value for converting to other units.

        :rtype: Tuple(:py:class:`PvResult`, str)
        :return:
            Tuple composed of (result, unit)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - unit: 
                - The units for the feature. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenFloat_GetUnit(self)

# Register PvGenFloat in _ebus_python:
_ebus_python.PvGenFloat_swigregister(PvGenFloat)
class PvGenInteger(PvGenParameter):
    r"""
    GenICam feature: Integer

    To use this class, see #PvGenParameter.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def SetValue(self, aValue):
        r"""
        Set the feature's new value.

        :type aValue: int, in
        :param aValue: The feature's new value.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::GENERIC_ERROR (Use #PvResult::GetDescription to get more information.)
        """
        return _ebus_python.PvGenInteger_SetValue(self, aValue)

    def GetValue(self):
        r"""
        PvGenInteger::GetValue() -> PvResult, int
        Get the feature's value.

        :rtype: Tuple(:py:class:`PvResult`, int)
        :return:
            Tuple composed of (result, value)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - value: 
                - The feature's new value. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenInteger_GetValue(self)

    def GetMin(self):
        r"""
        PvGenInteger::GetMin() -> PvResult, int
        Get the feature's limits (minimum).

        :rtype: Tuple(:py:class:`PvResult`, int)
        :return:
            Tuple composed of (result, min)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - min: 
                - The feature's minimum allowable value. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenInteger_GetMin(self)

    def GetMax(self):
        r"""
        PvGenInteger::GetMax() -> PvResult, int
        Get the feature's limits (maximum).

        :rtype: Tuple(:py:class:`PvResult`, int)
        :return:
            Tuple composed of (result, max)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - max: 
                - The feature's maximum allowable value. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenInteger_GetMax(self)

    def GetIncrement(self):
        r"""
        PvGenInteger::GetIncrement() -> PvResult, int
        Get the feature's suggested increment.
        The #GetIncrement method suggests how much an up/down button in the UI should increment/decrement
        the current value. 

        For example, a feature with a range of 0 to 1000000 might have an increment of 100000 to keep the user
        from having to click excessively.

        :rtype: Tuple(:py:class:`PvResult`, int)
        :return:
            Tuple composed of (result, increment)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - increment: 
                - The feature's suggested increment. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenInteger_GetIncrement(self)

    def GetRepresentation(self):
        r"""
        PvGenInteger::GetRepresentation() -> PvResult, int
        Get the feature's suggested presentation format.

        :rtype: Tuple(:py:class:`PvResult`, int)
        :return:
            Tuple composed of (result, representation)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - representation: 
                - PvGenRepresentation. See #PvGenRepresentation Enum. See #PvGenFloat::GetRepresentation. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenInteger_GetRepresentation(self)

    def GetUnit(self):
        r"""
        PvGenInteger::GetUnit() -> PvResult, str
        Get the feature's measurement unit.
        The #GetUnit method returns a string with the units for the feature. For example, 
        the string might contain "pixels", "bytes", "ms", and so on. The string
        is informational and has no intrinsic value for converting to other units.

        :rtype: Tuple(:py:class:`PvResult`, str)
        :return:
            Tuple composed of (result, unit)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - unit: 
                - The units for the feature. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenInteger_GetUnit(self)

# Register PvGenInteger in _ebus_python:
_ebus_python.PvGenInteger_swigregister(PvGenInteger)
class PvGenRegister(PvGenParameter):
    r"""
    GenICam feature: Register, or IRegister. A feature providing direct access to a section of the device's register map.

    To use this class, see #PvGenParameter.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Set(self, aBuffer, aLength):
        r"""
        Write to the register.

        Partial (less than #GetLength) writes are supported at the GenICam level,
        but the behaviour is defined by the device.

        GigE Vision enforces a mod-4 (can be divided by 4 bytes) length restriction
        on all read/write operations.

        :type aBuffer: uint8_t, in
        :param aBuffer:   Data to write to the register.
        :type aLength: int, in
        :param aLength:   Length of the buffer, in bytes.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::GENERIC_ERROR (Use #PvResult::GetDescription to get more information.)
        """
        return _ebus_python.PvGenRegister_Set(self, aBuffer, aLength)

    def Get(self, aBuffer, aLength):
        r"""
        Reads from the register.

        Partial (less than #GetLength) reads are supported at the GenICam level,
        but the behaviour is defined by the device.

        GigE Vision enforces a mod-4 (can be divided by 4 bytes) length restriction
        on all read/write operations.

        :type aBuffer: uint8_t, out
        :param aBuffer:   Data read from the register.
        :type aLength: int, out
        :param aLength:   Length of the buffer, in bytes.

        :rtype: :py:class:`PvResult`
        :return: See #Set.
        """
        return _ebus_python.PvGenRegister_Get(self, aBuffer, aLength)

    def GetLength(self):
        r"""
        Returns the length of the register mapped with this feature.

        :type aLength: int, out
        :param aLength:   Length of the register, in bytes.

        :rtype: :py:class:`PvResult`
        :return: See #Set.
        """
        return _ebus_python.PvGenRegister_GetLength(self)

# Register PvGenRegister in _ebus_python:
_ebus_python.PvGenRegister_swigregister(PvGenRegister)
class PvGenString(PvGenParameter):
    r"""
    GenICam feature: String

    To use this class, see #PvGenParameter.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def SetValue(self, aValue):
        r"""
        Set the feature's value.

        :type aValue: str, in
        :param aValue: The feature's new value.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::GENERIC_ERROR (Use #PvResult::GetDescription to get more information.)
        """
        return _ebus_python.PvGenString_SetValue(self, aValue)

    def GetValue(self):
        r"""
        PvGenString::GetValue() -> PvResult, str
        Get the feature's value.

        :rtype: Tuple(:py:class:`PvResult`, str)
        :return:
            Tuple composed of (result, value)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - value: 
                - The feature's value. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenString_GetValue(self)

    def GetMaxLength(self):
        r"""
        PvGenString::GetMaxLength() -> PvResult, int
        Returns the maximum length of the string.

        :rtype: Tuple(:py:class:`PvResult`, int)
        :return:
            Tuple composed of (result, maxlength)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (Use :py:func:`~PvResult.GetDescription` to get more information.)
             - maxlength: 
                - Maximum length of the register, in characters. (None if PvResult outcome is not :py:const:`~PvResultCode.PV_OK`)

        """
        return _ebus_python.PvGenString_GetMaxLength(self)

# Register PvGenString in _ebus_python:
_ebus_python.PvGenString_swigregister(PvGenString)
class PvGenStateStack(object):
    r"""
    Performs changes to a GenICam node map, tracks them and restores the previous state on destruction.

    This class can be used to perform temporary changes to a GenICam node map. Every parameter
    changed through this class is tracked and its original value is saved. When the object
    is destroyed, the original value of all parameters is restored in the reverse order.

    This class is very useful when dealing with selectors. If you want to change a selected value
    without affecting the current selector state of the node map, create an object of this type,
    change the selector(s) using the Set methods, perform your changes and let the object go
    out of scope: the selectors will go back to their original values.

    Assume A is originally 1, B is 2, C is 3. If you use this class to change A 4, B to 5 and C to 6
    (in that order) when the object goes out of scope C will be set back to 3, B to 2 and A to 1 (in that
    order as well).

    If a value cannot be set (an error occurs) the previous value is not pushed on the stack of
    parameters that will be restored when the destructor is called.

    If the parameter is already set to the requested value, its value IS NOT changed, and IS NOT
    pushed on the stack to be eventually restored. This is done to minimize traffic to the device
    and prevent too much invalidators to be fired when a selector is already set to the rigth value.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, aParameters):
        r"""
        Constructor.

        :type aParameters: :py:class:`PvGenParameterArray`, in
        :param aParameters: The GenICam parameter array to operate on.
        """
        _ebus_python.PvGenStateStack_swiginit(self, _ebus_python.new_PvGenStateStack(aParameters))
    __swig_destroy__ = _ebus_python.delete_PvGenStateStack

    def SetIntegerValue(self, aName, aValue):
        r"""
        Changes the value of an integer parameter.

        :type aName: str, in
        :param aName: The name of the parameter to change.
        :type aValue: int, in
        :param aValue: The new value of the parameter.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::GENERIC_ERROR (Use #PvResult::GetDescription to get more information.)
                - #PvResult::Code::NOT_FOUND if the parameter does not exist
        """
        return _ebus_python.PvGenStateStack_SetIntegerValue(self, aName, aValue)

    def SetFloatValue(self, aName, aValue):
        r"""
        Changes the value of a float parameter.

        :type aName: str, in
        :param aName: The name of the parameter to change.
        :type aValue: float, in
        :param aValue: The new value of the parameter.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::GENERIC_ERROR (Use #PvResult::GetDescription to get more information.)
                - #PvResult::Code::NOT_FOUND if the parameter does not exist
        """
        return _ebus_python.PvGenStateStack_SetFloatValue(self, aName, aValue)

    def SetEnumValue(self, *args):
        r"""
        *Overload 1:*

        Changes the value of an enum parameter.

        :type aName: str, in
        :param aName: The name of the parameter to change.
        :type aValue: str, in
        :param aValue: The new symbolic (string) value of the parameter.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::GENERIC_ERROR (Use #PvResult::GetDescription to get more information.)
                - #PvResult::Code::NOT_FOUND if the parameter does not exist

        |

        *Overload 2:*

        Changes the value of an enum parameter.

        :type aName: str, in
        :param aName: The name of the parameter to change.
        :type aValue: int, in
        :param aValue: The new integer value of the parameter.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::GENERIC_ERROR (Use #PvResult::GetDescription to get more information.)
                - #PvResult::Code::NOT_FOUND if the parameter does not exist
        """
        return _ebus_python.PvGenStateStack_SetEnumValue(self, *args)

    def SetBooleanValue(self, aName, aValue):
        r"""
        Changes the value of a boolean parameter.

        :type aName: str, in
        :param aName: The name of the parameter to change.
        :type aValue: boolean, in
        :param aValue: The new value of the parameter.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::GENERIC_ERROR (Use #PvResult::GetDescription to get more information.)
                - #PvResult::Code::NOT_FOUND if the parameter does not exist
        """
        return _ebus_python.PvGenStateStack_SetBooleanValue(self, aName, aValue)

    def SetStringValue(self, aName, aValue):
        r"""
        Changes the value of a string parameter.

        :type aName: str, in
        :param aName: The name of the parameter to change.
        :type aValue: str, in
        :param aValue: The new value of the parameter.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::GENERIC_ERROR (Use #PvResult::GetDescription to get more information.)
                - #PvResult::Code::NOT_FOUND if the parameter does not exist
        """
        return _ebus_python.PvGenStateStack_SetStringValue(self, aName, aValue)

# Register PvGenStateStack in _ebus_python:
_ebus_python.PvGenStateStack_swigregister(PvGenStateStack)
PvAccessType = _ebus_python.PvAccessType 
PvAccessUnknown = _ebus_python.PvAccessUnknown
PvAccessOpen = _ebus_python.PvAccessOpen
PvAccessControl = _ebus_python.PvAccessControl
PvAccessExclusive = _ebus_python.PvAccessExclusive
PvAccessReadOnly = _ebus_python.PvAccessReadOnly
PvActionAckStatusEnum = _ebus_python.PvActionAckStatusEnum 
PvActionAckStatusOK = _ebus_python.PvActionAckStatusOK
PvActionAckStatusLate = _ebus_python.PvActionAckStatusLate
PvActionAckStatusOverflow = _ebus_python.PvActionAckStatusOverflow
PvActionAckStatusNoRefTime = _ebus_python.PvActionAckStatusNoRefTime
PvUserSetState = _ebus_python.PvUserSetState 
PvUserSetStateSaveStart = _ebus_python.PvUserSetStateSaveStart
PvUserSetStateSaveCompleted = _ebus_python.PvUserSetStateSaveCompleted
PvUserSetStateLoadStart = _ebus_python.PvUserSetStateLoadStart
PvUserSetStateLoadCompleted = _ebus_python.PvUserSetStateLoadCompleted
class IPvUserSetNotify(object):
    r""" An interface to register a state change callback for UserSets"""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_IPvUserSetNotify

    def UserSetStateNotify(self, aUserSetState, aUserSetIndex):
        r"""
        The callback that is issued when a UserSetState is reached.
                The DefaultUserSet is index 0 and the rest start from 1.

        :type aUserSetState: int, in
        :param aUserSetState: The UserSet state the device has entered
        :type aUserSetIndex: int, in
        :param aUserSetIndex: The numeric value of the UserSet being affected
                                     DefaultUserSet is 0 and the rest start from 1.
        """
        return _ebus_python.IPvUserSetNotify_UserSetStateNotify(self, aUserSetState, aUserSetIndex)

    def __init__(self):
        if self.__class__ == IPvUserSetNotify:
            _self = None
        else:
            _self = self
        _ebus_python.IPvUserSetNotify_swiginit(self, _ebus_python.new_IPvUserSetNotify(_self, ))
    def __disown__(self):
        self.this.disown()
        _ebus_python.disown_IPvUserSetNotify(self)
        return weakref.proxy(self)

# Register IPvUserSetNotify in _ebus_python:
_ebus_python.IPvUserSetNotify_swigregister(IPvUserSetNotify)
PvScanType = _ebus_python.PvScanType 
PvScanTypeInvalid = _ebus_python.PvScanTypeInvalid
PvScanTypeArea = _ebus_python.PvScanTypeArea
PvScanTypeLine = _ebus_python.PvScanTypeLine
PvScanTypeArea3D = _ebus_python.PvScanTypeArea3D
PvScanTypeLine3D = _ebus_python.PvScanTypeLine3D
class IPvSoftDeviceGEVInfo(object):
    r"""
    Interface that is used to customize the identity of a software-based GigE Vision Device.

    Can be retrieved from a #PvSoftDeviceGEV to access device identity strings
    and GenICam XML version and GUIDs.

    The device identity strings can be set before or after calling #PvSoftDeviceGEV::Start. However, the GenICam
    XML version and GUIDs must be set before calling #PvSoftDeviceGEV::Start.

    Setting the GenICam XML version and GUIDs is recommended but not always required. Some non-Pleora
    software applications will use this information to manage the cached versions of the GenICam XML file
    and will not download a newer XML file from the device if the GenICam XML version GUID and/or version do not change.

    The recommended practice is to always update the GenICam XML GUID and version when releasing
    a new version of your GigE Vision Device. We also recommend that all of your
    GigE Vision Device products use a different GenICam XML Product GUID.

    Set your GenICam XML version with #SetGenICamXMLVersion.

    Set your GenICam XML GUIDs with #SetGenICamXMLGUIDs.

    This class cannot be instantiated and there is no use case where you would
    need to implement this interface.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_IPvSoftDeviceGEVInfo

    def GetManufacturerName(self):
        r"""
        Returns the current manufacturer name.

        Maps to GigE Vision 0x0048 bootstrap register: 32 bytes, read-only.

        :rtype: str
        :return: Manufacturer name string.
        """
        return _ebus_python.IPvSoftDeviceGEVInfo_GetManufacturerName(self)

    def GetModelName(self):
        r"""
        Returns the current model name.

        Maps to GigE Vision 0x0068 bootstrap register: 32 bytes, read-only.

        :rtype: str
        :return: Model name string.
        """
        return _ebus_python.IPvSoftDeviceGEVInfo_GetModelName(self)

    def GetDeviceVersion(self):
        r"""
        Returns the current #PvSoftDeviceGEV version string.

        Maps to GigE Vision 0x0088 bootstrap register: 32 bytes, read-only.

        :rtype: str
        :return: #PvSoftDeviceGEV version string.
        """
        return _ebus_python.IPvSoftDeviceGEVInfo_GetDeviceVersion(self)

    def GetDeviceFirmwareVersion(self):
        r"""
        Returns the current #PvSoftDeviceGEV firmware version string.

        Maps to GigE Vision 0x3FFF0100 bootstrap register: 32 bytes, read-only.

        :rtype: str
        :return: #PvSoftDeviceGEV firmware version string.
        """
        return _ebus_python.IPvSoftDeviceGEVInfo_GetDeviceFirmwareVersion(self)

    def GetManufacturerInformation(self):
        r"""
        Returns the current manufacturer information string.

        Maps to GigE Vision 0x00A8 bootstrap register: 32 bytes, read-only.

        :rtype: str
        :return: Manufacturer information string.
        """
        return _ebus_python.IPvSoftDeviceGEVInfo_GetManufacturerInformation(self)

    def GetSerialNumber(self):
        r"""
        Returns the current serial number string.

        Maps to GigE Vision 0x00D8 bootstrap register: 16 bytes, read-only.

        :rtype: str
        :return: Serial number string.
        """
        return _ebus_python.IPvSoftDeviceGEVInfo_GetSerialNumber(self)

    def SetManufacturerName(self, aValue):
        r"""
        Updates the manufacturer name string.

        Maps to GigE Vision 0x0048 bootstrap register: 32 bytes, read-only.

        :type aValue: str, in
        :param aValue: New manufacturer name, maximum 31 characters (31 + NULL).

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER if the string is too long.
        """
        return _ebus_python.IPvSoftDeviceGEVInfo_SetManufacturerName(self, aValue)

    def SetModelName(self, aValue):
        r"""
        Updates the model name string.

        Maps to GigE Vision 0x0068 bootstrap register: 32 bytes, read-only.

        :type aValue: str, in
        :param aValue: New model name, maximum 31 characters (31 + NULL for 32 bytes).

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER if the string is too long.
        """
        return _ebus_python.IPvSoftDeviceGEVInfo_SetModelName(self, aValue)

    def SetDeviceVersion(self, aValue):
        r"""
        Updates the device version string.

        Maps to GigE Vision 0x0088 bootstrap register: 32 bytes, read-only.

        :type aValue: str, in
        :param aValue: New device version, maximum 31 characters (31 + NULL for 32 bytes).

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER if the string is too long.
        """
        return _ebus_python.IPvSoftDeviceGEVInfo_SetDeviceVersion(self, aValue)

    def SetDeviceFirmwareVersion(self, aValue):
        r"""
        Updates the device firmware version string.

        Maps to GigE Vision 0x3FFF0100 bootstrap register: 32 bytes, read-only.

        :type aValue: str, in
        :param aValue: New device version, maximum 31 characters (31 + NULL for 32 bytes).

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER if the string is too long.
        """
        return _ebus_python.IPvSoftDeviceGEVInfo_SetDeviceFirmwareVersion(self, aValue)

    def SetManufacturerInformation(self, aValue):
        r"""
        Updates the manufacturer information string.

        Maps to GigE Vision 0x00A8 bootstrap register: 48 bytes, read-only.

        If the #PvSoftDeviceGEV is running without a valid license, the manufacturer information
        is overridden to provide a warning that indicates that the device is unlicensed.

        :type aValue: str, in
        :param aValue: New device version, maximum 47 characters (47 + NULL for 48 bytes).

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER if the string is too long.
        """
        return _ebus_python.IPvSoftDeviceGEVInfo_SetManufacturerInformation(self, aValue)

    def SetSerialNumber(self, aValue):
        r"""
        Updates the serial number string.

        Maps to GigE Vision 0x00D8 bootstrap register: 16 bytes, read-only.

        :type aValue: str, in
        :param aValue: New serial number, maximum 15 characters (15 + NULL for 16 bytes).

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER if the string is too long.
        """
        return _ebus_python.IPvSoftDeviceGEVInfo_SetSerialNumber(self, aValue)

    def GetGenICamXMLVersionMajor(self):
        r"""
        Returns the GenICam XML file major version.

        See #SetGenICamXMLVersion for more information.

        :rtype: int
        :return: Major version.
        """
        return _ebus_python.IPvSoftDeviceGEVInfo_GetGenICamXMLVersionMajor(self)

    def GetGenICamXMLVersionMinor(self):
        r"""
        Returns the GenICam XML file minor version.

        See #SetGenICamXMLVersion for more information.

        :rtype: int
        :return: Minor version.
        """
        return _ebus_python.IPvSoftDeviceGEVInfo_GetGenICamXMLVersionMinor(self)

    def GetGenICamXMLVersionSubMinor(self):
        r"""
        Returns the GenICam XML file subminor version.

        See #SetGenICamXMLVersion for more information.

        :rtype: int
        :return: Subminor version.
        """
        return _ebus_python.IPvSoftDeviceGEVInfo_GetGenICamXMLVersionSubMinor(self)

    def GetGenICamXMLProductGUID(self):
        r"""
        Returns the GenICam XML file Product GUID.

        See #SetGenICamXMLGUIDs for more information.

        :rtype: str
        :return: Product GUID.
        """
        return _ebus_python.IPvSoftDeviceGEVInfo_GetGenICamXMLProductGUID(self)

    def GetGenICamXMLVersionGUID(self):
        r"""
        Returns the GenICam XML file Version GUID.

        See #SetGenICamXMLGUIDs for more information.

        :rtype: str
        :return: Version GUID.
        """
        return _ebus_python.IPvSoftDeviceGEVInfo_GetGenICamXMLVersionGUID(self)

    def SetGenICamXMLVersion(self, aMajor, aMinor, aSubMinor):
        r"""
        Sets the GenICam XML file version.

        See the IPvSoftDeviceGEVInfo class description for usage and recommendations.

        :type aMajor: int, in
        :param aMajor: Major version for GenICam XML file header.
        :type aMinor: int, in
        :param aMinor: Minor version for GenICam XML file header.
        :type aSubMinor: int, in
        :param aSubMinor: Subminor version for GenICam XML file header.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::STATE_ERROR if the GenICam XML file has already been created.
        """
        return _ebus_python.IPvSoftDeviceGEVInfo_SetGenICamXMLVersion(self, aMajor, aMinor, aSubMinor)

    def SetGenICamXMLGUIDs(self, aProduct, aVersion):
        r"""
        Sets the GenICam XML file version.

        A GUID (globally unique identifier) is a 128-bit number that is used to identify information in computer
        systems. The term UUID (universally unique identifier) can also be used.

        Valid GUID example: CB9328DB-1273-42A3-90C7-EB3224537C39

        You can generate unique GUIDs using the Create GUID tool in Visual Studio, which can be accessed from the
        Visual Studio Tools menu. It uses the system unique MAC address and date/time components to ensure uniqueness.

        See the IPvSoftDeviceGEVInfo class description for usage and recommendations.

        :type aProduct: str, in
        :param aProduct: Product GUID for GenICam XML file header.
        :type aVersion: str, in
        :param aVersion: Version GUID for GenICam XML file header.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER if one or both GUIDs are not valid.
                - #PvResult::Code::STATE_ERROR if the GenICam XML file has already been created.
        """
        return _ebus_python.IPvSoftDeviceGEVInfo_SetGenICamXMLGUIDs(self, aProduct, aVersion)

# Register IPvSoftDeviceGEVInfo in _ebus_python:
_ebus_python.IPvSoftDeviceGEVInfo_swigregister(IPvSoftDeviceGEVInfo)
class IPvSoftDeviceGEVStatistics(object):
    r"""
    Interface that is used to retrieve control channel statistics from a software-based GigE Vision Device.

    Can be retrieved from a properly initialized #PvSoftDeviceGEV to access
    the statistics provided by this interface.

    This class cannot be instantiated and there is no use case where you would
    need to implement this interface.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_IPvSoftDeviceGEVStatistics

    def Reset(self):
        r""" Resets all counters to zero."""
        return _ebus_python.IPvSoftDeviceGEVStatistics_Reset(self)

    def GetReadMemsReceived(self):
        r"""
        GVCP read memory (READMEM_CMD) commands received.

        :rtype: int
        :return: Read memory command count.
        """
        return _ebus_python.IPvSoftDeviceGEVStatistics_GetReadMemsReceived(self)

    def GetWriteMemsReceived(self):
        r"""
        GVCP write memory (WRITEMEM_CMD) commands received.

        :rtype: int
        :return: Write memory command count.
        """
        return _ebus_python.IPvSoftDeviceGEVStatistics_GetWriteMemsReceived(self)

    def GetReadRegsReceived(self):
        r"""
        GVCP read register (READREG_CMD) commands received.

        :rtype: int
        :return: Read register command count.
        """
        return _ebus_python.IPvSoftDeviceGEVStatistics_GetReadRegsReceived(self)

    def GetWriteRegsReceived(self):
        r"""
        GVCP write register (WRITEREG_CMD) commands received.

        :rtype: int
        :return: Write register command count.
        """
        return _ebus_python.IPvSoftDeviceGEVStatistics_GetWriteRegsReceived(self)

    def GetDiscoveriesReceived(self):
        r"""
        GVCP discovery (DISCOVERY_CMD) commands received.

        :rtype: int
        :return: Discovery command count.
        """
        return _ebus_python.IPvSoftDeviceGEVStatistics_GetDiscoveriesReceived(self)

    def GetActionCommandsReceived(self):
        r"""
        GVCP action command (ACTION_CMD) received.

        :rtype: int
        :return: Action command count.
        """
        return _ebus_python.IPvSoftDeviceGEVStatistics_GetActionCommandsReceived(self)

    def GetForceIpsReceived(self):
        r"""
        GVCP force IP configuration (FORCEIP_CMD) commands received.

        :rtype: int
        :return: Force IP configuration command count.
        """
        return _ebus_python.IPvSoftDeviceGEVStatistics_GetForceIpsReceived(self)

    def GetPacketResendRequestsReceived(self):
        r"""
        GVCP packet resend (PACKETRESEND_CMD) commands received.

        :rtype: int
        :return: Packet resend command count.
        """
        return _ebus_python.IPvSoftDeviceGEVStatistics_GetPacketResendRequestsReceived(self)

    def GetPendingAcksIssued(self):
        r"""
        GVCP pending acknowledges (PENDING_ACK) issued.

        :rtype: int
        :return: Pending acknowledges count.
        """
        return _ebus_python.IPvSoftDeviceGEVStatistics_GetPendingAcksIssued(self)

    def GetRetriesReceived(self):
        r"""
        GVCP command retries received.

        :rtype: int
        :return: Command retries count.
        """
        return _ebus_python.IPvSoftDeviceGEVStatistics_GetRetriesReceived(self)

    def GetRetriesReceivedMax(self):
        r"""
        GVCP command retries maximum for a single command.

        :rtype: int
        :return: Command retries maximum count.
        """
        return _ebus_python.IPvSoftDeviceGEVStatistics_GetRetriesReceivedMax(self)

    def GetEventsIssued(self):
        r"""
        GVCP messaging channel event commands (EVENT_CMD) issued.

        :rtype: int
        :return: Messaging channel event count.
        """
        return _ebus_python.IPvSoftDeviceGEVStatistics_GetEventsIssued(self)

    def GetEventDatasIssued(self):
        r"""
        GVCP messaging channel event (with data) comands (EVENTDATA_CMD) issued.

        :rtype: int
        :return: Messaging channel event (with data) count.
        """
        return _ebus_python.IPvSoftDeviceGEVStatistics_GetEventDatasIssued(self)

    def GetEventRetriesIssued(self):
        r"""
        GVCP retries issued for unacknowledged messaging channel event or event data commands.

        :rtype: int
        :return: Messaging channel event retries count.
        """
        return _ebus_python.IPvSoftDeviceGEVStatistics_GetEventRetriesIssued(self)

    def GetEventRetriesIssuedMax(self):
        r"""
        :rtype: int
        :return: GVCP maximum retries issued for a single unacknowledged messaging channel event or event data command.


        :rtype: int
        :return: Messaging channel event retries maximum count.
        """
        return _ebus_python.IPvSoftDeviceGEVStatistics_GetEventRetriesIssuedMax(self)

    def GetSessionsOpened(self):
        r"""
        Returns the device controller session open count.

        :rtype: int
        :return: Session open count.
        """
        return _ebus_python.IPvSoftDeviceGEVStatistics_GetSessionsOpened(self)

    def GetSessionsClosed(self):
        r"""
        Returns the device controller session close count.

        :rtype: int
        :return: Session close count.
        """
        return _ebus_python.IPvSoftDeviceGEVStatistics_GetSessionsClosed(self)

    def GetHeartbeatFailedCount(self):
        r"""
        Returns the device controller session close on heartbeat failure count.

        :rtype: int
        :return: Session close on heartbeat failure count.
        """
        return _ebus_python.IPvSoftDeviceGEVStatistics_GetHeartbeatFailedCount(self)

    def GetGVSPTestPacketsIssued(self):
        r"""
        Returns the number of GVSP test packets issued.

        :rtype: int
        :return: GVSP test packets count.
        """
        return _ebus_python.IPvSoftDeviceGEVStatistics_GetGVSPTestPacketsIssued(self)

# Register IPvSoftDeviceGEVStatistics in _ebus_python:
_ebus_python.IPvSoftDeviceGEVStatistics_swigregister(IPvSoftDeviceGEVStatistics)
class IPvMessageChannel(object):
    r"""
    Messaging channel interface of the software-based GigE Vision Device.

    Can be retrieved from a properly initialized #PvSoftDeviceGEV to monitor
    the messaging channel state and send events to the GigE Vision controller.

    This class cannot be instantiated and there is no use case where you would
    need to implement this interface.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_IPvMessageChannel

    def FireEvent(self, *args):
        r"""
        IPvMessageChannel::FireEvent( aEventID, aData, aBlockID = 0, aChannelIndex = 0xFFFF ) -> PvResult
            - Fires a messaging channel event.
            - Sends a messaging channel event with data to the messaging channel destination that is currently registered.
            - An event ID needs to be provided.

        If the event is sent in the context of a streaming event, we recommend that you set the block ID 
        and streaming channel that the event is associated to.

        The default value for the block ID and channel index when an event is not associated to a streaming
        event is zero.

        It is possible to map event data to the GenApi interface of the #PvSoftDeviceGEV. See #IPvGenApiFactory::MapEvent for more information.

        *Overload 1:*

        Use `FireEvent( aEventID, aBlockID = 0, aChannelIndex = 0xFFFF)` to send an event with no data.

        :type aEventID: int, in
        :param aEventID:  Event ID. Use standard event codes or a value between 0x9000 and 0xFFFF for custom events.
        :type aBlockID: int, in, opt
        :param aBlockID:  aBlockID Block ID that the event is related to or zero.
        :type aChannelIndex: int, in, opt
        :param aChannelIndex:  aChannelIndex Channel index that the event is related to or 0xFFFF if no stream channel involved.

        :rtype: :py:class:`PvResult`
        :return: 
            Includes:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_STATE_ERROR` if the messaging channel is not opened.

        |

        *Overload 2:*

        Use `FireEvent( aEventID, aData, aBlockID = 0, aChannelIndex = 0xFFFF)` to send an event with data.

        :type aEventID: int, in
        :param aEventID:  Event ID. Use standard event codes or a value between 0x9000 and 0xFFFF for custom events.
        :type aData: python bytes object, in
        :param aData:  aData Python bytes object of the data attached to the event.
        :type aBlockID: int, in, opt
        :param aBlockID:  aBlockID Block ID that the event is related to or zero.
        :type aChannelIndex: int, in, opt
        :param aChannelIndex:  aChannelIndex Channel index that the event is related to or 0xFFFF if no stream channel involved.

        :rtype: :py:class:`PvResult`
        :return: 
            Includes:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_STATE_ERROR` if the messaging channel is not opened.
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER` if the data is NULL, data length is too small, too large, or not divisible by 4.


        """
        return _ebus_python.IPvMessageChannel_FireEvent(self, *args)

    def IsOpened(self):
        r"""
        Indicates whether the messaging channel is open.

        For the messaging channel to be opened, a GigE Vision controller must be connected
        to the #PvSoftDeviceGEV and must have set the messaging channel destination
        on the MCDA (0x0B10) and MCP (0x0B00) registers.

        :rtype: boolean
        :return: True if open.
        """
        return _ebus_python.IPvMessageChannel_IsOpened(self)

# Register IPvMessageChannel in _ebus_python:
_ebus_python.IPvMessageChannel_swigregister(IPvMessageChannel)
class IPvSoftDeviceGEVEventSink(object):
    r"""
    Interface that is used by #PvSoftDeviceGEV to report internal events.

    To receive these events, inherit one of your classes from IPvSoftDeviceGEVEventSink,
    instantiate an object from your class, and pass a pointer to this event sink to
    #PvSoftDeviceGEV::RegisterEventSink.

    When the events occur, the corresponding method in your class will be invoked.
    The events are usually invoked from a different thread, other than the main application thread.

    It is possible to use this callback interface to create device-scope and GenApi parameters. See
    #IPvSoftDeviceGEVEventSink::OnCreateCustomGenApiFeatures and #IPvSoftDeviceGEVEventSink::OnCreateCustomRegisters for
    more information. You should create streaming channel source GenApi feature and registers for
    source-specific features like deinterlacing, gain, exposure time. Look at
    #IPvStreamingChannelSource::CreateRegisters and #IPvStreamingChannelSource::CreateGenApiFeatures
    to create streaming channel source scope features. Note that chunks and messaging channel GenApi parameters should always
    be created from IPvSoftDeviceGEVEventSink and be at the device-scope.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_IPvSoftDeviceGEVEventSink

    def OnApplicationConnect(self, aDevice, aIPAddress, aPort, aAccessType):
        r"""
        Notification that a GigE Vision controller has taken ownership of the control channel of your #PvSoftDeviceGEV.

        :type aDevice: :py:class:`IPvSoftDeviceGEV`, in
        :param aDevice: Pointer to the #PvSoftDeviceGEV object that is sending the notification.
        :type aIPAddress: str, in
        :param aIPAddress: IP address of the GigE Vision controller in string format, such as "192.168.138.115".
        :type aPort: int, in
        :param aPort: UDP port of the GigE Vision controller.
        :type aAccessType: int, in
        :param aAccessType: Access type secured by the GigE Vision controller.
        """
        return _ebus_python.IPvSoftDeviceGEVEventSink_OnApplicationConnect(self, aDevice, aIPAddress, aPort, aAccessType)

    def OnControlChannelStart(self, aDevice, aMACAddress, aIPAddress, aMask, aGateway, aPort):
        r"""
        Notification that the control channel of the #PvSoftDeviceGEV has been started.

        The control channel is the GVCP command server of the #PvSoftDeviceGEV.

        :type aDevice: :py:class:`IPvSoftDeviceGEV`, in
        :param aDevice: Pointer to the #PvSoftDeviceGEV object that is sending the notification.
        :type aMACAddress: str, in
        :param aMACAddress: MAC address of the local network interface.
        :type aIPAddress: str, in
        :param aIPAddress: IP address that the control channel is bound to.
        :type aMask: str, in
        :param aMask: Subnet mask of the IP address that the control channel is bound to.
        :type aGateway: str, in
        :param aGateway: Default gateway of the network interface that is used by the control channel.
        :type aPort: int, in
        :param aPort: UDP port that the control channel is listening to. Hardcode this value to GigE Vision standard 3956.
        """
        return _ebus_python.IPvSoftDeviceGEVEventSink_OnControlChannelStart(self, aDevice, aMACAddress, aIPAddress, aMask, aGateway, aPort)

    def OnApplicationDisconnect(self, aDevice):
        r"""
        Notification that the GigE Vision controller has released the control channel of the #PvSoftDeviceGEV.

        The notification can be triggered if the control channel has been released by the #PvSoftDeviceGEV
        on a heartbeat refresh failure.

        :type aDevice: :py:class:`IPvSoftDeviceGEV`, in
        :param aDevice: Pointer to the #PvSoftDeviceGEV object that is sending the notification.
        """
        return _ebus_python.IPvSoftDeviceGEVEventSink_OnApplicationDisconnect(self, aDevice)

    def OnControlChannelStop(self, aDevice):
        r"""
        Notification that the control channel of the #PvSoftDeviceGEV has been stopped.

        The control channel is the GVCP command server of the #PvSoftDeviceGEV.

        :type aDevice: :py:class:`IPvSoftDeviceGEV`, in
        :param aDevice: Pointer to the #PvSoftDeviceGEV object that is sending the notification.
        """
        return _ebus_python.IPvSoftDeviceGEVEventSink_OnControlChannelStop(self, aDevice)

    def OnDeviceResetFull(self, aDevice):
        r"""
        Notification that the #PvSoftDeviceGEV has performed a full reset.

        A full reset is the equivalent of a power cycle.

        :type aDevice: :py:class:`IPvSoftDeviceGEV`, in
        :param aDevice: Pointer to the #PvSoftDeviceGEV object that is sending the notification.
        """
        return _ebus_python.IPvSoftDeviceGEVEventSink_OnDeviceResetFull(self, aDevice)

    def OnDeviceResetNetwork(self, aDevice):
        r"""
        Notification that the #PvSoftDeviceGEV has reset its network stack.

        A #PvSoftDeviceGEV network reset usually happens after it has received a FORCEIP_CMD
        command.

        :type aDevice: :py:class:`IPvSoftDeviceGEV`, in
        :param aDevice: Pointer to the #PvSoftDeviceGEV object that is sending the notification.
        """
        return _ebus_python.IPvSoftDeviceGEVEventSink_OnDeviceResetNetwork(self, aDevice)

    def OnCreateCustomRegisters(self, aDevice, aFactory):
        r"""
        Notification that the #PvSoftDeviceGEV should create its custom registers, if they are needed.

        Register creation must happen at a specific point in the #PvSoftDeviceGEV initialization.
        To create custom registers in your application, implement the IPvSoftDeviceGEVEventSink interface,
        register an object of this class to #PvSoftDeviceGEV::RegisterEventSink, and perform custom register
        creation in the #IPvSoftDeviceGEVEventSink::OnCreateCustomRegisters notification.

        Custom register creation occurs BEFORE the creation of custom GenApi features,
        inside the #PvSoftDeviceGEV::Start call.

        :type aDevice: :py:class:`IPvSoftDeviceGEV`, in
        :param aDevice: Pointer to the #PvSoftDeviceGEV object that is sending the notification.
        :type aFactory: :py:class:`IPvRegisterFactory`, in
        :param aFactory: Register factory that is used to create the new registers.
        """
        return _ebus_python.IPvSoftDeviceGEVEventSink_OnCreateCustomRegisters(self, aDevice, aFactory)

    def OnCreateCustomGenApiFeatures(self, aDevice, aFactory):
        r"""
        Notification that the #PvSoftDeviceGEV should create its custom GenApi parameters, if they are needed.

        GenApi feature creation must happen at a specific point in the #PvSoftDeviceGEV initialization.
        To create custom GenApi features in your application, implement the IPvSoftDeviceGEVEventSink interface,
        register an object of this class to #PvSoftDeviceGEV::RegisterEventSink, and perform custom GenApi feature
        creation in the #IPvSoftDeviceGEVEventSink::OnCreateCustomGenApiFeatures notification.

        Custom GenApi feature creation occurs AFTER the creation of custom registers,
        inside the #PvSoftDeviceGEV::Start call.

        :type aDevice: :py:class:`IPvSoftDeviceGEV`, in
        :param aDevice: #PvSoftDeviceGEV object that is sending the notification.
        :type aFactory: :py:class:`IPvGenApiFactory`, in
        :param aFactory: GenApi factory that is used to create the new GenApi features.
        """
        return _ebus_python.IPvSoftDeviceGEVEventSink_OnCreateCustomGenApiFeatures(self, aDevice, aFactory)

    def __init__(self):
        if self.__class__ == IPvSoftDeviceGEVEventSink:
            _self = None
        else:
            _self = self
        _ebus_python.IPvSoftDeviceGEVEventSink_swiginit(self, _ebus_python.new_IPvSoftDeviceGEVEventSink(_self, ))
    def __disown__(self):
        self.this.disown()
        _ebus_python.disown_IPvSoftDeviceGEVEventSink(self)
        return weakref.proxy(self)

# Register IPvSoftDeviceGEVEventSink in _ebus_python:
_ebus_python.IPvSoftDeviceGEVEventSink_swigregister(IPvSoftDeviceGEVEventSink)
class IPvStreamingChannelSource(object):
    r"""
    Interface that is used by #PvSoftDeviceGEV to query and report information from a streaming source implemented by your application.

    For the application to provide a streaming source to your software-based GigE Vision Device,
    inherit one of your classes from IPvStreamingChannelSource, implement all of the methods, instantiate an object
    from your class, and pass a pointer to your class to #PvSoftDeviceGEV::AddStream.

    The GigE Vision Device will use this interface to query the application about stream
    capabilities and to report streaming events, such as acquisition start and stop. The GigE Vision Device also uses this interface
    to manage streaming data.

    To properly report the PayloadSize GenApi parameter, your application must provide
    the GigE Vision Device with the width, height, pixel format, and data chunk size values using
    the GetWidth, GetHeight, GetPixelFormat, and GetChunksSize methods.

    You can hardcode the supported chunk size by returning the required chunk size
    using GetChunksSize. You could also provide more information about the supported chunk types
    using GetSupportedChunk. Doing so will allow the GigE Vision Device to properly populate
    the ChunkSelector of its GenApi interface to let the user decide which chunks it should
    support. The streaming source should decide whether or not to append a specific chunk type
    by looking at whether the master chunk active mode is enabled AND that the specific chunk type is enabled.

    It is possible to create streaming channel source custom registers and GenApi parameters. See
    #IPvStreamingChannelSource::CreateGenApiFeatures and #IPvStreamingChannelSource::CreateRegisters for more information.
    You should create streaming channel source GenApi feature and registers for source-specific features like
    deinterlacing, gain, exposure time. Look at #IPvSoftDeviceGEVEventSink::OnCreateCustomRegisters and
    #IPvSoftDeviceGEVEventSink::OnCreateCustomGenApiFeatures to create device-scope features. Note that chunks and messaging
    channel GenApi parameters should always be created from IPvSoftDeviceGEVEventSink and be at the device-scope.

    Here is what a typical streaming session would look like when it comes to buffer management:
        - A #PvSoftDeviceGEV object is instantiated by your application
        - A MySource object that implements the #IPvStreamingChannelSource interface is instantiated by your application
        - #PvSoftDeviceGEV::AddStream is called by your application with a pointer to MySource
        - #PvSoftDeviceGEV::Start is called by your application
            - #AllocBuffer is called to allow your application to allocate streaming buffers until NULL is returned or the maximum number of buffers is reached
            - #GetWidthInfo, #GetHeightInfo, and #GetSupportedPixelType are called on MySource to inquire about the image attributes supported by MySource
            - #OnOpen is called on MySource when the streaming channel is opened (when a GigE Vision controller connects to your GigE Vision Device)
                - #OnStreamingStart is called on MySource to notify the application that streaming is starting (when the GigE Vision controller calls AcquisitionStart)
                    - Internal acquisition loop run from a GigE Vision Device thread:
                        - Calls #QueueBuffer on MySource until it fails to provide MySource with buffers to fill with image data
                        - Calls #RetrieveBuffer on MySource until it fails to retrieve all MySource filled buffers that are ready for transmission
                        - End of acquisition loop
                - #OnStreamingStop is called on MySource to notify the application that streaming is stopping (when the GigE Vision controller calls AcquisitionStop)
                    - #AbortQueuedBuffers is called on MySource
                    - #RetrieveBuffer is called on MySource until it fails to retrieve all MySource buffers, whether they were acquired or aborted
            - #OnClose is called on MySource when the streaming channel is closed (when the GigE Vision controller disconnects from the GigE Vision Device)
        - #PvSoftDeviceGEV::Stop is called explicitly by your application or by the #PvSoftDeviceGEV destructor
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_IPvStreamingChannelSource

    def GetWidth(self):
        r"""
        Returns the current image width.

        Your application must implement this method and return the current image width when invoked.

        :rtype: int
        :return: Current image width.
        """
        return _ebus_python.IPvStreamingChannelSource_GetWidth(self)

    def GetHeight(self):
        r"""
        Returns the current image height.

        Your application must implement this method and return the current image height when invoked.

        :rtype: int
        :return: Current image height.
        """
        return _ebus_python.IPvStreamingChannelSource_GetHeight(self)

    def GetOffsetX(self):
        r"""
        Returns the current image offset X.

        Your application must implement this method and return the current image offset X when invoked.

        :rtype: int
        :return: Current image offset X.
        """
        return _ebus_python.IPvStreamingChannelSource_GetOffsetX(self)

    def GetOffsetY(self):
        r"""
        Returns the current image offset Y.

        Your application must implement this method and return the current image offset Y when invoked.

        :rtype: int
        :return: Current image offset Y.
        """
        return _ebus_python.IPvStreamingChannelSource_GetOffsetY(self)

    def GetPixelType(self):
        r"""
        Returns the current pixel type.

        Your application must implement this method and return the current image pixel type when invoked.

        :rtype: int
        :return: Current pixel type.
        """
        return _ebus_python.IPvStreamingChannelSource_GetPixelType(self)

    def GetWidthInfo(self):
        r"""
        IPvStreamingChannelSource::GetWidthInfo() -> ( aMin, aMax, aInc )
        Returns the stream channel width attributes.

        When using the GigE Vision Device as a transmitter, the Width parameter
        is automatically added to the device's GenICam XML file. This method is
        used to query the minimum, maximum, and increment attributes for the Width parameter.

        :rtype: Tuple[int, int, int]
        :return: Tuple composed of the width minimum, maximum and increment.

        """
        return _ebus_python.IPvStreamingChannelSource_GetWidthInfo(self)

    def GetHeightInfo(self):
        r"""
        IPvStreamingChannelSource::GetHeightInfo() -> ( aMin, aMax, aInc )
        Returns the stream channel height attributes.

        When using the GigE Vision Device as a transmitter, the Height parameter
        is automatically added to the device's GenICam XML file. This method is
        used to query the minimum, maximum, and increment attributes for the Height parameter.

        :rtype: Tuple[int, int, int]
        :return: Tuple composed of the height minimum, maximum and increment.

        """
        return _ebus_python.IPvStreamingChannelSource_GetHeightInfo(self)

    def GetChunksSize(self):
        r"""
        Gets the stream channel chunk size attributes.

        When using data chunks, it is important to report the chunk data size when
        queried through this method.

        The chunk data size needs to be taken into account when reporting the PayloadSize
        GenICam parameter to the GigE Vision controller, so it can properly allocate
        its buffer for streaming without forced buffer re-allocation.

        The size reported must for each chunk adds 4 bytes for the chunk ID and another
        4 bytes for the chunk length fields. If you have a chunk that is 64 bytes long and it is your
        only data chunk, you need to report 64 + 4 + 4 (72 bytes) when GetChunksSize is called.

        :rtype: int
        :return: Chunk data size as currently configured.
        """
        return _ebus_python.IPvStreamingChannelSource_GetChunksSize(self)

    def GetPayloadSize(self):
        r"""
        Stream channel payload size in bytes. Return zero to have it inferred from width, height and pixel format.

        If not using image streams (raw data, multi-part, etc.) use implement the GetPayloadSize method and return
        the payload size for the current streaming channel source configuration. If GetPayloadSize returns 0 the
        payload size will be inferred from the width, height, pixel format and data chunk size.

        When using multi-part, return the sum of the maximum size of all parts plus data chunk.

        When payload size is not zero, the payload size value is simply used as provided. Nothing is added
        to it, not even data chunk size.

        :rtype: int
        :return: Payload size to use or 0.
        """
        return _ebus_python.IPvStreamingChannelSource_GetPayloadSize(self)

    def GetScanType(self):
        r"""
        Returns the scan type that is used by the streaming source.

        Return PvScanTypeArea if your image source is areascan or PvScanTypeLine if your
        image source is linescan.

        :rtype: int
        :return: Scan type of the streaming source.
        """
        return _ebus_python.IPvStreamingChannelSource_GetScanType(self)

    def GetChunkModeActive(self):
        r"""
        Indicates whether the current master chunk mode is active.

        The application must implement this method and return the current master chunk mode state.
        Return false as a hardcoded value if chunks are not supported by the streaming source.

        :rtype: boolean
        :return: True if chunk mode is enabled for this streaming source.
        """
        return _ebus_python.IPvStreamingChannelSource_GetChunkModeActive(self)

    def GetChunkEnable(self, aChunkID):
        r"""
        Returns the current chunk enabled state.

        The application must implement this method and return the current chunk enabled state
        for the specified chunk ID. The streaming source should maintain an enabled/disabled
        state for each chunk type that it supports.

        The application should append the chunk represented by the specified chunk ID if it is enabled
        and if the master chunk mode (see #GetChunkModeActive) is true.

        :type aChunkID: int, in
        :param aChunkID: Chunk ID.

        :rtype: boolean
        :return: True if the chunk specified by aChunk ID is enabled for this streaming source.
        """
        return _ebus_python.IPvStreamingChannelSource_GetChunkEnable(self, aChunkID)

    def GetSupportedPixelType(self, aIndex):
        r"""
        IPvStreamingChannelSource::GetSupportedPixelType( aIndex ) -> ( aResult, aPixelType )
        Obtains an index of supported pixel types. Used at #PvSoftDeviceGEV::Start time to create the GenICam XML of the device.

        This method is used by the #PvSoftDeviceGEV to query the application
        about the supported pixel types for the streaming channel.

        The PvSoftDeviceGEV will query the application using this stream
        interface for all supported pixel types. It will start at index 0 and then increase
        until something other than :py:const:`~PvResultCode.:py:const:`~PvResultCode.PV_OK`` is returned.

        If the application supports Mono8, BayerRG8, and RGBa8 it needs to
        handle the request to GetSupportedPixelType, as follows:

            - GetSupportedPixelType( 0 ) -> (:py:const:`~PvResultCode.PV_OK`, PvPixelMono8)
            - GetSupportedPixelType( 1 ) -> (:py:const:`~PvResultCode.PV_OK`, PvPixelBayerRG8)
            - GetSupportedPixelType( 2 ) -> (:py:const:`~PvResultCode.PV_OK`, PvPixelRGBa8)
            - GetSupportedPixelType( 3 ) -> (:py:const:`~PvResultCode.PV_INVALID_PARAMETER`, 0)

        :type aIndex: int, in
        :param aIndex:  Index of the pixel type to return.

        :rtype: Tuple[:py:class:`PvResult`, PvPixelType]
        :return: 
            Tuple composed of (result, aPixelType).
             - result includes:
                - :py:const:`~PvResultCode.PV_OK` if aIndex represents a valid index and aPixelType has been set.
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER` or any other error code if aIndex is not valid.
             - aPixelType
                - The PvPixelType requested by aIndex. See #PvPixelType Enum.

        """
        return _ebus_python.IPvStreamingChannelSource_GetSupportedPixelType(self, aIndex)

    def GetSupportedChunk(self, aIndex):
        r"""
        IPvStreamingChannelSource::GetSupportedChunk( aIndex ) -> ( aResult, aChunkID, aChunkName )
        Returns the indexed supported chunk type. Used at #PvSoftDeviceGEV::Start time to create the GenICam XML of the device.

        This method is used by the PvSoftDeviceGEV to query the application
        about the supported chunk types for this streaming channel.

        The PvSoftDeviceGEV will query the application through this stream
        interface for all supported chunk types. It will start at index 0 and then increase
        until something other than :py:const:`~PvResultCode.PV_OK` is returned.

        The information retrieved through this method is used to populate the chunk selector, allowing
        the GigE Vision controller to enable or disable each chunk type individually.

        If the application supports ChunkSample (ID 0x4001) and ChunkHistogram (ID 0x4002) it needs to
        handle request to GetSupportedChunk as follows:

            - GetSupportedChunk( 0 ) -> (:py:const:`~PvResultCode.PV_OK`, 0x4001, "ChunkSample")
            - GetSupportedChunk( 1 ) -> (:py:const:`~PvResultCode.PV_OK`, 0x4002, "ChunkHistogram")
            - GetSupportedChunk( 2 ) -> (:py:const:`~PvResultCode.PV_INVALID_PARAMETER`, 0, )

        :type aIndex: int, in
        :param aIndex:  Index of the chunk type to return.

        :rtype: Tuple[:py:class:`PvResult`, int, str]
        :return: 
            Tuple composed of (result, chunkID, chunkName).
             - result includes:
                - :py:const:`~PvResultCode.PV_OK` if aIndex represents a valid index and aPixelType has been set.
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER` or any other error code if aIndex is not valid.
             - chunkID:
                - The ChunkID integer.
             - chunkName
                - chunk name in string and should always use the "Chunk" prefix for GenICam SFNC compliance.

        """
        return _ebus_python.IPvStreamingChannelSource_GetSupportedChunk(self, aIndex)

    def SetWidth(self, aWidth):
        r"""
        Request from the #PvSoftDeviceGEV to change the image width.

        The PvSoftDeviceGEV will call SetWidth when
        the Width GenApi parameter or the underlying register is
        changed by the GigE Vision controller.

        To accept the new width, return #PvResult::Code::OK and update
        your streaming code to use the new width.

        :type aWidth: int, in
        :param aWidth: New image width.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK when accepting the new width.
                - #PvResult::Code::GENERIC_ERROR or another error code to refuse the new width.
        """
        return _ebus_python.IPvStreamingChannelSource_SetWidth(self, aWidth)

    def SetHeight(self, aHeight):
        r"""
        Request from the PvSoftDeviceGEV to change the image height.

        The PvSoftDeviceGEV will call SetHeight when
        the Height GenApi parameter or the underlying register is
        changed by the GigE Vision controller.

        To accept the new height, return #PvResult::Code::OK and update
        your streaming code to use the new height.

        :type aHeight: int, in
        :param aHeight: New image height.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK when accepting the new height.
                - #PvResult::Code::GENERIC_ERROR or another error code to refuse the new height.
        """
        return _ebus_python.IPvStreamingChannelSource_SetHeight(self, aHeight)

    def SetOffsetX(self, aOffsetX):
        r"""
        Request from the #PvSoftDeviceGEV to change the image offset X.

        To accept the new offset X, return #PvResult::Code::OK and update
        your streaming code to use the new value.

        :type aOffsetX: int, in
        :param aOffsetX: New image offset X.

        :rtype: :py:class:`PvResult`
        :return: 
                Includes:
                    - #PvResult::Code::OK when accepting the new value.
                    - #PvResult::Code::GENERIC_ERROR or another error code to refuse the new value.
        """
        return _ebus_python.IPvStreamingChannelSource_SetOffsetX(self, aOffsetX)

    def SetOffsetY(self, aOffsetY):
        r"""
        Request from the PvSoftDeviceGEV to change the image offset Y.

        To accept the new offset Y, return #PvResult::Code::OK and update
        your streaming code to use the new value.

        :type aOffsetY: int, in
        :param aOffsetY: New image offset Y.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK when accepting the new value.
                - #PvResult::Code::GENERIC_ERROR or another error code to refuse the new value.
        """
        return _ebus_python.IPvStreamingChannelSource_SetOffsetY(self, aOffsetY)

    def SetPixelType(self, aPixelType):
        r"""
        Request from the #PvSoftDeviceGEV to change the image pixel type.

        The #PvSoftDeviceGEV will call SetPixelType when
        the PixelType GenApi parameter or the underlying register is
        changed by the GigE Vision controller.

        To accept the new pixel type, return #PvResult::Code::OK and update
        your streaming code to use the new pixel type.

        :type aPixelType: int, in
        :param aPixelType: New image pixel type.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK when accepting the new pixel type.
                - #PvResult::Code::GENERIC_ERROR or another error code to refuse the new pixel type.
        """
        return _ebus_python.IPvStreamingChannelSource_SetPixelType(self, aPixelType)

    def SetChunkModeActive(self, aEnabled):
        r"""
        Set the master chunk mode active state.

        The streaming source should append a specific chunk type to its streaming data
        when both the #GetChunkModeActive (master chunk mode) and #GetChunkEnable for this
        specific chunk type are true.

        :type aEnabled: boolean, in
        :param aEnabled: True to enable chunk mode for this streaming channel, false to disable it.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK to accept the new setting.
                - #PvResult::Code::GENERIC_ERROR or another error code to refuse the new setting.
        """
        return _ebus_python.IPvStreamingChannelSource_SetChunkModeActive(self, aEnabled)

    def SetChunkEnable(self, aChunkID, aEnabled):
        r"""
        Sets the chunk enabled state for a specific chunk type.

        The streaming source should append a specific chunk type to its streaming data
        when both the #GetChunkModeActive (master chunk mode) and #GetChunkEnable for this
        specific chunk type are true.

        :type aChunkID: int, in
        :param aChunkID: Chunk ID of the chunk type to enable or disable.
        :type aEnabled: boolean, in
        :param aEnabled: True to enable the chunk type, false to disable it.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK to accept the new setting.
                - #PvResult::Code::GENERIC_ERROR or another error code to refuse the new setting.
        """
        return _ebus_python.IPvStreamingChannelSource_SetChunkEnable(self, aChunkID, aEnabled)

    def OnOpen(self, aDestIP, aDestPort):
        r"""
        Notification from the #PvSoftDeviceGEV that this streaming channel has been opened.

        :type aDestIP: str, in
        :param aDestIP: IP address of the stream destination as a string in the "192.168.138.115" format (SCDA).
        :type aDestPort: int, in
        :param aDestPort: UDP port of the stream destination (SCP).
        """
        return _ebus_python.IPvStreamingChannelSource_OnOpen(self, aDestIP, aDestPort)

    def OnClose(self):
        r""" Notification from the PvSoftDeviceGEV that this streaming channel has been closed."""
        return _ebus_python.IPvStreamingChannelSource_OnClose(self)

    def OnStreamingStart(self):
        r""" Notification that the GigE Vision controller has requested that the device start streaming on this channel."""
        return _ebus_python.IPvStreamingChannelSource_OnStreamingStart(self)

    def OnStreamingStop(self):
        r""" Notification that the GigE Vision controller has requested that the device stop streaming on this channel."""
        return _ebus_python.IPvStreamingChannelSource_OnStreamingStop(self)

    def AllocBuffer(self):
        r"""
        Request by the #PvSoftDeviceGEV to allocate a PvBuffer.

        On initialization, the #PvSoftDeviceGEV will call this method, asking the application to
        allocate buffers that will be used for image acquisition and transmission. The application should return
        buffers until it has reached the desired number of buffers it wants to use for streaming and then
        return NULL.

        The more buffers you use, the more buffers you can have queued in the application for image acquisition
        and the more buffers you can leave in the transmission output queue for packet resend. The
        downside of using more buffers is increased memory usage.

        Buffers returned on AllocBuffer calls should be unique: you should not return the same
        buffer more than once.

        A maximum of 64 buffers can be used by one streaming channel of the #PvSoftDeviceGEV. If your
        application does not return NULL on the 64th buffer, AllocBuffer will not be called a 64th time.

        :rtype: :py:class:`PvBuffer`
        :return: Pointer to a new PvBuffer that can be used by the #PvSoftDeviceGEV's acquisition manager.
        """
        return _ebus_python.IPvStreamingChannelSource_AllocBuffer(self)

    def FreeBuffer(self, aBuffer):
        r"""
        Request by the #PvSoftDeviceGEV to free or release a buffer allocated with AllocBuffer.

        You should not delete or free any PvBuffer provided by the AllocBuffer method. FreeBuffer will be called
        for each buffer created with AllocBuffer when #PvSoftDeviceGEV::Stop is called.

        :type aBuffer: :py:class:`PvBuffer`, in
        :param aBuffer: Buffer to free.
        """
        return _ebus_python.IPvStreamingChannelSource_FreeBuffer(self, aBuffer)

    def QueueBuffer(self, aBuffer):
        r"""
        Request by the #PvSoftDeviceGEV to queue a buffer for acquisition.

        If the application can accept the buffer and queue it for image acquisition, it
        returns success. If the acquisition queue or pipeline is full, return a PvResult
        error code.

        :type aBuffer: :py:class:`PvBuffer`, in
        :param aBuffer: Buffer to queue for image acquisition.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK to accept the buffer.
                - Any error code to refuse the buffer.
        """
        return _ebus_python.IPvStreamingChannelSource_QueueBuffer(self, aBuffer)

    def PreQueueBufferProc(self):
        r"""
        This is an advanced feature used mostly internally. For expert users only.
        It is higly recommended to not override but use the default implementation.

        :rtype: boolean
        :return: True if the processing loop can proceed with queueing/retrieving next buffer.
        """
        return _ebus_python.IPvStreamingChannelSource_PreQueueBufferProc(self)

    def PostRetrieveBufferProc(self):
        r"""
        This is an advanced feature used mostly internally. For expert users only.
        It is higly recommended to not override but use the default implementation.
        """
        return _ebus_python.IPvStreamingChannelSource_PostRetrieveBufferProc(self)

    def RetrieveBuffer(self, aBuffer):
        r"""
        IPvStreamingChannelSource::GetSupportedChunk( notused ) -> ( aResult, aBuffer )
        Request by the #PvSoftDeviceGEV to retrieve a buffer from the streaming source.

        During acquisition, buffers retrieved with this method will contain valid image data and are
        going to be transmitted using the GVSP protocol. This method is also used to retrieve queued
        buffers after calling AbortQueuedBuffers.

        If no image is immediately available, we recommend that you wait until an image is available
        in this method to allow the acquisition thread to wait efficiently for a new image.
        | If getting a new image can take a long time, your application should wait small chunks of time (10, 20, or 50 ms)
        to prevent deadlocking the acquisition thread and to allow the #PvSoftDeviceGEV to
        stop streaming gracefully.

        :type notused: void, in
        :param notused:  Dummy argument. Unused.

        :rtype: Tuple[:py:class:`PvResult`, :py:class:`PvBuffer`]
        :return: 
            Tuple composed of (result, pvbuffer).
             - result includes:
                - :py:const:`~PvResultCode.PV_OK` if a buffer has been retrieved.
                - or any other error code if aIndex is not valid.
             - pvbuffer:
                - The PvBuffer object retrieved.

        """
        return _ebus_python.IPvStreamingChannelSource_RetrieveBuffer(self, aBuffer)

    def AbortQueuedBuffers(self):
        r"""
        Request by the #PvSoftDeviceGEV to abort all buffers queued for acquisition.

        This method should block until acquisition has been aborted or canceled for all buffers
        provided by QueueBuffer that have not yet been retrieved with RetrievedBuffer.

        When this method returns, it should be possible to call RetrieveBuffer for all aborted
        buffers.
        """
        return _ebus_python.IPvStreamingChannelSource_AbortQueuedBuffers(self)

    def CreateRegisters(self, aRegisterMap, aFactory):
        r"""
        When called, the streaming channel source should create its custom registers if they are needed.

        To create source-specific custom registers in your application, implement the CreateRegisters method of the
        IPvStreamingChannelSource interface.

        Custom source-specific register creation occurs BEFORE custom source-specific GenApi features creation,
        inside the #PvSoftDeviceGEV::Start call.

        If more than one streaming channel source is created from the same class, you must make sure its registers
        are still unique: RegisterXYZ in Source0 and Source1 should not have the same address. It is also recommended
        to assign them unique names like RegisterXYZ0 and RegisterXYZ1.

        :type aRegisterMap: :py:class:`IPvRegisterMap`, in
        :param aRegisterMap: The register map of the device.
        :type aFactory: :py:class:`IPvRegisterFactory`, in
        :param aFactory: Register factory used to create the new registers.
        """
        return _ebus_python.IPvStreamingChannelSource_CreateRegisters(self, aRegisterMap, aFactory)

    def CreateGenApiFeatures(self, aRegisterMap, aFactory):
        r"""
        When called, the streaming channel source should create its custom GenApi parameters if they are needed.

        Create GenApi features from this callback if the feature is associated with a streaming channel source. For global-device,
        non streaming channel source features use #IPvSoftDeviceGEVEventSink::OnCreateCustomGenApiFeatures instead.

        In a multi-source application, GenApi features created by a streaming channel source will only be available when
        the SourceSelector is set to the streaming channel source that created the feature.

        If FeatureXYX is created by Source0 and Source1 but not by Source2, the feature will only be available in the GenApi
        interface when SourceSelector is set to Source0 or Source1.

            - MySource0 has Feature0, Feature1, Feature2
            - MySource1 has Feature0, Feature3, Feature4
            - In a GenApi browser with SourceSelector=Source0, Feature0, Feature1, Feature2 are available. Feature3 and Feature4 are disabled.
            - In a GenApi browser with SourceSelector=Source1, Feature0, Feature3, Feature4 are available. Feature1 and Feature2 are disabled.

        If integers with the same name are created for more than one source but with source-specific minimum, maximum and increment
        attributes, these attributes will be handled by GenICam SwissKnife operators in the GenICam XML so they are dynamically
        adjusted based on the value of SourceSelector. The same applies to float maximum and minimum.

            - MyInteger is created for Source0 with min:0 max:100 increment:4
            - MyInteger is created for Source1 with min:4 max:200 increment:1
            - In a GenApi browser, MyInteger will report min:0 max:100 increment:4 with Source0 is selected
            - In a GenApi browser, MyInteger will report min:4 max:200 increment:1 with Source1 is selected

        If enumerations with the same name are created for more than one source but with different enum entries, they will be
        added to the GenICam XML file of the device in way that the correct enum entries should be available for the enum features
        based on the current SourceSelector value:

            - MyEnum is created with EE0, EE1, EE2 for Source0
            - MyEnum is created with EE0, EE3, EE4 for Source1
            - In a GenApi browser with SourceSelector=Source0, you would see EE0, EE1, EE2 in the combo box
            - In a GenApi browser with SourceSelector=Source1, you would see EE0, EE3, EE4 in the combo box

        Creating features of the same name but different types is not supported. Attempting to do so should have the #PvSoftDeviceGEV::Start
        call failing with an appropriate error description.

        GenApi features created for a streaming channel source should use registers unique to this streaming channel source. If you have
        a source class MySource that creates registers and features, it should still create unique register having their own unique addresses.
        They should however use the same parameter name. The GenApi parameters created by MySource should use the right register for the
        source instance. The complexity of overlapping per-source feature name is handled by PvSoftDeviceGEV when creating the GenICam XML
        file from #PvSoftDeviceGEV::Start.

            - For Source0:
                - MySource creates MySourceRegister0 @ 0x20000000 + 0x1000 * source index + 0
                - MySource creates MySourceParameter named "MySourceParameter" for Source0 using MySourceRegister0
            - For Source1:
                - MySource creates MySourceRegister1 @ 0x20000000 + 0x1000 * source index + 4
                - MySource creates MySourceParameter named "MySourceParameter" for Source1 using MySourceRegister1

        The exception to this rule is selectors: if selectors are created at the streaming source level
        they must all use the same register, sharing the same register address.

        Custom source-specific GenApi features creation occurs AFTER custom source-specific registers creation,
        inside the #PvSoftDeviceGEV::Start call.

        :type aRegisterMap: :py:class:`IPvRegisterMap`, in
        :param aRegisterMap: The register map of the device.
        :type aFactory: :py:class:`IPvGenApiFactory`, in
        :param aFactory: GenApi factory used to create the new GenApi features.
        """
        return _ebus_python.IPvStreamingChannelSource_CreateGenApiFeatures(self, aRegisterMap, aFactory)

    def IsPayloadTypeSupported(self, aPayloadType):
        r"""
        When called, the streaming source has to return whether the specificed payload type is supported or not.

        Return true if the streaming source exlusively or non-exclusively can stream buffers of the
        specified payload type. A default implementation is provided for this method which returns false.

        This method must be implemented and returning true for aPayloadType being equal to PvPayloadTypeMultiPart
        when multi-part is supported by the streaming source.

        See #SetTestPayloadFormatMode and #SetMultiPartAllowed for more information on propertly supporting the multi-part payload type.

        :type aPayloadType: int
        :param aPayloadType: [in] The payload type for which support is queried.

        :rtype: boolean
        :return: Return true if the payload type is supported, false if not.
        """
        return _ebus_python.IPvStreamingChannelSource_IsPayloadTypeSupported(self, aPayloadType)

    def SetMultiPartAllowed(self, aAllowed):
        r"""
        Sets whether the streaming source is allowed or not, but not forced, to transmit multi-part data.

        Streaming sources supporting multi-part data transmission must support non-multi-part streaming by default.
        All devices starting in a mode where multi-part is not allowed. The GigE Vision controller must unlock
        the multi-part capability of a GVSP streaming channel using either the SCCx and SCCFGx bootstrap registers
        or the GevSCCFGMultiPartEnabled GenApi parameter.

        The GevSCCFGMultiPartEnabled GenApi parameter is automatically added to the GenICam XML file
        of a PvSoftDeviceGEV device when #IsPayloadTypeSupported returns true when prompted with
        PvPayloadTypeMultiPart.

        See #IsPayloadTypeSupported and #SetTestPayloadFormatMode for more information on propertly supporting the multi-part payload type.

        :type aAllowed: boolean
        :param aAllowed: [in] True if multi-part is allowed.
        """
        return _ebus_python.IPvStreamingChannelSource_SetMultiPartAllowed(self, aAllowed)

    def SetLargeLeaderTrailerEnabled(self, aEnabled, aMaxMultiPartCount):
        r"""
        Sets whether the streaming source which transmit multi-part data uses large data leader and trailer packets.

        Streaming sources using multi-part data transmission without large data leader and trailer enabled only supports up to 10 multi-parts
        due to the data leader and trailer packet size limitation. Large data leader and data trailer packets can be enabled by configuring
        the GevSCCFGLargeLeaderTrailerEnabled GenApi parameter to allow more than 10 parts.
        The large leader and trailer packet size is then set to the value allowed by the SCPSx register.

        The GevSCCFGLargeLeaderTrailerEnabled GenApi parameter is automatically added to the GenICam XML file
        of a PvSoftDeviceGEV device when #IsPayloadTypeSupported returns true when prompted with
        PvPayloadTypeMultiPart. This parameter will only be available when GevSCCFGMultiPartEnabled is set to true.

        :type aEnabled: boolean
        :param aEnabled: [in] True if Large Leader Trailer is enabled.
        :type aMaxMultiPartCount: int
        :param aMaxMultiPartCount: [in] The number of maximum allowed Multi parts calculated from the value allowed by the SCPSx register.
        """
        return _ebus_python.IPvStreamingChannelSource_SetLargeLeaderTrailerEnabled(self, aEnabled, aMaxMultiPartCount)

    def SetTestPayloadFormatMode(self, aPayloadType):
        r"""
        When called, the streaming source has to ensure it can stream buffers of the specified payload type.

        The GigE Vision Validation Framework has to be able to set the device in a functional streaming mode
        for some payload types (currently only multi-part with more to come) in order to properly validate the device.

        This method must be implemented and for aPayloadType being PvPayloadTypeMultiPart
        when multi-part is supported by the streaming source. The streaming source must be able to configure itself
        in a mode where it will be able to stream data for certification with the GigE Vision Validation Framework.

        Of course, this method will only be called on a streaming source for payload type that have
        been reported as supported with #IsPayloadTypeSupported.

        How to prepare your multi-source device source for GigE Vision Validation Framework validation:

            - Implement #IsPayloadTypeSupported and return true if aPayloadType is PvPayloadTypeMultiPart.
            - Implement #SetTestPayloadFormatMode
                - If aPayloadType is PvPayloadTypeMultiPart
                    - Setup your streaming source for autonomous multi-part streaming if needed
                    - Return #PvResult::Code::OK
                - Else if aPayloadType is PvPayloadTypeNone
                    - Disable test mode, go back to streaming source normal operation mode
                    - Return #PvResult::Code::OK
                - Else
                    - Return any #PvResult error code like #PvResult::Code::NOT_SUPPORTED

        See the SoftDeviceGEVMultiPart C++ sample for an example of how to implement this method, #SetMultiPartAllowed, and #IsPayloadTypeSupported.

        :type aPayloadType: int, in
        :param aPayloadType: Payload type to prepare test for. PvPayloadTypeNone sets the device back in normal operation mode.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - Any error code can be returned to indicate failure.
        """
        return _ebus_python.IPvStreamingChannelSource_SetTestPayloadFormatMode(self, aPayloadType)

    def __init__(self):
        if self.__class__ == IPvStreamingChannelSource:
            _self = None
        else:
            _self = self
        _ebus_python.IPvStreamingChannelSource_swiginit(self, _ebus_python.new_IPvStreamingChannelSource(_self, ))
    def __disown__(self):
        self.this.disown()
        _ebus_python.disown_IPvStreamingChannelSource(self)
        return weakref.proxy(self)

# Register IPvStreamingChannelSource in _ebus_python:
_ebus_python.IPvStreamingChannelSource_swigregister(IPvStreamingChannelSource)
class IPvRegisterInfo(object):
    r"""
    Interface to access basic information about a #PvSoftDeviceGEV register.

    This interface can be used to query basic information about a register.

    This class cannot be instantiated and there is no use case where you would
    need to implement this interface.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_IPvRegisterInfo

    def GetName(self):
        r"""
        Returns the register name.

        All #PvSoftDeviceGEV registers are named. This method
        allows the user to retrieve this name.

        The GigE Vision standard does not require that you name your registers.
        The name is used internally to provide contextual information
        about the register in logs or user interfaces.

        :rtype: str
        :return: Register name.
        """
        return _ebus_python.IPvRegisterInfo_GetName(self)

    def GetAddress(self):
        r"""
        Returns the register address.

        :rtype: int
        :return: Register address.
        """
        return _ebus_python.IPvRegisterInfo_GetAddress(self)

    def GetLength(self):
        r"""
        Returns the length of the register, in bytes.

        :rtype: int
        :return: Register length.
        """
        return _ebus_python.IPvRegisterInfo_GetLength(self)

    def GetContext(self, *args):
        r"""
        *Overload 1:*

        Returns the contextual pointer provided at register creation.

        :rtype: void
        :return: Const contextual pointer.

        |

        *Overload 2:*

        Returns the contextual pointer provided at register creation.

        :rtype: void
        :return: Contextual pointer.
        """
        return _ebus_python.IPvRegisterInfo_GetContext(self, *args)

    def IsWritable(self):
        r"""
        Indicates whether the register is writable.

        Whether the register is writable (or not) is only enforced when
        the register is accessed from the GigE Vision controller.

        Using the internal APIs it is possible to write to read-only
        registers. However, take care when doing so: If you do not fully control the
        custom register, it could cause issues (and is not
        recommended).

        :rtype: boolean
        :return: True if the register is writable.
        """
        return _ebus_python.IPvRegisterInfo_IsWritable(self)

    def IsReadable(self):
        r"""
        Indicates whether the register is readable.

        :rtype: boolean
        :return: True if the register is readable.
        """
        return _ebus_python.IPvRegisterInfo_IsReadable(self)

    def IsArrayOfBytes(self):
        r"""
        Indicates whether the register is an array of bytes or plain data type.

        :rtype: boolean
        :return: True if the register is array of bytes.
        """
        return _ebus_python.IPvRegisterInfo_IsArrayOfBytes(self)

# Register IPvRegisterInfo in _ebus_python:
_ebus_python.IPvRegisterInfo_swigregister(IPvRegisterInfo)
class IPvRegister(IPvRegisterInfo):
    r"""
    Interface that is used to access the registers of the software-based GigE Vision Device.

    This interface is retrieved through the IPvRegisterMap interface and
    can be used to read from or write to registers. It is also possible to register
    event sinks to registers using this interface.

    This interface cannot be instantiated and there is no use case where you
    would need to implement this interface.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_IPvRegister

    def Write(self, *args):
        r"""

        *Overload 1:*

        Writes an array of bytes to a register.

        :type aData: python bytes object, in
        :param aData: python bytes containing the data to write to the register.
        :type aOffset: int, in, optional
        :param aOffset: Offset (in bytes) of the write operation in the register.

        :rtype: :py:class:`PvResult`
        :return: 
              Includes:
                 - :py:const:`~PvResultCode.PV_OK` on success.

        |

        *Overload 2:*

        Writes the register content from a 4-byte unsigned integer.

        Convenience method. Works the same as the bytes-array Write but writes from
        a 4-byte unsigned integer directly.

        :type aValue: int, in
        :param aValue: Value to write to the register.
        :type aOffset: int, in, optional
        :param aOffset: Offset of the write operation in the register.

        :rtype: :py:class:`PvResult`
        :return: 
              Includes:
                 - :py:const:`~PvResultCode.PV_OK` on success.

        |

        *Overload 3:*

        Writes the register content from a string.

        Convenience method. Works the same as the byte-array Write but writes from
        a string directly.

        :type aValue: str, in
        :param aValue: Value to write to the register.

        :rtype: :py:class:`PvResult`
        :return: 
              Includes:
                 - :py:const:`~PvResultCode.PV_OK` on success.

        """
        return _ebus_python.IPvRegister_Write(self, *args)

    def ReadFloat(self):
        r"""
        IPvRegister::ReadFloat() -> PvResult, float
        Reads the register content to a 4-byte float.

        Convenience method. Works the same as the byte-array Read but reads to
        a float directly.

        :rtype: Tuple(:py:class:`PvResult`, float)
        :returns:
            Tuple composed of (result, floatValue)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
             - floatValue:
                - Float contents of register.

        """
        return _ebus_python.IPvRegister_ReadFloat(self)

    def WriteFloat(self, aValue):
        r"""
        Writes the register content from a float.

        Convenience method. Works the same as the byte-array Write but writes from
        a float directly.

        :type aValue: float, in
        :param aValue: Value to write to the register.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
        """
        return _ebus_python.IPvRegister_WriteFloat(self, aValue)

    def ReadDouble(self):
        r"""
        IPvRegister::ReadDouble() -> PvResult, float
        Reads the register content to a double precision floating point.

        Convenience method. Works the same as the byte-array Read but reads to
        a double precision float directly.

        :rtype: Tuple(:py:class:`PvResult`, float)
        :returns:
            Tuple composed of (result, floatValue)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
             - floatValue:
                - Double precision contents of register.

        """
        return _ebus_python.IPvRegister_ReadDouble(self)

    def WriteDouble(self, aValue):
        r"""
        Writes the register content from a double precision floating point.

        Convenience method. Works the same as the byte-array Write but writes from
        a double precision float directly.

        :type aValue: float, in
        :param aValue: Value to write to the register.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
        """
        return _ebus_python.IPvRegister_WriteDouble(self, aValue)

    def AddEventSink(self, aEventSink):
        r"""
        Registers a #IPvRegisterEventSink for register callbacks.

        See also: IPvRegisterEventSink

        :type aEventSink: :py:class:`IPvRegisterEventSink`, in
        :param aEventSink: Pointer to the event sink.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_PARAMETER if the event sink is NULL or was previously registered.
        """
        return _ebus_python.IPvRegister_AddEventSink(self, aEventSink)

    def RemoveEventSink(self, aEventSink):
        r"""
        Removes an event sink registered with AddEventSink.

        :type aEventSink: :py:class:`IPvRegisterEventSink`, in
        :param aEventSink: Pointer to the event sink that is being removed.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_PARAMETER if the event sink is NULL or was not previously registered.
        """
        return _ebus_python.IPvRegister_RemoveEventSink(self, aEventSink)

    def ReadString(self):
        r"""
        IPvRegister::ReadString() -> PvResult, str
        Reads the register content to a string.

        Convenience method. Works the same as the byte-array Read but reads to
        a string directly.

        :rtype: Tuple(:py:class:`PvResult`, str)
        :returns:
            Tuple composed of (result, stringValue)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
             - stringValue:
                - String with the contents of the register.

        """
        return _ebus_python.IPvRegister_ReadString(self)

    def ReadInt(self, aOffset=0):
        r"""
        IPvRegister::ReadInt( aOffset = 0 ) -> PvResult, int
        Reads the register content to a 4-byte unsigned integer.

        Convenience method. Works the same as the byte-array Read but reads to
        a 4-byte unsigned integer directly.

        :type aOffset: int, in ,opt
        :param aOffset:  Offset (in bytes) of the write operation in the register.

        :rtype: Tuple(:py:class:`PvResult`, int)
        :returns:
            Tuple composed of (result, intValue)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
             - intValue:
                - 32 bit integer.

        """
        return _ebus_python.IPvRegister_ReadInt(self, aOffset)

    def ReadBytes(self, aData, aOffset=0):
        r"""
        IPvRegister::ReadBytes( aDataLength, aOffset = 0 ) -> PvResult, ndarray
        Reads a register to an array of bytes.

        :type aDataLength: int, in
        :param aDataLength:  length of the ndarray data to read from the register.
        :type aOffset: int, in ,opt
        :param aOffset:  Offset (in bytes) of the write operation in the register.

        :rtype: Tuple(:py:class:`PvResult`, ndarray)
        :returns:
            Tuple composed of (result, BytesValue)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
             - BytesValue:
                - A 1-dimensional python numpy array with dtype np.uint8 describing the data read.

        """
        return _ebus_python.IPvRegister_ReadBytes(self, aData, aOffset)

# Register IPvRegister in _ebus_python:
_ebus_python.IPvRegister_swigregister(IPvRegister)
class IPvRegisterStore(object):
    r"""
    Class used with register persistence in the context of user-sets.

    The register store is where user-set data is stored. On Windows it is the Registry,
    on Linux user-profile files in the home directory. On embedded applications it could
    also be any static storage like flash memory.

    See also: #IPvRegisterEventSink::Persist
    See also: #IPvSoftDeviceGEV::SetUserSetCount
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_IPvRegisterStore

    def Persist(self, aRegister, aNameSuffix):
        r"""
        Persists a register to the register store using a name suffix.

        Use this method from the IPvRegisterEventSink::Persist callback when walking registers through
        all possible selector(s) values. This method saves data to the store when saving a user-set
        and loads data from the store when loading a user-set.

        See also: #IPvRegisterEventSink::Persist
        See also: #IPvSoftDeviceGEV::SetUserSetCount

        :type aRegister: :py:class:`IPvRegister`, in
        :param aRegister: Register to save to or load from the store.
        :type aNameSuffix: str, in
        :param aNameSuffix: Name suffix to use when saving to or loading from the store.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - Any other error code on failure.
        """
        return _ebus_python.IPvRegisterStore_Persist(self, aRegister, aNameSuffix)

# Register IPvRegisterStore in _ebus_python:
_ebus_python.IPvRegisterStore_swigregister(IPvRegisterStore)
class IPvRegisterEventSink(object):
    r"""
    Interface that is used to report the register activity of the software-based GigE Vision Device.

    To receive register access callbacks, inherit one of your classes from #IPvRegisterEventSink
    and pass a pointer to an object of that class to #IPvRegister::AddEventSink for the register that you
    want to get callbacks from.

    It is possible to have more than one event sink registered for callbacks to the same register.
    It is possible (and can be convenient) to use the same event sink for more than one register.
    When an event sink is used for more than one register, all #IPvRegisterEventSink callbacks
    will have the register of interest provided as the first parameter, to provide contextual differentiation.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_IPvRegisterEventSink

    def PreRead(self, aRegister):
        r"""
        Pre-read register notification.

        This notification is invoked before a register read operation on the #PvSoftDeviceGEV.
        The notification handler is a good place to update the content of the register
        with dynamic information.

        As an example, the #PvSoftDeviceGEV uses this notification to update
        the timestamp register every time it is read.

        Returning an error from this notification will cause the read operation to
        fail up to where it was initiated, which could be from an internal #IPvRegister
        read operation or from a READREG_CMD or READMEM_CMD GVCP remote operation.

        :type aRegister: :py:class:`IPvRegister`, in
        :param aRegister: Register to which the notification applies.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - Any PvResult error code on failure.
        """
        return _ebus_python.IPvRegisterEventSink_PreRead(self, aRegister)

    def PostRead(self, aRegister):
        r"""
        Post-read register notification.

        This notification is invoked after a register read operation on the #PvSoftDeviceGEV.

        :type aRegister: :py:class:`IPvRegister`, in
        :param aRegister: Register to which the notification applies.
        """
        return _ebus_python.IPvRegisterEventSink_PostRead(self, aRegister)

    def PreWrite(self, aRegister):
        r"""
        Pre-write register notification.

        This notification is invoked before a register write operation on the #PvSoftDeviceGEV.
        The notification handler is a good place to validate a new value before it is
        committed to the register.

        On receiving this notification, the value of the register can be retrieved using
        the IPvRegister interface. On failure, the register will revert back to its original value.

        Returning an error from this notification will cause the write operation to
        fail up to where it was initiated, which could be from an internal #IPvRegister
        write operation or from a WRITEREG_CMD or WRITEMEM_CMD GVCP remote operation.

        We recommend that you do not react to new register values in this notification handler.
        It is possible that other event sinks for the register could refuse the write,
        which will result in the operation failing and will cause the register to revert back to
        its original value. Use the #PostWrite notification instead.

        :type aRegister: :py:class:`IPvRegister`, in
        :param aRegister: Register to which the notification applies.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - Any PvResult error code on failure.
        """
        return _ebus_python.IPvRegisterEventSink_PreWrite(self, aRegister)

    def PostWrite(self, aRegister):
        r"""
        Post-write register notification.

        This notification is invoked after a register write operation on the #PvSoftDeviceGEV. It can
        be used to react to the value of a register being changed.

        As an example, #PvSoftDeviceGEV uses this notification internally
        to open or close the streaming channel on SCDA or SCP changes.

        :type aRegister: :py:class:`IPvRegister`, in
        :param aRegister: Register to which the notification applies.
        """
        return _ebus_python.IPvRegisterEventSink_PostWrite(self, aRegister)

    def Persist(self, aRegister, aStore):
        r"""
        Peristence request for selected registers for user-sets.

        This interface callback is invoked when saving to or loading from registers in the context of user-sets.

        Most registers can be saved to device user-sets by only setting the Streamable attribute
        of their attached GenApi feature when creating the GenICam XML file.

        Some registers have GenApi selector(s) and thus contain more than one value. These registers
        need to be "walked" through all possible selector(s) values when persisted. Here the word
        "persisted" is used for both Save and Load use-cases.

        These registers must implement this Persist method and call #IPvRegisterStore::Persist for
        each possible selector(s) combination.

        See also: #IPvSoftDeviceGEV::SetUserSetCount

        :type aRegister: :py:class:`IPvRegister`, in
        :param aRegister: Register to persist.
        :type aStore: :py:class:`IPvRegisterStore`, in
        :param aStore: Register store to use for persistence.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK if the method successfully handled persistence for the register.
                - #PvResult::Code::NOT_IMPLEMENTED if the register does not need advanced persistence. Returned by default implementation.
                - Any other PvResult error code on failure.
        """
        return _ebus_python.IPvRegisterEventSink_Persist(self, aRegister, aStore)

    def __init__(self):
        if self.__class__ == IPvRegisterEventSink:
            _self = None
        else:
            _self = self
        _ebus_python.IPvRegisterEventSink_swiginit(self, _ebus_python.new_IPvRegisterEventSink(_self, ))
    def __disown__(self):
        self.this.disown()
        _ebus_python.disown_IPvRegisterEventSink(self)
        return weakref.proxy(self)

# Register IPvRegisterEventSink in _ebus_python:
_ebus_python.IPvRegisterEventSink_swigregister(IPvRegisterEventSink)
class IPvRegisterFactory(object):
    r"""
    Class used for register creation.

    The #AddRegister method can be used to add customer registers to the #PvSoftDeviceGEV.
    Note however that custom registers can only be added from the
    #IPvSoftDeviceGEVEventSink::OnCreateCustomRegisters notification. A pointer to this register
    factory interface is provided with the notification.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_IPvRegisterFactory

    def AddRegister(self, aName, aAddress, aLength, aAccessMode, aRegisterEventSink=None, aContext=None):
        r"""
        Adds a new register (Integer, Float) to the #PvSoftDeviceGEV register map.

        :type aName: str, in
        :param aName: The name of the new register to create.
        :type aAddress: int, in
        :param aAddress: The address for the new register. It must be unique and must not overlap previously-allocated register space.
        :type aLength: int, in
        :param aLength: Register length, in bytes. Must be 4 or 8.
        :type aAccessMode: int, in
        :param aAccessMode: Access mode of the register: PvGenAccessModeReadOnly, PvGenAccessModeReadWrite, or PvGenAccessModeWriteOnly.
        :type aRegisterEventSink: :py:class:`IPvRegisterEventSink`, in, optional
        :param aRegisterEventSink: An optional event sink to register on creation.
        :type aContext: void, in, optional
        :param aContext: A contextual pointer that is specific to the register. It can be retrieved using #IPvRegisterInfo::GetContext.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
        """
        return _ebus_python.IPvRegisterFactory_AddRegister(self, aName, aAddress, aLength, aAccessMode, aRegisterEventSink, aContext)

    def AddByteArray(self, aName, aAddress, aLength, aAccessMode, aRegisterEventSink=None, aContext=None):
        r"""
        Adds a new array of bytes (String, Register) to the #PvSoftDeviceGEV register map.

        :type aName: str, in
        :param aName: The name of the new register to create.
        :type aAddress: int, in
        :param aAddress: The address for the new register. It must be unique and must not overlap previously-allocated register space.
        :type aLength: int, in
        :param aLength: Register length, in bytes. Must be divisible by 4.
        :type aAccessMode: int, in
        :param aAccessMode: Access mode of the register: PvGenAccessModeReadOnly, PvGenAccessModeReadWrite, or PvGenAccessModeWriteOnly.
        :type aRegisterEventSink: :py:class:`IPvRegisterEventSink`, in, optional
        :param aRegisterEventSink: An optional event sink to register on creation.
        :type aContext: void, in, optional
        :param aContext: A contextual pointer that is specific to the register. It can be retrieved using #IPvRegisterInfo::GetContext.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
        """
        return _ebus_python.IPvRegisterFactory_AddByteArray(self, aName, aAddress, aLength, aAccessMode, aRegisterEventSink, aContext)

# Register IPvRegisterFactory in _ebus_python:
_ebus_python.IPvRegisterFactory_swigregister(IPvRegisterFactory)
class IPvRegisterMap(object):
    r"""
    Register map interface for a software-based GigE Vision Device.

    The interface to the #PvSoftDeviceGEV register map can be retrieved using
    #IPvSoftDeviceGEV::GetRegisterMap any time after the device has been started.

    This interface can be used to browse the register map using the #GetRegisterCount
    and #GetRegisterByIndex methods. If you know the address of the register that you are looking
    for, you can access it directly with #GetRegisterByAddress.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_IPvRegisterMap

    def GetRegisterCount(self):
        r"""
        Obtains a count of how many registers are in the #PvSoftDeviceGEV register map.

        Typically used to enumerate all registers. Call #GetRegisterByIndex
        with aIndex iterating from 0 to #GetRegisterCount - 1, inclusively.

        :rtype: int
        :return: Register count.
        """
        return _ebus_python.IPvRegisterMap_GetRegisterCount(self)

    def GetRegisterByIndex(self, aIndex):
        r"""
        Obtains a register from the register map based on the register's index.

        :type aIndex: int, in
        :param aIndex: 0-based index.

        :rtype: :py:class:`IPvRegister`
        :return: Register interface or NULL on failure.
        """
        return _ebus_python.IPvRegisterMap_GetRegisterByIndex(self, aIndex)

    def GetRegisterByAddress(self, aAddress):
        r"""
        Obtains a register from the register map based on the register's address.

        :type aAddress: int, in
        :param aAddress: Register address.

        :rtype: :py:class:`IPvRegister`
        :return: Register interface or NULL on failure.
        """
        return _ebus_python.IPvRegisterMap_GetRegisterByAddress(self, aAddress)

    def Lock(self, *args):
        r"""
        *Overload 1:*

        Locks the register map for safe register access.

        We recommend that you lock the register map before accessing the registers using the
        IPvRegisterMap interface. The lock should not be held for longer than necessary
        and should be released as soon as possible.

        Failure to lock the register map before accessing its content could mean that an
        IPvRegister obtained through #GetRegisterByIndex or #GetRegisterByAddress could be
        deleted while using it in parallel with a #PvSoftDeviceGEV reset.

        Locking the register map prevents register map additions or removals while it is being
        accessed. However, it does not prevent register access, which can safely occur
        in parallel, because each individual register is thread-safe on read/write operations.

        It is very important that you call Release after a #Lock() success. Failure to do so will
        likely result in a #PvSoftDeviceGEV deadlock on reset or shutdown.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::STATE_ERROR if the #PvSoftDeviceGEV is not running.

        |

        *Overload 2:*

        Locks the register map for safe register access but fails on timeout.

        See #Lock() for more information.

        :type aTimeout: int, in
        :param aTimeout: Timeout, in ms, to wait for the lock.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::STATE_ERROR if the device is not running.
                - #PvResult::Code::TIMEOUT if the lock could not be acquired before aTimeout ran out.
        """
        return _ebus_python.IPvRegisterMap_Lock(self, *args)

    def Release(self):
        r"""
        Releases a lock acquired with #Lock.

        Not calling this method after calling #Lock will most likely result in a #PvSoftDeviceGEV
        deadlock on reset or shutdown.
        """
        return _ebus_python.IPvRegisterMap_Release(self)

# Register IPvRegisterMap in _ebus_python:
_ebus_python.IPvRegisterMap_swigregister(IPvRegisterMap)
class IPvGenApiFactory(object):
    r"""
    GenApi factory used to add custom GenApi parameters to a software-based GigE Vision Device GenICam XML file.

    GenApi features can only be added to the device's GenICam XML file using the
    #IPvSoftDeviceGEVEventSink::OnCreateCustomGenApiFeatures callback. See #IPvSoftDeviceGEVEventSink
    and #PvSoftDeviceGEV for more information.

    To add a feature, set all of its attributes in the factory and then call one of the Create methods. After calling
    a Create method, ALL feature attributes in the factory are reset to their default value.

    The following sequence will work and is valid:
        - Set Feature A name.
        - Set Feature A category.
        - Create Feature A.
        - Reset feature attributes of the factory.
        - Set Feature B name.
        - Set Feature B category.
        - Create Feature B.

    The following sequence will fail because Feature B would not have a category defined:
        - Set Feature A name.
        - Set Feature A category.
        - Create Feature A.
        - Reset feature attributes of the factory.
        - Set Feature B name.
        - Create Feature B.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_IPvGenApiFactory

    def SetName(self, aName):
        r"""
        Sets the name of the next feature to be added to the GenICam XML file.

        The name must not contain any special characters. It can only contain letters,
        digits, and underscores. The feature name must begin with a letter.

        :type aName: str, in
        :param aName: Feature name.
        """
        return _ebus_python.IPvGenApiFactory_SetName(self, aName)

    def SetDisplayName(self, aDisplayName):
        r"""
        Sets the display name of the next feature to be added to the GenICam XML.

        The display name can be used by GenApi browsers in order to present the features
        in a simpler user-interface. Display names do not have to be unique and do can
        contain spaces.

        Features for which display names are not provided will have a display name
        automatically generated for them.

        Automatically generated display names created by adding spaces and removing
        the last sub-category prefix from the name of the feature:

            - DeviceType from DeviceControl category: Type
            - WidthMax from ImageFormatControl category: Width Max
            - EventTestTimestamp from EventControl\EventTestData category: Test Timestamp

        These simple rules should be enough for most features. If you need more control
        on the display name of a feature, just call this method to set a custom display name
        before using the factory to create the feature.

        :type aDisplayName: str, in
        :param aDisplayName: Feature name.
        """
        return _ebus_python.IPvGenApiFactory_SetDisplayName(self, aDisplayName)

    def SetCategory(self, *args):
        return _ebus_python.IPvGenApiFactory_SetCategory(self, *args)

    def SetDescription(self, aDescription):
        r"""
        Sets the description of the next feature to be added to the GenICam XML file.

        :type aDescription: str, in
        :param aDescription: Feature description.
        """
        return _ebus_python.IPvGenApiFactory_SetDescription(self, aDescription)

    def SetToolTip(self, aToolTip):
        r"""
        Sets the tooltip of the next feature to be added to the GenICam XML file.

        :type aToolTip: str, in
        :param aToolTip: Feature tooltip.
        """
        return _ebus_python.IPvGenApiFactory_SetToolTip(self, aToolTip)

    def SetAccessMode(self, aAccessMode):
        r"""
        Sets the access mode of the next feature to be added to the GenICam XML file.

        The access mode can be different than the register that it is bound to. However, it
        does not make sense for it to be more restrictive. As an example, a register could be
        read-write and the GenApi feature be read-only.

        :type aAccessMode: int, in
        :param aAccessMode: Feature access mode.
        """
        return _ebus_python.IPvGenApiFactory_SetAccessMode(self, aAccessMode)

    def SetRepresentation(self, aRepresentation):
        r"""
        Sets the numeric representation of the next feature to be added to the GenICam XML file.

        :type aRepresentation: int, in
        :param aRepresentation: Feature representation.
        """
        return _ebus_python.IPvGenApiFactory_SetRepresentation(self, aRepresentation)

    def SetVisibility(self, aVisibility):
        r"""
        Sets the visibility of the next feature to be added to the GenICam XML.

        :type aVisibility: int, in
        :param aVisibility: Feature visibility.
        """
        return _ebus_python.IPvGenApiFactory_SetVisibility(self, aVisibility)

    def SetCachable(self, aCache):
        r"""
        Sets the cache behavior of the next feature to be added to the GenICam XML file.

        Possible values:
            - PvGenCacheWriteThrough: The cached value of the register behind the feature is updated to the new value on write operations.
            - PvGenCacheWriteAround: The cached value of the register behind the feature is invalidated on write operations and refreshed with the value read from #PvSoftDeviceGEV on the next read operation.
            - PvGenCacheNone: The register value behind the feature is not cached and is refreshed every #SetPollingTime ms cycle.

        :type aCache: int, in
        :param aCache: Feature cachable.
        """
        return _ebus_python.IPvGenApiFactory_SetCachable(self, aCache)

    def SetPollingTime(self, aPollingTime):
        r"""
        Sets the polling time, in ms, of the next feature to be added to the GenICam XML file.

        The polling time provides a hint of how often no-cache features should be updated
        from GenApi browsers.

        :type aPollingTime: int, in
        :param aPollingTime: Feature polling time.
        """
        return _ebus_python.IPvGenApiFactory_SetPollingTime(self, aPollingTime)

    def SetNameSpace(self, aNameSpace):
        r"""
        Sets the namespace of the next feature to be added to the GenICam XML file.

        Possible values:
        - PvGenNameSpaceStandard for GenICam SFNC features.
        - PvGenNameSpaceCustom for custom features.

        :type aNameSpace: int, in
        :param aNameSpace: Feature namespace.
        """
        return _ebus_python.IPvGenApiFactory_SetNameSpace(self, aNameSpace)

    def SetTLLocked(self, aLocked):
        r"""
        Sets the TLParamsLocked behavior of the next feature to be added to the GenICam XML file.

        A feature with its TLLocked attribute set to True will be forced to read-only
        when the #PvSoftDeviceGEV is streaming.

        As an example, the Width and Height features use TLLocked (transport layer locked) to prevent
        the user from changing their values when the #PvSoftDeviceGEV is streaming.

        :type aLocked: boolean, in
        :param aLocked: Feature TLLocked attribute.
        """
        return _ebus_python.IPvGenApiFactory_SetTLLocked(self, aLocked)

    def SetStreamable(self, aStreamable):
        r"""
        Sets the streamable behaviour of the next feature to be added to the GenICam XML.

        A feature with its streamable attribute set to true will be be considered when creating
        a persistence file of the GenApi interface of the device.

        :type aStreamable: boolean, in
        :param aStreamable: Feature streamable attribute.
        """
        return _ebus_python.IPvGenApiFactory_SetStreamable(self, aStreamable)

    def SetUnit(self, aUnit):
        r"""
        Sets the units for an integer or float feature.

        This string-based unit is only used for display purpose, it carries not functional signification.

        Applies to integer or float feature, SwissKnife or Converter.

        :type aUnit: str, in
        :param aUnit: Feature unit attribute.
        """
        return _ebus_python.IPvGenApiFactory_SetUnit(self, aUnit)

    def SetPValue(self, aFeatureName):
        r"""
        Sets the pValue attribute of the next feature to be added to the GenICam XML.

        Most GenApi features are linked to a register. With pValue you replace the register
        by the link or pointer to another feature.

        When defining a register as pValue, do not provide a register when calling the factory
        create method, use NULL instead.

        For ADVANCED GenApi support use cases.

        :type aFeatureName: str
        :param aFeatureName: [in] Feature name to use for pValue.
        """
        return _ebus_python.IPvGenApiFactory_SetPValue(self, aFeatureName)

    def SetPIsAvailable(self, aFeatureName):
        r"""
        Sets the pIsAvaialble attribute of the next feature to be added to the GenICam XML.

        This attribute can be used to make a feature dynamically available or unavailable. It has
        to be the name of another feature.

        If you need an more complex expression to control the available state of a feature,
        create a private integer SwissKnife that returns non-zero (1 or true) when the feature
        should be available.

        See #SetCategory for more information on private features. See #CreateIntSwissKnife for more
        information on SwissKnifes.

        When pIsAvailable evaluates to true the feature is available as defined: read-write, read-only
        or write-only. When pIsAvailable evaluates to false the feature is not readable and not writable.
        The eBUS GenApi browser shows a feature that state as {Not available}.

        For ADVANCED GenApi support use cases.

        :type aFeatureName: str
        :param aFeatureName: [in] Feature name to use for pIsImplemented.
        """
        return _ebus_python.IPvGenApiFactory_SetPIsAvailable(self, aFeatureName)

    def SetPIsLocked(self, aFeatureName):
        return _ebus_python.IPvGenApiFactory_SetPIsLocked(self, aFeatureName)

    def MapChunk(self, aChunkID, aAddress, aLength, aEndianness=PvGenEndiannessLittle):
        r"""
        Maps the next feature to be added to the GenICam XML file to a chunk, identified by its ID.

        Sets the chunk ID and mapping (address, length, and endianness) of the next feature to be added
        to the GenICam XML file.

        By default all features map to a #PvSoftDeviceGEV register provided in the Create calls, unless
        #MapChunk or #MapEvent are called when defining the feature attributes.

        :type aChunkID: int, in
        :param aChunkID: Chunk ID to map.
        :type aAddress: int, in
        :param aAddress: Data offset of the feature in the chunk, in bytes.
        :type aLength: int, in
        :param aLength: Data length of the feature in the chunk, in bytes.
        :type aEndianness: int, in, optional
        :param aEndianness: Data endianness.
        """
        return _ebus_python.IPvGenApiFactory_MapChunk(self, aChunkID, aAddress, aLength, aEndianness)

    def MapEvent(self, aEventID, aAddress, aLength, aEndianness=PvGenEndiannessLittle, aAdjustAddress=True):
        r"""
        Maps the next feature to be added to the GenICam XML file to a messaging channel event, identified by its ID.

        Sets the messaging channel event ID and mapping (address, length, and endianness) of the next feature to be added
        to the GenICam XML file.

        By default all features map to a #PvSoftDeviceGEV register provided in the Create calls, unless
        #MapChunk or #MapEvent are called when defining the feature attributes.

        :type aEventID: int, in
        :param aEventID: Event ID to map.
        :type aAddress: int, in
        :param aAddress: Data offset of the feature in the event data, in bytes.
        :type aLength: int, in
        :param aLength: Data length of the feature in the event data, in bytes.
        :type aEndianness: int, in, optional
        :param aEndianness: Data endianness.
        :type aAdjustAddress: boolean, in, optional
        :param aAdjustAddress: Applies an offset on the provided address.
        """
        return _ebus_python.IPvGenApiFactory_MapEvent(self, aEventID, aAddress, aLength, aEndianness, aAdjustAddress)

    def AddSelected(self, aFeatureName):
        r"""
        Adds a selector to the next feature to be added to the GenICam XML file.

        A selector, as specified by the GenICam SFNC, is used to index which instance of the feature is accessed in
        situations where multiple instances of a feature exist (For instance, the analog gain for each
        separate channel of the red/green/blue component of a color camera).

        Feature A can be the selector for Features B and C. We could also say that
        B and C are indexed by A. In that case, Feature A needs to be identified as the selector
        for Feature B and Feature C.

        Example:
            - Create Feature A, our selector
            - Call #IPvGenApiFactory::AddSelected with Feature A name
            - Call #IPvGenApiFactory::AddSelected with Feature B name
            - Create Feature B (selected by A)
            - Create Feature C (selected by A)

        A feature can have more than one selector. A feature with one selector
        could be thought of as a one-dimensional vector. A feature with two selector
        would be like a table with columns and rows, etc.

        :type aFeatureName: str, in
        :param aFeatureName: Name of the feature that is selecting the new feature.
        """
        return _ebus_python.IPvGenApiFactory_AddSelected(self, aFeatureName)

    def AddInvalidator(self, aFeatureName):
        r"""
        Add an invalidator to the next feature to be added to the GenICam XML file.

        Add one invalidator to a feature. For example, Feature A being invalidated by Feature B
        has the cache of Feature A being invalidated when a new value is written to Feature B.

        :type aFeatureName: str, in
        :param aFeatureName: Name of the feature that is invalidating the new feature.
        """
        return _ebus_python.IPvGenApiFactory_AddInvalidator(self, aFeatureName)

    def AddEnumEntry(self, *args):
        r"""
        *Overload 1:*

        Add an enumeration entry to the next feature to be added to the GenICam XML file.

        When #CreateEnum is called, it will be populated with the enumeration entries added
        using this method. Call #AddEnumEntry for each enumeration entry of the new feature.

        If one of the Create methods other than #CreateEnum is called, the enumeration entries
        added to the factory are ignored.

        :type aName: str, in
        :param aName: Name of the new enumeration entry.
        :type aValue: int, in
        :param aValue: Value of the new enumeration entry.

        |

        *Overload 2:*

        Add an enumeration entry to the next feature to be added to the GenICam XML file.

        When #CreateEnum is called, it will be populated with the enumeration entries added
        using this method. Call #AddEnumEntry for each enumeration entry of the new feature.

        If one of the Create methods other than #CreateEnum is called, the enumeration entries
        added to the factory are ignored.

        :type aName: str, in
        :param aName: Name of the new enumeration entry.
        :type aValue: int, in
        :param aValue: Value of the new enumeration entry.
        :type aDisplayName: str, in
        :param aDisplayName: Custom display name for the new enum entry. If an empty string is provided a default display name is generated for the enum entry.
        :type aNameSpace: int, in, optional
        :param aNameSpace: Namespace for the new enum entry. See #SetNameSpace for more information on GenICam XML namespaces.

        |

        *Overload 3:*

        Add an enumeration entry to the next feature to be added to the GenICam XML file.

        When #CreateEnum is called, it will be populated with the enumeration entries added
        using this method. Call #AddEnumEntry for each enumeration entry of the new feature.

        If one of the Create methods other than #CreateEnum is called, the enumeration entries
        added to the factory are ignored.

        :type aName: str, in
        :param aName: Name of the new enumeration entry.
        :type aValue: int, in
        :param aValue: Value of the new enumeration entry.
        :type aDisplayName: str, in
        :param aDisplayName: Custom display name for the new enum entry. If an empty string is provided a default display name is generated for the enum entry.
        :param aNameSpace: Namespace for the new enum entry. See #SetNameSpace for more information on GenICam XML namespaces.
        """
        return _ebus_python.IPvGenApiFactory_AddEnumEntry(self, *args)

    def AddVariable(self, aFeatureName):
        r"""
        Adds a variable that will be declared for the next SwissKnife of Converter to be added to the GenICam XML file.

        In order to refer to a feature in a SwissKnife or Converter formula, it first needs to be defined
        as a variable.

        Variables are defined using the exact case sensitive feature name. They are then used in the formulas using the same
        exact feature name.

        A SwissKnife can have one or more variables.

        A Converter can have zero or more variables. Important: the main feature a Converter operates on (TO/FROM)
        does not have to be defined as a variable.

        Variables are ignored if the next feature to be added to the GenICam XML file is not
        a SwissKnife or Converter.

        For ADVANCED GenApi support use cases.

        :type aFeatureName: str
        :param aFeatureName: [in] Feature name to use as variable.
        """
        return _ebus_python.IPvGenApiFactory_AddVariable(self, aFeatureName)

    def CreateInteger(self, *args):
        return _ebus_python.IPvGenApiFactory_CreateInteger(self, *args)

    def CreateFloat(self, *args):
        return _ebus_python.IPvGenApiFactory_CreateFloat(self, *args)

    def CreateString(self, aRegister=None):
        r"""
        Adds a string feature to the GenICam XML file using the current state of the factory for its attributes.

        After calling this method, all feature creation attributes are reset to their default values.

        :type aRegister: :py:class:`IPvRegister`, in, optional
        :param aRegister: Register that the new string feature maps to or NULL if creating a chunk or messaging channel event data feature.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_PARAMETER
                     - If aRegister is NULL and none of chunk ID, messaging channel event or pValue has been defined.
                - #PvResult::Code::NOT_INITIALIZED if #SetName has not been called for the new feature.
        """
        return _ebus_python.IPvGenApiFactory_CreateString(self, aRegister)

    def CreateRegister(self, aRegister=None):
        return _ebus_python.IPvGenApiFactory_CreateRegister(self, aRegister)

    def CreateBoolean(self, aRegister=None):
        r"""
        Adds a Boolean feature to the GenICam XML file using the current state of the factory for its attributes.

        After calling this method, all feature creation attributes are reset to their default values.

        :type aRegister: :py:class:`IPvRegister`, in, optional
        :param aRegister: Register that the new Boolean feature maps to or NULL if creating a chunk or messaging channel event data feature.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_PARAMETER
                     - If aRegister is NULL and none of chunk ID, messaging channel event or pValue has been defined.
                - #PvResult::Code::NOT_INITIALIZED if #SetName has not been called for the new feature.
        """
        return _ebus_python.IPvGenApiFactory_CreateBoolean(self, aRegister)

    def CreateCommand(self, aRegister=None):
        r"""
        Adds a command feature to the GenICam XML file using the current state of the factory for its attributes.

        After calling this method, all feature creation attributes are reset to their default values.

        :type aRegister: :py:class:`IPvRegister`, in, optional
        :param aRegister: Register that the new command feature maps to.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_PARAMETER
                     - If aRegister is NULL and pValue has not been defined.
                - #PvResult::Code::NOT_INITIALIZED if #SetName has not been called for the new feature.
        """
        return _ebus_python.IPvGenApiFactory_CreateCommand(self, aRegister)

    def CreateEnum(self, aRegister=None):
        r"""
        Adds an enumeration feature to the GenICam XML file using the current state of the factory for its attributes.

        After calling this method, all feature creation attributes are reset to their default values.

        :type aRegister: :py:class:`IPvRegister`, in, optional
        :param aRegister: Register that the new enumeration feature maps to or NULL if creating a chunk or messaging channel event data feature.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_PARAMETER
                     - If aRegister is NULL and none of chunk ID, messaging channel event or pValue has been defined.
                     - If no enumeration entries have been defined for the new feature.
                - #PvResult::Code::NOT_INITIALIZED if #SetName has not be called for the new feature.
        """
        return _ebus_python.IPvGenApiFactory_CreateEnum(self, aRegister)

    def CreateIntSwissKnife(self, aFormula):
        r"""
        Adds an integer SwissKnife to the GenICam XML file using the current state of the factory for its attributes.

        An integer SwissKnife is a GenApi read-only feature that resolves a formula whenever it is read. The formula
        is defined as a string and evaluates to an integer. It can refer to other features as long as they have been
        declared with #AddVariable. Variables can be integer, float (truncated to integer), enum (integer value)
        boolean (1 or 0 integer value) or command as long as they are readable.

        Example of a simple SwissKnife adding the value of two features:

        .. code-block:: c++

            lFactory->SetName( "MySwissKnife" );
            lFactory->SetCategory( "MyCategory" );
            lFactory->AddVariable( "ValueA" );
            lFactory->AddVariable( "ValueB" );
            lFactory->CreateIntSwissKnife( "ValueA + ValueB" );

        When MySwissKnife is read, the formula is evaluated. If ValueA is 4 and ValueB is 3, MySwissKnife
        will read as 7: 4 + 3.

        Formula examples:
            - Simple constant: 42
            - Simple feature: ValueA
            - Simple mathematical expression: 32 + 10
            - Simple mathematical expression with features: ValueA + (10 * ValueB)
            - Bitwise operations: (ValueA << 16) | (ValueB >> 16)
            - 'if' statement: (ValueA = 4) ? 8 : 16
            - Switch-case statement with default: (ValueA = 0) ? 0x0000B824 : (ValueA = 1) ? 0x0000B82C : (ValueA = 2) ? 0x0000B884 : (ValueA = 3) ? 0x0000B88C : 0xFFFFFFFF

        After calling this method, all feature creation attributes are reset to their default values.

        GenApi formulas are compatible with expressions defined for the Kirill Zaborsk's math parser library,
        the CCalc library from Walery Studennikov. More information is available at http://kirya.narod.ru/mathparser.html.

        For ADVANCED GenApi support use cases.

        :type aFormula: str
        :param aFormula: [in] SwissKnife formula.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_PARAMETER if the formula is empty.
                - #PvResult::Code::NOT_INITIALIZED if #SetName has not be called for the new feature.
        """
        return _ebus_python.IPvGenApiFactory_CreateIntSwissKnife(self, aFormula)

    def CreateFloatSwissKnife(self, aFormula):
        r"""
        Adds a float SwissKnife to the GenICam XML file using the current state of the factory for its attributes.

        A float SwissKnife is a GenApi read-only feature that resolves a formula whenever it is read. The formula
        is defined as a string and evaluates to a float. It can refer to other features as long as they have been
        declared with #AddVariable. Variables can be integer (converter to float), float, enum (integer value converted to float)
        boolean (1 or 0 integer value converted to float) or command as long as they are readable.

        Example of a simple SwissKnife adding the value of two features:

        .. code-block:: c++

            lFactory->SetName( "MySwissKnife" );
            lFactory->SetCategory( "MyCategory" );
            lFactory->AddVariable( "ValueA" );
            lFactory->AddVariable( "ValueB" );
            lFactory->CreateFloatSwissKnife( "ValueA + ValueB" );

        When MySwissKnife is read, the formula is evaluated. If ValueA is 4.1 and ValueB is 3.2, MySwissKnife
        will read as 7.3: 4.1 + 3.2.

        Formula examples:
            - Simple constant: 42.4
            - Simple feature: ValueA
            - Simple mathematical expression: 32.34 + 10.714
            - Simple mathematical expression with features: ValueA + (10.1 * ValueB)
            - Advanced mathematical expression: SIN(0.814)
            - Advanced mathematical expression with feature: SQRT(ValueA)
            - 'if' statement: (ValueA > 4) ? 8.12 : 16.991
            - Bitwise operations are not supported with float SwissKnife.

        After calling this method, all feature creation attributes are reset to their default values.

        GenApi formulas are compatible with expressions defined for the Kirill Zaborsk's math parser library,
        the CCalc library from Walery Studennikov. More information is available at http://kirya.narod.ru/mathparser.html.

        For ADVANCED GenApi support use cases.

        :type aFormula: str
        :param aFormula: [in] SwissKnife formula.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_PARAMETER if the formula is empty.
                - #PvResult::Code::NOT_INITIALIZED if #SetName has not be called for the new feature.
        """
        return _ebus_python.IPvGenApiFactory_CreateFloatSwissKnife(self, aFormula)

    def CreateIntConverter(self, aValueFeatureName, aFromFormula, aToFormula):
        r"""
        Adds an integer Converter to the GenICam XML file using the current state of the factory for its attributes.

        A converter is a read-write GenApi construct that allows reading from and writing to a referenced feature using
        SwissKnife-like formulas.

        The referenced feature is provided through aValueFeatureName and represents the feature on which the
        expressions operates. It is referred to as FROM and TO in the  converter formulas and does not have
        to be declared as a variable.

        The formula used to read the referenced feature is provided with aFromFormula. The raw value read from the
        reference is available as the special TO variable.

        The formula used to write to the referenced feature is provided with aToFormula. The raw value written
        to the converter is available as the special FROM variable.

        If the converter formulas need to reference additional features they should first be declared
        using the #AddVariable method.

        Example of a converter handling conversion between milliseconds and nanoseconds:

        .. code-block:: c++

            lFactory->SetName( "MyNanosecondFeature" );
            lFactory->SetCategory( "MyCategory" );
            lFactory->SetUnit( "ms" );
            lFactory->CreateIntConverter( "MyMillisecondFeature", "TO * 1000", "FROM / 1000" );

        In the example above:
            - We create a MyNanosecondFeature.
            - The referenced feature is MyMillisecondFeature.
            - The converter read formula is TO * 1000, where TO is the value read from MyMillisecondFeature.
                - Reading from the MyNanosecondFeature converter:
                    - Reads the referenced feature, MyMillisecondFeature (4)
                    - Replaces TO in the 'from' formula with the value read from MyMillisecondFeature (4 * 1000)
                    - Evaluates the formula (4000)
                    - Completes the read operation returning 4000
            - The converter write formula is is FROM / 1000, where FROM is the value written to the converter.
                - Writing to the MyNanosecondFeature converter:
                    - Value written to the converter (2000)
                    - Replaces FROM in the 'to' formula with the value written to the converter (2000 / 1000)
                    - Evaluates the formula (2)
                    - Writes 2 to MyMillisecondFeature

        See #CreateFloatSwissKnife for more information on formulas.

        For ADVANCED GenApi support use cases.

        After calling this method, all feature creation attributes are reset to their default values.

        :type aValueFeatureName: str
        :param aValueFeatureName: [in] Main feature the converter operates on, referred as TO and FROM in the formulas.
        :type aFromFormula: str
        :param aFromFormula: [in] Formula used when reading from the converter.
        :type aToFormula: str
        :param aToFormula: [in] Formula used when writing to the converter.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_PARAMETER if value feature name or either formula is empty.
                - #PvResult::Code::NOT_INITIALIZED if #SetName has not be called for the new feature.
        """
        return _ebus_python.IPvGenApiFactory_CreateIntConverter(self, aValueFeatureName, aFromFormula, aToFormula)

    def CreateFloatConverter(self, aValueFeatureName, aFromFormula, aToFormula):
        r"""
        Adds a float Converter to the GenICam XML file using the current state of the factory for its attributes.

        A converter is a read-write GenApi construct that allows reading from and writing to a referenced feature using
        SwissKnife-like formulas.

        The referenced feature is provided through aValueFeatureName and represents the feature on which the
        expressions operates. It is referred to as FROM and TO in the  converter formulas and does not have
        to be declared as a variable.

        The formula used to read the referenced feature is provided with aFromFormula. The raw value read from the
        reference is available as the special TO variable.

        The formula used to write to the referenced feature is provided with aToFormula. The raw value written
        to the converter is available as the special FROM variable.

        If the converter formulas need to reference additional features they should first be declared
        using the #AddVariable method.

        Example of a converter handling conversion between inches and centimeters:

        .. code-block:: c++

            lFactory->SetName( "MyCentimeterFeature" );
            lFactory->SetCategory( "MyCategory" );
            lFactory->SetUnit( "cm" );
            lFactory->CreateFloatConverter( "MyInchesFeature", "TO * 2.54", "FROM * 0.3937" );

        In the example above:
           - We create a MyCentimeterFeature.
           - The referenced feature is MyInchesFeature.
           - The converter read formula is TO * 2.54, where TO is the value read from MyInchesFeature.
                - Reading from the MyCentimeterFeature converter:
                    - Reads the referenced feature, MyInchesFeature (4)
                    - Replaces TO in the 'from' formula with the value read from MyInchesFeature (4 * 2.54)
                    - Evaluates the formula (10.16)
                    - Completes the read operation returning 10.16
                    - The converter write formula is is FROM * 0.3937, where FROM is the value written to the converter.
                - Writing to the MyCentimeterFeature converter:
                    - Value written to the converter (2)
                    - Replaces FROM in the 'to' formula with the value written to the converter (2 * 0.3937)
                    - Evaluates the formula (0.7874)
                    - Writes 0.7874 to MyInchesFeature

        See #CreateFloatSwissKnife for more information on formulas.

        For ADVANCED GenApi support use cases.

        After calling this method, all feature creation attributes are reset to their default values.

        :type aValueFeatureName: str
        :param aValueFeatureName: [in] Main feature the converter operates on, referred as TO and FROM in the formulas.
        :type aFromFormula: str
        :param aFromFormula: [in] Formula used when reading from the converter.
        :type aToFormula: str
        :param aToFormula: [in] Formula used when writing to the converter.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_PARAMETER if value feature name or either formula is empty.
                - #PvResult::Code::NOT_INITIALIZED if #SetName has not be called for the new feature.
        """
        return _ebus_python.IPvGenApiFactory_CreateFloatConverter(self, aValueFeatureName, aFromFormula, aToFormula)

    def AddInvalidatorTo(self, aStandardFeatureName, aInvalidatorFeatureName):
        r"""
        Adds a a custom invalidator to a feature managed by #PvSoftDeviceGEV.

        This methods allows defining extra custom invalidators for features managed by #PvSoftDeviceGEV. As an example, if you
        call this method to add an ComponentSelector invalidator to the #PvSoftDeviceGEV managed (or owned) PixelFormat feature,
        the invalidator is added to the invalidators of PixelFormat when creating the GenICam XML of the device. With this example,
        the GenApi cache of PixelFormat would be invalidated when the value of ComponentSelector changes client-side.

        For ADVANCED GenApi support use cases.

        :type aStandardFeatureName: str
        :param aStandardFeatureName: [in] Name of the feature to add the invalidator to.
        :type aInvalidatorFeatureName: str
        :param aInvalidatorFeatureName: [in] Name of the feature which changes causes aStandardFeatureName to be invalidated.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
        """
        return _ebus_python.IPvGenApiFactory_AddInvalidatorTo(self, aStandardFeatureName, aInvalidatorFeatureName)

    def SetPIsAvailableFor(self, aStandardFeatureName, aPIsAvailableFeatureName):
        r"""
        Forces a pIsAvailable reference for a feature managed by #PvSoftDeviceGEV.

        The pIsAvailable would typically be an IntSwissKnife defined as a global feature in the
        #IPvSoftDeviceGEVEventSink::OnCreateCustomGenApiFeatures callback. The feature identified by
        aStandardFeatureName would only be available when the IntSwissKnife referred to by aPIsAvailableFeatureName
        evaluates to non-zero.

        With most use-cases #SetPIsAvailableFor should be called in the same context.

        For ADVANCED GenApi support use cases.

        :type aStandardFeatureName: str
        :param aStandardFeatureName: [in] Name of the feature to add the pIsAvailable for.
        :type aPIsAvailableFeatureName: str
        :param aPIsAvailableFeatureName: [in] Feature used to evaluate if the feature is available or not.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
        """
        return _ebus_python.IPvGenApiFactory_SetPIsAvailableFor(self, aStandardFeatureName, aPIsAvailableFeatureName)

    def SetPIsAvailableForEnumEntry(self, aStandardFeatureName, aEnumEntryName, aPIsAvailableFeatureName):
        r"""
        Forces a pIsAvailable reference for a the enum entry of an enum feature managed by #PvSoftDeviceGEV.

        The pIsAvailable would typically be an IntSwissKnife defined as a global feature in the
        #IPvSoftDeviceGEVEventSink::OnCreateCustomGenApiFeatures callback. aEnumEntry of the enum feature identified by
        aStandardFeatureName would only be available when the IntSwissKnife referred to by aPIsAvailableFeatureName
        evaluates to non-zero.

        With most use-cases #SetPIsAvailableFor should be called in the same context.

        For ADVANCED GenApi support use cases.

        :type aStandardFeatureName: str
        :param aStandardFeatureName: [in] Name of the enum feature the enum entry belongs to.
        :type aEnumEntryName: str
        :param aEnumEntryName: [in] Name of the enum entry to add the pIsAvailable for.
        :type aPIsAvailableFeatureName: str
        :param aPIsAvailableFeatureName: [in] Feature used to evaluate if the enum entry is available or not.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
        """
        return _ebus_python.IPvGenApiFactory_SetPIsAvailableForEnumEntry(self, aStandardFeatureName, aEnumEntryName, aPIsAvailableFeatureName)

    def SetPIsLockedFor(self, aStandardFeatureName, aPIsLockedFeatureName):
        return _ebus_python.IPvGenApiFactory_SetPIsLockedFor(self, aStandardFeatureName, aPIsLockedFeatureName)

    def SetPValueFor(self, aStandardFeatureName, aPValueFeatureName):
        r"""
        Forces a pValue reference for a feature managed by #PvSoftDeviceGEV.

        For ADVANCED GenApi support use cases.

        :type aStandardFeatureName: str
        :param aStandardFeatureName: [in] Name of the feature to force pValue for.
        :type aPValueFeatureName: str
        :param aPValueFeatureName: [in] Name of the feature used provide the value of the aStandardFeatureName feature.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
        """
        return _ebus_python.IPvGenApiFactory_SetPValueFor(self, aStandardFeatureName, aPValueFeatureName)

    def SetPMinFor(self, aStandardFeatureName, aPMinFeatureName):
        r"""
        Forces a pMin reference for an integer or float feature managed by #PvSoftDeviceGEV.

        For ADVANCED GenApi support use cases.

        :type aStandardFeatureName: str
        :param aStandardFeatureName: [in] Name of the feature to force pMin for.
        :type aPMinFeatureName: str
        :param aPMinFeatureName: [in] Name of the feature used provide the minimum of the aStandardFeatureName feature.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
        """
        return _ebus_python.IPvGenApiFactory_SetPMinFor(self, aStandardFeatureName, aPMinFeatureName)

    def SetPMaxFor(self, aStandardFeatureName, aPMaxFeatureName):
        r"""
        Forces a pMax reference for an integer or float feature managed by #PvSoftDeviceGEV.

        For ADVANCED GenApi support use cases.

        :type aStandardFeatureName: str
        :param aStandardFeatureName: [in] Name of the feature to force pMax for.
        :type aPMaxFeatureName: str
        :param aPMaxFeatureName: [in] Name of the feature used provide the maximum of the aStandardFeatureName feature.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
        """
        return _ebus_python.IPvGenApiFactory_SetPMaxFor(self, aStandardFeatureName, aPMaxFeatureName)

    def SetPIncFor(self, aStandardFeatureName, aPIncFeatureName):
        r"""
        Forces a pInc reference for an integer feature managed by #PvSoftDeviceGEV.

        For ADVANCED GenApi support use cases.

        :type aStandardFeatureName: str
        :param aStandardFeatureName: [in] Name of the feature to force pInc for.
        :type aPIncFeatureName: str
        :param aPIncFeatureName: [in] Name of the feature used provide the maximum of the aStandardFeatureName feature.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
        """
        return _ebus_python.IPvGenApiFactory_SetPIncFor(self, aStandardFeatureName, aPIncFeatureName)

    def SetPMin(self, aFeatureName):
        r"""
        Sets node to use for integer or float dynamic minimum attribute.

        Sets the pMin attribute of an integer or float to point to another GenApi node like
        a Swiss Knife. When pMin is set for a new feature, it has precedence on any defined
        constant minimum.

        :type aFeatureName: str
        :param aFeatureName: [in] Name of the feature the integer or float minimum attribute points to.
        """
        return _ebus_python.IPvGenApiFactory_SetPMin(self, aFeatureName)

    def SetPMax(self, aFeatureName):
        r"""
        Sets node to use for integer or float dynamic maximum attribute.

        Sets the pMax attribute of an integer or float to point to another GenApi node like
        a Swiss Knife. When pMax is set for a new feature, it has precedence on any defined
        constant maximum.

        :type aFeatureName: str
        :param aFeatureName: [in] Name of the feature the integer or float maximum attribute points to.
        """
        return _ebus_python.IPvGenApiFactory_SetPMax(self, aFeatureName)

    def SetPInc(self, aFeatureName):
        r"""
        Sets node to use for integer dynamic increment attribute.

        Sets the pInc attribute of an integer to point to another GenApi node like
        a Swiss Knife. When pInc is set for a new feature, it has precedence on any defined
        constant increment.

        :type aFeatureName: str
        :param aFeatureName: [in] Name of the feature the integer increment attribute points to.
        """
        return _ebus_python.IPvGenApiFactory_SetPInc(self, aFeatureName)

# Register IPvGenApiFactory in _ebus_python:
_ebus_python.IPvGenApiFactory_swigregister(IPvGenApiFactory)
class IPvSoftDeviceGEV(object):
    r""" Interface to the main class of the software-based GigE Vision Device."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_IPvSoftDeviceGEV

    def AddStream(self, aSource):
        r"""
        Adds a new stream to the #PvSoftDeviceGEV.

        All streams must be added before starting the #PvSoftDeviceGEV.

        :type aSource: :py:class:`IPvStreamingChannelSource`, in
        :param aSource: Interface to a user-provided source.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_PARAMETER if aSource is NULL.
                - #PvResult::Code::STATE_ERROR if the #PvSoftDeviceGEV is already running.
                - #PvResult::Code::NOT_SUPPORTED if the maximum stream count has already been reached.
        """
        return _ebus_python.IPvSoftDeviceGEV_AddStream(self, aSource)

    def SetUserSetCount(self, aCount):
        r"""
        Sets the number of user-sets supported by the #PvSoftDeviceGEV.

        The maximum supported user-set count is 256.

        Can only be changed before starting the device.

        User-sets are all about device-side persistence. The status of the device can be saved
        or retrieved from some static store on the device. User-sets are first and foremost managed at the
        register level. The SFNC allowing defines the UserSetFeatureSelector which is populated
        with feature names. This creates an imperfect but mostly acceptable one-to-one link between
        Streamable (persistent) GenApi features and the register providing its implementation.

        Features marked as Streamable (persistent) when creating the GenICam XML file
        of the device are used for device-side persistence through user-sets.

        Persistent features have the content of the register they directly map to
        saved to the persistent store of the device. The persistent store is implemented
        through the Registry on Windows and profile home files on Linux. Hardware implementations
        could rely on Flash memory to store user-sets.

        Most registers are simply persisted as-is: their binary content is simply saved to or loaded
        from the store.

        Some registers have only one address but can contain many values when indexed through
        device-managed selectors. If those registers are Streamable (persistent) the application
        must handle the IPvRegisterEventSink::Persist event for the registers and for each
        possible selector combination call #IPvRegisterStore::Persist. For the application the
        same code is used for both save and load operations, thus the generic "persist" naming.

        The SoftDeviceGEV sample shows basic use of user-sets.

        The SoftDeviceGEV3d sample shows how to handle complex multi-selector registers in
        the context of user-sets.

        Selected registers handling in pseudo-code:
            - Save current selector of interest values
            - Set selectors to 1st combination
            - Call #IPvRegisterStore::Persist with register and unique name suffix representing selector of interest values
            - Set selectors to 2nd combination
            - Call #IPvRegisterStore::Persist with register and unique name suffix representing selector of interest values
            - ...
            - Restore selector values

        The #IPvRegisterStore::Persist method loads or saves the register content in the store using the
        feature name and provided suffix.

        On startup the default user-set is always updated in the store from the fresh device status. If the UserSetDefault
        GenApi feature is assigned to a user-set other than Default, the user-set is automatically loaded on device startup.

        The UserSetDefault GenApi feature is special: it is not saved to a user-set but is immediately and automatically
        persistent to the store whenever changed.

        User-sets can be saved and loaded explicitly using the UserSetSelector, UserSetSave, and UserSetLoad
        GenApi features.

        The UserSetFeatureSelector and UserSetFeatureEnable GenApi features can be used to control which features
        are saved to the user-sets. All features defined as Streamable when creating the GenICam XML file of the
        device should be available under the UserSetFeatureSelector enum feature.

        :type aCount: int, in
        :param aCount: Count of user-sets supported, in addition to the default user-set.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_PARAMETER if aSource is greather than the maximum user-set count.
                - #PvResult::Code::STATE_ERROR if the #PvSoftDeviceGEV is already running.
        """
        return _ebus_python.IPvSoftDeviceGEV_SetUserSetCount(self, aCount)

    def SetUserSetNotify(self, aUserSetNotify):
        r"""
        Binds in a class which will contain a callback which will be called when the
         state of a UsersetLoad/Save changes.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes
                - #PvResult::Code::OK on success
        """
        return _ebus_python.IPvSoftDeviceGEV_SetUserSetNotify(self, aUserSetNotify)

    def SetTCPTransportEnabled(self, aEnabled):
        r"""
        Enables experimental TCP transport.

        PvSoftDeviceGEV supports optional, experimental TCP transport for GigE Vision devices.
        It affects GVCP control, GVCP messaging channel and GVSP streaming.

        When TCP is enabled the device still respond to UDP requests as usual. Additional TCP
        sockets are opened to optionally accept TCP connections from the host.

        As long as TCP is not fully ratified by the GigE Vision specification, enabling
        TCP could and most likely will break GigE Vision compliance. It also means only the
        eBUS PvDeviceGEV and PvStreamGEV can be used to interact with the device when using
        TCP transport.

        :type aEnabled: boolean, in
        :param aEnabled: Toggles TCP support.

        :rtype: :py:class:`PvResult`
        :return: #PvResult::Code::OK
        """
        return _ebus_python.IPvSoftDeviceGEV_SetTCPTransportEnabled(self, aEnabled)

    def SetRTPProtocolEnabled(self, aEnabled):
        r"""
        Enables the option of using RTP for streaming.

        PvSoftDeviceGEV supports optional RTP protocol for GigE Vision devices.

        When RTP is enabled it can be selected as the protocol used to data transmission
        at the stream channel level of the GenApi interface of the device.

        RTP supported is not covered by the GigE Vision specification. A GigE Vision Device
        actively streaming using RTP goes beyond the bounds covered by the GigE Vision standard.

        The RTP implementation is however compliant with the RTP RFCs covering the transport
        of images (RFC 4175) and H.264 data (RFC 6184).

        When a stream transmits using the RTP protocol, the stream is announced on a multicast
        channel (224.2.127.254:9875) using the SAP protocol with a SDP descriptor as required
        by the DEFSTAN 0082 specification.

        :type aEnabled: boolean, in
        :param aEnabled: Toggles RTP support.

        :rtype: :py:class:`PvResult`
        :return: #PvResult::Code::OK
        """
        return _ebus_python.IPvSoftDeviceGEV_SetRTPProtocolEnabled(self, aEnabled)

    def SetActionHandler(self, aActionHandler):
        r"""


        :rtype: :py:class:`PvResult`
        :return: PvResult.
        """
        return _ebus_python.IPvSoftDeviceGEV_SetActionHandler(self, aActionHandler)

    def RegisterEventSink(self, aEventSink):
        r"""
        Registers an event sink to receive notifications from the #PvSoftDeviceGEV.

        This method can be called before the #PvSoftDeviceGEV is started.

        See also: IPvVirtualDeviceEventSink

        :type aEventSink: :py:class:`IPvSoftDeviceGEVEventSink`, in
        :param aEventSink: Pointer to a #PvSoftDeviceGEV event sink.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_PARAMETER if aEventSink is NULL or already registered.
        """
        return _ebus_python.IPvSoftDeviceGEV_RegisterEventSink(self, aEventSink)

    def UnregisterEventSink(self, aEventSink):
        r"""
        Unregisters a previously registered event sink.

        This method can be called before the #PvSoftDeviceGEV is started and after it has been stopped.

        :type aEventSink: :py:class:`IPvSoftDeviceGEVEventSink`, in
        :param aEventSink: Pointer to a #PvSoftDeviceGEV event sink.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_PARAMETER if aEventSink is NULL.
        """
        return _ebus_python.IPvSoftDeviceGEV_UnregisterEventSink(self, aEventSink)

    def Start(self, aIpAddress):
        r"""
        Starts the #PvSoftDeviceGEV.

        Both GVCP and GVSP are operated from a background thread. Even though the Start method
        returns, the device is running in your process until you call Stop or until the
        object is destroyed.

        :param aMACAddress: MAC address of the interface to bind the #PvSoftDeviceGEV to.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::STATE_ERROR if the #PvSoftDeviceGEV is already running.
                - #PvResult::Code::INVALID_PARAMETER if the MAC address is not valid.
        """
        return _ebus_python.IPvSoftDeviceGEV_Start(self, aIpAddress)

    def Stop(self):
        r"""
        Stops the #PvSoftDeviceGEV.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::STATE_ERROR if the #PvSoftDeviceGEV is not running.
        """
        return _ebus_python.IPvSoftDeviceGEV_Stop(self)

    def GetInfo(self):
        r"""
        Obtains the information interface of the #PvSoftDeviceGEV.

        Only available after the #PvSoftDeviceGEV has been started.

        #IPvSoftDeviceGEVInfo is used to set the information strings in the read-only
        bootstrap registers of the #PvSoftDeviceGEV, such as Model Name, Vendor Name, etc.

        :rtype: :py:class:`IPvSoftDeviceGEVInfo`
        :return: Information interface of the #PvSoftDeviceGEV or NULL if the device is not running.
        """
        return _ebus_python.IPvSoftDeviceGEV_GetInfo(self)

    def GetRegisterMap(self):
        r"""
        Obtains the register map interface of the #PvSoftDeviceGEV.

        Only available after the #PvSoftDeviceGEV has been started.

        #IPvRegisterMap can be used to directly access the register map of the
        #PvSoftDeviceGEV. It is also possible to subscribe to register
        read/write events using #IPvSoftDeviceGEVEventSink.

        See #IPvSoftDeviceGEVEventSink::OnCreateCustomRegisters for information about adding custom
        registers to a #PvSoftDeviceGEV.

        :rtype: :py:class:`IPvRegisterMap`
        :return: Register map interface of the #PvSoftDeviceGEV or NULL if the device is not running.
        """
        return _ebus_python.IPvSoftDeviceGEV_GetRegisterMap(self)

    def GetStatistics(self):
        r"""
        Obtains the statistics interface of the #PvSoftDeviceGEV.

        Only available after the #PvSoftDeviceGEV has been started.

        :rtype: :py:class:`IPvSoftDeviceGEVStatistics`
        :return: Statistics interface of the #PvSoftDeviceGEV or NULL if the device is not running.
        """
        return _ebus_python.IPvSoftDeviceGEV_GetStatistics(self)

    def GetMessagingChannel(self):
        r"""
        Obtains the messaging channel interface of the #PvSoftDeviceGEV.

        The #IPvMessageChannel interface can be used to send events on the messaging
        channel when a GigE Vision controller is connected to the #PvSoftDeviceGEV and has properly set up
        a destination for messaging channel events.

        See also: #IPvMessageChannel

        Only available after the #PvSoftDeviceGEV has been started.

        :rtype: :py:class:`IPvMessageChannel`
        :return: Messaging channel interface of the #PvSoftDeviceGEV or NULL if the device is not running.
        """
        return _ebus_python.IPvSoftDeviceGEV_GetMessagingChannel(self)

    def GetGenICamXMLFile(self):
        r"""
        IPvSoftDeviceGEV::GetGenICamXMLFile() -> PvResult, str
        Returns the GenICam XML file of the device.

        Can be used to retrieve the GenICam XML file of the device after the Start method has been called.

        Can be used on success or failure of the Start method.

        :rtype: Tuple(:py:class:`PvResult`, str)
        :return:
            Tuple composed of (result, xmlFile)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.STATE_ERROR` if the GenICam XML file is not available (likely Start has not been called yet)
             - xmlFile:
                - String where the XML file is copied.

        """
        return _ebus_python.IPvSoftDeviceGEV_GetGenICamXMLFile(self)

# Register IPvSoftDeviceGEV in _ebus_python:
_ebus_python.IPvSoftDeviceGEV_swigregister(IPvSoftDeviceGEV)
class PvSoftDeviceGEV(IPvSoftDeviceGEV):
    r"""
    Implements a software-based GigE Vision Device with full GVCP and GVSP support.

    Basic GigE Vision Device setup:
        - Inherit a class from #IPvStreamingChannelSource, implement all virtual pure methods
        - Instantiate an object from your streaming source class
        - Instantiate a #PvSoftDeviceGEV object
        - Add your streaming channel to the GigE Vision Device using #AddStream
        - Call #PvSoftDeviceGEV::Start, selecting the network interface to bind to
        - Use #PvSoftDeviceGEV::GetInfo to set the identity of your GigE Vision Device
        - At this point your GigE Vision Device should be available on the network

    A more advanced GigE Vision Device setup:
        - Inherit a class from #IPvStreamingChannelSource and implement all virtual pure methods
        - Inherit a class from #IPvSoftDeviceGEVEventSink
            - Implement #IPvSoftDeviceGEVEventSink::OnCreateCustomRegisters with your custom registers
            - Implement #IPvSoftDeviceGEVEventSink::OnCreateCustomGenApiFeatures with your custom GenApi features
        - Instantiate an object from your streaming source class
        - Instantiate a #PvSoftDeviceGEV object
        - Add your streaming channel to the GigE Vision Device using #AddStream
        - Call #PvSoftDeviceGEV::Start, selecting the network interface to bind to
            - Your #IPvSoftDeviceGEVEventSink::OnCreateCustomRegisters will be called
            - Your #IPvSoftDeviceGEVEventSink::OnCreateCustomGenApiFeatures will be called
        - Use #PvSoftDeviceGEV::GetInfo to set the identity of your GigE Vision Device
        - At this point your GigE Vision Device should be available on the network
        - Use #PvSoftDeviceGEV::GetRegisterMap to directly access the registers or register access callbacks
        - Use #PvSoftDeviceGEV::GetGVCPStatistics to monitor GVCP statistics
        - Use #PvSoftDeviceGEV::GetMessagingChannel to fire events on the messaging channel back to the GigE Vision controller
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" Constructor."""
        _ebus_python.PvSoftDeviceGEV_swiginit(self, _ebus_python.new_PvSoftDeviceGEV())
    __swig_destroy__ = _ebus_python.delete_PvSoftDeviceGEV

    def GetInfo(self):
        r"""
        Obtains the information interface of the #PvSoftDeviceGEV.

        Only available after the #PvSoftDeviceGEV has been started.

        #IPvSoftDeviceGEVInfo is used to set the information strings in the read-only
        bootstrap registers of the #PvSoftDeviceGEV, such as Model Name, Vendor Name, etc.

        :rtype: :py:class:`IPvSoftDeviceGEVInfo`
        :return: Information interface of the #PvSoftDeviceGEV or NULL if the device is not running.
        """
        return _ebus_python.PvSoftDeviceGEV_GetInfo(self)

    def AddStream(self, aSource):
        r"""
        Adds a new stream to the #PvSoftDeviceGEV.

        All streams must be added before starting the #PvSoftDeviceGEV.

        :type aSource: :py:class:`IPvStreamingChannelSource`, in
        :param aSource: Interface to a user-provided source.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_PARAMETER if aSource is NULL.
                - #PvResult::Code::STATE_ERROR if the #PvSoftDeviceGEV is already running.
                - #PvResult::Code::NOT_SUPPORTED if the maximum stream count has already been reached.
        """
        return _ebus_python.PvSoftDeviceGEV_AddStream(self, aSource)

    def SetUserSetCount(self, aCount):
        r"""
        Sets the number of user-sets supported by the #PvSoftDeviceGEV.

        The maximum supported user-set count is 256.

        Can only be changed before starting the device.

        User-sets are all about device-side persistence. The status of the device can be saved
        or retrieved from some static store on the device. User-sets are first and foremost managed at the
        register level. The SFNC allowing defines the UserSetFeatureSelector which is populated
        with feature names. This creates an imperfect but mostly acceptable one-to-one link between
        Streamable (persistent) GenApi features and the register providing its implementation.

        Features marked as Streamable (persistent) when creating the GenICam XML file
        of the device are used for device-side persistence through user-sets.

        Persistent features have the content of the register they directly map to
        saved to the persistent store of the device. The persistent store is implemented
        through the Registry on Windows and profile home files on Linux. Hardware implementations
        could rely on Flash memory to store user-sets.

        Most registers are simply persisted as-is: their binary content is simply saved to or loaded
        from the store.

        Some registers have only one address but can contain many values when indexed through
        device-managed selectors. If those registers are Streamable (persistent) the application
        must handle the #IPvRegisterEventSink::Persist event for the registers and for each
        possible selector combination call #IPvRegisterStore::Persist. For the application the
        same code is used for both save and load operations, thus the generic "persist" naming.

        The SoftDeviceGEV sample shows basic use of user-sets.


        Selected registers handling in pseudo-code:
            - Save current selector of interest values
            - Set selectors to 1st combination
            - Call #IPvRegisterStore::Persist with register and unique name suffix representing selector of interest values
            - Set selectors to 2nd combination
            - Call #IPvRegisterStore::Persist with register and unique name suffix representing selector of interest values
            - ...
            - Restore selector values

        The #IPvRegisterStore::Persist method loads or saves the register content in the store using the
        feature name and provided suffix.

        On startup the default user-set is always updated in the store from the fresh device status. If the UserSetDefault
        GenApi feature is assigned to a user-set other than Default, the user-set is automatically loaded on device startup.

        The UserSetDefault GenApi feature is special: it is not saved to a user-set but is immediately and automatically
        persistent to the store whenever changed.

        User-sets can be saved and loaded explicitly using the UserSetSelector, UserSetSave, and UserSetLoad
        GenApi features.

        The UserSetFeatureSelector and UserSetFeatureEnable GenApi features can be used to control which features
        are saved to the user-sets. All features defined as Streamable when creating the GenICam XML file of the
        device should be available under the UserSetFeatureSelector enum feature.

        :type aCount: int, in
        :param aCount: Count of user-sets supported, in addition to the default user-set.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_PARAMETER if aSource is greather than the maximum user-set count.
                - #PvResult::Code::STATE_ERROR if the #PvSoftDeviceGEV is already running.
        """
        return _ebus_python.PvSoftDeviceGEV_SetUserSetCount(self, aCount)

    def SetUserSetNotify(self, aUserSetNotify):
        r"""
        Binds in a class which will contain a callback which will be called when the
         state of a UsersetLoad/Save changes.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes
                - #PvResult::Code::OK on success
        """
        return _ebus_python.PvSoftDeviceGEV_SetUserSetNotify(self, aUserSetNotify)

    def SetTCPTransportEnabled(self, aEnabled):
        r"""
        Enables experimental TCP transport.

        PvSoftDeviceGEV supports optional, experimental TCP transport for GigE Vision devices.
        It affects GVCP control, GVCP messaging channel and GVSP streaming.

        When TCP is enabled the device still respond to UDP requests as usual. Additional TCP
        sockets are opened to optionally accept TCP connections from the host.

        As long as TCP is not fully ratified by the GigE Vision specification, enabling
        TCP could and most likely will break GigE Vision compliance. It also means only the
        eBUS PvDeviceGEV and PvStreamGEV can be used to interact with the device when using
        TCP transport.

        :type aEnabled: boolean, in
        :param aEnabled: Toggles TCP support.

        :rtype: :py:class:`PvResult`
        :return: #PvResult::Code::OK
        """
        return _ebus_python.PvSoftDeviceGEV_SetTCPTransportEnabled(self, aEnabled)

    def SetRTPProtocolEnabled(self, aEnabled):
        r"""
        Enables the option of using RTP for streaming.

        PvSoftDeviceGEV supports optional RTP protocol for GigE Vision devices.

        When RTP is enabled it can be selected as the protocol used to data transmission
        at the stream channel level of the GenApi interface of the device.

        RTP supported is not covered by the GigE Vision specification. A GigE Vision Device
        actively streaming using RTP goes beyond the bounds covered by the GigE Vision standard.

        The RTP implementation is however compliant with the RTP RFCs covering the transport
        of images (RFC 4175) and H.264 data (RFC 6184).

        When a stream transmits using the RTP protocol, the stream is announced on a multicast
        channel (224.2.127.254:9875) using the SAP protocol with a SDP descriptor as required
        by the DEFSTAN 0082 specification.

        :type aEnabled: boolean, in
        :param aEnabled: Toggles RTP support.

        :rtype: :py:class:`PvResult`
        :return: #PvResult::Code::OK
        """
        return _ebus_python.PvSoftDeviceGEV_SetRTPProtocolEnabled(self, aEnabled)

    def SetStreamTimestamping(self, aEnabled):
        r"""
        Enables stream timestamping on all sources. 'True' by default.

        Buffers are timestamped by the acquisition manager. This method can be
        called with a 'False' value to skip timestamping when placing the buffers into the queue.

        This method can be useful in a scenario where the original timestamp of the buffer
        needs to be preserved, or if the timestamp is updated externally (in the application).
        Doing so will prevent the acquisition manager to override the timestamp before transmission.

        The method does not affect GenICam registers or message channel timestamps.

        :type aEnabled: boolean, in
        :param aEnabled: Toggles stream timestamping.

        :rtype: :py:class:`PvResult`
        :return: #PvResult::Code::OK
        """
        return _ebus_python.PvSoftDeviceGEV_SetStreamTimestamping(self, aEnabled)

    def SetActionHandler(self, aActionHandler):
        r"""


        :rtype: :py:class:`PvResult`
        :return: PvResult.
        """
        return _ebus_python.PvSoftDeviceGEV_SetActionHandler(self, aActionHandler)

    def GetRegisterMap(self):
        r"""
        Obtains the register map interface of the #PvSoftDeviceGEV.

        Only available after the #PvSoftDeviceGEV has been started.

        #IPvRegisterMap can be used to directly access the register map of the
        #PvSoftDeviceGEV. It is also possible to subscribe to register
        read/write events using #IPvSoftDeviceGEVEventSink.

        See #IPvSoftDeviceGEVEventSink::OnCreateCustomRegisters for information about adding custom
        registers to a #PvSoftDeviceGEV.

        :rtype: :py:class:`IPvRegisterMap`
        :return: Register map interface of the #PvSoftDeviceGEV or NULL if the device is not running.
        """
        return _ebus_python.PvSoftDeviceGEV_GetRegisterMap(self)

    def Start(self, aMACAddress):
        r"""
        Starts the #PvSoftDeviceGEV.

        Both GVCP and GVSP are operated from a background thread. Even though the Start method
        returns, the device is running in your process until you call Stop or until the
        object is destroyed.

        :type aMACAddress: str, in
        :param aMACAddress: MAC address of the interface to bind the #PvSoftDeviceGEV to.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::STATE_ERROR if the #PvSoftDeviceGEV is already running.
                - #PvResult::Code::INVALID_PARAMETER if the MAC address is not valid.
        """
        return _ebus_python.PvSoftDeviceGEV_Start(self, aMACAddress)

    def Stop(self):
        r"""
        Stops the #PvSoftDeviceGEV.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::STATE_ERROR if the #PvSoftDeviceGEV is not running.
        """
        return _ebus_python.PvSoftDeviceGEV_Stop(self)

    def GetStatistics(self):
        r"""
        Obtains the statistics interface of the #PvSoftDeviceGEV.

        Only available after the #PvSoftDeviceGEV has been started.

        :rtype: :py:class:`IPvSoftDeviceGEVStatistics`
        :return: Statistics interface of the #PvSoftDeviceGEV or NULL if the device is not running.
        """
        return _ebus_python.PvSoftDeviceGEV_GetStatistics(self)

    def GetMessagingChannel(self):
        r"""
        Obtains the messaging channel interface of the #PvSoftDeviceGEV.

        The #IPvMessageChannel interface can be used to send events on the messaging
        channel when a GigE Vision controller is connected to the #PvSoftDeviceGEV and has properly set up
        a destination for messaging channel events.

        See also: #IPvMessageChannel

        Only available after the #PvSoftDeviceGEV has been started.

        :rtype: :py:class:`IPvMessageChannel`
        :return: Messaging channel interface of the #PvSoftDeviceGEV or NULL if the device is not running.
        """
        return _ebus_python.PvSoftDeviceGEV_GetMessagingChannel(self)

    def RegisterEventSink(self, aEventSink):
        r"""
        Registers an event sink to receive notifications from the #PvSoftDeviceGEV.

        This method can be called before the #PvSoftDeviceGEV is started.

        See also: IPvVirtualDeviceEventSink

        :type aEventSink: :py:class:`IPvSoftDeviceGEVEventSink`, in
        :param aEventSink: Pointer to a #PvSoftDeviceGEV event sink.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_PARAMETER if aEventSink is NULL or already registered.
        """
        return _ebus_python.PvSoftDeviceGEV_RegisterEventSink(self, aEventSink)

    def UnregisterEventSink(self, aEventSink):
        r"""
        Unregisters a previously registered event sink.

        This method can be called before the #PvSoftDeviceGEV is started and after it has been stopped.

        :type aEventSink: :py:class:`IPvSoftDeviceGEVEventSink`, in
        :param aEventSink: Pointer to a #PvSoftDeviceGEV event sink.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - #PvResult::Code::INVALID_PARAMETER if aEventSink is NULL.
        """
        return _ebus_python.PvSoftDeviceGEV_UnregisterEventSink(self, aEventSink)

    def GetGenICamXMLFile(self):
        r"""
        IPvSoftDeviceGEV::GetGenICamXMLFile() -> PvResult, str
        Returns the GenICam XML file of the device.

        Can be used to retrieve the GenICam XML file of the device after the Start method has been called.

        Can be used on success or failure of the Start method.

        :rtype: Tuple(:py:class:`PvResult`, str)
        :return:
            Tuple composed of (result, xmlFile)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.STATE_ERROR` if the GenICam XML file is not available (likely Start has not been called yet)
             - xmlFile:
                - String where the XML file is copied.

        """
        return _ebus_python.PvSoftDeviceGEV_GetGenICamXMLFile(self)

# Register PvSoftDeviceGEV in _ebus_python:
_ebus_python.PvSoftDeviceGEV_swigregister(PvSoftDeviceGEV)
class PvFPSStabilizer(object):
    r"""
    Display frame rate manager. Used to stabilize the frames-per-seconds displayed.

    This class is pretty simple to use. Just instantiate an object and call the IsTimeToDisplay
    every time you have a new frame to display, specifying the desired frame rate.

    This class is not tied to the display. It simply keeps track of the times associated with
    displayed frames (IsTimeToDisplay returning true) in a circular buffer and uses this history
    to decide if it is time to display a new frame.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" Constructor."""
        _ebus_python.PvFPSStabilizer_swiginit(self, _ebus_python.new_PvFPSStabilizer())
    __swig_destroy__ = _ebus_python.delete_PvFPSStabilizer

    def IsTimeToDisplay(self, aTargetFPS):
        r"""
        Checks whether displaying a frame now would bring us close to the desired display frame rate or not.

        If the new frame will bring you closer to your desired frame rate, the method returns true
        and you send the frame to be displayed to a PvDisplayWnd or your own display class.

        If it returns false, this new frame would bring you above the desired display rate. The
        frame can still be processed, etc. but displaying it would bring you above the desired frame rate.
        The expected course of action would then be to simply not display the frame and wait for a new
        incoming frame - instead of holding to the current one and trying to display it later.

        :type aTargetFPS: int, in
        :param aTargetFPS: The target (desired) display frame rate.

        :rtype: boolean
        :return: True if the frame should be displayed, false if not.
        """
        return _ebus_python.PvFPSStabilizer_IsTimeToDisplay(self, aTargetFPS)

    def GetAverage(self):
        r"""
        Queries the displayed frame rate average

        Used by eBUS Player in the status control that displays the display frame rate.

        :rtype: int
        :return: Returns the current display frame rate average.
        """
        return _ebus_python.PvFPSStabilizer_GetAverage(self)

    def Reset(self):
        r""" Resets the history."""
        return _ebus_python.PvFPSStabilizer_Reset(self)

# Register PvFPSStabilizer in _ebus_python:
_ebus_python.PvFPSStabilizer_swigregister(PvFPSStabilizer)
class PvStreamingChannelSourceDefault(IPvStreamingChannelSource):
    r"""
    A default implementation for the IPvStreamingSourceChannelSource interface.

    While it is recommended to build your Software GigE Vision Device application with
    the IPvStreamingSourceChannelSource interface, simple use cases could benefit
    from using PvStreamingChannelSourceDefault as a starting point.

    PvStreamingChannelSourceDefault enforces constant width, height, pixel format,
    no offset X/Y, no data chunk support, etc.

    If you have a simple use case that would only require changing width and height, you
    could always use PvStreamingChannelSourceDefault as a starting point and
    only override the width and height methods.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, aWidth=640, aHeight=480, aPixelType=PvPixelMono8, aBufferCount=16):
        r"""
        Default constructor.

        :type aWidth: int, in, optional
        :param aWidth: Default width of the image source.
        :type aHeight: int, in, optional
        :param aHeight: Default height of the image source.
        :type aPixelType: int, in, optional
        :param aPixelType: Default pixel type of the image source.
        :type aBufferCount: int, in, optional
        :param aBufferCount: Number of buffers to allocate for streaming.
        """
        if self.__class__ == PvStreamingChannelSourceDefault:
            _self = None
        else:
            _self = self
        _ebus_python.PvStreamingChannelSourceDefault_swiginit(self, _ebus_python.new_PvStreamingChannelSourceDefault(_self, aWidth, aHeight, aPixelType, aBufferCount))
    __swig_destroy__ = _ebus_python.delete_PvStreamingChannelSourceDefault

    def GetWidth(self):
        r"""
        Returns the current image width.

        Your application must implement this method and return the current image width when invoked.

        :rtype: int
        :return: Current image width.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_GetWidth(self)

    def GetHeight(self):
        r"""
        Returns the current image height.

        Your application must implement this method and return the current image height when invoked.

        :rtype: int
        :return: Current image height.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_GetHeight(self)

    def GetOffsetX(self):
        r"""
        Returns the current image offset X.

        Your application must implement this method and return the current image offset X when invoked.

        :rtype: int
        :return: Current image offset X.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_GetOffsetX(self)

    def GetOffsetY(self):
        r"""
        Returns the current image offset Y.

        Your application must implement this method and return the current image offset Y when invoked.

        :rtype: int
        :return: Current image offset Y.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_GetOffsetY(self)

    def GetPixelType(self):
        r"""
        Returns the current pixel type.

        Your application must implement this method and return the current image pixel type when invoked.

        :rtype: int
        :return: Current pixel type.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_GetPixelType(self)

    def GetWidthInfo(self):
        r"""
        IPvStreamingChannelSource::GetWidthInfo() -> ( aMin, aMax, aInc )
        Returns the stream channel width attributes.

        When using the GigE Vision Device as a transmitter, the Width parameter
        is automatically added to the device's GenICam XML file. This method is
        used to query the minimum, maximum, and increment attributes for the Width parameter.

        :rtype: Tuple[int, int, int]
        :return: Tuple composed of the width minimum, maximum and increment.

        """
        return _ebus_python.PvStreamingChannelSourceDefault_GetWidthInfo(self)

    def GetHeightInfo(self):
        r"""
        IPvStreamingChannelSource::GetHeightInfo() -> ( aMin, aMax, aInc )
        Returns the stream channel height attributes.

        When using the GigE Vision Device as a transmitter, the Height parameter
        is automatically added to the device's GenICam XML file. This method is
        used to query the minimum, maximum, and increment attributes for the Height parameter.

        :rtype: Tuple[int, int, int]
        :return: Tuple composed of the height minimum, maximum and increment.

        """
        return _ebus_python.PvStreamingChannelSourceDefault_GetHeightInfo(self)

    def GetChunksSize(self):
        r"""
        Gets the stream channel chunk size attributes.

        When using data chunks, it is important to report the chunk data size when
        queried through this method.

        The chunk data size needs to be taken into account when reporting the PayloadSize
        GenICam parameter to the GigE Vision controller, so it can properly allocate
        its buffer for streaming without forced buffer re-allocation.

        The size reported must for each chunk adds 4 bytes for the chunk ID and another
        4 bytes for the chunk length fields. If you have a chunk that is 64 bytes long and it is your
        only data chunk, you need to report 64 + 4 + 4 (72 bytes) when GetChunksSize is called.

        :rtype: int
        :return: Chunk data size as currently configured.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_GetChunksSize(self)

    def GetPayloadSize(self):
        r"""
        Stream channel payload size in bytes. Return zero to have it inferred from width, height and pixel format.

        If not using image streams (raw data, multi-part, etc.) use implement the GetPayloadSize method and return
        the payload size for the current streaming channel source configuration. If GetPayloadSize returns 0 the
        payload size will be inferred from the width, height, pixel format and data chunk size.

        When using multi-part, return the sum of the maximum size of all parts plus data chunk.

        When payload size is not zero, the payload size value is simply used as provided. Nothing is added
        to it, not even data chunk size.

        :rtype: int
        :return: Payload size to use or 0.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_GetPayloadSize(self)

    def GetScanType(self):
        r"""
        Returns the scan type that is used by the streaming source.

        Return PvScanTypeArea if your image source is areascan or PvScanTypeLine if your
        image source is linescan.

        :rtype: int
        :return: Scan type of the streaming source.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_GetScanType(self)

    def GetChunkModeActive(self):
        r"""
        Indicates whether the current master chunk mode is active.

        The application must implement this method and return the current master chunk mode state.
        Return false as a hardcoded value if chunks are not supported by the streaming source.

        :rtype: boolean
        :return: True if chunk mode is enabled for this streaming source.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_GetChunkModeActive(self)

    def GetChunkEnable(self, aChunkID):
        r"""
        Returns the current chunk enabled state.

        The application must implement this method and return the current chunk enabled state
        for the specified chunk ID. The streaming source should maintain an enabled/disabled
        state for each chunk type that it supports.

        The application should append the chunk represented by the specified chunk ID if it is enabled
        and if the master chunk mode (see #GetChunkModeActive) is true.

        :type aChunkID: int, in
        :param aChunkID: Chunk ID.

        :rtype: boolean
        :return: True if the chunk specified by aChunk ID is enabled for this streaming source.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_GetChunkEnable(self, aChunkID)

    def GetSupportedPixelType(self, aIndex):
        r"""
        IPvStreamingChannelSource::GetSupportedPixelType( aIndex ) -> ( aResult, aPixelType )
        Obtains an index of supported pixel types. Used at #PvSoftDeviceGEV::Start time to create the GenICam XML of the device.

        This method is used by the #PvSoftDeviceGEV to query the application
        about the supported pixel types for the streaming channel.

        The PvSoftDeviceGEV will query the application using this stream
        interface for all supported pixel types. It will start at index 0 and then increase
        until something other than :py:const:`~PvResultCode.:py:const:`~PvResultCode.PV_OK`` is returned.

        If the application supports Mono8, BayerRG8, and RGBa8 it needs to
        handle the request to GetSupportedPixelType, as follows:

            - GetSupportedPixelType( 0 ) -> (:py:const:`~PvResultCode.PV_OK`, PvPixelMono8)
            - GetSupportedPixelType( 1 ) -> (:py:const:`~PvResultCode.PV_OK`, PvPixelBayerRG8)
            - GetSupportedPixelType( 2 ) -> (:py:const:`~PvResultCode.PV_OK`, PvPixelRGBa8)
            - GetSupportedPixelType( 3 ) -> (:py:const:`~PvResultCode.PV_INVALID_PARAMETER`, 0)

        :type aIndex: int, in
        :param aIndex:  Index of the pixel type to return.

        :rtype: Tuple[:py:class:`PvResult`, PvPixelType]
        :return: 
            Tuple composed of (result, aPixelType).
             - result includes:
                - :py:const:`~PvResultCode.PV_OK` if aIndex represents a valid index and aPixelType has been set.
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER` or any other error code if aIndex is not valid.
             - aPixelType
                - The PvPixelType requested by aIndex. See #PvPixelType Enum.

        """
        return _ebus_python.PvStreamingChannelSourceDefault_GetSupportedPixelType(self, aIndex)

    def GetSupportedChunk(self, aIndex):
        r"""
        IPvStreamingChannelSource::GetSupportedChunk( aIndex ) -> ( aResult, aChunkID, aChunkName )
        Returns the indexed supported chunk type. Used at #PvSoftDeviceGEV::Start time to create the GenICam XML of the device.

        This method is used by the PvSoftDeviceGEV to query the application
        about the supported chunk types for this streaming channel.

        The PvSoftDeviceGEV will query the application through this stream
        interface for all supported chunk types. It will start at index 0 and then increase
        until something other than :py:const:`~PvResultCode.PV_OK` is returned.

        The information retrieved through this method is used to populate the chunk selector, allowing
        the GigE Vision controller to enable or disable each chunk type individually.

        If the application supports ChunkSample (ID 0x4001) and ChunkHistogram (ID 0x4002) it needs to
        handle request to GetSupportedChunk as follows:

            - GetSupportedChunk( 0 ) -> (:py:const:`~PvResultCode.PV_OK`, 0x4001, "ChunkSample")
            - GetSupportedChunk( 1 ) -> (:py:const:`~PvResultCode.PV_OK`, 0x4002, "ChunkHistogram")
            - GetSupportedChunk( 2 ) -> (:py:const:`~PvResultCode.PV_INVALID_PARAMETER`, 0, )

        :type aIndex: int, in
        :param aIndex:  Index of the chunk type to return.

        :rtype: Tuple[:py:class:`PvResult`, int, str]
        :return: 
            Tuple composed of (result, chunkID, chunkName).
             - result includes:
                - :py:const:`~PvResultCode.PV_OK` if aIndex represents a valid index and aPixelType has been set.
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER` or any other error code if aIndex is not valid.
             - chunkID:
                - The ChunkID integer.
             - chunkName
                - chunk name in string and should always use the "Chunk" prefix for GenICam SFNC compliance.

        """
        return _ebus_python.PvStreamingChannelSourceDefault_GetSupportedChunk(self, aIndex)

    def SetWidth(self, aWidth):
        r"""
        Request from the #PvSoftDeviceGEV to change the image width.

        The PvSoftDeviceGEV will call SetWidth when
        the Width GenApi parameter or the underlying register is
        changed by the GigE Vision controller.

        To accept the new width, return #PvResult::Code::OK and update
        your streaming code to use the new width.

        :type aWidth: int, in
        :param aWidth: New image width.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK when accepting the new width.
                - #PvResult::Code::GENERIC_ERROR or another error code to refuse the new width.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_SetWidth(self, aWidth)

    def SetHeight(self, aHeight):
        r"""
        Request from the PvSoftDeviceGEV to change the image height.

        The PvSoftDeviceGEV will call SetHeight when
        the Height GenApi parameter or the underlying register is
        changed by the GigE Vision controller.

        To accept the new height, return #PvResult::Code::OK and update
        your streaming code to use the new height.

        :type aHeight: int, in
        :param aHeight: New image height.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK when accepting the new height.
                - #PvResult::Code::GENERIC_ERROR or another error code to refuse the new height.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_SetHeight(self, aHeight)

    def SetOffsetX(self, aOffsetX):
        r"""
        Request from the #PvSoftDeviceGEV to change the image offset X.

        To accept the new offset X, return #PvResult::Code::OK and update
        your streaming code to use the new value.

        :type aOffsetX: int, in
        :param aOffsetX: New image offset X.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK when accepting the new value.
                - #PvResult::Code::GENERIC_ERROR or another error code to refuse the new value.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_SetOffsetX(self, aOffsetX)

    def SetOffsetY(self, aOffsetY):
        r"""
        Request from the PvSoftDeviceGEV to change the image offset Y.

        To accept the new offset Y, return #PvResult::Code::OK and update
        your streaming code to use the new value.

        :type aOffsetY: int, in
        :param aOffsetY: New image offset Y.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK when accepting the new value.
                - #PvResult::Code::GENERIC_ERROR or another error code to refuse the new value.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_SetOffsetY(self, aOffsetY)

    def SetPixelType(self, aPixelType):
        r"""
        Request from the #PvSoftDeviceGEV to change the image pixel type.

        The #PvSoftDeviceGEV will call SetPixelType when
        the PixelType GenApi parameter or the underlying register is
        changed by the GigE Vision controller.

        To accept the new pixel type, return #PvResult::Code::OK and update
        your streaming code to use the new pixel type.

        :type aPixelType: int, in
        :param aPixelType: New image pixel type.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK when accepting the new pixel type.
                - #PvResult::Code::GENERIC_ERROR or another error code to refuse the new pixel type.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_SetPixelType(self, aPixelType)

    def SetChunkModeActive(self, aEnabled):
        r"""
        Set the master chunk mode active state.

        The streaming source should append a specific chunk type to its streaming data
        when both the #GetChunkModeActive (master chunk mode) and #GetChunkEnable for this
        specific chunk type are true.

        :type aEnabled: boolean, in
        :param aEnabled: True to enable chunk mode for this streaming channel, false to disable it.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK to accept the new setting.
                - #PvResult::Code::GENERIC_ERROR or another error code to refuse the new setting.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_SetChunkModeActive(self, aEnabled)

    def SetChunkEnable(self, aChunkID, aEnabled):
        r"""
        Sets the chunk enabled state for a specific chunk type.

        The streaming source should append a specific chunk type to its streaming data
        when both the #GetChunkModeActive (master chunk mode) and #GetChunkEnable for this
        specific chunk type are true.

        :type aChunkID: int, in
        :param aChunkID: Chunk ID of the chunk type to enable or disable.
        :type aEnabled: boolean, in
        :param aEnabled: True to enable the chunk type, false to disable it.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK to accept the new setting.
                - #PvResult::Code::GENERIC_ERROR or another error code to refuse the new setting.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_SetChunkEnable(self, aChunkID, aEnabled)

    def OnOpen(self, aDestIP, aDestPort):
        r"""
        Notification from the #PvSoftDeviceGEV that this streaming channel has been opened.

        :type aDestIP: str, in
        :param aDestIP: IP address of the stream destination as a string in the "192.168.138.115" format (SCDA).
        :type aDestPort: int, in
        :param aDestPort: UDP port of the stream destination (SCP).
        """
        return _ebus_python.PvStreamingChannelSourceDefault_OnOpen(self, aDestIP, aDestPort)

    def OnClose(self):
        r""" Notification from the PvSoftDeviceGEV that this streaming channel has been closed."""
        return _ebus_python.PvStreamingChannelSourceDefault_OnClose(self)

    def OnStreamingStart(self):
        r""" Notification that the GigE Vision controller has requested that the device start streaming on this channel."""
        return _ebus_python.PvStreamingChannelSourceDefault_OnStreamingStart(self)

    def OnStreamingStop(self):
        r""" Notification that the GigE Vision controller has requested that the device stop streaming on this channel."""
        return _ebus_python.PvStreamingChannelSourceDefault_OnStreamingStop(self)

    def AllocBuffer(self):
        r"""
        Request by the #PvSoftDeviceGEV to allocate a PvBuffer.

        On initialization, the #PvSoftDeviceGEV will call this method, asking the application to
        allocate buffers that will be used for image acquisition and transmission. The application should return
        buffers until it has reached the desired number of buffers it wants to use for streaming and then
        return NULL.

        The more buffers you use, the more buffers you can have queued in the application for image acquisition
        and the more buffers you can leave in the transmission output queue for packet resend. The
        downside of using more buffers is increased memory usage.

        Buffers returned on AllocBuffer calls should be unique: you should not return the same
        buffer more than once.

        A maximum of 64 buffers can be used by one streaming channel of the #PvSoftDeviceGEV. If your
        application does not return NULL on the 64th buffer, AllocBuffer will not be called a 64th time.

        :rtype: :py:class:`PvBuffer`
        :return: Pointer to a new PvBuffer that can be used by the #PvSoftDeviceGEV's acquisition manager.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_AllocBuffer(self)

    def FreeBuffer(self, aBuffer):
        r"""
        Request by the #PvSoftDeviceGEV to free or release a buffer allocated with AllocBuffer.

        You should not delete or free any PvBuffer provided by the AllocBuffer method. FreeBuffer will be called
        for each buffer created with AllocBuffer when #PvSoftDeviceGEV::Stop is called.

        :type aBuffer: :py:class:`PvBuffer`, in
        :param aBuffer: Buffer to free.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_FreeBuffer(self, aBuffer)

    def AbortQueuedBuffers(self):
        r"""
        Request by the #PvSoftDeviceGEV to abort all buffers queued for acquisition.

        This method should block until acquisition has been aborted or canceled for all buffers
        provided by QueueBuffer that have not yet been retrieved with RetrievedBuffer.

        When this method returns, it should be possible to call RetrieveBuffer for all aborted
        buffers.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_AbortQueuedBuffers(self)

    def CreateRegisters(self, aRegisterMap, aFactory):
        r"""
        When called, the streaming channel source should create its custom registers if they are needed.

        To create source-specific custom registers in your application, implement the CreateRegisters method of the
        IPvStreamingChannelSource interface.

        Custom source-specific register creation occurs BEFORE custom source-specific GenApi features creation,
        inside the #PvSoftDeviceGEV::Start call.

        If more than one streaming channel source is created from the same class, you must make sure its registers
        are still unique: RegisterXYZ in Source0 and Source1 should not have the same address. It is also recommended
        to assign them unique names like RegisterXYZ0 and RegisterXYZ1.

        :type aRegisterMap: :py:class:`IPvRegisterMap`, in
        :param aRegisterMap: The register map of the device.
        :type aFactory: :py:class:`IPvRegisterFactory`, in
        :param aFactory: Register factory used to create the new registers.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_CreateRegisters(self, aRegisterMap, aFactory)

    def CreateGenApiFeatures(self, aRegisterMap, aFactory):
        r"""
        When called, the streaming channel source should create its custom GenApi parameters if they are needed.

        Create GenApi features from this callback if the feature is associated with a streaming channel source. For global-device,
        non streaming channel source features use #IPvSoftDeviceGEVEventSink::OnCreateCustomGenApiFeatures instead.

        In a multi-source application, GenApi features created by a streaming channel source will only be available when
        the SourceSelector is set to the streaming channel source that created the feature.

        If FeatureXYX is created by Source0 and Source1 but not by Source2, the feature will only be available in the GenApi
        interface when SourceSelector is set to Source0 or Source1.

            - MySource0 has Feature0, Feature1, Feature2
            - MySource1 has Feature0, Feature3, Feature4
            - In a GenApi browser with SourceSelector=Source0, Feature0, Feature1, Feature2 are available. Feature3 and Feature4 are disabled.
            - In a GenApi browser with SourceSelector=Source1, Feature0, Feature3, Feature4 are available. Feature1 and Feature2 are disabled.

        If integers with the same name are created for more than one source but with source-specific minimum, maximum and increment
        attributes, these attributes will be handled by GenICam SwissKnife operators in the GenICam XML so they are dynamically
        adjusted based on the value of SourceSelector. The same applies to float maximum and minimum.

            - MyInteger is created for Source0 with min:0 max:100 increment:4
            - MyInteger is created for Source1 with min:4 max:200 increment:1
            - In a GenApi browser, MyInteger will report min:0 max:100 increment:4 with Source0 is selected
            - In a GenApi browser, MyInteger will report min:4 max:200 increment:1 with Source1 is selected

        If enumerations with the same name are created for more than one source but with different enum entries, they will be
        added to the GenICam XML file of the device in way that the correct enum entries should be available for the enum features
        based on the current SourceSelector value:

            - MyEnum is created with EE0, EE1, EE2 for Source0
            - MyEnum is created with EE0, EE3, EE4 for Source1
            - In a GenApi browser with SourceSelector=Source0, you would see EE0, EE1, EE2 in the combo box
            - In a GenApi browser with SourceSelector=Source1, you would see EE0, EE3, EE4 in the combo box

        Creating features of the same name but different types is not supported. Attempting to do so should have the PvSoftDeviceGEV::Start
        call failing with an appropriate error description.

        GenApi features created for a streaming channel source should use registers unique to this streaming channel source. If you have
        a source class MySource that creates registers and features, it should still create unique register having their own unique addresses.
        They should however use the same parameter name. The GenApi parameters created by MySource should use the right register for the
        source instance. The complexity of overlapping per-source feature name is handled by PvSoftDeviceGEV when creating the GenICam XML
        file from #PvSoftDeviceGEV::Start.

            - For Source0:
                - MySource creates MySourceRegister0 @ 0x20000000 + 0x1000 * source index + 0
                - MySource creates MySourceParameter named "MySourceParameter" for Source0 using MySourceRegister0
            - For Source1:
                - MySource creates MySourceRegister1 @ 0x20000000 + 0x1000 * source index + 4
                - MySource creates MySourceParameter named "MySourceParameter" for Source1 using MySourceRegister1

        The exception to this rule is selectors: if selectors are created at the streaming source level
        they must all use the same register, sharing the same register address.

        Custom source-specific GenApi features creation occurs AFTER custom source-specific registers creation,
        inside the #PvSoftDeviceGEV::Start call.

        :type aRegisterMap: :py:class:`IPvRegisterMap`, in
        :param aRegisterMap: The register map of the device.
        :type aFactory: :py:class:`IPvGenApiFactory`, in
        :param aFactory: GenApi factory used to create the new GenApi features.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_CreateGenApiFeatures(self, aRegisterMap, aFactory)

    def IsPayloadTypeSupported(self, aPayloadType):
        r"""
        When called, the streaming source has to return whether the specificed payload type is supported or not.

        Return true if the streaming source exlusively or non-exclusively can stream buffers of the
        specified payload type. A default implementation is provided for this method which returns false.

        This method must be implemented and returning true for aPayloadType being equal to PvPayloadTypeMultiPart
        when multi-part is supported by the streaming source.

        See #SetTestPayloadFormatMode and #SetMultiPartAllowed for more information on propertly supporting the multi-part payload type.

        :type aPayloadType: int
        :param aPayloadType: [in] The payload type for which support is queried.

        :rtype: boolean
        :return: Return true if the payload type is supported, false if not.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_IsPayloadTypeSupported(self, aPayloadType)

    def SetMultiPartAllowed(self, aAllowed):
        r"""
        Sets whether the streaming source is allowed or not, but not forced, to transmit multi-part data.

        Streaming sources supporting multi-part data transmission must support non-multi-part streaming by default.
        All devices starting in a mode where multi-part is not allowed. The GigE Vision controller must unlock
        the multi-part capability of a GVSP streaming channel using either the SCCx and SCCFGx bootstrap registers
        or the GevSCCFGMultiPartEnabled GenApi parameter.

        The GevSCCFGMultiPartEnabled GenApi parameter is automatically added to the GenICam XML file
        of a PvSoftDeviceGEV device when #IsPayloadTypeSupported returns true when prompted with
        PvPayloadTypeMultiPart.

        See #IsPayloadTypeSupported and #SetTestPayloadFormatMode for more information on propertly supporting the multi-part payload type.

        :type aAllowed: boolean
        :param aAllowed: [in] True if multi-part is allowed.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_SetMultiPartAllowed(self, aAllowed)

    def SetLargeLeaderTrailerEnabled(self, aEnabled, aMaxMultiPartCount):
        r"""
        Sets whether the streaming source which transmit multi-part data uses large data leader and trailer packets.

        Streaming sources using multi-part data transmission without large data leader and trailer
        enabled only supports up to 10 multi-parts due to the data leader and trailer packet size
        limitation. Large data leader and data trailer packets can be enabled by configuring the
        GevSCCFGLargeLeaderTrailerEnabled GenApi parameter to allow more than 10 parts. The large
        leader and trailer packet size is then set to the value allowed by the SCPSx register.

        The GevSCCFGLargeLeaderTrailerEnabled GenApi parameter is automatically added to the GenICam
        XML file of a PvSoftDeviceGEV device when #IsPayloadTypeSupported returns true when prompted
        with PvPayloadTypeMultiPart. This parameter will only be available when
        GevSCCFGMultiPartEnabled is set to true.

        :type aEnabled: boolean
        :param aEnabled: [in] True if Large Leader Trailer is enabled.
        :type aMaxMultiPartCount: int
        :param aMaxMultiPartCount: [in] The number of maximum allowed Multi parts calculated from the value allowed by the SCPSx register.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_SetLargeLeaderTrailerEnabled(self, aEnabled, aMaxMultiPartCount)

    def SetTestPayloadFormatMode(self, aPayloadType):
        r"""
        When called, the streaming source has to ensure it can stream buffers of the specified payload type.

        The GigE Vision Validation Framework has to be able to set the device in a functional streaming mode
        for some payload types (currently only multi-part with more to come) in order to properly validate the device.

        This method must be implemented and for aPayloadType being PvPayloadTypeMultiPart
        when multi-part is supported by the streaming source. The streaming source must be able to configure itself
        in a mode where it will be able to stream data for certification with the GigE Vision Validation Framework.

        Of course, this method will only be called on a streaming source for payload type that have
        been reported as supported with #IsPayloadTypeSupported.

        How to prepare your multi-source device source for GigE Vision Validation Framework validation:
            - Implement #IsPayloadTypeSupported and return true if aPayloadType is PvPayloadTypeMultiPart.
            - Implement #SetTestPayloadFormatMode
                - If aPayloadType is PvPayloadTypeMultiPart
                    - Setup your streaming source for autonomous multi-part streaming if needed
                    - Return #PvResult::Code::OK
                - Else if aPayloadType is PvPayloadTypeNone
                    - Disable test mode, go back to streaming source normal operation mode
                    - Return #PvResult::Code::OK
                - Else
                    - Return any #PvResult error code like #PvResult::Code::NOT_SUPPORTED

        See the SoftDeviceGEVMultiPart C++ sample for an example of how to implement this method, #SetMultiPartAllowed, and #IsPayloadTypeSupported.

        :type aPayloadType: int, in
        :param aPayloadType: Payload type to prepare test for. PvPayloadTypeNone sets the device back in normal operation mode.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK on success.
                - Any error code can be returned to indicate failure.
        """
        return _ebus_python.PvStreamingChannelSourceDefault_SetTestPayloadFormatMode(self, aPayloadType)
    def __disown__(self):
        self.this.disown()
        _ebus_python.disown_PvStreamingChannelSourceDefault(self)
        return weakref.proxy(self)

# Register PvStreamingChannelSourceDefault in _ebus_python:
_ebus_python.PvStreamingChannelSourceDefault_swigregister(PvStreamingChannelSourceDefault)
PvDeviceClass = _ebus_python.PvDeviceClass 
PvDeviceClassUnknown = _ebus_python.PvDeviceClassUnknown
PvDeviceClassTransmitter = _ebus_python.PvDeviceClassTransmitter
PvDeviceClassReceiver = _ebus_python.PvDeviceClassReceiver
PvDeviceClassTransceiver = _ebus_python.PvDeviceClassTransceiver
PvDeviceClassPeripheral = _ebus_python.PvDeviceClassPeripheral
PvUSBStatus = _ebus_python.PvUSBStatus 
PvUSBStatusNotInitialized = _ebus_python.PvUSBStatusNotInitialized
PvUSBStatusConnected = _ebus_python.PvUSBStatusConnected
PvUSBStatusFailedEnumeration = _ebus_python.PvUSBStatusFailedEnumeration
PvUSBStatusGeneralFailure = _ebus_python.PvUSBStatusGeneralFailure
PvUSBStatusCausedOvercurrent = _ebus_python.PvUSBStatusCausedOvercurrent
PvUSBStatusNotEnoughPower = _ebus_python.PvUSBStatusNotEnoughPower
PvUSBStatusNotEnoughBandwidth = _ebus_python.PvUSBStatusNotEnoughBandwidth
PvUSBStatusHubNestedTooDeeply = _ebus_python.PvUSBStatusHubNestedTooDeeply
PvUSBStatusInLegacyHub = _ebus_python.PvUSBStatusInLegacyHub
PvUSBStatusEnumerating = _ebus_python.PvUSBStatusEnumerating
PvUSBStatusReset = _ebus_python.PvUSBStatusReset
PvInterfaceType = _ebus_python.PvInterfaceType 
PvInterfaceTypeUnknown = _ebus_python.PvInterfaceTypeUnknown
PvInterfaceTypeUSBHostController = _ebus_python.PvInterfaceTypeUSBHostController
PvInterfaceTypeNetworkAdapter = _ebus_python.PvInterfaceTypeNetworkAdapter
PvDeviceInfoType = _ebus_python.PvDeviceInfoType 
PvDeviceInfoTypeUnknown = _ebus_python.PvDeviceInfoTypeUnknown
PvDeviceInfoTypeGEV = _ebus_python.PvDeviceInfoTypeGEV
PvDeviceInfoTypePleoraProtocol = _ebus_python.PvDeviceInfoTypePleoraProtocol
PvDeviceInfoTypeUSB = _ebus_python.PvDeviceInfoTypeUSB
PvDeviceInfoTypeU3V = _ebus_python.PvDeviceInfoTypeU3V
PvUSBSpeed = _ebus_python.PvUSBSpeed 
PvUSBSpeedUnsupported = _ebus_python.PvUSBSpeedUnsupported
PvUSBSpeedUnknown = _ebus_python.PvUSBSpeedUnknown
PvUSBSpeedLow = _ebus_python.PvUSBSpeedLow
PvUSBSpeedFull = _ebus_python.PvUSBSpeedFull
PvUSBSpeedHigh = _ebus_python.PvUSBSpeedHigh
PvUSBSpeedSuper = _ebus_python.PvUSBSpeedSuper
PvDeviceType = _ebus_python.PvDeviceType 
PvDeviceTypeUnknown = _ebus_python.PvDeviceTypeUnknown
PvDeviceTypeGEV = _ebus_python.PvDeviceTypeGEV
PvDeviceTypeU3V = _ebus_python.PvDeviceTypeU3V
class PvSessionInfo(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    mName = property(_ebus_python.PvSessionInfo_mName_get, _ebus_python.PvSessionInfo_mName_set)
    mAddress = property(_ebus_python.PvSessionInfo_mAddress_get, _ebus_python.PvSessionInfo_mAddress_set)
    mPort = property(_ebus_python.PvSessionInfo_mPort_get, _ebus_python.PvSessionInfo_mPort_set)
    mLocalAddress = property(_ebus_python.PvSessionInfo_mLocalAddress_get, _ebus_python.PvSessionInfo_mLocalAddress_set)

    def __init__(self):
        _ebus_python.PvSessionInfo_swiginit(self, _ebus_python.new_PvSessionInfo())
    __swig_destroy__ = _ebus_python.delete_PvSessionInfo

# Register PvSessionInfo in _ebus_python:
_ebus_python.PvSessionInfo_swigregister(PvSessionInfo)
class PvSystem(object):
    r"""
    Find interfaces (network adapters or USB host controllers) and devices reachable from this PC

    #PvSystem finds all interfaces and returns #PvInterface objects. #PvInterface finds all devices on a specific
    interface and returns #PvDeviceInfo based objects. #PvDeviceInfo provides the information required to connect to
    a GigE Vision or USB3 Vision device.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" Constructor."""
        _ebus_python.PvSystem_swiginit(self, _ebus_python.new_PvSystem())
    __swig_destroy__ = _ebus_python.delete_PvSystem

    def Find(self):
        r"""
        Find all interfaces and GigE Vision, USB3 Vision and Pleora Protocol devices reachable from this system.

        This method is blocking and won't return for the duration
        set using #SetDetectionTimeout.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
        """
        return _ebus_python.PvSystem_Find(self)

    def FindDevice(self, aDeviceToFind, aDeviceInfo):
        r"""
        Finds devices until a specific device is found.

        Performs a standard find operation and keeps listening for answers
        until a specific device is found.

        More than one device can be found and added to the interfaces during this
        find operation. Do not assume only the device of interest is present
        in the system/interface data after this method returns.

        If the device of interest is found, a pointer to the device info in the interface
        where the device was found is returned using the aDeviceInfo parameter.

        :type aDeviceToFind: str, in
        :param aDeviceToFind: String representing the device to find. Can be a MAC, IP or device name.
        :type aDeviceInfo: :py:class:`PvDeviceInfo`, out
        :param aDeviceInfo: If the device is found, contains a pointer to a PvDeviceInfo about the device requested in aDeviceToFind.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_FOUND
                - #PvResult::Code::INVALID_PARAMETER
        """
        return _ebus_python.PvSystem_FindDevice(self, aDeviceToFind, aDeviceInfo)

    def SetDetectionTimeout(self, aTimeout):
        r"""
        Sets the time to search the system devices.

        Time the #PvSystem::Find methods wait for responses from GigE Vision or Pleora Protocol
        devices before returning.

        GigE Vision devices may wait up to 1 second before answering a discovery request and this
        detection timeout allows enough time for all discovery answers to come back in.

        USB3 Vision devices detection is instant. You can set this timeout to its minimum supported
        value if you are only interested in detecting USB3 Vision devices.

        Pleora Protocol and some GigE Vision devices answer as soon as the discovery request is received.
        Experimenting with this timeout and discovery stability is a way improving discovery performance.
        Another would be to stick with the safe, default delay and use the event sink callback to be
        notified as soon as a device is discovered.

        :type aTimeout: int, in
        :param aTimeout:   Time to search for devices in ms. The default value of 1500 is generally a good value in most situations.
                                    Values beyond 100 to 60000 are set to 100 and 60000, respectively.
        """
        return _ebus_python.PvSystem_SetDetectionTimeout(self, aTimeout)

    def GetDetectionTimeout(self):
        r"""
        Get the maximum time to search for GigE Vision devices.

        Search here is defined as the time to wait devices to answer after
        sending a discovery through each interface.

        Only applies to Ethernet devices as USB devices enumeration does not
        include the notion of wait or timeout.

        See #SetDetectionTimeout.

        :rtype: int
        :return: See #SetDetectionTimeout.
        """
        return _ebus_python.PvSystem_GetDetectionTimeout(self)

    def SetSubnetBroadcastEnabled(self, aValue):
        r"""
        Sets whether subnet broadcasts are used (or not) when detecting GigE Vision devices.

        :type aValue: boolean, in
        :param aValue: True if subnet broadcasts are to be used when detecting GigE Vision devices.
        """
        return _ebus_python.PvSystem_SetSubnetBroadcastEnabled(self, aValue)

    def GetSubnetBroadcastEnabled(self):
        r"""
        Gets whether subnet broadcasts are used (or not) when detecting GigE Vision devices.

        :rtype: boolean
        :return: True if subnet broadcasts are to be used when detecting GigE Vision devices.
        """
        return _ebus_python.PvSystem_GetSubnetBroadcastEnabled(self)

    def GetGEVSupportedVersion(self):
        r"""
        Get the version of GigE Vision spec supported by the SDK.

        The high 16 bits contain the major version and The low 16 bits the minor version.

        :rtype: int
        :return: GigE Vision spec version supported by the SDK.
        """
        return _ebus_python.PvSystem_GetGEVSupportedVersion(self)

    def GetU3VSupportedVersion(self):
        r"""
        Get the version of USB3 Vision spec supported by the SDK.

        The high 16 bits contain the major version and The low 16 bits the minor version.

        :rtype: int
        :return: USB3 Vision spec version supported by the SDK.
        """
        return _ebus_python.PvSystem_GetU3VSupportedVersion(self)

    def RegisterEventSink(self, aEventSink):
        r"""
        Register an event sink (for device finding notification).

        To use this method, see #PvSystemEventSink.

        :type aEventSink: PvSystemEventSink, in
        :param aEventSink:   A pointer to the event sink object.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
                - #PvResult::Code::GENERIC_ERROR
        """
        return _ebus_python.PvSystem_RegisterEventSink(self, aEventSink)

    def UnregisterEventSink(self, aEventSink):
        r"""
        Unregister an event sink

        To use this method, see #PvSystemEventSink.

        :type aEventSink: PvSystemEventSink, in
        :param aEventSink:   A pointer to the event sink object.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_FOUND
        """
        return _ebus_python.PvSystem_UnregisterEventSink(self, aEventSink)

    def GetInterfaceCount(self):
        r"""
        Get the number of interfaces detected on the system

        :rtype: int
        :return: The number of interfaces detected on the system; the range for the #PvSystem::GetInterface method.
        """
        return _ebus_python.PvSystem_GetInterfaceCount(self)

    def GetInterface(self, aIndex):
        r"""
        Get a #PvInterface.

        Interfaces are ordered in the #PvSystem array as provided by the OS.

        :param [in]:  aIndex  The interface's index in the array; a number ranging from 0 to #GetInterfaceCount-1.

        :rtype: :py:class:`PvInterface`
        :return: A pointer to a #PvInterface object, or NULL if the index is out of bounds.
        """
        return _ebus_python.PvSystem_GetInterface(self, aIndex)

    def GetDeviceCount(self):
        r"""
        Returns number of device that can be enumerated from PvSystem using GetDeviceInfo.

        :rtype: int
        :return: Device count.
        """
        return _ebus_python.PvSystem_GetDeviceCount(self)

    def GetDeviceInfo(self, aIndex):
        r"""
        Returns a pointer to a device of the PvSystem.

        The GetDeviceCount and GetDeviceInfo methods of PvSystem are a shortcut
        for users only interested in retrieving devices without having to handle the
        interface to device topology.

        :type aIndex: int, in
        :param aIndex: Zero-based index of the device info. Valid range is [0 .. GetDeviceCount - 1].

        :rtype: :py:class:`PvDeviceInfo`
        :return: Pointer to the requested PvDeviceInfo.
        """
        return _ebus_python.PvSystem_GetDeviceInfo(self, aIndex)

    def DiscoverSessions(self):
        return _ebus_python.PvSystem_DiscoverSessions(self)

    def GetSessionInfo(self, aIndex, aSessionInfo):
        return _ebus_python.PvSystem_GetSessionInfo(self, aIndex, aSessionInfo)

# Register PvSystem in _ebus_python:
_ebus_python.PvSystem_swigregister(PvSystem)
class PvDeviceInfo(object):
    r"""
    Information identifying a device

    #PvDeviceInfo provides information about a device (GigE Vision, USB3 Vision or Pleora Protocol) as found by either #PvSystem/#PvInterface
    or device finder dialog.

    To use #PvDeviceInfo, see #PvDevice.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_PvDeviceInfo

    def Copy(self):
        r"""
        Creates a copy of the PvDeviceInfo object.

        The user is responsible from freeing/deleting the object after use. The object is fully
        detached from PvSystem or the device finder dialog object.

        :rtype: :py:class:`PvDeviceInfo`
        :return: Pointer to the PvDeviceInfo copy. The user is reponsable to delete/free this pointer.
        """
        return _ebus_python.PvDeviceInfo_Copy(self)

    def GetType(self):
        r"""
        Returns the type of the device info object.

        :rtype: int
        :return: Type of the device info object. see #PvDeviceInfoType enum.
        """
        return _ebus_python.PvDeviceInfo_GetType(self)

    def GetVendorName(self):
        r"""
        Get the device's manufacturer name.

        :rtype: str
        :return: The device's manufacturer name.
        """
        return _ebus_python.PvDeviceInfo_GetVendorName(self)

    def GetModelName(self):
        r"""
        Get the device's model name.

        :rtype: str
        :return: The device's model name.
        """
        return _ebus_python.PvDeviceInfo_GetModelName(self)

    def GetVersion(self):
        r"""
        Get the device's version.

        :rtype: str
        :return: The GigE Vision or USB3 Vision device's firmware version.
        """
        return _ebus_python.PvDeviceInfo_GetVersion(self)

    def GetManufacturerInfo(self):
        r"""
        Get the manufacturer information returned by the device

        :rtype: str
        :return: The manufacturer information returned by the GigE Vision or USB3 Vision device.
        """
        return _ebus_python.PvDeviceInfo_GetManufacturerInfo(self)

    def GetSerialNumber(self):
        r"""
        Get the GigE Vision device's serial number.

        :rtype: str
        :return: The GigE Vision or USB3 Vision device's serial number represented as a string.
        """
        return _ebus_python.PvDeviceInfo_GetSerialNumber(self)

    def GetUserDefinedName(self):
        r"""
        Get the device's user defined name.

        This feature is only supported by devices having persistence memory.
        It can therefor be blank if not supported by the device, or simply
        not yet assigned.

        :rtype: str
        :return: The device's name.
        """
        return _ebus_python.PvDeviceInfo_GetUserDefinedName(self)

    def GetLicenseMessage(self):
        r"""
        Get a message of whether license is valid, and if not why

        This string provides information on validity of the license. If the license is valid, then
        it is simply 'valid'. Otherwise, the reason for the invalidity is provided as a string.

        :rtype: str
        :return: A string indicating 'valid' if license is valid, or a reason for invalid license
        """
        return _ebus_python.PvDeviceInfo_GetLicenseMessage(self)

    def GetDisplayID(self):
        r"""
        Get a string identifying this device for display purpose.

        :rtype: str
        :return: A string identifying the device.
        """
        return _ebus_python.PvDeviceInfo_GetDisplayID(self)

    def GetUniqueID(self):
        r"""
        Get a string uniquely identifying this device.

        The content of the unique ID is not garanteed to be represent anything or to be
        constant between revisions of the eBUS SDK. It should only be used to opaquely,
        uniquely match other device unique IDs from within the same application
        life cycle.

        Do not assume the unique ID will be using a MAC address for network devices or
        the USB GUID for USB devices.

        If you need the MAC address of a GigE Vision device, use #PvDeviceInfoGEV::GetMACAddress.

        If you need the USB GUID of a USB3 Vision device, use #PvDeviceInfoU3V::GetGUID.

        :rtype: str
        :return: A unique string identifying the device.
        """
        return _ebus_python.PvDeviceInfo_GetUniqueID(self)

    def GetConnectionID(self):
        r"""
        Get a unique string identifying this device for connection purpose.

        This string can be used with the factory methods of PvDevice and PvStream to
        create a GigE Vision device or USB3 Vision device from  generic PvDeviceInfo.

        :rtype: str
        :return: A unique string identifying the device.
        """
        return _ebus_python.PvDeviceInfo_GetConnectionID(self)

    def GetInterface(self):
        r"""
        Get the network adapter (#PvInterface) through which this device was reached.

        :rtype: :py:class:`PvInterface`
        :return: A pointer to the interface the device was found on.
        """
        return _ebus_python.PvDeviceInfo_GetInterface(self)

    def IsConfigurationValid(self):
        r"""
        Test if the device can be reached as currently configured.

        This method compares the GigE Vision device and NIC's IP configurations to ensure they are
        on the same subnet. For USB3 Vision devices, the configuration is considered valid if the
        device can be enumerated and the Pleora driver is associated to the device.

        :rtype: boolean
        :return: True if valid.
        """
        return _ebus_python.PvDeviceInfo_IsConfigurationValid(self)

    def IsLicenseValid(self):
        r"""
        Test if the eBUS SDK license is valid for this device.

        To connect to third-party devices, the eBUS SDK requires a valid license.
        If you don't have a license, contact sales.

        :rtype: boolean
        :return: True if the license is valid; otherwise, false.
        """
        return _ebus_python.PvDeviceInfo_IsLicenseValid(self)

    def GetClass(self):
        r"""
        Get the device class.

        :rtype: int
        :return: The device's class; a PvDeviceClass enumeration.
        """
        return _ebus_python.PvDeviceInfo_GetClass(self)

# Register PvDeviceInfo in _ebus_python:
_ebus_python.PvDeviceInfo_swigregister(PvDeviceInfo)
class PvDeviceInfoGEV(PvDeviceInfo):
    r""" Information identifying a GigE Vision device"""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" Constructor."""
        _ebus_python.PvDeviceInfoGEV_swiginit(self, _ebus_python.new_PvDeviceInfoGEV())
    __swig_destroy__ = _ebus_python.delete_PvDeviceInfoGEV

    def GetMACAddress(self):
        r"""
        Get the GigE Vision device's MAC address.

        :rtype: str
        :return: The GigE Vision device's MAC address, in the form *aa*:*bb*:*cc*:*dd*:*ee*:*ff*,
                    where *aa* through *ff* are lowercase hexadecimal numbers ranging from 0x00 to 0xff.
        """
        return _ebus_python.PvDeviceInfoGEV_GetMACAddress(self)

    def GetIPAddress(self):
        r"""
        Get the GigE Vision device's current IP address.

        :rtype: str
        :return: The GigE Vision device's current IP address; the **GevCurrentIPAddress** feature. The form is *a*.*b*.*c*.*d*,
                    where *a* through *d* are decimal numbers ranging from 0 to 255.
        """
        return _ebus_python.PvDeviceInfoGEV_GetIPAddress(self)

    def GetDefaultGateway(self):
        r"""
        Get the GigE Vision device's default gateway.

        :rtype: str
        :return: The GigE Vision device's default gateway; the **GevCurrentDefaultGateway** feature. For the form, see #GetIPAddress.
        """
        return _ebus_python.PvDeviceInfoGEV_GetDefaultGateway(self)

    def GetSubnetMask(self):
        r"""
        Get the GigE Vision device's subnet mask.

        :rtype: str
        :return: The GigE Vision device's subnet mask; the **GevCurrentSubnetMask** feature. For the form, see #GetIPAddress.
        """
        return _ebus_python.PvDeviceInfoGEV_GetSubnetMask(self)

    def GetGEVVersion(self):
        r"""
        Get the GigE Vision device's network protocol version.

        The high 16 bits contain the major version and The low 16 bits the minor version.

        :rtype: int
        :return: The GigE Vision device's network protocol version.
        """
        return _ebus_python.PvDeviceInfoGEV_GetGEVVersion(self)

    def GetIPConfigOptionsString(self):
        r"""
        Get the GigE Vision device's IP config options.

        :rtype: str
        :return: The GigE Vision device's IP config options; The form is *LLA(L)**DHCP(D)**Persistent_IP(P)**PAUSE_reception(PR)**PAUSE_generation(PG)*,
                     where each represents device's possible IP configuration options.
        """
        return _ebus_python.PvDeviceInfoGEV_GetIPConfigOptionsString(self)

    def GetIPConfigCurrentString(self):
        r"""
        Get the GigE Vision device's current IP config.

        :rtype: str
        :return: The GigE Vision device's current IP config; The form is *LLA(L)**DHCP(D)**Persistent_IP(P)**PAUSE_reception(PR)**PAUSE_generation(PG)*,
                    where each represents device's currently set IP configuration.
        """
        return _ebus_python.PvDeviceInfoGEV_GetIPConfigCurrentString(self)

    def IsLLAAvailable(self):
        r"""
        Check if LLA is one of the IP config options for the GigE Vision device.

        :rtype: boolean
        :return: True, if LLA is an option, False otherwise.
        """
        return _ebus_python.PvDeviceInfoGEV_IsLLAAvailable(self)

    def IsDHCPAvailable(self):
        r"""
        Check if DHCP is one of the IP config options for the GigE Vision device.

        :rtype: boolean
        :return: True, if DHCP is an option, False otherwise.
        """
        return _ebus_python.PvDeviceInfoGEV_IsDHCPAvailable(self)

    def IsPersistentAvailable(self):
        r"""
        Check if Persistent_IP is one of the IP config options for the GigE Vision device.

        :rtype: boolean
        :return: True, if Persistent_IP is an option, False otherwise.
        """
        return _ebus_python.PvDeviceInfoGEV_IsPersistentAvailable(self)

    def IsPRAvailable(self):
        r"""
        Check if PAUSE_reception is one of the IP config options for the GigE Vision device.

        :rtype: boolean
        :return: True, if PAUSE_reception is an option, False otherwise.
        """
        return _ebus_python.PvDeviceInfoGEV_IsPRAvailable(self)

    def IsPGAvailable(self):
        r"""
        Check if PAUSE_generation is one of the IP config options for the GigE Vision device.

        :rtype: boolean
        :return: True, if PAUSE_generation is an option, False otherwise.
        """
        return _ebus_python.PvDeviceInfoGEV_IsPGAvailable(self)

    def IsLLAEnabled(self):
        r"""
        Check if LLA is in current IP config for the GigE Vision device.

        :rtype: boolean
        :return: True, if LLA is in current IP config, False otherwise.
        """
        return _ebus_python.PvDeviceInfoGEV_IsLLAEnabled(self)

    def IsDHCPEnabled(self):
        r"""
        Check if DHCP is in current IP config for the GigE Vision device.

        :rtype: boolean
        :return: True, if DHCP is in current IP config, False otherwise.
        """
        return _ebus_python.PvDeviceInfoGEV_IsDHCPEnabled(self)

    def IsPersistentEnabled(self):
        r"""
        Check if Persistent_IP is in current IP config for the GigE Vision device.

        :rtype: boolean
        :return: True, if Persistent_IP is in current IP config, False otherwise.
        """
        return _ebus_python.PvDeviceInfoGEV_IsPersistentEnabled(self)

    def IsPREnabled(self):
        r"""
        Check if PAUSE_reception is in current IP config for the GigE Vision device.

        :rtype: boolean
        :return: True, if PAUSE_reception is in current IP config, False otherwise.
        """
        return _ebus_python.PvDeviceInfoGEV_IsPREnabled(self)

    def IsPGEnabled(self):
        r"""
        Check if PAUSE_generation is in current IP config for the GigE Vision device.

        :rtype: boolean
        :return: True, if PAUSE_generation is in current IP config, False otherwise.
        """
        return _ebus_python.PvDeviceInfoGEV_IsPGEnabled(self)

# Register PvDeviceInfoGEV in _ebus_python:
_ebus_python.PvDeviceInfoGEV_swigregister(PvDeviceInfoGEV)
class PvDeviceInfoPleoraProtocol(PvDeviceInfo):
    r"""
    Information about a Pleora Protocol device.

    The eBUS SDK allows enumerating devices using the Pleora protocol. However, it does not allow
    connecting to or controlling these device.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" Constructor."""
        _ebus_python.PvDeviceInfoPleoraProtocol_swiginit(self, _ebus_python.new_PvDeviceInfoPleoraProtocol())
    __swig_destroy__ = _ebus_python.delete_PvDeviceInfoPleoraProtocol

    def GetMACAddress(self):
        r"""
        Get the Pleora Protocol device's MAC address.

        :rtype: str
        :return: The Pleora Protocol device's MAC address, in the form *aa*:*bb*:*cc*:*dd*:*ee*:*ff*,
                    where *aa* through *ff* are lowercase hexadecimal numbers ranging from 0x00 to 0xff.
        """
        return _ebus_python.PvDeviceInfoPleoraProtocol_GetMACAddress(self)

    def GetIPAddress(self):
        r"""
        Get the Pleora Protocol device's current IP address.

        :rtype: str
        :return: The Pleora Protocol device's current IP address; the **GevCurrentIPAddress** feature. The form is *a*.*b*.*c*.*d*,
                    where *a* through *d* are decimal numbers ranging from 0 to 255.
        """
        return _ebus_python.PvDeviceInfoPleoraProtocol_GetIPAddress(self)

    def GetSubnetMask(self):
        r"""
        Get the Pleora Protocol device's subnet mask.

        :rtype: str
        :return: The Pleora Protocol device's subnet mask; the **GevCurrentSubnetMask** feature. For the form, see #GetIPAddress.
        """
        return _ebus_python.PvDeviceInfoPleoraProtocol_GetSubnetMask(self)

    def GetDefaultGateway(self):
        r"""
        Get the Pleora Protocol device's default gateway.

        :rtype: str
        :return: The Pleora Protocol device's default gateway; the **GevCurrentDefaultGateway** feature. For the form, see #GetIPAddress.
        """
        return _ebus_python.PvDeviceInfoPleoraProtocol_GetDefaultGateway(self)

    def GetDeviceID(self):
        r"""
        Returns the Device ID of the Pleora Protocol device.

        :rtype: uint8_t
        :return: Device ID.
        """
        return _ebus_python.PvDeviceInfoPleoraProtocol_GetDeviceID(self)

    def GetModuleID(self):
        r"""
        Returns the Module ID of the Pleora Protocol device.

        :rtype: uint8_t
        :return: Module ID.
        """
        return _ebus_python.PvDeviceInfoPleoraProtocol_GetModuleID(self)

    def GetSubID(self):
        r"""
        Returns the Sub ID of the Pleora Protocol device.

        :rtype: uint8_t
        :return: Sub ID.
        """
        return _ebus_python.PvDeviceInfoPleoraProtocol_GetSubID(self)

    def GetVendorID(self):
        r"""
        Returns the Vendor ID of the Pleora Protocol device.

        :rtype: uint8_t
        :return: Vendor ID.
        """
        return _ebus_python.PvDeviceInfoPleoraProtocol_GetVendorID(self)

    def GetSoftwareMajor(self):
        r"""
        Major version of the firmware running on the Pleora Protocol device.

        :rtype: uint8_t
        :return: Major version of the firmware.
        """
        return _ebus_python.PvDeviceInfoPleoraProtocol_GetSoftwareMajor(self)

    def GetSoftwareMinor(self):
        r"""
        Minor version of the firmware running on the Pleora Protocol device.

        :rtype: uint8_t
        :return: Minor version of the firmware.
        """
        return _ebus_python.PvDeviceInfoPleoraProtocol_GetSoftwareMinor(self)

# Register PvDeviceInfoPleoraProtocol in _ebus_python:
_ebus_python.PvDeviceInfoPleoraProtocol_swigregister(PvDeviceInfoPleoraProtocol)
class PvDeviceInfoUSB(PvDeviceInfo):
    r""" Information about a generic USB device."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" Constructor."""
        _ebus_python.PvDeviceInfoUSB_swiginit(self, _ebus_python.new_PvDeviceInfoUSB())
    __swig_destroy__ = _ebus_python.delete_PvDeviceInfoUSB

    def GetStatus(self):
        r"""
        Returns the enumeration status of the USB device.

        :rtype: int
        :return: Current enumeration status.
        """
        return _ebus_python.PvDeviceInfoUSB_GetStatus(self)

# Register PvDeviceInfoUSB in _ebus_python:
_ebus_python.PvDeviceInfoUSB_swigregister(PvDeviceInfoUSB)
class PvDeviceInfoU3V(PvDeviceInfoUSB):
    r""" Information about a USB3 Vision device."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" Constructor."""
        _ebus_python.PvDeviceInfoU3V_swiginit(self, _ebus_python.new_PvDeviceInfoU3V())
    __swig_destroy__ = _ebus_python.delete_PvDeviceInfoU3V

    def GetGenCPVersion(self):
        r"""
        Get the USB3 Vision device's GenCP protocol version.

        The high 16 bits contain the major version and The low 16 bits the minor version.

        :rtype: int
        :return: The USB3 Vision device's GenCP protocol version.
        """
        return _ebus_python.PvDeviceInfoU3V_GetGenCPVersion(self)

    def GetU3VVersion(self):
        r"""
        Get the USB3 Vision device's USB3 Vision protocol version.

        The high 16 bits contain the major version and The low 16 bits the minor version.

        :rtype: int
        :return: The USB3 Vision device's USB3 Vision protocol version.
        """
        return _ebus_python.PvDeviceInfoU3V_GetU3VVersion(self)

    def GetDeviceGUID(self):
        r"""
        Get the USB3 Vision GUID of the device.

        GUID stands for "Globally Unique Identifier". It is the USB3 Vision counterpart of
        the MAC of a GigE Vision device.

        :rtype: str
        :return: USB3 Vision GUID of the device.
        """
        return _ebus_python.PvDeviceInfoU3V_GetDeviceGUID(self)

    def GetFamilyName(self):
        r"""
        Returns the family name of the device.

        :rtype: str
        :return: Family name of the device.
        """
        return _ebus_python.PvDeviceInfoU3V_GetFamilyName(self)

    def GetU3VSerialNumber(self):
        r"""
        Returns the U3V serial number of the device.

        :rtype: str
        :return: U3V serial number of the device.
        """
        return _ebus_python.PvDeviceInfoU3V_GetU3VSerialNumber(self)

    def GetDevicePath(self):
        r"""
        Returns the U3V device path.

        Cryptic, internal device key used to load the driver for a device from a device info.

        :rtype: str
        :return: U3V device key.
        """
        return _ebus_python.PvDeviceInfoU3V_GetDevicePath(self)

    def GetDeviceKey(self):
        r"""
        Returns the U3V device key.

        Cryptic, internal device key used to load the driver for a device from a device info.

        :rtype: str
        :return: U3V device key.
        """
        return _ebus_python.PvDeviceInfoU3V_GetDeviceKey(self)

    def GetSpeedMessage(self):
        r"""
        Get a message of the speed negotiated between the controller and the device (low, high, full, super) or an error message

        :rtype: str
        :return: 
               A string indicating the negotiated speed ('low', 'high', 'full', 'super') or an error message:
                - 'Unknown' if the negotiation speed is not known
                - 'Connect to USB 3.0 port" if a device that can only support higher speeds is connected to lower speed ports
        """
        return _ebus_python.PvDeviceInfoU3V_GetSpeedMessage(self)

    def GetPowerMessage(self):
        r"""
        Get a message of whether device is powered properly or not

        This string provides information on whether the device seems to be powered properly or not

        :rtype: str
        :return: A string indicating 'Ok' if devices seems to be powered or an error message (e.g. "Ensure correct power") otherwise
        """
        return _ebus_python.PvDeviceInfoU3V_GetPowerMessage(self)

    def IsLowSpeedSupported(self):
        r"""
        Returns true if the device supports USB1.0 speed.

        :rtype: boolean
        :return: True if the device supports low speed.
        """
        return _ebus_python.PvDeviceInfoU3V_IsLowSpeedSupported(self)

    def IsFullSpeedSupported(self):
        r"""
        Returns true if the device supports USB1.1 speed.

        :rtype: boolean
        :return: True if the device supports full speed.
        """
        return _ebus_python.PvDeviceInfoU3V_IsFullSpeedSupported(self)

    def IsHighSpeedSupported(self):
        r"""
        Returns true if the device supports USB2 speed.

        :rtype: boolean
        :return: True if the device supports high speed.
        """
        return _ebus_python.PvDeviceInfoU3V_IsHighSpeedSupported(self)

    def IsSuperSpeedSupported(self):
        r"""
        Returns true if the device supports USB3 speed.

        :rtype: boolean
        :return: True if the device supports super speed.
        """
        return _ebus_python.PvDeviceInfoU3V_IsSuperSpeedSupported(self)

    def IsCurrentSpeedSupported(self):
        r"""
        Returns true if the current speed of the device is supported by the host controller.

        :rtype: boolean
        :return: True if the host controller supports the current speed of the device.
        """
        return _ebus_python.PvDeviceInfoU3V_IsCurrentSpeedSupported(self)

    def GetSpeed(self):
        r"""
        Returns the currently effective connection speed of the USB3 Vision device.

        If a device supporting super speed is connected in a slower hub or controller it is
        not able to negotiate up to its maximum supported speed.

        If a device IsSuperSpeedSupported returns true and GetSpeed returns something slower
        look into the supported speed of the hubs chain to the controller or the controller itself.

        :rtype: int
        :return: Effective connection speed. See #PvUSBSpeed Enum.
        """
        return _ebus_python.PvDeviceInfoU3V_GetSpeed(self)

    def GetMaxPower(self):
        r"""
        Power consumption of the device in milliamp.

        :rtype: int
        :return: Power consumption of the device.
        """
        return _ebus_python.PvDeviceInfoU3V_GetMaxPower(self)

    def GetMaxPacketSize(self):
        r"""
        Maximum packet size that can be used by the device in bytes.

        :rtype: int
        :return: Maximum packet size.
        """
        return _ebus_python.PvDeviceInfoU3V_GetMaxPacketSize(self)

    def IsPleoraDriverInstalled(self):
        r"""
        Returns true if the currently selected driver for the device is the Pleora driver.

        :rtype: boolean
        :return: True is the device is using the Pleora driver.
        """
        return _ebus_python.PvDeviceInfoU3V_IsPleoraDriverInstalled(self)

    def IsInitializedCapabilities(self):
        r"""
        Returns true if the device U3V capabilities were retrieved and initialized

        :rtype: boolean
        :return: True if the device's capabilities are accessible, false otherwise (indicating device may not be powered properly)
        """
        return _ebus_python.PvDeviceInfoU3V_IsInitializedCapabilities(self)

# Register PvDeviceInfoU3V in _ebus_python:
_ebus_python.PvDeviceInfoU3V_swigregister(PvDeviceInfoU3V)
class PvInterface(object):
    r"""
    Represents one interface (network adapter or USB host controller) on a system (the PC)

    To use this class, see #PvSystem.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_PvInterface

    def Copy(self):
        r"""
        Creates a copy of the PvInterface object.

        The user is responsible from freeing/deleting the object after use. The object is fully
        detached from PvSystem or the device finder dialog object.

        :rtype: :py:class:`PvInterface`
        :return: Pointer to the PvInterface copy. The user is reponsable to delete/free this pointer.
        """
        return _ebus_python.PvInterface_Copy(self)

    def GetType(self):
        r"""
        Get the interface type.

        :rtype: int
        :return: Type of interface (network interface or USB host controller). See #PvInterfaceType Enum.
        """
        return _ebus_python.PvInterface_GetType(self)

    def GetName(self):
        r"""
        Get the description of the NIC, as reported by the OS.

        :rtype: str
        :return: The description of the NIC, as reported by the OS. The value is intended
                    only for human reading.
        """
        return _ebus_python.PvInterface_GetName(self)

    def GetDisplayID(self):
        r"""
        Get a string that can be used in a user interface to identify the interface.

        :rtype: str
        :return: The interface's display ID.
        """
        return _ebus_python.PvInterface_GetDisplayID(self)

    def GetUniqueID(self):
        r"""
        Get a string uniquely identifying the interface.

        The content of the unique ID is not garanteed to be represent anything or to be
        constant between revisions of the eBUS SDK. It should only be used to opaquely,
        uniquely match other interface unique IDs from within the same application
        life cycle.

        Do not assume the unique ID will be using a MAC address for network adapters or
        anything specifc for USB host controllers.

        If you need the MAC address of a network adapter, use #PvNetworkAdapter::GetMACAddress.

        If you need specific information about a USB host controller, use the PvUSBHostController class.

        :rtype: str
        :return: The interface's unique ID.
        """
        return _ebus_python.PvInterface_GetUniqueID(self)

    def GetCompareID(self):
        r"""
        Get a string that can be used to sort interfaces.

        The content of the compare ID is not garanteed to be represent anything or to be
        constant between revisions of the eBUS SDK.

        It should only be used to opaquely, uniquely compare other interface sorting IDs
        to allow consistent sorting and ordering of interfaces, typically in a user
        interface context.

        :rtype: str
        :return: String that can be used to sort interfaces.
        """
        return _ebus_python.PvInterface_GetCompareID(self)

    def GetDeviceCount(self):
        r"""
        Get the number of found devices on this #PvInterface.

        :rtype: int
        :return: The number of devices found through this #PvInterface.
        """
        return _ebus_python.PvInterface_GetDeviceCount(self)

    def GetDeviceInfo(self, aIndex):
        r"""
        Get information identifying a device.

        Returns information identifying a device discovered on this interface (network adapter or USB host controller).
        This information can be used to connect and control it with a #PvDevice object.

        To connect, use #PvDevice::CreateAndConnect (supports both GigE Vision and USB3 Vision devices), #PvDeviceGEV::Connect or #PvDeviceU3V::Connect.

        :type aIndex: int, in
        :param aIndex:  The device's array position. The zero-based
                                parameter accepts 0 through #GetDeviceCount-1.

        :rtype: :py:class:`PvDeviceInfo`
        :return: Information identifying a device; a #PvDeviceInfo object.
                    If *aIndex* is out of bounds, the return is NULL.
        """
        return _ebus_python.PvInterface_GetDeviceInfo(self, aIndex)

    @staticmethod
    def Compare(a1, a2):
        r"""
        Static method used for sorting interfaces

        :type a1: :py:class:`PvInterface`, in
        :param a1: A first interface.
        :type a2: :py:class:`PvInterface`, in
        :param a2: A second interface.

        :rtype: boolean
        :return: 
                - true if the value of the first character that doesn't match is lower in a1's ID or all compared characters match but the compared ID is shorter.
                - false otherwise.
        """
        return _ebus_python.PvInterface_Compare(a1, a2)

    def GetPleoraDriverVersion(self):
        r"""
        Get the eBUS driver version installed on this #PvInterface.

        :rtype: str
        :return: 
                - The eBUS driver version, if installed. The numbers are, in order: the major, minor, subminor and build number (format: #.#.#.#.####).
                - An empty string if the eBUS driver is not currently installed on the interface.
        """
        return _ebus_python.PvInterface_GetPleoraDriverVersion(self)

# Register PvInterface in _ebus_python:
_ebus_python.PvInterface_swigregister(PvInterface)
class IPConfig(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    mIPAddress = property(_ebus_python.IPConfig_mIPAddress_get, _ebus_python.IPConfig_mIPAddress_set)
    mSubnetMask = property(_ebus_python.IPConfig_mSubnetMask_get, _ebus_python.IPConfig_mSubnetMask_set)

    def __init__(self):
        _ebus_python.IPConfig_swiginit(self, _ebus_python.new_IPConfig())
    __swig_destroy__ = _ebus_python.delete_IPConfig

# Register IPConfig in _ebus_python:
_ebus_python.IPConfig_swigregister(IPConfig)
class PvNetworkAdapter(PvInterface):
    r"""
    Represents one Ethernet network adapter on a system (the PC)

    To use this class, see #PvSystem.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" Constructor."""
        _ebus_python.PvNetworkAdapter_swiginit(self, _ebus_python.new_PvNetworkAdapter())
    __swig_destroy__ = _ebus_python.delete_PvNetworkAdapter

    def GetMACAddress(self):
        r"""
        Get the NIC's MAC address.

        :rtype: str
        :return: The NIC's MAC address. The form is *##.##.##.##.##.##*,
                    where *#* is a 0-9 or A-F.
        """
        return _ebus_python.PvNetworkAdapter_GetMACAddress(self)

    def GetDescription(self):
        r"""
        Returns the operating system provided description of the network adapter.

        :rtype: str
        :return: Description of the network adapter.
        """
        return _ebus_python.PvNetworkAdapter_GetDescription(self)

    def GetIPAddressCount(self):
        r"""
        Returns one of the IP addresses for the network adapter, index-based.

        IP addresses and subnet masks are enumerated together. GetIPAddressCount
        is used to get the 0-based range that can be used with both GetIPAddress
        and GetSubnetMask. The subnet mask of 0 matches the IP addresses of 0, etc.

        :rtype: int
        :return: One of the IP addresses used by the adapter represented as a string.
        """
        return _ebus_python.PvNetworkAdapter_GetIPAddressCount(self)

    def GetIPAddress(self, aIndex):
        r"""
        Returns the IP address of the network adapter.

        IP addresses and subnet masks are enumerated together. The subnet mask of 0
        matches the IP addresses of 0, etc.

        :type aIndex: int, in
        :param aIndex: The IP configuration index.

        :rtype: str
        :return: One of the IP addresses of the network adapter.
        """
        return _ebus_python.PvNetworkAdapter_GetIPAddress(self, aIndex)

    def GetSubnetMask(self, aIndex):
        r"""
        Returns the subnet mask of one of the IP addresses of the network adapter.

        IP addresses and subnet masks are enumerated together. The subnet mask of 0
        matches the IP addresses of 0, etc.

        :type aIndex: int, in
        :param aIndex: The IP configuration index.

        :rtype: str
        :return: One of the IP addresses of the network adapter.
        """
        return _ebus_python.PvNetworkAdapter_GetSubnetMask(self, aIndex)

    def GetDefaultGateway(self):
        r"""
        The NIC's default gateway.

        :rtype: str
        :return: The NIC's default gateway. The form follows that of #GetIPAddress.
        """
        return _ebus_python.PvNetworkAdapter_GetDefaultGateway(self)

    def IsPleoraDriverInstalled(self):
        r"""
        Returns true if the Pleora driver is installed on this network interface.

        :rtype: boolean
        :return: True if the Pleora driver is installed on this network interface.
        """
        return _ebus_python.PvNetworkAdapter_IsPleoraDriverInstalled(self)

# Register PvNetworkAdapter in _ebus_python:
_ebus_python.PvNetworkAdapter_swigregister(PvNetworkAdapter)
class PvUSBHostController(PvInterface):
    r"""
    Represents one USB host controller on a system (the PC)

    To use this class, see #PvSystem.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" Constructor."""
        _ebus_python.PvUSBHostController_swiginit(self, _ebus_python.new_PvUSBHostController())
    __swig_destroy__ = _ebus_python.delete_PvUSBHostController

    def GetVendorID(self):
        r"""
        Vendor ID of the USB host controller.

        :rtype: int
        :return: Vendor ID.
        """
        return _ebus_python.PvUSBHostController_GetVendorID(self)

    def GetDeviceID(self):
        r"""
        Device ID of the USB host controller.

        :rtype: int
        :return: Device ID.
        """
        return _ebus_python.PvUSBHostController_GetDeviceID(self)

    def GetSubsystemID(self):
        r"""
        Subsystem ID of the USB host controller.

        :rtype: int
        :return: Subsystem ID.
        """
        return _ebus_python.PvUSBHostController_GetSubsystemID(self)

    def GetRevision(self):
        r"""
        Revision of the USB host controller.

        :rtype: int
        :return: Revision of the USB host controller.
        """
        return _ebus_python.PvUSBHostController_GetRevision(self)

    def GetSpeed(self):
        r"""
        Speed of the USB host controller.

        Even if a USB host controller supports super speed it does not guarantee a device
        will be connected as super speed. Bad cables or hubs not supporting super speed
        could force the controller and device to end up being connected at a slower speed.

        :rtype: int
        :return: Speed of the USB host controller.
        """
        return _ebus_python.PvUSBHostController_GetSpeed(self)

# Register PvUSBHostController in _ebus_python:
_ebus_python.PvUSBHostController_swigregister(PvUSBHostController)
class PvDeviceEventSink(object):
    r"""
    Observer interface for an observable PvDevice object

    #PvDeviceEventSink defines a set of callback methods from
    a PvDevice object to any object implementing this interface.

    ## GigE Vision Recovery

    A #PvDeviceGEV object continually sends a heartbeat message every HeartbeatInterval ("devicecommunicationGEV.html#HeartbeatInterval") milliseconds to the connected GigE Vision device
    to maintain its control channel privilege and ensure that the two entities are aware of each other's continued existence.

    If the GigE Vision device fails to receive a heartbeat message after a given period of time
    (see the GevHeartbeatTimeout GigE Vision parameter and DefaultHeartbeatTimeout ("devicecommunicationGEV.html#DefaultHeartbeatTimeout")),
    it loses its control channel privilege so that another controller may connect to the device in the event of a connection loss.

    Each heartbeat sent by the #PvDeviceGEV object is acknowledged by the device.
    If the GigE Vision device fails to respond to the heartbeat (within AnswerTimeout ("devicecommunicationGEV.html#AnswerTimeout") milliseconds) after CommandRetryCount ("devicecommunicationGEV.html#CommandRetryCount") retries, it considers itself disconnected
    and notifies any registered #PvDeviceEventSink objects using the #OnLinkDisconnected callback.

    Device recovery (or reconnection) must be performed at the application level. After a #OnLinkDisconnected callback, the current session should
    be cleaned up (disconnecting or deleting your PvDevice controller, closing your PvStream, etc.) and you should start polling with FindDevice from PvSystem
    to see when the device is available again. When the device is available, reconnect and restore any previously known good application
    configuration.

    For a complete working example of how to initiate recovery and continue streaming in the event of a connection loss, refer to the ConnectionRecovery sample.

    ## USB3 Vision Recovery

    A #PvDeviceU3V object continually sends a heartbeat message every HeartbeatInterval ("devicecommunicationU3V.html#HeartbeatInterval") milliseconds to the connected USB3 Vision device
    to ensure that the two entities are aware of each other's continued existence.

    If a #PvDeviceU3V fails to respond to the heartbeat (within AnswerTimeout ("devicecommunicationU3V.html#AnswerTimeout") milliseconds), it considers itself disconnected
    and notifies any registered #PvDeviceEventSink objects using the #OnLinkDisconnected callback.

    USB3 Vision devices do not require the heartbeat. There is no concept of control channel or even a heartbeat being required in order
    to keep the control channel opened. The heartbeat is only used for the host to know that the device is still connected and responsive.

    See GigE Vision section above for instructions on how to perform application level recovery after a disconnect event.

    ## Messaging channel events

    **To receive raw events notifications:**
        - Create an instance of your MySink class.
        - Connect to the GigE Vision device as you normally would. See #PvDevice.
        - Register your MySink class with the #PvDevice object. Use #PvDevice::RegisterEventSink.
        - Control the GigE Vision device as you normally would. See #PvDevice.
        - Handle events when #PvDevice calls your #OnEvent overridden method.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" Constructor."""
        if self.__class__ == PvDeviceEventSink:
            _self = None
        else:
            _self = self
        _ebus_python.PvDeviceEventSink_swiginit(self, _ebus_python.new_PvDeviceEventSink(_self, ))
    __swig_destroy__ = _ebus_python.delete_PvDeviceEventSink

    def OnLinkDisconnected(self, aDevice):
        r"""
        Notification that the #PvDevice unexpectedly lost contact with the device.

        :type aDevice: :py:class:`PvDevice`, in
        :param aDevice: Pointer to the device object that invoked this callback.
        """
        return _ebus_python.PvDeviceEventSink_OnLinkDisconnected(self, aDevice)

    def OnLinkReconnected(self, aDevice):
        r"""
        Deprecated, no longer used.

        PvDevice no longer attempts automatic reconnection. After receiving an #OnLinkDisconnected notification,
        it is recommend to properly complete disconnection at the application level and then either attempting
        reconnection until it  succeeds or trying find the device in a loop with #PvSystem::FindDevice until it
        succeeds and then finally reconnecting PvDevice, re-opening PvStream, etc.

        :type aDevice: :py:class:`PvDevice`, in
        :param aDevice: Pointer to the device object that invoked this callback.
        """
        return _ebus_python.PvDeviceEventSink_OnLinkReconnected(self, aDevice)

    def OnEvent(self, aDevice, aEventID, aChannel, aBlockID, aTimestamp, aData):
        r"""

        Messaging channel raw event notification.

        This #OnEvent handler lets users access the raw GigE Vision or USB3 
        Vision event before it is forwarded to the GenApi layer.

        Notes: This callback is an advanced feature that should only be used by 
        developers who are aware of the event IDs that are being sent from their device. 
        It is recommended to use OnEventGenICam whenever possible.

        Depending on the nature of the event being received, there may be data returned 
        that is pointed to by aData (otherwise aData is None). 
        This additional data is received on the wire in the device\’s Endianess.

        All other parameters are provided in the Endianess of the host.

        :type aDevice: :py:class:`PvDevice`, in
        :param aDevice:    PvDevice object that triggered the callback.
        :type aEventID: int, in
        :param aEventID:    Event ID. Some standard event IDs are defined but usually device dependent.
        :type aChannel: int, in
        :param aChannel:    Streaming channel associated with the event, if any. 
                            0xFFFF is used if the event is not associated to a streaming channel.
        :type aBlockID: int, in
        :param aBlockID:    Streaming block ID associated with the event, if any. 
                            Can be used to pair one or more than one event with a block received from a device. 
                            0 is used if the event is not associated to a block.
        :type aTimestamp: int, in
        :param aTimestamp:    Timestamp of the event on the time domain of the device. 
                                Time unit is defined by the device. 0 if timestamps are not supported by the device that generated the event.
        :type aData: ndarray, in
        :param aData:    A 1-dimensional python numpy array with dtype np.uint8 describing the event Data, if applicable. (None otherwise).

        """
        return _ebus_python.PvDeviceEventSink_OnEvent(self, aDevice, aEventID, aChannel, aBlockID, aTimestamp, aData)

    def OnEventGenICam(self, aDevice, aEventID, aChannel, aBlockID, aTimestamp, aData):
        r"""
        Messaging channel GenICam event notification.

        This #OnEvent handler lets users access the event as
        mapped through the GenApi interface of the device.

        Unlike the other OnEvent that provides a pointer to the raw event data,
        the data is provided as a list of GenApi parameters that have been invalidated
        when the event has been attached to the GenApi node map of the device.

        If events with no data or events with data not mapped in the GenApi interface
        of the device are received, this callback is still invoked by the parameter
        list containing is not provided, it is simply set to NULL.

        :type aDevice: :py:class:`PvDevice`, in
        :param aDevice:     Pointer to the PvDevice object that triggered the callback.
        :type aEventID: int, in
        :param aEventID:    Event ID. Some standard event IDs are defined but usually device dependent.
        :type aChannel: int, in
        :param aChannel:    Streaming channel associated with the event, if any. 0xFFFF is used if the event is not associated to a streaming channel.
        :type aBlockID: int, in
        :param aBlockID:    Streaming block ID associated with the event, if any. Can be used to pair one or more than one event with a block received from a device. 0 is used if the event is not associated to a block.
        :type aTimestamp: int, in
        :param aTimestamp:  Timestamp of the event on the time domain of the device. Time unit is defined by the device. 0 if timestamps are not supported by the device that generated the event.
        :type aData: :py:class:`PvGenParameterList`, in
        :param aData:       List containing all parameters invalidated by this event. Can be NULL if the event carried no data or the data was does not invalidate any GenApi parameters of the device.
        """
        return _ebus_python.PvDeviceEventSink_OnEventGenICam(self, aDevice, aEventID, aChannel, aBlockID, aTimestamp, aData)

    def OnCmdLinkRead(self, aBuffer):
        r"""
        OnCmdLinkRead(aBufferTuple)
        Callback invoked after a port read.

        Used to report read activity  on the GenApi IPort implementation of the command link of the PvDevice.

        The callback is invoked AFTER the read operation so the content of aBuffer
        contains the data that was read from the device.

        This callback is only invoked on a successful read operation.

        If aLength is 4 bytes, that data is represented as a 4 bytes value formatted as big endian.

        If data is more that 4 bytes, it is presented as a stream of bytes requiring
        proper interpretation..

        :type aBufferTuple: Tuple(ndarray, int)
        :param aBufferTuple:
              Tuple composed of (aBuffer, aAddress):
                 - aBuffer which is a 1-dimensional python numpy array with dtype np.uint8 describing the data read.
                 - aAddress representing the address of the data read on the device. 

        """
        return _ebus_python.PvDeviceEventSink_OnCmdLinkRead(self, aBuffer)

    def OnCmdLinkWrite(self, aBuffer):
        r"""
        OnCmdLinkWrite(aBufferTuple)
        Callback invoked after a port write.

        Used to report write activity  on the GenApi IPort implementation of the command link of the PvDevice.

        The callback is invoked AFTER the write operation. The content of aBuffer
        represents the data that was written to the device.

        This callback is only invoked on a successful write operation.

        If aLength is 4 bytes, that data is represented as a 4 bytes value formatted as big endian.

        If data is more that 4 bytes, it is presented as a stream of bytes requiring
        proper interpretation.

        :type aBufferTuple: Tuple(ndarray, int)
        :param aBufferTuple:
              Tuple composed of (aBuffer, aAddress):
                 - aBuffer which is a 1-dimensional python numpy array with dtype np.uint8 describing the data written to the device.
                 - aAddress representing the address of the data written to the device.

        """
        return _ebus_python.PvDeviceEventSink_OnCmdLinkWrite(self, aBuffer)
    def __disown__(self):
        self.this.disown()
        _ebus_python.disown_PvDeviceEventSink(self)
        return weakref.proxy(self)

# Register PvDeviceEventSink in _ebus_python:
_ebus_python.PvDeviceEventSink_swigregister(PvDeviceEventSink)
class PvDevice(object):
    r"""
    Connect, configure and control a GigE Vision or USB3 Vision device.

    It is not possible to instantiate a generic PvDevice. PvDeviceGEV and PvDeviceU3V can
    be instantiated directly.

    If order to write hybrid code one could use the static CreateAndConnect methods. These
    methods dynamically allocated a PvDevice of the right type to connect to the requested
    device. Just remember to free the dynamically allocated device object using the static
    Free method.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_PvDevice

    @staticmethod
    def CreateAndConnect(*args):
        r"""
        CreateAndConnect(*args) -> PvResult, PvDevice
        Dynamically allocates a PvDevice of the right type.

        Objects allocated with CreateAndConnect should be freed with :py:func:`PvDevice.Free`.

        *Overload 1:*

        This static method takes PvDeviceInfo identifying a device, creates the right type of PvDevice (PvDeviceGEV or PvDeviceU3V) and connects it.

        :type aDeviceInfo: :py:class:`PvDeviceInfo`, in
        :param aDeviceInfo:    The GigE Vision devices network connectivity information.

        :rtype:  Tuple(:py:class:`PvResult`, :py:class:`PvDevice`)
        :return:  
            Tuple composed of (result, pvdevice)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER` (if NULL aDeviceInfo, or bad parameter passed)
                - :py:const:`~PvResultCode.PV_NOT_CONNECTED` (if device was found, initially connected but disconnect during the connection process)
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (if an unexpected exception was thrown or if socket cannot bind or connect [GEV] or usb driver is busy [U3V])
                - :py:const:`~PvResultCode.PV_NETWORK_ERROR` (if sending packets failed, GEV)
                - :py:const:`~PvResultCode.PV_TIMEOUT` (if socket binds and sends but times out on receive, GEV)
                - :py:const:`~PvResultCode.PV_THREAD_ERROR` (if heartbeat thread will not start)
                - :py:const:`~PvResultCode.PV_GENICAM_XML_ERROR` (if creating device genicam node map failed with xml error)
                - :py:const:`~PvResultCode.PV_NOT_FOUND` (if the device specified is not found)
                - :py:const:`~PvResultCode.PV_NOT_SUPPORTED` (if no message channels are supported)
                - :py:const:`~PvResultCode.PV_CANT_READ_MANIFEST` (if manifest table could not be read. This can sometimes happen if the U3V device is not powered properly)
             - pvdevice:
                - :py:class:`PvDevice` object (:py:class:`PvDeviceGEV`, :py:class:`PvDeviceU3V` or None).

        |

        *Overload 2:*

        This static method takes a string identifying a device, creates the right type of PvDevice (PvDeviceGEV or PvDeviceU3V) and connects it.

        :type aInfo: str, in
        :param aInfo: String identifying the device. See PvDevice.Connect for more information. 

        :rtype:  Tuple(:py:class:`PvResult`, :py:class:`PvDevice`)
        :return:  
            Tuple composed of (result, pvdevice)
              - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER` (if NULL aDeviceInfo, or bad parameter passed)
                - :py:const:`~PvResultCode.PV_NOT_CONNECTED` (if device was found, initially connected but disconnect during the connection process)
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` (if an unexpected exception was thrown or if socket cannot bind or connect[GEV] or usb driver is busy [U3V])
                - :py:const:`~PvResultCode.PV_NETWORK_ERROR` (if sending packets failed, GEV)
                - :py:const:`~PvResultCode.PV_TIMEOUT` (if socket binds and sends but times out on receive, GEV)
                - :py:const:`~PvResultCode.PV_THREAD_ERROR` (if heartbeat thread will not start)
                - :py:const:`~PvResultCode.PV_GENICAM_XML_ERROR` (if creating device genicam node map failed with xml error)
                - :py:const:`~PvResultCode.PV_NOT_FOUND` (if the device specified is not found)
                - :py:const:`~PvResultCode.PV_NOT_SUPPORTED` (if no message channels are supported)
                - :py:const:`~PvResultCode.PV_CANT_READ_MANIFEST` (if manifest table could not be read. This can sometimes happen if the U3V device is not powered properly)
              - pvdevice:
                - :py:class:`PvDevice` object (:py:class:`PvDeviceGEV`, :py:class:`PvDeviceU3V` or None).

        """
        return _ebus_python.PvDevice_CreateAndConnect(*args)

    @staticmethod
    def Free(aDevice):
        r"""
        Frees an object allocated with CreateAndConnect.

        Even though calling delete on a PvDevice created with CreateAndConnect should
        work in most cases, sometime it is necessary to call "delete" in the same context where
        "new" was called to avoid false positives on memory leaks.

        It is a good practice to use this method to free a PvDevice allocated with CreateAndConnect.

        :type aDevice: :py:class:`PvDevice`, in
        :param aDevice: Pointer to the device object to delete.
        """
        return _ebus_python.PvDevice_Free(aDevice)

    def GetType(self):
        r"""
        Returns the type of the instantiated device.

        :rtype: int
        :return: Type of device controller. See #PvDeviceType enum
        """
        return _ebus_python.PvDevice_GetType(self)

    def Connect(self, *args):
        r"""
        *Overload 1:*

        Connect to a GigE Vision or USB3 Vision device.

        The #Connect method connects to a GigE Vision device found using a #PvSystem or device finder dialog object.
        Only one device can be connected to at a time.

        :type aDeviceInfo: :py:class:`PvDeviceInfo`, in
        :param aDeviceInfo:    The GigE Vision device's network connectivity information; a #PvDeviceInfo object.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER (if NULL aDeviceInfo, or bad parameter passed)
                - #PvResult::Code::NOT_CONNECTED (if device was found, initially connected but disconnect during the connection process)
                - #PvResult::Code::NETWORK_ERROR (if sending packets failed, GEV)
                - #PvResult::Code::TIMEOUT (if socket binds and sends but times out on receive, GEV)
                - #PvResult::Code::THREAD_ERROR (if heartbeat thread will not start)
                - #PvResult::Code::GENERIC_ERROR (if an unexpected exception was thrown or if socket cannot bind or connect[GEV] or usb driver is busy [U3V])
                - #PvResult::Code::GENICAM_XML_ERROR (if creating device genicam node map failed with xml error)
                - #PvResult::Code::NOT_FOUND (if the device specified is not found)
                - #PvResult::Code::NOT_SUPPORTED (if no message channels are supported)
                - #PvResult::Code::CANT_READ_MANIFEST (if manifest table could not be read. This can sometimes happen if the U3V device is not powered properly)

        |

        *Overload 2:*

        Connect to a GigE Vision or USB3 Vision device.

        If you know the GigE Vision device's IP address, MAC address or DeviceUserID, you can use this method to connect to it.

        If you know the USB3 Vision device's GUID or DeviceUserID, you can use this method to connect it.

            - If aInfo contains an IP address, the connection attempt connecting a GigE Vision device is direct.
            - If aInfo contains a MAC address:
                - An internal #PvSystem is used to find all reachable GigE Vision devices
                - Found devices are browsed, looking for a match on the MAC address
                - If the device is found, connection is attempted.
            - If aInfo contains a USB3 Vision GUID:
                - All USB3 Vision devices are enumerated
                - Found devices are browsed, looking for a match on the GUID
                - If the device is found, connection is attempted.
            - If aInfo contains a device user ID:
                - All GigE Vision and USB3 Vision are enumerated
                - Found devices are browsed, looking for a match on device user ID
                - If the device is found, connection is attempted.

        :type aInfo: str, in
        :param aInfo:          Information that uniquely identifies the device. You may use one of the following:
                                          - GigE Vision device's MAC address. Use the form 00:11:22:33:44:5F.
                                          - GigE Vision device's IP Address. Use the form 192.168.1.114.
                                          - GigE Vision or USB3 Vision device's DeviceUserID.
                                          - USB3 Vision GUID.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER (if empty aInfo, or bad parameter passed)
                - #PvResult::Code::NOT_CONNECTED (if device was found, initially connected but disconnect during the connection process)
                - #PvResult::Code::NETWORK_ERROR (if sending packets failed, GEV)
                - #PvResult::Code::TIMEOUT (if socket binds and sends but times out on receive, GEV)
                - #PvResult::Code::THREAD_ERROR (if heartbeat thread will not start)
                - #PvResult::Code::GENERIC_ERROR (if an unexpected exception was thrown or if socket cannot bind or connect[GEV] or usb driver is busy [U3V])
                - #PvResult::Code::GENICAM_XML_ERROR (if creating device genicam node map failed with xml error)
                - #PvResult::Code::NOT_FOUND (if the device specified is not found)
                - #PvResult::Code::NOT_SUPPORTED (if no message channels are supported)
                - #PvResult::Code::CANT_READ_MANIFEST (if manifest table could not be read. This can sometimes happen if the U3V device is not powered properly)
        """
        return _ebus_python.PvDevice_Connect(self, *args)

    def Disconnect(self):
        r"""
        Disconnect the #PvDevice object from the GigE Vision or USB3 Vision device to which it is currently connected.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK

        See also: Connect
        """
        return _ebus_python.PvDevice_Disconnect(self)

    def StreamEnable(self, aChannel=0):
        r"""
        Enables streaming on the device.

        For GigE Vision devices, this takes care of setting the TLParamsLocked so that changes
        to streaming related parameters are prevent in the GenICam interface of the device.

        For USB3 Vision devices, this takes care of the TLParamsLocked, configures the driver
        for streaming and sets the streaming enable bit on the device.

        After calling StreamEnable, the user must still execute the AcquisitionStart GenICam command
        of the device to instruct the device to begin acquisition.

        :type aChannel: int, in, optional
        :param aChannel: The channel on which to enable streaming.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_CONNECTED
                - #PvResult::Code::GENERIC_ERROR      -if GenApi throws exception setting TLParam (GEV) or read memory faild (U3V)
                - #PvResult::Code::INVALID_PARAMETER  -if command size is not correct (U3V)
        """
        return _ebus_python.PvDevice_StreamEnable(self, aChannel)

    def StreamDisable(self, aChannel=0):
        r"""
        Disables streaming on the device.

        For GigE Vision devices, this takes care of resetting the TLParamsLocked so that changes
        to streaming related parameters are possible again.

        For USB3 Vision devices, this takes care of the TLParamsLocked and sets the streaming
        enable bit on the device.

        StreamDisable should be called after the AcquisitionStop GenICam command has been executed
        and all images have been received.

        :type aChannel: int, in, optional
        :param aChannel: The channel on which to enable streaming.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_CONNECTED
                - #PvResult::Code::GENERIC_ERROR      -if GenApi throws exception setting TLParam (GEV) or read memory faild (U3V)
                - #PvResult::Code::INVALID_PARAMETER  -if command size is not correct (U3V)
        """
        return _ebus_python.PvDevice_StreamDisable(self, aChannel)

    def IsConnected(self):
        r"""
        Test if this #PvDevice is currently connected to a GigE Vision or USB3 Vision device.

        :rtype: boolean
        :return: True if this #PvDevice is currently connected to a GigE Vision or USB3 Vision device otherwise, false.
        """
        return _ebus_python.PvDevice_IsConnected(self)

    def IsPleoraPowered(self):
        r"""
        Test if this #PvDevice is currently connected to a Pleora powered GigE Vision or USB3 Vision device.

        :rtype: boolean
        :return: True if this #PvDevice is currently connected to a Pleora powered GigE Vision or USB3 Vision device, false otherwise.
        """
        return _ebus_python.PvDevice_IsPleoraPowered(self)

    def DumpGenICamXML(self, aFilename):
        r"""
        Save the GigE Vision or USB3 Visio device's GenICam XML file to disk.

        If the XML is stored in a zip file on the device, the zip file containing the XML
        is saved on the disk.

        :type aFilename: str
        :param aFilename:  The file's name.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_CONNECTED
                - #PvResult::Code::NOT_SUPPORTED
                - #PvResult::Code::GENERIC_ERROR
        """
        return _ebus_python.PvDevice_DumpGenICamXML(self, aFilename)

    def GetDefaultGenICamXMLFilename(self):
        r"""
        GetDefaultGenICamXMLFilename() -> PvResult, str
        Returns a good default filename to use with DumpGenICamXML.

        The filename is built from the URL that was used in order to locate
        the GenICam XML file of the device.

        :rtype:  Tuple(:py:class:`PvResult`, string)
        :return:  
            Tuple composed of (result, filename)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_NOT_CONNECTED`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR`
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER`
             - filename: 
                - A default filename built from the device XML location URL.

        """
        return _ebus_python.PvDevice_GetDefaultGenICamXMLFilename(self)

    def GetParameters(self):
        r"""
        Get the parameters used to control the GigE Vision or USB3 Vision device to which you are connected.

        Each device provides its own GenICam XML file with parameters describing its behaviour referred to as features.
        The PvGenParameterArray object returned by this method provides an interface to these features.

        :rtype: :py:class:`PvGenParameterArray`
        :return: The parameters used to control the GigE Vision device to which you are connected
        """
        return _ebus_python.PvDevice_GetParameters(self)

    def GetCommunicationParameters(self):
        r"""
        Get the parameters used to define how PvDevice connects to and communicates with the device.

        For a listing of all the available parameters, refer to  GEV Device Communication Parameters ("devicecommunicationGEV.html")
                                                             or  U3V Device Communication Parameters  ("devicecommunicationU3V.html")

        :rtype: :py:class:`PvGenParameterArray`
        :return: The parameters used to define how PvDevice connects to and communicates with the device
        """
        return _ebus_python.PvDevice_GetCommunicationParameters(self)

    def ReadMemory(self, aAddress, aDestination):
        r"""
        ReadMemory( aAddress, aByteCount ) -> PvResult, ndarray
        Reads bytes starting at a specific register address on the GigE Vision or USB3 Vision device.

        See warnings about accessing the register map directly in #WriteMemory.

        :type aAddress: int, in
        :param aAddress:    Start address of the read memory operation (mod 4).
        :type aByteCount: int, in
        :param aByteCount:    Bytes to read from the device (mod 4, non 0). 

        :rtype:  Tuple(:py:class:`PvResult`, ndarray)
        :return:  
            Tuple composed of (result, abuffer)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_NOT_CONNECTED`
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER`
                - :py:const:`~PvResultCode.PV_TIMEOUT`
                - :py:const:`~PvResultCode.GENERIC_ERROR`
                - :py:const:`~PvResultCode.NETWORK_ERROR`
             - abuffer: 
                - A 1-dimensional python numpy array with dtype np.uint8 describing the data read from the device.

        """
        return _ebus_python.PvDevice_ReadMemory(self, aAddress, aDestination)

    def WriteMemory(self, aAddress, aSource):
        r"""
        WriteMemory( aAddress, aByteCount ) -> PvResult
        Returns a unique string identifier for the device.

        :type aAddress: int, in
        :param aAddress:    Start address of the read memory operation (mod 4).
        :type aSource: ndarray, in
        :param aSource:    A 1-dimensional python numpy array with dtype np.uint8 describing the data to write to the device. 

        :rtype:  :py:class:`PvResult`
        :return:  
             - PvResult representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_NOT_CONNECTED`
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER`
                - :py:const:`~PvResultCode.PV_TIMEOUT`
                - :py:const:`~PvResultCode.GENERIC_ERROR`
                - :py:const:`~PvResultCode.NETWORK_ERROR`

        """
        return _ebus_python.PvDevice_WriteMemory(self, aAddress, aSource)

    def WaitForMessagingChannelIdle(self, aTimeout):
        r"""
        Waits for the messaging channel to become idle.

        This method returns once the host-side messaging channel in-queue is empty
        or aTimeout (ms) has elapsed.

        :type aTimeout: int, in
        :param aTimeout: Maximum time to wait, in ms.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_CONNECTED
                - #PvResult::Code::TIMEOUT
        """
        return _ebus_python.PvDevice_WaitForMessagingChannelIdle(self, aTimeout)

    def RegisterEventSink(self, aEventSink):
        r"""
        Register an event sink used for callbacks.

        :type aEventSink: :py:class:`PvDeviceEventSink`, in
        :param aEventSink:  A pointer to the event sink.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
                - #PvResult::Code::GENERIC_ERROR      - if event already registered
        """
        return _ebus_python.PvDevice_RegisterEventSink(self, aEventSink)

    def UnregisterEventSink(self, aEventSink):
        r"""
        Unregister an event sink

        :type aEventSink: :py:class:`PvDeviceEventSink`, in
        :param aEventSink:  A pointer to the event sink.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
                - #PvResult::Code::NOT_FOUND
        """
        return _ebus_python.PvDevice_UnregisterEventSink(self, aEventSink)

    def GetHeartbeatThreadPriority(self):
        r"""
        Get the priority of the heartbeat thread

        See #SetHeartbeatThreadPriority for details about the meaning of the values returned

        :rtype: int
        :return: The priority of the thread
        """
        return _ebus_python.PvDevice_GetHeartbeatThreadPriority(self)

    def SetHeartbeatThreadPriority(self, aPriority):
        r"""
        Set the priority of the heartbeat thread

        The heartbeat thread priority is critical to most applications.
        This thread must never starve against any other system thread to the risk of losing the device connection.

        This thread takes all messages queued for deferred processing by the interrupt link thread and
        fires all GenApi and PvDeviceEventSink callback. All callbacks are fired/run in the context of this thread.

        See #GetHeartbeatThreadPriority

        :type aPriority: int, in
        :param aPriority:   See #PvPipeline::SetBufferHandlingThreadPriority for description of the supported values

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
                - #PvResult::Code::THREAD_ERROR
        """
        return _ebus_python.PvDevice_SetHeartbeatThreadPriority(self, aPriority)

    def GetInterruptLinkThreadPriority(self):
        r"""
        Get the priority of the interrupt link thread

        See #SetInterruptLinkThreadPriority for details about the meaning of the values returned

        :rtype: int
        :return: The priority of the thread
        """
        return _ebus_python.PvDevice_GetInterruptLinkThreadPriority(self)

    def SetInterruptLinkThreadPriority(self, aPriority):
        r"""
        Set the priority of the interrupt link thread

        Interrupt link thread receives messaging channel packets from the device, sends acknowledge
        back and queues the message in the interrupt queue. Process and callbacks are not done from this thread.

        This thread takes all messages queued for deferred processing by the interrupt link thread and
        fires all GenApi and PvDeviceEventSink callback. All callbacks are fired/run in the context of this thread.

        See #GetInterruptLinkThreadPriority

        :type aPriority: int, in
        :param aPriority:   See #PvPipeline::SetBufferHandlingThreadPriority for description of the supported values

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
                - #PvResult::Code::THREAD_ERROR
        """
        return _ebus_python.PvDevice_SetInterruptLinkThreadPriority(self, aPriority)

    def GetInterruptQueueThreadPriority(self):
        r"""
        Get the priority of the interrupt queue thread

        See #SetInterruptQueueThreadPriority for details about the meaning of the values returned

        :rtype: int
        :return: The priority of the thread
        """
        return _ebus_python.PvDevice_GetInterruptQueueThreadPriority(self)

    def SetInterruptQueueThreadPriority(self, aPriority):
        r"""
        Set the priority of the interrupt queue thread

        This thread is simply used to fire/invoke the OnLinkDisconnected and OnLinkReconnected PvDeviceEventSink events.

        This thread takes all messages queued for deferred processing by the interrupt link thread and
        fires all GenApi and PvDeviceEventSink callback. All callbacks are fired/run in the context of this thread.

        See #GetInterruptQueueThreadPriority

        :type aPriority: int, in
        :param aPriority:   See #PvPipeline::SetBufferHandlingThreadPriority for description of the supported values

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
                - #PvResult::Code::THREAD_ERROR
        """
        return _ebus_python.PvDevice_SetInterruptQueueThreadPriority(self, aPriority)

    def GetPayloadSize(self):
        r"""
        Returns the payload size the device is currently configured to stream with.

        This method attempts to read the GenICam PayloadSize parameter of the device. If the operation fails
        the payload size is computed from width, height and pixel format as a fall back. If even this fails,
        a value that is still valid to allocate buffers is finally returned.

        :rtype: int
        :return: The recommended payload size. 0 can only be returned if the device is not connected.
        """
        return _ebus_python.PvDevice_GetPayloadSize(self)

    def GetUniqueID(self):
        r"""
        GetUniqueID() -> PvResult, str
        Returns a unique string identifier for the device.

        :rtype:  Tuple(:py:class:`PvResult`, string)
        :return:  
            Tuple composed of (result, uniqueID)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_NOT_CONNECTED`
             - uniqueID: 
                - A unique str indentifier for the device.

        """
        return _ebus_python.PvDevice_GetUniqueID(self)

# Register PvDevice in _ebus_python:
_ebus_python.PvDevice_swigregister(PvDevice)
class PvDeviceGEV(PvDevice):
    r"""
    Connect, configure and control a GigE Vision device

    **To connect and configure a GigE Vision device to begin transmitting data:**
        - Select the GigE Vision device to which you want to connect. See #PvSystem, #PvInterface, #PvDeviceInfo.
        - Connect to a GigE Vision device. Use #Connect.
        - Get the GigE Vision device's GenICam interface. Use #GetParameters.
        - Configure the device through the GenICam interface. See #PvGenParameterArray.
        - Configure the receiver and take note of its IP address and port.
        - Configure your #PvDevice's streaming destination using #PvDeviceGEV::SetStreamDestination.
        - Lock the interface for streaming. Set **TLParamsLocked** feature of the GigE Vision device's GenICam interface to 1.
        - Configure the GigE Vision device to send images. Use **AcquisitionStart** feature of the GigE Vision device's GenICam interface.
        - Release the interface for streaming. Set **TLParamsLocked** feature of the GigE Vision device's GenICam interface to 0.
        - Configure the GigE Vision device to stop sending images. Use **AcquisitionStop** feature of the GigE Vision device's GenICam interface.

    For a complete example that illustrates the steps above, refer to the following samples:
        - MulticastMaster - Configure a GigE Vision device to transmit
        - PvPipelineSample - Configure a GigE Vision device to transmit and receive the data it transmits in the same application

    ## Recovery

    The SDK can let you automatically recover from problems such as accidental disconnects,
    power interrupts, and so on. To learn more, see #PvDeviceEventSink.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" Constructor."""
        _ebus_python.PvDeviceGEV_swiginit(self, _ebus_python.new_PvDeviceGEV())
    __swig_destroy__ = _ebus_python.delete_PvDeviceGEV

    def Connect(self, *args):
        r"""
        *Overload 1:*

        Connect to a GigE Vision device.

        The #Connect method connects to a GigE Vision device found using a #PvSystem or device finder dialog object.
        Only one device can be connected to at a time.

        :type aDeviceInfo: :py:class:`PvDeviceInfo`, in
        :param aDeviceInfo:    The GigE Vision device's network connectivity information; a #PvDeviceInfo object.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
                - #PvResult::Code::NO_LICENSE
                - #PvResult::Code::GENERIC_ERROR
                - #PvResult::Code::GENICAM_XML_ERROR

        |

        *Overload 2:*

        Connect to a GigE Vision device (found with #PvSystem, #PvInterface, #PvDeviceInfo).

        The #Connect method connects to a GigE Vision device found using a #PvSystem or device finder dialog object.
        Only one device can be connected to at a time.

        :type aDeviceInfo: :py:class:`PvDeviceInfo`, in
        :param aDeviceInfo:    The GigE Vision device's network connectivity information; a #PvDeviceInfo object.
        :type aAccessType: int, in
        :param aAccessType:    The GigE Vision device's availability for connections by multiple
                                       controllers. See #PvAccessType.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
                - #PvResult::Code::NO_LICENSE
                - #PvResult::Code::GENERIC_ERROR
                - #PvResult::Code::GENICAM_XML_ERROR

        |

        *Overload 3:*

        Connect to a GigE Vision device with the default access control mode.

        If you know the GigE Vision device's IP address, MAC address or DeviceUserID, you can use this method to connect to it.

            - If aInfo contains an IP address, the connection attempt is direct.
            - If aInfo contains a MAC address or DeviceUserID:
                - An internal #PvSystem is used to find all reachable GigE Vision devices
                - Found devices are browsed, looking for a match on either MAC address or DeviceUserID
                - If the device is found, connection is attempted.

        :type aInfo: str, in
        :param aInfo:          Information that uniquely identifies the GigE Vision device. You may use one of the following:
                                          - GigE Vision device's MAC address. Use the form 00:11:22:33:44:5F.
                                          - GigE Vision device's IP Address. Use the form 192.168.1.114.
                                          - GigE Vision device's DeviceUserID.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
                - #PvResult::Code::NO_LICENSE
                - #PvResult::Code::GENERIC_ERROR
                - #PvResult::Code::GENICAM_XML_ERROR

        |

        *Overload 4:*

        Connect to a GigE Vision device.

        If you know the GigE Vision device's IP address, MAC address or DeviceUserID, you can use this method to connect to it.

            - If aInfo contains an IP address, the connection attempt is direct.
            - If aInfo contains a MAC address or DeviceUserID:
                - An internal #PvSystem is used to find all reachable GigE Vision devices
                - Found devices are browsed, looking for a match on either MAC address or DeviceUserID
                - If the device is found, connection is attempted.

        :type aInfo: str, in
        :param aInfo:          Information that uniquely identifies the GigE Vision device. You may use one of the following:
                                          - GigE Vision device's MAC address. Use the form 00:11:22:33:44:5F.
                                          - GigE Vision device's IP Address. Use the form 192.168.1.114.
                                          - GigE Vision device's DeviceUserID.
        :type aAccessType: int, in
        :param aAccessType:    The access control privilege to set at the time of connection. See #PvAccessType.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
                - #PvResult::Code::NO_LICENSE
                - #PvResult::Code::GENERIC_ERROR
                - #PvResult::Code::GENICAM_XML_ERROR
        """
        return _ebus_python.PvDeviceGEV_Connect(self, *args)

    def SetStreamDestination(self, aIPAddress, aDataPort, aChannel=0):
        r"""
        Set the UDP/IP destination to which the GigE Vision device transmits data.

        The destination constists of an IP address (unicast or multicast) and a port number.

        :type aIPAddress: str, in
        :param aIPAddress:   The receiving PC's IP address (GenICam feature name: **GevSCDA**) or a multicast IP address.
        :type aDataPort: int, in
        :param aDataPort:    The receiving PC's data port (feature name: **GevSCPHostPort**) or the multicast port.
        :type aChannel: int, in, optional
        :param aChannel:     The GigE Vision stream channel; the channel over which the GigE Vision device transmits images.
                                     Use 0 for device having supporting a single streaming channel.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_CONNECTED
                - #PvResult::Code::TIMEOUT
                - #PvResult::Code::GENERIC_ERROR
        """
        return _ebus_python.PvDeviceGEV_SetStreamDestination(self, aIPAddress, aDataPort, aChannel)

    def ResetStreamDestination(self, aChannel=0):
        r"""
        Resets the UDP/IP streaming destination of the GigE Vision device.

        This method is equivalent to calling #SetStreamDestination with values ("0.0.0.0", 0, *aChannel*).

        :type aChannel: int, in, optional
        :param aChannel:  See the *aChannel* parameter for the #SetStreamDestination method.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_CONNECTED
                - #PvResult::Code::TIMEOUT
                - #PvResult::Code::GENERIC_ERROR
        """
        return _ebus_python.PvDeviceGEV_ResetStreamDestination(self, aChannel)

    def SetPacketSize(self, aPacketSize, aChannel=0):
        r"""
        Sets the packet size for a streaming channel.

        Applies a specific packet size to a streaming channel. Unlike the NegotiatePacketSize method,
        it does not attempt to find the best packet size, it just uses the one provided as a parameter.

        :type aPacketSize: int, in
        :param aPacketSize:  The packet size to use for aChannel.
        :type aChannel: int, in, optional
        :param aChannel:     The streaming channel. Use 0 for most GigE Vision devices only supporting a single streaming channel.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::NOT_CONNECTED
                - #PvResult::Code::TIMEOUT
                - #PvResult::Code::GENERIC_ERROR
                - #PvResult::Code::NOT_FOUND
        """
        return _ebus_python.PvDeviceGEV_SetPacketSize(self, aPacketSize, aChannel)

    def NegotiatePacketSize(self, aChannel=0, aDefaultPacketSize=0):
        r"""
        Automatically finds and sets the optimal packet size.

        The #NegotiatePacketSize method tests the network connection for the largest as possible packet size
        that the network can support between the GigE Vision transmitter and the controlling PC.

        Calling this method resets the streaming destination for aChannel. You should always call this
        method AFTER connecting, BEFORE setting the GigE Vision streaming destination using SetStreamDestination.

        The highest possible packet size from { MTU (if below 9000), 9000, 8000, 4000, 2000, 1500, 1000, 600 } is used. These values are
        used as raw seeds and are adjusted by removing 24 bytes for the Ethernet layer and then rounded down to meet
        the increment requirement imposed by the GevSCPSPacketSize parameter.

        :type aChannel: int, in, optional
        :param aChannel:            The streaming channel. Use 0 for most GigE Vision devices only supporting a single streaming channel.
        :type aDefaultPacketSize: int, in, optional
        :param aDefaultPacketSize:   The packet size to use, in bytes, should the negotiation fail.
                                             Use 1476 for a safe packet size; 0 to continue using the GigE Vision device's original setting in case of failure.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::NOT_CONNECTED
                - #PvResult::Code::TIMEOUT
                - #PvResult::Code::GENERIC_ERROR
                - #PvResult::Code::NOT_FOUND
        """
        return _ebus_python.PvDeviceGEV_NegotiatePacketSize(self, aChannel, aDefaultPacketSize)

    def ReadRegister(self, aAddress):
        r"""
        ReadRegister() -> PvResult, int
        Read an inteter value from a specific register address on the GigE Vision device.

        Operations are always performed as Big Endian and on Intel platforms are corrected to/from Little Endian.

        :rtype:  Tuple(:py:class:`PvResult`, int)
        :return:  
            Tuple composed of (result, value)
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_NOT_CONNECTED`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR`
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER`
                - :py:const:`~PvResultCode.PV_TIMEOUT`
                - :py:const:`~PvResultCode.PV_NETWORK_ERROR`
             - value: 
                - An inteter value from a specific register address.

        """
        return _ebus_python.PvDeviceGEV_ReadRegister(self, aAddress)

    def WriteRegister(self, aAddress, aValue, aAcknowledge=True):
        r"""
        Write a 32-bit value to a specific register address on the GigE Vision device.

        See warnings about accessing the register map directly in #WriteMemory.

        aValue is provided in the platform's expected Endianess. GigE Vision single register
        operations are always performed as Big Endian and on Intel platforms are corrected to/from Little Endian.

        :type aAddress: int, in
        :param aAddress:     The GigE Vision device's register address (mod 4).
        :type aValue: int, in
        :param aValue:       The value to be written to the register.
        :type aAcknowledge: boolean, in, optional
        :param aAcknowledge: When sending the command, sets the acknowledge requested bit and waits for that acknowledge.
                                     If set to false, the acknowledge is not requested and the method returns as soon as the command has been
                                     pushed in the UDP socket. If not specified true is assumed.

        :rtype: :py:class:`PvResult`
        :return: See #WriteMemory.
        """
        return _ebus_python.PvDeviceGEV_WriteRegister(self, aAddress, aValue, aAcknowledge)

    def GetClass(self):
        r"""
        Returns the GigE Vision device class of the connected device.

        If no device is connected, PvDeviceClassTransmitter is returned.

        :rtype: int
        :return: Device class of the device was connected with. See #PvDeviceClass enum
        """
        return _ebus_python.PvDeviceGEV_GetClass(self)

    def GetIPAddress(self):
        r"""
        Returns the IP address of the connected device.

        If no device is connected, an empty string is returned.

        :rtype: str
        :return: IP address of the device.
        """
        return _ebus_python.PvDeviceGEV_GetIPAddress(self)

    def GetMACAddress(self):
        r"""
        Returns the MAC address of the connected device.

        If no device is connnected, an emptyu string is returned.

        :rtype: str
        :return: MAC address of the device.
        """
        return _ebus_python.PvDeviceGEV_GetMACAddress(self)

    @staticmethod
    def GetAccessType(*args):
        r"""
        *Overload 1:*

        Returns the access type of the connected device.

        If no device is connected, PvAccessUnknown is returned.

        :rtype: int
        :return: Access type of the device was connected with. See #PvAccessType enum

        |

        *Overload 2:*

        Returns the current access type of a device identified by its IP address.

        This function is static. It does not work on an specific object but will return the access type
        of a GigE Vision device identified by its IP address.

        :type aDeviceIPAddress: str, in
        :param aDeviceIPAddress: The IP address of the GigE Vision device.
        :type aAccessType: int, out
        :param aAccessType: The access type of the GigE Vision device on success. See #PvAccessType enum. PvAccessUnknown on failure.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
                - #PvResult::Code::TIMEOUT
                - #PvResult::Code::GENERIC_ERROR
        """
        return _ebus_python.PvDeviceGEV_GetAccessType(*args)

    @staticmethod
    def SetIPConfiguration(*args):
        r"""
        Sets the GigE Vision device's IP address.

        This static method lets you configure the GigE Vision device's IP address. You cannot
        change the IP address when a PvDevice is connected.

        Can be used to assign a valid IP configuration to a device before connecting a #PvDevice to a
        GigE Vision device (using the #Connect method). The GigE Vision device to be configured is identified using its MAC address.

        :type aMACAddress: str, in
        :param aMACAddress:    The GigE Vision device's MAC address.
        :type aIP: str, in
        :param aIP:            The GigE Vision device's new IP address.
        :type aSubnetMask: str, in, optional
        :param aSubnetMask:    The GigE Vision device's new subnet mask.
        :type aGateway: str, in, optional
        :param aGateway:       The GigE Vision device's new gateway.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
        """
        return _ebus_python.PvDeviceGEV_SetIPConfiguration(*args)

# Register PvDeviceGEV in _ebus_python:
_ebus_python.PvDeviceGEV_swigregister(PvDeviceGEV)
class PvDeviceU3V(PvDevice):
    r""" Connect, configure and control a USB3 Vision device"""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" Constructor."""
        _ebus_python.PvDeviceU3V_swiginit(self, _ebus_python.new_PvDeviceU3V())
    __swig_destroy__ = _ebus_python.delete_PvDeviceU3V

    def Connect(self, *args):
        r"""
        *Overload 1:*

        Connect to a USB3 Vision device.

        The #Connect method connects to a USB3 Vision device found using a #PvSystem or device finder dialog object.
        Only one device can be connected to at a time.

        :param aDeviceInfo: The USB3 Vision device's connectivity information; a #PvDeviceInfo object.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
            	- #PvResult::Code::OK
            	- #PvResult::Code::INVALID_PARAMETER
            	- #PvResult::Code::NO_LICENSE
            	- #PvResult::Code::GENERIC_ERROR
            	- #PvResult::Code::GENICAM_XML_ERROR

        |

        *Overload 2:*

        Connect to a USB3 Vision device.

        The #Connect method connects to a USB3 Vision device found using a #PvSystem or device finder dialog object.
        Only one device can be connected to at a time.

        :param aInfo: The USB3 Vision device's 12 hex digit GUID.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
            	- #PvResult::Code::OK
            	- #PvResult::Code::INVALID_PARAMETER
            	- #PvResult::Code::NO_LICENSE
            	- #PvResult::Code::GENERIC_ERROR
            	- #PvResult::Code::GENICAM_XML_ERROR
        """
        return _ebus_python.PvDeviceU3V_Connect(self, *args)

    def GetGUID(self):
        r"""
        Returns the GUID of the connected device.

        If no device is connected, an empty string is returned.

        :rtype: str
        :return: GUID of the device.
        """
        return _ebus_python.PvDeviceU3V_GetGUID(self)

# Register PvDeviceU3V in _ebus_python:
_ebus_python.PvDeviceU3V_swigregister(PvDeviceU3V)
class PvDevicePleoraProtocol(object):
    r""" Class simply used to configure the IP address of a Pleora Protocol device."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    @staticmethod
    def SetIPConfiguration(*args):
        r"""
        Sets the Pleora Protocol device's IP address.

        This static method lets you configure the Pleora Protocol device's IP address.

        :type aMACAddress: str, in
        :param aMACAddress:    The Pleora Protocol device's MAC address.
        :type aIP: str, in
        :param aIP:            The Pleora Protocol device's new IP address.
        :type aSubnetMask: str, in, optional
        :param aSubnetMask:    The Pleora Protocol device's new subnet mask.
        :type aGateway: str, in, optional
        :param aGateway:       The Pleora Protocol device's new gateway.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
        """
        return _ebus_python.PvDevicePleoraProtocol_SetIPConfiguration(*args)
    __swig_destroy__ = _ebus_python.delete_PvDevicePleoraProtocol

# Register PvDevicePleoraProtocol in _ebus_python:
_ebus_python.PvDevicePleoraProtocol_swigregister(PvDevicePleoraProtocol)
class PvDeviceAdapter(object):
    r"""
    IPvDeviceAdapter default implementation for the eBUS SDK.

    The IPvDeviceAdapter interface can be implemented for any SDK that can control
    GigE Vision and/or USB3 Vision devices in order to use PvDeviceSerialPort.

    PvDeviceAdapter provides a default implementation of the IPvDeviceAdapter that
    can be used with the eBUS SDK.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, aDevice):
        r"""
        Constructor.

        :type aDevice: :py:class:`PvDevice`, in
        :param aDevice: A device.
        """
        _ebus_python.PvDeviceAdapter_swiginit(self, _ebus_python.new_PvDeviceAdapter(aDevice))
    __swig_destroy__ = _ebus_python.delete_PvDeviceAdapter

    def IsGenIntegerInNodeMap(self, aParameterName):
        r"""
        See IPvDeviceAdapter for description.

        :type aParameterName: str, in
        :param aParameterName: Name of the parameter to test for.

        :rtype: boolean
        :return: True if the parameter is present, false if not.
        """
        return _ebus_python.PvDeviceAdapter_IsGenIntegerInNodeMap(self, aParameterName)

    def IsGenEnumInNodeMap(self, aParameterName):
        r"""
        See IPvDeviceAdapter for description.

        :type aParameterName: str, in
        :param aParameterName: Name of the parameter to test for.

        :rtype: boolean
        :return: True if the parameter is present, false if not.
        """
        return _ebus_python.PvDeviceAdapter_IsGenEnumInNodeMap(self, aParameterName)

    def IsGenBooleanInNodeMap(self, aParameterName):
        r"""
        See IPvDeviceAdapter for description.

        :type aParameterName: str, in
        :param aParameterName: Name of the parameter to test for.

        :rtype: boolean
        :return: True if the parameter is present, false if not.
        """
        return _ebus_python.PvDeviceAdapter_IsGenBooleanInNodeMap(self, aParameterName)

    def IsGenRegisterInNodeMap(self, aParameterName):
        r"""
        See IPvDeviceAdapter for description.

        :type aParameterName: str, in
        :param aParameterName: Name of the parameter to test for.

        :rtype: boolean
        :return: True if the parameter is present, false if not.
        """
        return _ebus_python.PvDeviceAdapter_IsGenRegisterInNodeMap(self, aParameterName)

    def IsGenReadable(self, aParameterName):
        r"""
        See IPvDeviceAdapter for description.

        :type aParameterName: str, in
        :param aParameterName: Name of the parameter to test for.

        :rtype: boolean
        :return: True if the parameter is present and readable, false if either condition fails.
        """
        return _ebus_python.PvDeviceAdapter_IsGenReadable(self, aParameterName)

    def IsGenWritable(self, aParameterName):
        r"""
        See IPvDeviceAdapter for description.

        :type aParameterName: str, in
        :param aParameterName: Name of the parameter to test for.

        :rtype: boolean
        :return: True if the parameter is present and writable, false if either condition fails.
        """
        return _ebus_python.PvDeviceAdapter_IsGenWritable(self, aParameterName)

    def IsGenEnumEntryAvailable(self, aParameterName, aEnumEntry):
        r"""
        See IPvDeviceAdapter for description.

        :type aParameterName: str, in
        :param aParameterName: Name of the parameter to test for.
        :type aEnumEntry: str, in
        :param aEnumEntry: Name of the enum entry to test for.

        :rtype: boolean
        :return: True if the parameter is present and contains the specific enum entry, false if either condition fails.
        """
        return _ebus_python.PvDeviceAdapter_IsGenEnumEntryAvailable(self, aParameterName, aEnumEntry)

    def GetGenIntegerValue(self, aParameterName, aValue):
        r"""
        See IPvDeviceAdapter for description.

        :type aParameterName: str, in
        :param aParameterName: Name of the parameter.
        :type aValue: int, out
        :param aValue: Value of the parameter.

        :rtype: :py:class:`PvResult`
        :return: OK on success.
        """
        return _ebus_python.PvDeviceAdapter_GetGenIntegerValue(self, aParameterName, aValue)

    def GetGenEnumEntriesAvailable(self, aParameterName, aList):
        r"""
        See IPvDeviceAdapter for description.

        :type aParameterName: str, in
        :param aParameterName: Name of the parameter.
        :type aList: PvStringList, out
        :param aList: A list containing the string representation of all available enum entries.

        :rtype: :py:class:`PvResult`
        :return: OK on success.
        """
        return _ebus_python.PvDeviceAdapter_GetGenEnumEntriesAvailable(self, aParameterName, aList)

    def GetGenEnumValue(self, aParameterName, aEnumEntry):
        r"""
        See IPvDeviceAdapter for description.

        :type aParameterName: str, in
        :param aParameterName: Name of the parameter.
        :type aEnumEntry: str, out
        :param aEnumEntry: Value of the parameter.

        :rtype: :py:class:`PvResult`
        :return: OK on success.
        """
        return _ebus_python.PvDeviceAdapter_GetGenEnumValue(self, aParameterName, aEnumEntry)

    def SetGenEnumValue(self, aParameterName, aEnumEntry):
        r"""
        See IPvDeviceAdapter for description.

        :type aParameterName: str, in
        :param aParameterName: Name of the parameter.
        :type aEnumEntry: str, in
        :param aEnumEntry: New value for the enumeration.

        :rtype: :py:class:`PvResult`
        :return: OK on success.
        """
        return _ebus_python.PvDeviceAdapter_SetGenEnumValue(self, aParameterName, aEnumEntry)

    def GetGenBooleanValue(self, aParameterName, aValue):
        r"""
        See IPvDeviceAdapter for description.

        :type aParameterName: str, in
        :param aParameterName: Name of the parameter.
        :type aValue: boolean, out
        :param aValue: Value of the parameter.

        :rtype: :py:class:`PvResult`
        :return: OK on success.
        """
        return _ebus_python.PvDeviceAdapter_GetGenBooleanValue(self, aParameterName, aValue)

    def SetGenBooleanValue(self, aParameterName, aValue):
        r"""
        See IPvDeviceAdapter for description.

        :type aParameterName: str, in
        :param aParameterName: Name of the parameter.
        :type aValue: boolean, in
        :param aValue: New value for the enumeration.

        :rtype: :py:class:`PvResult`
        :return: OK on success.
        """
        return _ebus_python.PvDeviceAdapter_SetGenBooleanValue(self, aParameterName, aValue)

    def GetGenStringValue(self, aParameterName, aValue):
        r"""
        Returns the string value of string parameter identified by its name.

        :type aParameterName: str, in
        :param aParameterName: Name of the parameter.
        :type aValue: str, out
        :param aValue: Value of the parameter.

        :rtype: :py:class:`PvResult`
        :return: OK on success.
        """
        return _ebus_python.PvDeviceAdapter_GetGenStringValue(self, aParameterName, aValue)

    def GetGenRegisterLength(self, aParameterName, aLength):
        r"""
        See IPvDeviceAdapter for description.

        :type aParameterName: str, in
        :param aParameterName: Name of the parameter.
        :type aLength: int, in
        :param aLength: Length (in bytes) of the register.

        :rtype: :py:class:`PvResult`
        :return: OK on success.
        """
        return _ebus_python.PvDeviceAdapter_GetGenRegisterLength(self, aParameterName, aLength)

    def GetGenRegisterData(self, aParameterName, aDataBuffer, aByteCount):
        r"""
        See IPvDeviceAdapter for description.

        :type aParameterName: str, in
        :param aParameterName: Name of the parameter.
        :type aDataBuffer: uint8_t, out
        :param aDataBuffer: Buffer where to copy the data.
        :type aByteCount: int, in
        :param aByteCount: How many bytes to copy to aDataBuffer.

        :rtype: :py:class:`PvResult`
        :return: OK on success.
        """
        return _ebus_python.PvDeviceAdapter_GetGenRegisterData(self, aParameterName, aDataBuffer, aByteCount)

    def SetGenRegisterData(self, aParameterName, aDataBuffer, aByteCount):
        r"""
        See IPvDeviceAdapter for description.

        :type aParameterName: str, in
        :param aParameterName: Name of the parameter.
        :type aDataBuffer: uint8_t, out
        :param aDataBuffer: Buffer to copy the data from.
        :type aByteCount: int, in
        :param aByteCount: How many bytes to copy from aDataBuffer to the register.

        :rtype: :py:class:`PvResult`
        :return: OK on success.
        """
        return _ebus_python.PvDeviceAdapter_SetGenRegisterData(self, aParameterName, aDataBuffer, aByteCount)

    def RegisterGenInvalidator(self, aParameterName):
        r"""
        See IPvDeviceAdapter for description.

        :type aParameterName: str, in
        :param aParameterName: Name of the parameter.

        :rtype: :py:class:`PvResult`
        :return: OK on success.
        """
        return _ebus_python.PvDeviceAdapter_RegisterGenInvalidator(self, aParameterName)

    def UnregisterGenInvalidator(self, aParameterName):
        r"""
        See IPvDeviceAdapter for description.

        :type aParameterName: str, in
        :param aParameterName: Name of the parameter.

        :rtype: :py:class:`PvResult`
        :return: OK on success.
        """
        return _ebus_python.PvDeviceAdapter_UnregisterGenInvalidator(self, aParameterName)

    def WriteRegister(self, aAddress, aValue):
        r"""
        See IPvDeviceAdapter for description.

        :type aAddress: int, in
        :param aAddress: Address of the register.
        :type aValue: int, in
        :param aValue: Value to write to the register.

        :rtype: :py:class:`PvResult`
        :return: OK on success.
        """
        return _ebus_python.PvDeviceAdapter_WriteRegister(self, aAddress, aValue)

    def ReadRegister(self, aAddress):
        r"""
        See IPvDeviceAdapter for description.

        :type aAddress: int, in
        :param aAddress: Address of the register.
        :type aValue: int, out
        :param aValue: Value read from the register.

        :rtype: :py:class:`PvResult`
        :return: OK on success.
        """
        return _ebus_python.PvDeviceAdapter_ReadRegister(self, aAddress)

    def WriteMemory(self, aBuffer, aAddress, aLength):
        r"""
        See IPvDeviceAdapter for description.

        :type aBuffer: uint8_t, in
        :param aBuffer: Pointer to the data to write.
        :type aAddress: int, in
        :param aAddress: Address where to write the data.
        :type aLength: int, in
        :param aLength: Length of the data to write, in bytes.

        :rtype: :py:class:`PvResult`
        :return: OK on success.
        """
        return _ebus_python.PvDeviceAdapter_WriteMemory(self, aBuffer, aAddress, aLength)

    def ReadMemory(self, aBuffer, aAddress, aLength):
        r"""
        See IPvDeviceAdapter for description.

        :type aBuffer: uint8_t, in
        :param aBuffer: Pointer of the buffer where the data will be written.
        :type aAddress: int, in
        :param aAddress: Address where to read the daa.
        :type aLength: int, in
        :param aLength: Length of the data to read, in bytes.

        :rtype: :py:class:`PvResult`
        :return: OK on success.
        """
        return _ebus_python.PvDeviceAdapter_ReadMemory(self, aBuffer, aAddress, aLength)

    def WaitForMessagingChannelIdle(self, aTimeout):
        r"""
        See IPvDeviceAdapter for description.

        :type aTimeout: int, in
        :param aTimeout: A timeout.

        :rtype: :py:class:`PvResult`
        :return: OK if the messaging channel is idle. TIMEOUT if the timeout elapsed before it becomes idle.
        """
        return _ebus_python.PvDeviceAdapter_WaitForMessagingChannelIdle(self, aTimeout)

    def IsConnected(self):
        r"""
        See IPvDeviceAdapter for description.

        :rtype: boolean
        :return: True if the device is connected, false if not.
        """
        return _ebus_python.PvDeviceAdapter_IsConnected(self)

    def IsPleoraPowered(self):
        r"""
        See IPvDeviceAdapter for description.

        :rtype: boolean
        :return: True if the device runs on a Pleora design, false if not.
        """
        return _ebus_python.PvDeviceAdapter_IsPleoraPowered(self)

    def IsGigEVision(self):
        r"""
        See IPvDeviceAdapter for description.

        :rtype: boolean
        :return: True if using the GigE Vision protocol, false if not.
        """
        return _ebus_python.PvDeviceAdapter_IsGigEVision(self)

    def IsUSB3Vision(self):
        r"""
        See IPvDeviceAdapter for description.

        :rtype: boolean
        :return: True if using the USB3 Vision protocol, false if not.
        """
        return _ebus_python.PvDeviceAdapter_IsUSB3Vision(self)

    def RegisterEventSink(self, aEventSink):
        r"""
        See IPvDeviceAdapter for description.

        :type aEventSink: IPvDeviceEventSink, in
        :param aEventSink: Pointer to an object implementing the IPvDeviceEventSink interface.

        :rtype: :py:class:`PvResult`
        :return: OK on success.
        """
        return _ebus_python.PvDeviceAdapter_RegisterEventSink(self, aEventSink)

    def UnregisterEventSink(self, aEventSink):
        r"""
        See IPvDeviceAdapter for description.

        :type aEventSink: IPvDeviceEventSink, in
        :param aEventSink: Pointer to an object implementing the IPvDeviceEventSink interface.

        :rtype: :py:class:`PvResult`
        :return: OK on success.
        """
        return _ebus_python.PvDeviceAdapter_UnregisterEventSink(self, aEventSink)

    def GetUniqueID(self):
        r"""
        Returns a unique string identifier for the device.

        :type aID: str, out
        :param aID: Unique string identifier for the device.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
        """
        return _ebus_python.PvDeviceAdapter_GetUniqueID(self)

# Register PvDeviceAdapter in _ebus_python:
_ebus_python.PvDeviceAdapter_swigregister(PvDeviceAdapter)
PvStreamType = _ebus_python.PvStreamType 
PvStreamTypeUnknown = _ebus_python.PvStreamTypeUnknown
PvStreamTypeGEV = _ebus_python.PvStreamTypeGEV
PvStreamTypeU3V = _ebus_python.PvStreamTypeU3V
PvStreamTypeRTP = _ebus_python.PvStreamTypeRTP
class PvStream(object):
    r"""
    Receive data from a GigE Vision or USB3 Vision transmitter.

    This provides a means of opening a connection to the data receiver and obtaining data from it.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ebus_python.delete_PvStream

    def GetQueuedBufferCount(self):
        r"""
        Get the number of buffers (#PvBuffer objects) waiting to be filled with images by the data receiver.

        Every call to #QueueBuffer increases the count by one; every call to #RetrieveBuffer reduces the count by one.

        :rtype: int
        :return: The number of buffers (#PvBuffer objects).
        """
        return _ebus_python.PvStream_GetQueuedBufferCount(self)

    def GetQueuedBufferMaximum(self):
        r"""
        Get the maximum number of buffers (#PvBuffer objects) that can be queued at a time.

        :rtype: int
        :return: Maximum number of buffers (#PvBuffer objects).
        """
        return _ebus_python.PvStream_GetQueuedBufferMaximum(self)

    @staticmethod
    def CreateAndOpen(*args):
        r"""

        CreateAndOpen(*args) -> PvResult, PvStream
        Dynamically allocates a PvStream of the right type.

        This static method takes a string or PvDeviceInfo, creates the right type of PvStream
        (PvStreamGEV or PvStreamU3V) and opens it.

        Objects allocated with CreateAndOpen should be freed with PvStream.Free.

        *Overload 1:*

        :type aDeviceInfo: :py:class:`PvDeviceInfo`, in
        :param aDeviceInfo:    The GigE Vision device's network connectivity information; a #PvDeviceInfo object.

        :rtype:  Tuple[:py:class:`PvResult`, :py:class:`PvStream`]
        :return:
            Tuple composed of (result, pvstream):
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER`    aInfo is not correct or default buffer configurations are not correct 
                - :py:const:`~PvResultCode.PV_NOT_ENOUGH_MEMORY`    could not allocate class
                - :py:const:`~PvResultCode.PV_NOT_CONNECTED`        device not connected
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR`        unexpected drive error
                - :py:const:`~PvResultCode.PV_BAD_VERSION`          bad driver version
                - :py:const:`~PvResultCode.PV_NOT_FOUND`            usb only
                - :py:const:`~PvResultCode.PV_CANNOT_OPEN_FILE`     usb only
                - :py:const:`~PvResultCode.PV_NOT_SUPPORTED`        usb only
             - pvstream:
                - :py:class:`PvStream` object (:py:class:`PvStreamGEV`, :py:class:`PvStreamU3V` or None).

        |

        *Overload 2:*

        :type aInfo: str, in
        :param aInfo:    String identifying the device. You may use one of the following:
                            - GigE Vision devices IP Address. Use the form 192.168.1.1.
                            - USB3 Vision GUID.

        :rtype:  Tuple[:py:class:`PvResult`, :py:class:`PvStream`]
        :return:  
            Tuple composed of (result, pvstream):
             - result representing the outcome:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER`    aInfo is not correct or default buffer configurations are not correct 
                - :py:const:`~PvResultCode.PV_NOT_ENOUGH_MEMORY`    could not allocate class
                - :py:const:`~PvResultCode.PV_NOT_CONNECTED`        device not connected
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR`        unexpected drive error
                - :py:const:`~PvResultCode.PV_BAD_VERSION`          bad driver version
                - :py:const:`~PvResultCode.PV_NOT_FOUND`            usb only
                - :py:const:`~PvResultCode.PV_CANNOT_OPEN_FILE`     usb only
                - :py:const:`~PvResultCode.PV_NOT_SUPPORTED`        usb only
             - pvstream 
                - :py:class:`PvStream` object (:py:class:`PvStreamGEV`, :py:class:`PvStreamU3V` or None).

        """
        return _ebus_python.PvStream_CreateAndOpen(*args)

    @staticmethod
    def Free(aStream):
        r"""
        Frees an object allocated with CreateAndOpen.

        Even though calling delete on a PvStream created with CreateAndOpen should
        work in most cases, sometime it is necessary to call "delete" in the same context where
        "new" was called to avoid false positives on memory leaks.

        It is a good practice to use this method to free a PvStream allocated with CreateAndOpen.

        :type aStream: :py:class:`PvStream`, in
        :param aStream: Pointer to the device object to delete.
        """
        return _ebus_python.PvStream_Free(aStream)

    def Open(self, *args):
        return _ebus_python.PvStream_Open(self, *args)

    def Close(self):
        r"""
        Close the stream channel receiver.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_CONNECTED

        See also: Open
        """
        return _ebus_python.PvStream_Close(self)

    def GetType(self):
        r"""
        Returns whether the object is a GigE Vision or USB3 Vision stream receiver.

        :rtype: int
        :return: Specific object type.
        """
        return _ebus_python.PvStream_GetType(self)

    def AbortQueuedBuffers(self):
        r"""
        Abort all pending block requests

        Once you've aborted pending block requests, they still need to be de-queued. Use #RetrieveBuffer.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_CONNECTED
        """
        return _ebus_python.PvStream_AbortQueuedBuffers(self)

    def QueueBuffer(self, aBuffer):
        r"""
        Queue a buffer to receive a block.

        The #QueueBuffer method queues in a buffer (#PvBuffer object) to a stream (#PvStream object) so it
        can be filled by the data receiver.

        For each buffer you remove (using #RetrieveBuffer), you should queue another (using #QueueBuffer).
        **The maximum number of buffers that can be queued at a given time can be obtained by calling #GetQueuedBufferMaximum.**
        To reduce the risk of missing incoming data, it is recommended that several blocks remain queued and ready to go at any given time.
        Generally it is recommended that a larger number of buffers remain queued for higher frame rates.
        Larger block sizes with blocks being streamed at a lower frame rate can afford to allocate fewer buffers to optimize memory usage and reduce potential latency.

        Once the stream fills the buffer with a block, retrieve the buffer by calling #RetrieveBuffer.

        :type aBuffer: :py:class:`PvBuffer`, in
        :param aBuffer:  A pointer to the buffer to be filled.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::INVALID_PARAMETER
                - #PvResult::Code::NOT_CONNECTED
                - #PvResult::Code::NO_MORE_ENTRY
                - #PvResult::Code::NOT_ENOUGH_MEMORY
                - #PvResult::Code::PENDING if the buffer has been properly queued
                - #PvResult::Code::GENERIC_ERROR if the buffer could not be queued. See #PvResult::GetDescription for more information
        """
        return _ebus_python.PvStream_QueueBuffer(self, aBuffer)

    def RetrieveBuffer(self, *args):
        r"""
        RetrieveBuffer(aTimeout = 0xFFFFFFFF) -> PvResult, PvBuffer, PvResult
        Attempt to retrieve a queued buffer.

        To use this method, see also #QueueBuffer.

        The #RetrieveBuffer method blocks until one of the following occurs:

            - The buffer is filled with a block (image or raw data).
            - The retrieve buffer operation times out: it exceeds aTimeout. 
            - The acquisition fails (by being aborted, data receiver timeout as defined by ImageTimeout property, etc.)

        Once the method returns, you can determine the ultimate success of the image acquisition by 
        testing the operational_result. For example, #RetrieveBuffer may return a result of :py:const:`~PvResultCode.PV_OK`,
        even if the operation was aborted (by a call to #AbortQueuedBuffers or #Close). 
        In this case, operation_result would be PV_ABORTED.

        The result returned contains the RetrieveBuffer operation results and operation_result contains
        the actual result (or failure) of the data receiver on this buffer. This method can
        succeed in providing you the oldest buffer but the result of the operation may still be 
        a failure - if acquisition was aborted, incomplete, etc.

        :type aTimeout: int, in
        :param aTimeout:    The maximum time, in ms, to wait for a buffer to be returned by the data receiver.
                            | The default value is 0xFFFFFFFF milliseconds (wait forever)

        :rtype:  Tuple[:py:class:`PvResult`, :py:class:`PvBuffer`, :py:class:`PvResult`]
        :return:  
            Tuple composed of (result, pvbuffer, operational_result):
             - result includes:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_TIMEOUT`
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER`
                - :py:const:`~PvResultCode.PV_NOT_CONNECTED` -> not connected
                - :py:const:`~PvResultCode.PV_NO_MORE_ITEM`  -> no PvBuffer queued
                - :py:const:`~PvResultCode.PV_NO_MORE_ENTRY`
                - :py:const:`~PvResultCode.PV_BUSY`
             - pvbuffer
                - The acquired PvBuffer frame or None if result is not OK.
             - operational_result
                - The result of the acquisition operation. See #PvBuffer::GetOperationResult.

        """
        return _ebus_python.PvStream_RetrieveBuffer(self, *args)

    def GetChannel(self):
        r"""
        Get the stream's Channel property.

        :rtype: int
        :return: The stream's Channel property.
        """
        return _ebus_python.PvStream_GetChannel(self)

    def IsOpen(self):
        r"""
        Test if the stream is open.

        :rtype: boolean
        :return: True if the stream is opened; otherwise, false.
        """
        return _ebus_python.PvStream_IsOpen(self)

    def RegisterEventSink(self, aEventSink):
        r"""
        Register an event sink used for callbacks.

        :type aEventSink: PvStreamEventSink, in
        :param aEventSink:  A pointer to the event sink.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
                - #PvResult::Code::GENERIC_ERROR
        """
        return _ebus_python.PvStream_RegisterEventSink(self, aEventSink)

    def UnregisterEventSink(self, aEventSink):
        r"""
        Unregister an event sink

        :type aEventSink: PvStreamEventSink, in
        :param aEventSink:  A pointer to the event sink.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
                - #PvResult::Code::NOT_FOUND

        See also: #RegisterEventSink
        """
        return _ebus_python.PvStream_UnregisterEventSink(self, aEventSink)

    def GetParameters(self):
        r"""
        Get the parameters defining how data is received from a GigE Vision transmitter

        :rtype: :py:class:`PvGenParameterArray`
        :return: The parameters defining how data is received from a GigE Vision transmitter
        """
        return _ebus_python.PvStream_GetParameters(self)

# Register PvStream in _ebus_python:
_ebus_python.PvStream_swigregister(PvStream)
PvDataReceiverType = _ebus_python.PvDataReceiverType 
PvDataReceiverTypeUnknown = _ebus_python.PvDataReceiverTypeUnknown
PvDataReceiverTypeEBusDriver = _ebus_python.PvDataReceiverTypeEBusDriver
PvDataReceiverTypeUserMode = _ebus_python.PvDataReceiverTypeUserMode
PvDataReceiverTypeTCP = _ebus_python.PvDataReceiverTypeTCP
class PvStreamGEV(PvStream):
    r"""
    Receive data from a GigE Vision.

    This provides a means of opening a connection to the data receiver and obtaining data from it.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" Constructor."""
        _ebus_python.PvStreamGEV_swiginit(self, _ebus_python.new_PvStreamGEV())
    __swig_destroy__ = _ebus_python.delete_PvStreamGEV

    def Open(self, *args):
        r"""

        *Overload 1:*

        Begin receiving blocks (images or raw data) **unicasted** from a GigE Vision transmitter.

         See equivalent Open method with aInfo PvString as first parameter for more information.

        :type aDeviceInfo: :py:class:`PvDeviceInfo`, in
        :param aDeviceInfo:    Device information as retrieved from a device finder.

        :rtype: :py:class:`PvResult`
        :return: 
            Includes:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_NOT_CONNECTED`
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER`
                - :py:const:`~PvResultCode.PV_NOT_FOUND`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR`
                - :py:const:`~PvResultCode.PV_BAD_VERSION`

        |

        *Overload 2:*

        Begin receiving blocks (images or raw data) **unicasted** from a GigE Vision transmitter.

         See equivalent Open method with aInfo PvString as first parameter for more information.

        :type aDeviceInfo: :py:class:`PvDeviceInfo`, in
        :param aDeviceInfo:      Device information as retrieved from a device finder.
        :type aLocalPort: int, in
        :param aLocalPort:       The local port upon which to begin receiving incoming data. A value of 0 (default) indicates that the local port will be assigned automatically. Call #GetLocalPort afterwards to obtain the port number that was assigned by the system. Set the streaming channel destination address (SCDA) on your GigE Vision transmitter accordingly by calling #PvDeviceGEV::SetStreamDestination.
        :type aChannel: int, in, optional
        :param aChannel:         The GigE Vision transmitter's streaming channel (default 0).
        :type aLocalIPAddress: str, in, optional
        :param aLocalIPAddress:  Deprecated and ignored.
        :type aBuffersCapacity: int, in, optional
        :param aBuffersCapacity: The maximum number of buffers that can be stored simultaneously in the data receiver.

        :rtype: :py:class:`PvResult`
        :return: 
            Includes:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_NOT_CONNECTED`
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER`
                - :py:const:`~PvResultCode.PV_NOT_FOUND`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR`
                - :py:const:`~PvResultCode.PV_BAD_VERSION`

        |

        *Overload 3:*

        Begin receiving blocks (images or raw data) **multicasted** from a GigE Vision transmitter.

         See equivalent Open method with aInfo PvString as first parameter for more information.

        :type aDeviceInfo: :py:class:`PvDeviceInfo`, in
        :param aDeviceInfo:     Device information as retrieved from a device finder.
        :type aMulticastAddr: str, in
        :param aMulticastAddr:   The multicast IP address to which the receiver subscribes and the GigE Vision transmitter sends data. (Set the streaming channel destination address (SCDA) on your GigE Vision transmitter accordingly by calling #PvDeviceGEV::SetStreamDestination.)
        :type aDataPort: int, in
        :param aDataPort:        The multicast port to which the receiver subscribes and the GigE Vision transmitter sends data. (Set the streaming channel port (SCP) on your GigE Vision transmitter accordingly by calling #PvDeviceGEV::SetStreamDestination.)
        :type aChannel: int, in, optional
        :param aChannel:         The GigE Vision transmitter's streaming channel (default 0).
        :type aLocalIPAddress: str, in, optional
        :param aLocalIPAddress: Deprecated and ignored.
        :type aBuffersCapacity: int, in, optional
        :param aBuffersCapacity: The maximum number of buffers that can be stored simultaneously in the data receiver.

        :rtype: :py:class:`PvResult`
        :return:
            Includes:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_NOT_CONNECTED`
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER`
                - :py:const:`~PvResultCode.PV_NOT_FOUND`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR`
                - :py:const:`~PvResultCode.PV_BAD_VERSION`

        |

        *Overload 4:*


        Begin receiving blocks (images or raw data) **unicasted** from a GigE Vision transmitter.

        Note that this overload of Open is for receiving blocks that are unicasted from a GigE Vision transmitter to an interface on the same subnet.

        To receive multicasted data, refer to the other overload of the other (multicast) Open method.

        :type aInfo: str, in
        :param aInfo:            The GigE Vision transmitter's IP address.

        :rtype: :py:class:`PvResult`
        :return:
            Includes:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_NOT_CONNECTED`
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER`
                - :py:const:`~PvResultCode.PV_NOT_FOUND`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR`
                - :py:const:`~PvResultCode.PV_BAD_VERSION`

        |

        *Overload 5:*

        Begin receiving blocks (images or raw data) **unicasted** from a GigE Vision transmitter.

        Note that this overload of Open is for receiving blocks that are unicasted from a GigE Vision transmitter to an interface on the same subnet.

        To receive multicasted data, refer to the other overload of the other (multicast) Open method.

        :type aInfo: str, in
        :param aInfo:            The GigE Vision transmitter's IP address.
        :type aLocalPort: int, in
        :param aLocalPort:       The local port upon which to begin receiving incoming data. A value of 0 (default) indicates that the local port will be assigned automatically. Call #GetLocalPort afterwards to obtain the port number that was assigned by the system. Set the streaming channel destination address (SCDA) on your GigE Vision transmitter accordingly by calling #PvDeviceGEV::SetStreamDestination.
        :type aChannel: int, in, optional
        :param aChannel:         The GigE Vision transmitter's streaming channel (default 0).
        :type aLocalIPAddress: str, in, optional
        :param aLocalIPAddress:  The local IP address upon which to begin receiving incoming data. An empty string (default) indicates that the local IP address will be assigned automatically. Call #GetLocalIPAddress afterwards to obtain the local IP address that was assigned by the system. Set the streaming channel port number (SCP) on your GigE Vision transmitter accordingly by calling #PvDeviceGEV::SetStreamDestination.
        :type aBuffersCapacity: int, in, optional
        :param aBuffersCapacity: The maximum number of buffers that can be stored simultaneously in the data receiver.

        :rtype: :py:class:`PvResult`
        :return:
            Includes:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_NOT_CONNECTED`
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER`
                - :py:const:`~PvResultCode.PV_NOT_FOUND`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR`
                - :py:const:`~PvResultCode.PV_BAD_VERSION`

        |

        *Overload 6:*

        Begin receiving blocks (images or raw data) **multicasted** from a GigE Vision transmitter.

        Note that this overload of Open is for receiving blocks that are multicasted from a GigE Vision transmitter to a given multicast group.

        To receive unicasted data, refer to the other overload of the Open method.

        Multicasting is the delivery of data to a group of receivers simultaneously in a single transmission.

        The following example illustrates how to multicast data from one transmitter to a given set of receivers:

            - Connect receivers and transmitter to an IGMP compliant switch.
            - The GigE Vision transmitter begins transmitting to a multicast group (i.e. 239.192.1.1:1042).
            - The GigE Vision transmitter has a control channel listening for device discovery requests and packet resend requests on a given IP address (i.e. 169.254.1.1).
            - Receiver applications discover the device and subscribe to the multicast group (call **Open( "169.254.1.1", "239.192.1.1", 1042 )**)

        Why does the GigE Vision device address (*aIPAddress*) need to be specified?

            - In this example, the data is transmitted using the GVSP protocol to a multicast group (239.192.1.1:1042).
            - The receiving application contacts the device (IP address 169.254.1.1) using the GVCP protocol to ensure that it is reachable.
            - In addition to this, packet resend requests are directed from receiver to GigE Vision device using the GVCP control channel.
            - This is by design as per the GigEVision standard.

        | Multicasting uses the IGMP (Internet Group Management Protocol) and requires an IGMP-compliant switch.
        | The switch maintains a list of subscribed peers associated with a given multicast group.
        | Multicast group IP addresses take the form 239.192.*xx*.*yy*.

        It is also possible to use multicasting with a non-IGMP compliant switch or network. In that case, the multicast stream is simply
        broadcasted to every connected entity on the network. It can be OK in controlled environment, but use with caution!

        To learn more about IGMPv3, see *RFC 3376* at www.ietf.org.

        For a complete illustration of how to use this method to receive data multicasted from a GigE Vision transmitter, refer to the following two samples:

            - MulticastMaster - Connects to a GigE Vision device as a controler and tells it to begin streaming to a multicast address.
            - MulticastSlave - Illustrates the use of PvStream multicast Open method by receiving the data the GigE Vision device is transmitting.

        :type aInfo: str, in
        :param aInfo:            The GigE Vision transmitter's IP address.
        :type aMulticastAddr: str, in
        :param aMulticastAddr:   The multicast IP address to which the receiver subscribes and the GigE Vision transmitter sends data. (Set the streaming channel destination address (SCDA) on your GigE Vision transmitter accordingly by calling #PvDeviceGEV::SetStreamDestination.)
        :type aDataPort: int, in
        :param aDataPort:        The multicast port to which the receiver subscribes and the GigE Vision transmitter sends data. (Set the streaming channel port (SCP) on your GigE Vision transmitter accordingly by calling #PvDeviceGEV::SetStreamDestination.)
        :type aChannel: int, in, optional
        :param aChannel:         The GigE Vision transmitter's streaming channel (default 0).
        :type aLocalIPAddress: str, in, optional
        :param aLocalIPAddress:  The local IP address upon which the stream object will begin receiving incoming data. An empty string (default) indicates that the local ip address will be assigned automatically.
        :type aBuffersCapacity: int, in, optional
        :param aBuffersCapacity: The maximum number of buffers that can be stored simultaneously in the data receiver.

        :rtype: :py:class:`PvResult`
        :return:
            Includes:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_NOT_CONNECTED`
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER`
                - :py:const:`~PvResultCode.PV_NOT_FOUND`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR`
                - :py:const:`~PvResultCode.PV_BAD_VERSION`

        """
        return _ebus_python.PvStreamGEV_Open(self, *args)

    def GetType(self):
        r"""
        Returns whether the object is a GigE Vision or USB3 Vision stream receiver.

        :rtype: int
        :return: Specific object type.
        """
        return _ebus_python.PvStreamGEV_GetType(self)

    def GetDataReceiverType(self):
        r"""
        Returns the type of GigE Vision data receiving used by the stream receiver.

        :rtype: int
        :return: Data receiver type. See #PvDataReceiverType Enum.
        """
        return _ebus_python.PvStreamGEV_GetDataReceiverType(self)

    def FlushPacketQueue(self):
        r"""
        Flushes all non-processed UDP packets from the data receiver.

        Should be called before resuming streaming after a pause
        to ensure that old packets are not processed
        as new incoming data.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_CONNECTED
        """
        return _ebus_python.PvStreamGEV_FlushPacketQueue(self)

    def GetWaitForFirstPacketOfBlockToStart(self):
        r"""
        Wait for the first packet of the block to start the stream capture StartStreamOnlyOnPacketIdZero ("streamparameters.html#StartStreamOnlyOnPacketIdZero") property.

        :rtype: boolean
        :return: The value of the StartStreamOnlyOnPacketIdZero ("streamparameters.html#StartStreamOnlyOnPacketIdZero") property.
        """
        return _ebus_python.PvStreamGEV_GetWaitForFirstPacketOfBlockToStart(self)

    def SetWaitForFirstPacketOfBlockToStart(self, aWaitForFirstPacketOfBlockToStart):
        r"""
        Set the stream's StartStreamOnlyOnPacketIdZero ("streamparameters.html#StartStreamOnlyOnPacketIdZero") property.

        :type aWaitForFirstPacketOfBlockToStart: boolean, in
        :param aWaitForFirstPacketOfBlockToStart:   The value being set.

        :rtype: :py:class:`PvResult`
        :return: #PvResult::Code::OK or #PvResult::Code::NOT_SUPPORTED or #PvResult::Code::NOT_CONNECTED
        """
        return _ebus_python.PvStreamGEV_SetWaitForFirstPacketOfBlockToStart(self, aWaitForFirstPacketOfBlockToStart)

    def GetLocalPort(self):
        r"""
        Get the stream's DataPort ("streamparametersGEV.html#DataPort") property.

        :rtype: int
        :return: The stream's DataPort ("streamparametersGEV.html#DataPort") property.
        """
        return _ebus_python.PvStreamGEV_GetLocalPort(self)

    def GetLocalIPAddress(self):
        r"""
        Get the stream's LocalIPAddress ("streamparametersGEV.html#LocalIPAddress") property.

        :rtype: str
        :return: The stream's LocalIPAddress ("streamparametersGEV.html#LocalIPAddress") property.
        """
        return _ebus_python.PvStreamGEV_GetLocalIPAddress(self)

    def GetMulticastIPAddress(self):
        r"""
        Get the stream's MulticastIPAddress ("streamparametersGEV.html#MulticastIPAddress") property.

        :rtype: str
        :return: The stream's MulticastIPAddress ("streamparametersGEV.html#MulticastIPAddress") property.
        """
        return _ebus_python.PvStreamGEV_GetMulticastIPAddress(self)

    def GetDeviceIPAddress(self):
        r"""
        Get the IP address of the device this stream receives data from.

        :rtype: str
        :return: IP address of the streaming device.
        """
        return _ebus_python.PvStreamGEV_GetDeviceIPAddress(self)

    def GetSpecificLocalPort(self):
        r"""
        Returns the local UDP port requested when opening the stream.

        0 is returned if the user did not open the stream requesting a specific local UDP port if if the stream is not opened.

        :rtype: int
        :return: Local UDP port requested when opening the stream.
        """
        return _ebus_python.PvStreamGEV_GetSpecificLocalPort(self)

    def GetUserModeDataReceiverThreadPriority(self):
        r"""
        Get the priority of the thread used to run the data receiver user mode

        See #SetUserModeDataReceiverThreadPriority for details about the meaning of the values returned

        :rtype: int
        :return: The priority of the thread
        """
        return _ebus_python.PvStreamGEV_GetUserModeDataReceiverThreadPriority(self)

    def SetUserModeDataReceiverThreadPriority(self, aPriority):
        r"""
        Set the priority of the thread used to run the data receiver user mode

        Only applicable if using a user-mode data receiver. The thread priority of a
        driver-based data receiver cannot be controlled. This thread receives and processes
        all packets received from the device.

        If you change the thread priorities, it may alterate the stability of the system. For this reason,
        if you report a bug to Pleora, ensure to clearly mention that you change threads priorities.

        See #GetUserModeDataReceiverThreadPriority

        :type aPriority: int, in
        :param aPriority:   See #PvPipeline::SetBufferHandlingThreadPriority for description of the supported values

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
                - #PvResult::Code::THREAD_ERROR
        """
        return _ebus_python.PvStreamGEV_SetUserModeDataReceiverThreadPriority(self, aPriority)

    def GetUserModeSocketRxBufferSize(self):
        r"""

        Read the current Receive Buffer Size set by the PvStreamGEV that the socket uses.
        The API is ONLY supported on Linux System in User Mode when eBUS UniversalProForEthernet Driver is not used.
        :py:const:`~PvResultCode.PV_NOT_SUPPORTED` will be returned if the API is used on Windows.

        See :func:`PvStreamGEV.SetUserModeBufferSizeRx` for details.

        :rtype:  Tuple(:py:class:`PvResult`, int)
        :return:  
            Tuple composed of (result, bufferSize).
             - result includes:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_NOT_SUPPORTED`
                - :py:const:`~PvResultCode.PV_NOT_CONNECTED`
             - bufferSize:
                - The Receive Buffer Size used in the socket opened by the current PvStreamGEV instance.

        """
        return _ebus_python.PvStreamGEV_GetUserModeSocketRxBufferSize(self)

    def SetUserModeSocketRxBufferSize(self, aSize):
        r"""
        Set the Receive Buffer Size through socket option SO_RCVBUF by PvStreamGEV.

        The API is ONLY supported in User Mode when eBUS UniversalProForEthernet Driver is not used.

        The API allows the user to configure the SO_RCVBUF - the size of the buffer the kernel allocates to hold the data
        arriving into the given socket between the time when it arrives over the network and when it is read by eBUS SDK User Mode Data Receiver.

        In case the method was called when eBUS UniversalProForEthernet Driver is used, the value will be ignored.

        This API must be called before PvStreamGEV::Open(), otherwise you will receive NETWORK_CONFIG_ERROR.
        The actual value set can be confirmed by #GetUserModeSocketRxBufferSize after PvStream::Open() returns successfully.
        And it's recommended to always call #GetUserModeSocketRxBufferSize to validate the value set.

        To configure and confirm the value used by the socket, you should perform this sequence:
            - #PvStreamGEV.SetUserModeSocketRxBufferSize
            - #PvStreamGEV.Open
            - #PvStreamGEV.GetUserModeSocketRxBufferSize


        On Linux System:

        The value allowed is limited by rmem_max defined on your Linux System.
        If the value set exceeds rmem_max, rmem_max will be used instead, and the method will return INVALID_PARAMETER.

        The rmem_max value on your Linux system could be configured by script set_socket_buffer_size.sh provided by eBUS SDK.

        In case the value #PvStreamGEV.GetUserModeBufferSizeRx retrieved is not what you expected, check the rmem_max setting first.

        Note: The kernel doubles the value set by #SetUserModeSocketRxBufferSize (to allow space for bookkeeping overhead) if possible.
        The retrived value from #GetUserModeSocketRxBufferSize could be doubled, but should not exceed rmem_max * 2.


        Note: the set value is not permanent or global, it is only for the current PVStreamGEV instance.

        :type aSize: int, in
        :param aSize:  The Receive Buffer Size to use with socket option SO_RCVBUF.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NETWORK_CONFIG_ERROR
                - #PvResult::Code::INVALID_PARAMETER
        """
        return _ebus_python.PvStreamGEV_SetUserModeSocketRxBufferSize(self, aSize)

    def SetUserModeRxPacketBufferSize(self, aSize):
        r"""
        Set ther Receive Packet Buffer Size used by PvStreamGEV.

        The API is ONLY supported in User Mode when eBUS UniversalProForEthernet Driver is not used.

        In case the method was called on Linux system when eBUS UniversalProForEthernet Driver is used, the value will be ignored.

        This API allows the user to increase the max jumbo packet size eBUS SDK supports.
        The minimum value can be set is 17000, the default value of eBUS SDK, to support all physical NICs.
        The maximum value can be set is 65500, to support Virtual NICs.
        eBUS will set the value to min or max for you if the aSize value is out of range.

        Note: the set value is not permanent or global, it is only for the current PVStreamGEV instance.

        This API must be called before PvStreamGEV::Open(), otherwise you will receive NETWORK_CONFIG_ERROR.

        To configure the value, you should perform this sequence:
            - #PvStreamGEV.SetUserModeRxPacketBufferSize
            - #PvStreamGEV.Open

        :type aSize: int, in
        :param aSize:  The Receive Packet Buffer Size to use when using User Mode DataReceiver. Minimum supported value is 17000 bytes, Maximum is 65500 bytes.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NETWORK_CONFIG_ERROR
        """
        return _ebus_python.PvStreamGEV_SetUserModeRxPacketBufferSize(self, aSize)

    @staticmethod
    def IsDriverInstalled(*args):
        r"""
        Test if the specified GigE Vision device is currently reachable through an eBUS driver

        :type aIPAddress: str, in
        :param aIPAddress:     The GigE Vision transmitter's IP address.
        :type aInstalled: boolean, out
        :param aInstalled:     True if the device is reachable through an eBUS driver; otherwise, false.
        :type aLocalIPAddress: str, in, optional
        :param aLocalIPAddress: Deprecated and ignored.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
        """
        return _ebus_python.PvStreamGEV_IsDriverInstalled(*args)

# Register PvStreamGEV in _ebus_python:
_ebus_python.PvStreamGEV_swigregister(PvStreamGEV)
class PvStreamU3V(PvStream):
    r"""
    Receive data from a USB3 Vision transmitter.

    This provides a means of opening a connection to the data receiver and obtaining data from it.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" Constructor."""
        _ebus_python.PvStreamU3V_swiginit(self, _ebus_python.new_PvStreamU3V())
    __swig_destroy__ = _ebus_python.delete_PvStreamU3V

    def Open(self, *args):
        r"""

        *Overload 1:*

        Begin receiving blocks (images or raw data) **unicasted** from a USB3 Vision transmitter.

        :type aDeviceInfo: :py:class:`PvDeviceInfo`, in
        :param aDeviceInfo: Device info retrieved from finder for the USB3 Vision to open the stream from.

        :rtype: :py:class:`PvResult`
        :return: 
            Includes:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_BUSY` Only one instance to one transmitter can be opened at the time
                - :py:const:`~PvResultCode.PV_NOT_CONNECTED`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR`
                - :py:const:`~PvResultCode.PV_NOT_FOUND`
                - :py:const:`~PvResultCode.PV_CANNOT_OPEN_FILE`
                - :py:const:`~PvResultCode.PV_NOT_SUPPORTED`

        |

        *Overload 2:*

        Begin receiving blocks (images or raw data) **unicasted** from a USB3 Vision transmitter.

        :type aDeviceInfo: :py:class:`PvDeviceInfo`, in
        :param aDeviceInfo: Device info retrieved from finder for the USB3 Vision to open the stream from.
        :type aChannel: int, in
        :param aChannel: The USB3 Vision transmitter's streaming channel (default 0).
        :type aBuffersCapacity: int, in, optional
        :param aBuffersCapacity: The maximum number of buffers that can be stored simultaneously in the data receiver.
        :type aSmallImageThreshold: int, in, optional
        :param aSmallImageThreshold: Threashold where the exchange of memory with the driver is making copy to decrease overall overhead due to memory mapping
        :type aMaximumNumberOfPendingURB: int, in, optional
        :param aMaximumNumberOfPendingURB: Maximum of pending URBs in the controller at one time

        :rtype: :py:class:`PvResult`
        :return:
            Includes:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_BUSY` Only one instance to one transmitter can be opened at the time
                - :py:const:`~PvResultCode.PV_NOT_CONNECTED`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR`
                - :py:const:`~PvResultCode.PV_NOT_FOUND`
                - :py:const:`~PvResultCode.PV_CANNOT_OPEN_FILE`
                - :py:const:`~PvResultCode.PV_NOT_SUPPORTED`

        |

        *Overload 3:*

        Begin receiving blocks (images or raw data) **unicasted** from a USB3 Vision transmitter.

        :type aInfo: str, in
        :param aInfo: The USB3 Vision GUID transmitter's U3VGUID

        :rtype: :py:class:`PvResult`
        :return:
            Includes:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_BUSY` Only one instance to one transmitter can be opened at the time
                - :py:const:`~PvResultCode.PV_NOT_CONNECTED`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR`
                - :py:const:`~PvResultCode.PV_NOT_FOUND`
                - :py:const:`~PvResultCode.PV_CANNOT_OPEN_FILE`
                - :py:const:`~PvResultCode.PV_NOT_SUPPORTED`

        |

        *Overload 4:*

        Begin receiving blocks (images or raw data) **unicasted** from a USB3 Vision transmitter.

        :type aInfo: str, in
        :param aInfo: The USB3 Vision GUID transmitter's U3VGUID
        :type aChannel: int, in
        :param aChannel: The USB3 Vision transmitter's streaming channel (default 0).
        :type aBuffersCapacity: int, in, optional
        :param aBuffersCapacity: The maximum number of buffers that can be stored simultaneously in the data receiver.
        :type aSmallImageThreshold: int, in, optional
        :param aSmallImageThreshold: Threashold where the exchange of memory with the driver is making copy to decrease overall overhead due to memory mapping
        :type aMaximumNumberOfPendingURB: int, in, optional
        :param aMaximumNumberOfPendingURB: Maximum of pending URBs in the controller at one time

        :rtype: :py:class:`PvResult`
        :return:
            Includes:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_BUSY` Only one instance to one transmitter can be opened at the time
                - :py:const:`~PvResultCode.PV_NOT_CONNECTED`
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR`
                - :py:const:`~PvResultCode.PV_NOT_FOUND`
                - :py:const:`~PvResultCode.PV_CANNOT_OPEN_FILE`
                - :py:const:`~PvResultCode.PV_NOT_SUPPORTED`

        """
        return _ebus_python.PvStreamU3V_Open(self, *args)

    def GetGUID(self):
        r"""
        Get the stream's GUID () property.

        :rtype: str
        :return: The stream's GUID () property.
        """
        return _ebus_python.PvStreamU3V_GetGUID(self)

    def GetType(self):
        r"""
        Returns whether the object is a GigE Vision or USB3 Vision stream receiver.

        :rtype: int
        :return: See #PvStreamType Enum.
        """
        return _ebus_python.PvStreamU3V_GetType(self)

# Register PvStreamU3V in _ebus_python:
_ebus_python.PvStreamU3V_swigregister(PvStreamU3V)
class PvStreamRTP(PvStream):
    r"""
    Receive data from a RTP transmitter.

    This provides a means of opening a connection to the data receiver and obtaining data from it.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" Constructor."""
        _ebus_python.PvStreamRTP_swiginit(self, _ebus_python.new_PvStreamRTP())
    __swig_destroy__ = _ebus_python.delete_PvStreamRTP

    def PrepareFor(self, aWidth, aHeight, aPixelType, aPaddingX=0):
        r"""
        Tells the stream object to expect uncompressed images of a specific format.

        :type aWidth: int, in
        :param aWidth: The image's width to receive.
        :type aHeight: int, in
        :param aHeight: The image's height to receive.
        :type aPixelType: int, in
        :param aPixelType: The image's pixel type to receive.
        :type aPaddingX: int, in, optional
        :param aPaddingX: The image's padding to receive.

        :rtype: :py:class:`PvResult`
        :return: #PvResult::Code::OK on success.
        """
        return _ebus_python.PvStreamRTP_PrepareFor(self, aWidth, aHeight, aPixelType, aPaddingX)

    def PrepareForH264(self):
        r"""
        Tells the stream object to expect an H.264 stream.

        :rtype: :py:class:`PvResult`
        :return: #PvResult::Code::OK on success.
        """
        return _ebus_python.PvStreamRTP_PrepareForH264(self)

    def ResetPayloadType(self):
        r"""
        Resets the expected stream attributes to undefined.

        :rtype: :py:class:`PvResult`
        :return: #PvResult::Code::OK on success.
        """
        return _ebus_python.PvStreamRTP_ResetPayloadType(self)

    def Open(self, *args):
        r"""

        *Overload 1:*

        Opens a stream from a #PvDeviceInfo. Not supported with RTP.

        :type aDeviceInfo: :py:class:`PvDeviceInfo`, in
        :param aDeviceInfo: The PvDeviceInfo input.

        :rtype: :py:class:`PvResult`
        :return: #PvResult::Code::NOT_SUPPORTED

        |

        *Overload 2:*

        Opens a stream from a device info string. Not supported with RTP.

        :type aInfo: str, in
        :param aInfo: The device info, formatted as a string.

        :rtype: :py:class:`PvResult`
        :return: #PvResult::Code::NOT_SUPPORTED

        |

        *Overload 3:*

        Opens the stream from a SDP session info.

        :type aSession: PvSessionInfoSDP, in
        :param aSession: The SDP for a given stream.
        :type aLocalIpAddress: int, in
        :param aLocalIpAddress: A local IP address to receive from.
        :type aLocalPort: int, in, optional
        :param aLocalPort: A local port to receive from.

        :rtype: :py:class:`PvResult`
        :return: #PvResult::Code::NOT_SUPPORTED

        |

        *Overload 4:*

        Opens the stream object for unicast RTP receiving.

        :type aLocalIpAddress: str, in
        :param aLocalIpAddress: A local IP address to receive from.
        :type aLocalPort: int, in
        :param aLocalPort: A local port to receive from.

        :rtype: :py:class:`PvResult`
        :return: :py:const:`~PvResultCode.PV_OK` on success.

        |

        *Overload 5:*

        Opens the stream object for multicast RTP receiving.

        :type aMulticastAddress: str, in
        :param aMulticastAddress: The multicast IP address of the stream.
        :type aDataPort: int, in
        :param aDataPort: The stream port.
        :type aLocalIpAddress: str, in
        :param aLocalIpAddress: A local IP address to receive from.

        :rtype: :py:class:`PvResult`
        :return: :py:const:`~PvResultCode.PV_OK` on success.

        """
        return _ebus_python.PvStreamRTP_Open(self, *args)

    def OpenTCP(self, aServerIpAddress, aServerPort):
        r"""
        Opens the stream object for TCP receiving.

        :param aServerIPAddress: The RTP server IP address.
        :type aServerPort: int, in
        :param aServerPort: The RTP server port.

        :rtype: :py:class:`PvResult`
        :return: #PvResult::Code::OK on success.
        """
        return _ebus_python.PvStreamRTP_OpenTCP(self, aServerIpAddress, aServerPort)

    def GetType(self):
        r"""
        Receiver type.

        :rtype: int
        :return: See #PvStreamType enum.
        """
        return _ebus_python.PvStreamRTP_GetType(self)

    def GetLocalPort(self):
        r"""
        Returns the local socket port used by the stream.

        :rtype: int
        :return: Stream local port.
        """
        return _ebus_python.PvStreamRTP_GetLocalPort(self)

    def GetLocalIPAddress(self):
        r"""
        Returns the local IPaddress used by the stream.

        :rtype: str
        :return: Stream local IP address.
        """
        return _ebus_python.PvStreamRTP_GetLocalIPAddress(self)

    def GetMulticastIPAddress(self):
        r"""
        Returns the multicast IP address of the stream.

        :rtype: str
        :return: Stream multipcast IP addres if applicable.
        """
        return _ebus_python.PvStreamRTP_GetMulticastIPAddress(self)

    def GetTCPServerIPAddress(self):
        r"""
        Returns the IP address of the server stream.

        Only valid in TCP mode.

        :rtype: str
        :return: Server IP address.
        """
        return _ebus_python.PvStreamRTP_GetTCPServerIPAddress(self)

    def GetTCPServerPort(self):
        r"""
        Returns the port of the stream server.

        Only valid in TCP mode.

        :rtype: int
        :return: Server port.
        """
        return _ebus_python.PvStreamRTP_GetTCPServerPort(self)

    def GetThreadPriority(self):
        r"""
        Returns thread priority of the data receiver thread.

        :rtype: int
        :return: Thread priority.
        """
        return _ebus_python.PvStreamRTP_GetThreadPriority(self)

    def SetThreadPriority(self, aPriority):
        r"""
        Set the priority of the thread used to run the data receiver.

        If you change the thread priorities, it may alterate the stability of the system. For this reason,
        if you report a bug to Pleora, ensure to clearly mention that you change threads priorities.

        See #GetThreadPriority

        :type aPriority: int, in
        :param aPriority: See #PvPipeline::SetBufferHandlingThreadPriority for description of the supported values

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
                - #PvResult::Code::THREAD_ERROR
        """
        return _ebus_python.PvStreamRTP_SetThreadPriority(self, aPriority)

# Register PvStreamRTP in _ebus_python:
_ebus_python.PvStreamRTP_swigregister(PvStreamRTP)
class PvPipeline(object):
    r"""
    Helper class for receiving data from a GigE Vision or USB3 Vision transmitter.

    The process of receiving data from a GigE Vision or USB3 Vision transmitter involves queuing buffers into the data receiver ensuring that there are always buffers available for the incoming data.
    #PvPipeline partners with a #PvStream object to allocate and push buffers into the data receiver as needed.

    For further information on how #PvPipeline fits in with the process of receiving data from a GigE Vision transmitter, refer to the
    receiving data from a transmitter ("receivingdata.html") page.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, aStream):
        r"""
        Constructor.

        The PvPipeline is just a helper of a PvStream class. Your code
        is still the owner of the PvStream class.

        :type aStream: :py:class:`PvStream`, in
        :param aStream: The object responsible for receiving data from a GEV transmitter; a #PvStream object.
        """
        _ebus_python.PvPipeline_swiginit(self, _ebus_python.new_PvPipeline(aStream))
    __swig_destroy__ = _ebus_python.delete_PvPipeline

    def GetBufferSize(self):
        r"""
        Get the size for all managed buffers in bytes.

        :rtype: int
        :return: The size of managed buffers, in bytes.
        """
        return _ebus_python.PvPipeline_GetBufferSize(self)

    def GetBufferCount(self):
        r"""
        Get number of buffers owned and used by the pipeline.

        :rtype: int
        :return: The number of buffers.
        """
        return _ebus_python.PvPipeline_GetBufferCount(self)

    def GetOutputQueueSize(self):
        r"""
        Returns the number of #PvBuffer objects currently available in the output queue.

        #PvBuffer objects are pushed into the output queue as soon as they have been populated with incoming data.
        #PvBuffer objects are pulled out of the output queue by calling #RetrieveNextBuffer.
        The number of buffers available in the pool managed by #PvPipeline is limited to #GetBufferCount.
        If the calling application cannot retrieve buffers at the rate that data is arriving, buffers are silently dropped.
        To obtain a count of dropped buffers, refer to the PipelineImagesDropped property of the #PvStream parameters.

        :rtype: int
        :return: The number of #PvBuffer currently available in the output queue.
        """
        return _ebus_python.PvPipeline_GetOutputQueueSize(self)

    def GetHandleBufferTooSmall(self):
        r"""
        Returns if the pipeline is configured to handle BUFFER_TOO_SMALL operation results automatically.

        :rtype: boolean
        :return: True if the pipeline handles BUFFER_TOO_SMALL operation results automatically.

        See also: #PvPipeline::SetHandleBufferTooSmall
        """
        return _ebus_python.PvPipeline_GetHandleBufferTooSmall(self)

    def IsStarted(self):
        r"""
        Test if the pipeline has started.

        :rtype: boolean
        :return: True if the pipeline has been started (using #Start); otherwise, false.
        """
        return _ebus_python.PvPipeline_IsStarted(self)

    def SetBufferSize(self, aSize):
        r"""
        Set the optimal size of buffers being queued into the data receiver

        Each time a buffer is queued into the data receiver, it is re-allocated as necessary according to the following behavior:
            - If the buffer size is less than the require buffer size (BUFFER_TOO_SMALL) it is re-allocated.
            - If the buffer size is more than four times the required buffer size, it is re-allocated in order to save memory.

        Originally the buffer size can be specified using SetBufferSize. The pipeline automatically adjusts the buffer size
        based on incoming buffers. As buffers are returned to the pipeline and being queued by the data receiver they may be
        re-allocated as described above.

        :type aSize: int, in
        :param aSize:      The size of the buffer, in bytes.

        See also: #PvBuffer::Alloc
        """
        return _ebus_python.PvPipeline_SetBufferSize(self, aSize)

    def SetBufferCount(self, aBufferCount):
        r"""
        Set the number of buffers owned and used by the #PvPipeline.

        Buffers are added or removed as necessary until the actual buffer count matches the desired buffer count being set.
        During this time, the pipeline is paused temporarily.

        :type aBufferCount: int, in
        :param aBufferCount:   The total number of buffers.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_ENOUGH_MEMORY
                - #PvResult::Code::INVALID_PARAMETER
        """
        return _ebus_python.PvPipeline_SetBufferCount(self, aBufferCount)

    def SetHandleBufferTooSmall(self, aValue):
        r"""
        Configures whether the pipeline handles BUFFER_TOO_SMALL operation result or not.

        If the pipeline is configured to handle BUFFER_TOO_SMALL operation results the buffers are automatically
        re-allocated and re-queued for acquisition when this condition occurs.

        If the pipeline is not configured to handled BUFFER_TOO_SMALL operation results the buffers are
        queued in the pipeline output queue just as any other buffer and what to do with the buffer is deferred
        to the application using PvPipeline.

        If the pipeline handles BUFFER_TOO_SMALL operation results, the #PvPipelineEventSink::OnBufferTooSmall
        callback is invoked in order to order to query how to handle the condition. If not implemented
        the default behaviour is applied. See #PvPipelineEventSink::OnBufferTooSmall for more information.

        #PvPipelineEventSink::OnBufferTooSmall is not invoked when the pipeline is not configured to handle
        BUFFER_TOO_SMALL operation results.

        :type aValue: boolean, in
        :param aValue: If true, the pipeline handles BUFFER_TOO_SMALL operation results automatically. If
                               false the pipeline queues these buffers in the output queue and defers handling of these
                               buffers to the application.
        """
        return _ebus_python.PvPipeline_SetHandleBufferTooSmall(self, aValue)

    def RetrieveNextBuffer(self, *args):
        r"""
        RetrieveNextBuffer(aTimeout = 0xFFFFFFFF) -> PvResult, PvBuffer, PvResult
        Retrieve the next acquired block

        Once the method returns, you can determine the ultimate success of the image acquisition by 
        testing the operational_result. For example, #RetrieveBuffer may return a result of :py:const:`~PvResultCode.PV_OK`,
        even if the operation was aborted (by a call to #AbortQueuedBuffers or #Close). 
        In this case, operation_result would be :py:const:`~PvResultCode.PV_ABORTED`.

        :type aTimeout: int, in
        :param aTimeout:    The maximum time, in ms, to wait for a buffer to be received.
                            The default value is 0xFFFFFFFF milliseconds (wait forever)

        :rtype:  Tuple(:py:class:`PvResult`, :py:class:`PvBuffer`, :py:class:`PvResult`)
        :return:  
            Tuple composed of (result, pvbuffer, operational_result).
             - result includes:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_TIMEOUT`
                - :py:const:`~PvResultCode.PV_INVALID_PARAMETER`
                - :py:const:`~PvResultCode.PV_NOT_CONNECTED` -> not connected
                - :py:const:`~PvResultCode.PV_NO_MORE_ITEM`  -> no PvBuffer queued
             - pvbuffer:
                - The acquired PvBuffer frame or None if result is not OK.
             - operational_result:
                - The result of the acquisition operation. See #PvBuffer::GetOperationResult.

        """
        return _ebus_python.PvPipeline_RetrieveNextBuffer(self, *args)

    def ReleaseBuffer(self, aBuffer):
        r"""
        Return a buffer to the pipeline.

        **IMPORTANT**: all buffers retrieved through #RetrieveNextBuffer must be
        released back to the #PvPipeline. A minimum of 4 buffers must be available to
        the #PvPipeline at all times.

        :type aBuffer: :py:class:`PvBuffer`, in
        :param aBuffer: A pointer to the buffer to return to the queue.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_ENOUGH_MEMORY (May occur if the buffer size needs to be increased but not enough memory is available.)
        """
        return _ebus_python.PvPipeline_ReleaseBuffer(self, aBuffer)

    def Start(self):
        r"""
        Starts the #PvPipeline.

        In order to retrieve images from the stream and make them available
        to #RetrieveNextBuffer, the pipeline must be running. This
        starts a thread that continually ensures that buffers are allocated and ready in the #PvStream so that incoming data is captured.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
        """
        return _ebus_python.PvPipeline_Start(self)

    def Stop(self):
        r"""
        Stops the #PvPipeline.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::GENERIC_ERROR (Errors occured when stopping the pipeline's thread.)
        """
        return _ebus_python.PvPipeline_Stop(self)

    def Reset(self):
        r"""
        Resets the pipeline.

        Synchronously aborts the stream, waits for all buffers to be removed from the
        stream and queues in a fresh set of buffers. Call ONLY when it is running, otherwise
        it returns error

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::STATE_ERROR If already waiting for another reset to complete or if not running
        """
        return _ebus_python.PvPipeline_Reset(self)

    def RegisterEventSink(self, aEventSink):
        r"""
        Register an event sink used for callbacks.

        :type aEventSink: :py:class:`PvPipelineEventSink`, in
        :param aEventSink:  A pointer to the event sink.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
                - #PvResult::Code::GENERIC_ERROR
        """
        return _ebus_python.PvPipeline_RegisterEventSink(self, aEventSink)

    def UnregisterEventSink(self, aEventSink):
        r"""
        Unregister an event sink

        :type aEventSink: :py:class:`PvPipelineEventSink`, in
        :param aEventSink:  A pointer to the event sink.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
                - #PvResult::Code::NOT_FOUND
        """
        return _ebus_python.PvPipeline_UnregisterEventSink(self, aEventSink)

    def GetBufferHandlingThreadPriority(self):
        r"""
        Get the priority of the pipeline thread

        See #SetBufferHandlingThreadPriority for details about the meaning of the values returned

        :rtype: int
        :return: The priority of the thread
        """
        return _ebus_python.PvPipeline_GetBufferHandlingThreadPriority(self)

    def SetBufferHandlingThreadPriority(self, aPriority):
        r"""
        Set the priority of the pipeline thread

        This thread is pretty much the pipeline itself: it queues buffers in PvStream and
        retrieves them when they are ready, making them available in an output queue.

        In Linux, the priorities supported are between 0 and 99, 99 been the highest priority as per the
        SCHED_FIFO scheduler specifications. If the process is not running with root priviledge, all the
        threads are run into the SCHED_OTHER ( scheduler 01 ) and have the same priority at 0.

        In Windows, the priorities supported are between 0 and 6. The value will be translated into one of the
        following scheduler defines:

            0 - THREAD_PRIORITY_IDLE
            1 - THREAD_PRIORITY_LOWEST
            2 - THREAD_PRIORITY_BELOW_NORMAL
            3 - THREAD_PRIORITY_NORMAL
            4 - THREAD_PRIORITY_ABOVE_NORMAL
            5 - THREAD_PRIORITY_HIGHEST
            6 - THREAD_PRIORITY_TIME_CRITICAL

        If you change the thread priorities, it may alterate the stability of the system. For this reason,
        if you report a bug to Pleora, ensure to clearly mention that you change threads priorities.

        See #GetBufferHandlingThreadPriority

        :type aPriority: int, in
        :param aPriority:   Priority to be set to the conversion threads.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER
                - #PvResult::Code::THREAD_ERROR
        """
        return _ebus_python.PvPipeline_SetBufferHandlingThreadPriority(self, aPriority)

# Register PvPipeline in _ebus_python:
_ebus_python.PvPipeline_swigregister(PvPipeline)
class PvPipelineEventSink(object):
    r"""
    Observer interface for an observable PvPipeline object

    #PvPipelineEventSink defines a set of callback methods from
    a PvPIpeline object to any object implementing this interface.

    **To receive PvPipeline notifications:**

        - Create an instance of your MySink class.
        - Register your MySink class with the #PvPipeline object. Use #PvPipeline::RegisterEventSink.
        - Handle events when #PvPipeline calls your overriden methods.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" PvPipeline event sink constructor."""
        if self.__class__ == PvPipelineEventSink:
            _self = None
        else:
            _self = self
        _ebus_python.PvPipelineEventSink_swiginit(self, _ebus_python.new_PvPipelineEventSink(_self, ))
    __swig_destroy__ = _ebus_python.delete_PvPipelineEventSink

    def OnBufferCreated(self, aPipeline, aBuffer):
        r"""
        Called whenever a PvBuffer is allocated by the pipeline.

        Can be used to track memory usage or structures used to follow
        PvBuffer pipeline management.

        This method is invoked right after the PvBuffer has been created but before its payload has been allocated.

        :type aPipeline: :py:class:`PvPipeline`, in
        :param aPipeline: A pointer to the #PvPipeline object.
        :type aBuffer: :py:class:`PvBuffer`, in
        :param aBuffer: Pointer to the buffer that was just created.
        """
        return _ebus_python.PvPipelineEventSink_OnBufferCreated(self, aPipeline, aBuffer)

    def OnBufferDeleted(self, aPipeline, aBuffer):
        r"""
        Called whenever a PvBuffer is deleted by the pipeline.

        Can be used to track memory usage or structures used to follow
        PvBuffer pipeline management.

        This method is invoked right before the PvBuffer is deleted.

        :type aPipeline: :py:class:`PvPipeline`, in
        :param aPipeline: A pointer to the #PvPipeline object.
        :type aBuffer: :py:class:`PvBuffer`, in
        :param aBuffer: Pointer to the buffer that was just deleted.
        """
        return _ebus_python.PvPipelineEventSink_OnBufferDeleted(self, aPipeline, aBuffer)

    def OnStart(self, aPipeline):
        r"""
        PvPipeline event sink OnStart event.

        Invoked when the pipeline just before the pipeline starts.

        This callback is invoked from the same thread that called #PvPipeline::Start.

        :type aPipeline: :py:class:`PvPipeline`, in
        :param aPipeline: A pointer to the #PvPipeline object.
        """
        return _ebus_python.PvPipelineEventSink_OnStart(self, aPipeline)

    def OnStop(self, aPipeline):
        r"""
        PvPipeline event sink OnStop event.

        Invoked right after the pipeline has been stopped.

        This callback is invoked from the same thread that called #PvPipeline::Stop.

        :type aPipeline: :py:class:`PvPipeline`, in
        :param aPipeline: A pointer to the #PvPipeline object.
        """
        return _ebus_python.PvPipelineEventSink_OnStop(self, aPipeline)

    def OnReset(self, aPipeline):
        r"""
        PvPipeline event sink OnReset event.

        Invoked after the pipeline has been reset.

        This callback is invoked from the same thread that called #PvPipeline::Reset.

        :type aPipeline: :py:class:`PvPipeline`, in
        :param aPipeline: A pointer to the #PvPipeline object.
        """
        return _ebus_python.PvPipelineEventSink_OnReset(self, aPipeline)

    def OnBufferTooSmall(self, aPipeline, aReallocAll, aResetStats):
        r"""
        PvPipeline event sink OnBufferTooSmall event.

        Invoked when the pipeline retrieve a buffer from the stream object which failed
        with an operation result set to BUFFER_TOO_SMALL.

        The user can set aRealloc all to true in order to force a complete re-allocation
        of the buffers performed synchronously after the notification is invoked.

        If OnBufferTooSmall is not handled to aReallocAll is set to false, the buffer
        is re-allocated before being queued in the stream object but the other buffers
        are not affected until they too will fail on BUFFER_TOO_SMALL.

        The aResetStats parameter is only considered if aReallocAll is set to true. The
        statistics do not need to be reset if the buffers are not re-allocated.

        This callback is invoked from the pipeline thread.

        :type aPipeline: :py:class:`PvPipeline`, in
        :param aPipeline: A pointer to the #PvPipeline object.
        :type aReallocAll: boolean, in
        :param aReallocAll: If set to true by at least one of the sinks, synchronous buffer re-allocation will be performed.
        :type aResetStats: boolean, in
        :param aResetStats: If set to true by at least one of the sinks, stream statistics are reset.
        """
        return _ebus_python.PvPipelineEventSink_OnBufferTooSmall(self, aPipeline, aReallocAll, aResetStats)

    def OnBufferReady(self, aPipeline):
        r"""
        PvPipeline event sink OnBufferReady event.

        Invoked after a buffer has been retrieved from stream and is ready for retrieve

        :type aPipeline: :py:class:`PvPipeline`, in
        :param aPipeline: A pointer to the #PvPipeline object.
        """
        return _ebus_python.PvPipelineEventSink_OnBufferReady(self, aPipeline)
    def __disown__(self):
        self.this.disown()
        _ebus_python.disown_PvPipelineEventSink(self)
        return weakref.proxy(self)

# Register PvPipelineEventSink in _ebus_python:
_ebus_python.PvPipelineEventSink_swigregister(PvPipelineEventSink)
PvDeviceSerial = _ebus_python.PvDeviceSerial 
PvDeviceSerialInvalid = _ebus_python.PvDeviceSerialInvalid
PvDeviceSerial0 = _ebus_python.PvDeviceSerial0
PvDeviceSerial1 = _ebus_python.PvDeviceSerial1
PvDeviceSerialBulk0 = _ebus_python.PvDeviceSerialBulk0
PvDeviceSerialBulk1 = _ebus_python.PvDeviceSerialBulk1
PvDeviceSerialBulk2 = _ebus_python.PvDeviceSerialBulk2
PvDeviceSerialBulk3 = _ebus_python.PvDeviceSerialBulk3
PvDeviceSerialBulk4 = _ebus_python.PvDeviceSerialBulk4
PvDeviceSerialBulk5 = _ebus_python.PvDeviceSerialBulk5
PvDeviceSerialBulk6 = _ebus_python.PvDeviceSerialBulk6
PvDeviceSerialBulk7 = _ebus_python.PvDeviceSerialBulk7
class PvDeviceSerialPort(object):
    r"""
    Provides access the a serial port on a Pleora GigE Vision or USB3 Vision device.

    #PvDeviceSerialPort uses a proprietary serial communication protocol on top of GigE Vision's GVCP
    or USB3 Vision's GenCP protocol. It does not support non-Pleora devices.

    Use of the #PvDeviceSerialPort class to directly access the camera head
    will interfere with the synchronization between the device and the camera
    head. Avoid accessing device features linked to the
    camera head while using the #PvDeviceSerialPort class to interact with the camera head.

    ## How to use this class


    **To use a serial port:**
        - Connect to a device using any of the #PvDevice::Connect methods.
        - Open a serial port to the device using #PvDeviceSerialPort::Open.
        - Write to the serial port using #PvSerialPort::Write.
        - Read from the serial port using #PvSerialPort::Read.
        - Finally close the serial port using #PvDeviceSerialPort::Close.

    **To check if a device supports a specific serial port:**
        - Connect to a device using any of the #PvDevice::Connect methods.
        - Use the #PvDeviceSerialPort::IsSupported static method.

    For a simple example illustrating how to use PvDeviceSerialPort, refer to the sample entitled DeviceSerialPort.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r""" Constructor."""
        _ebus_python.PvDeviceSerialPort_swiginit(self, _ebus_python.new_PvDeviceSerialPort())
    __swig_destroy__ = _ebus_python.delete_PvDeviceSerialPort

    def Open(self, aDevice, aPort):
        r"""
        Opens the serial port.

        The #Open method opens a serial port to a device - mainly
        configuring it for serial communication readiness.

        :type aDevice: IPvDeviceAdapter, in
        :param aDevice:        Pointer to a #PvDevice object. The device must be connected
                                       prior to opening a serial port.
        :type aPort: int, in
        :param aPort:          #PvDeviceSerial enumeration value representing the device's
                                       serial port to open.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER if aDevice is NULL.
                - #PvResult::Code::NOT_CONNECTED if the device is not connected.
                - #PvResult::Code::NOT_SUPPORTED if the port is not supported by the device.
        """
        return _ebus_python.PvDeviceSerialPort_Open(self, aDevice, aPort)

    def Close(self):
        r"""
        Closes the serial port.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::NOT_CONNECTED if the port was already closed
        """
        return _ebus_python.PvDeviceSerialPort_Close(self)

    def IsOpened(self):
        r"""
        Returns true if the serial port is opened.

        :rtype: boolean
        :return: True if the port is opened.
        """
        return _ebus_python.PvDeviceSerialPort_IsOpened(self)

    def Write(self, aBuffer):
        r"""
        Write( aBuffer ) -> PvResult, int
        Writes data to the serial port.

        :type aBuffer: ndarray, in
        :param aBuffer:       A 1-dimensional python numpy array with dtype np.uint8 containing the bytes to write on the serial port.

        :rtype: Tuple(:py:class:`PvResult`, int)
        :return: 
            Tuple composed of (result, aBytesWritten).
             - result includes:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_NOT_CONNECTED` if the port is not opened or the associated #PvDevice is no longer connected.
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` if not all bytes could be written to the serial port.
             - aBytesWritten 
                - The number of bytes successfully written on the serial port

        """
        return _ebus_python.PvDeviceSerialPort_Write(self, aBuffer)

    def GetWriteProgress(self):
        r"""
        GetWriteProgress() -> PvResult, int, int
        Gets the progress of an ongoing write operation.

        This method can be called from a different thread than the blocking Write call in order
        track or report the progress of the operation.

        After a successful write operation, this method returns aWritten equals to aTotal
        until the begining of the next write operation.

        :rtype: Tuple(:py:class:`PvResult`, int, int)
        :return: 
            Tuple composed of (result, aWritten, aTotal).
             - result includes:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_STATE_ERROR` if no write operation has been performed yet
             - aWritten
                - How many bytes have been written up to now.
             - aTotal
                - The total number of bytes to write.

        """
        return _ebus_python.PvDeviceSerialPort_GetWriteProgress(self)

    def Read(self, aBuffer, aTimeout=0):
        r"""
        Read( aSize, aTimeout=0 ) -> PvResult, ndarray, int
        Reads from the serial port.

        :type aSize: int, in
        :param aSize:         Size of the numpy array or maximum number of bytes that are read from the serial port
        :type aTimeout: int, in, optional
        :param aTimeout:      Time to wait for new bytes, in ms.

        :rtype: Tuple(:py:class:`PvResult`, ndarray, int)
        :return: 
            Tuple composed of (result, aBuffer, aBytesRead).
             - result includes:
                - :py:const:`~PvResultCode.PV_OK`
                - :py:const:`~PvResultCode.PV_NOT_CONNECTED` if the port is not opened or the associated #PvDevice is no longer connected.
                - :py:const:`~PvResultCode.PV_GENERIC_ERROR` if not all bytes could be written to the serial port.
             - aBuffer:
                - A 1-dimensional python numpy array with dtype np.uint8 describing the received bytes.
             - aBytesRead 
                - The number of bytes read from the serial port.

        """
        return _ebus_python.PvDeviceSerialPort_Read(self, aBuffer, aTimeout)

    def NotifyReadComplete(self):
        r"""
        Method used to trigger a OnReadComplete event to PvDeviceSerialPortEchoSink subscribers.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
        """
        return _ebus_python.PvDeviceSerialPort_NotifyReadComplete(self)

    def FlushRxBuffer(self):
        r"""
        Empties the read buffer.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
        """
        return _ebus_python.PvDeviceSerialPort_FlushRxBuffer(self)

    def GetRxBytesReady(self):
        r"""
        Returns the number of bytes in the read buffer.

        :type aBytes: int, out
        :param aBytes:    Number of bytes currently queued in the receive buffer.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
        """
        return _ebus_python.PvDeviceSerialPort_GetRxBytesReady(self)

    def GetRxBufferSize(self):
        r"""
        Returns the current capacity of the receive buffer.

        If more data than the receive buffer's capacity is received before being
        read using #Read, oldest bytes are dropped first.

        :type aSize: int, out
        :param aSize:     Current capacity of the receive buffer.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
        """
        return _ebus_python.PvDeviceSerialPort_GetRxBufferSize(self)

    def SetRxBufferSize(self, aSize):
        r"""
        Sets the capacity of the receive buffer.
        The receive buffer needs to be big enough to buffer all incoming bytes before the user calls #Read
        Resizing the receive buffer flushes all data in that buffer.

        :type aSize: int, in
        :param aSize:     New capacity for the receive buffer.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK

        See also: GetRxBufferSize
        """
        return _ebus_python.PvDeviceSerialPort_SetRxBufferSize(self, aSize)

    @staticmethod
    def IsSupported(aDevice, aPort):
        r"""
        Tests if a specific serial port is supported on a device.

        This static method can be used to probe which serial ports are supported
        by a specific #PvDevice.

        :type aDevice: IPvDeviceAdapter, in
        :param aDevice:        Pointer to a #PvDevice object. The device must be connected.
        :type aPort: int, in
        :param aPort:          #PvDeviceSerial enumeration value representing the device's serial port.

        :rtype: boolean
        :return: True if supported.
        """
        return _ebus_python.PvDeviceSerialPort_IsSupported(aDevice, aPort)

    @staticmethod
    def RegisterEchoSink(aSink):
        r"""
        Registers an echo sink for all device serial communication in the process.

        :type aSink: PvDeviceSerialPortEchoSink, in
        :param aSink: pointer to an object of a class inheriting PvDeviceSerialPortEchoSink.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER if aSink is NULL
                - #PvResult::Code::NOT_SUPPORTED if aSink is already registered
        """
        return _ebus_python.PvDeviceSerialPort_RegisterEchoSink(aSink)

    @staticmethod
    def UnregisterEchoSink(aSink):
        r"""
        Unregisters an echo sink for all device serial communication in the process.

        :type aSink: PvDeviceSerialPortEchoSink, in
        :param aSink: pointer to the object of a class inheriting PvDeviceSerialPortEchoSink to unregister.

        :rtype: :py:class:`PvResult`
        :return: 
               Includes:
                - #PvResult::Code::OK
                - #PvResult::Code::INVALID_PARAMETER if aSink is NULL
                - #PvResult::Code::NOT_FOUND if the object was not previously registered
        """
        return _ebus_python.PvDeviceSerialPort_UnregisterEchoSink(aSink)

    def GetBytesSent(self):
        r"""
        Returns how many bytes were sent through the serial port.

        :rtype: int
        :return: Bytes sent.
        """
        return _ebus_python.PvDeviceSerialPort_GetBytesSent(self)

    def GetBytesReceived(self):
        r"""
        Returns how many bytes were received from the serial port.

        :rtype: int
        :return: Bytes received.
        """
        return _ebus_python.PvDeviceSerialPort_GetBytesReceived(self)

    def ResetStatistics(self):
        r""" Resets the port statistics."""
        return _ebus_python.PvDeviceSerialPort_ResetStatistics(self)

# Register PvDeviceSerialPort in _ebus_python:
_ebus_python.PvDeviceSerialPort_swigregister(PvDeviceSerialPort)

from enum import Enum
def makeEnum(dict_name):
    for k,v in globals().items():
        if type(v) is dict and k is dict_name:
            globals()[k] = Enum(k,v)

def PvResultEnum():
    tmpD = {k:v for k,v in globals().items() if k.startswith('PV_')}
    for k,v in tmpD.items():
        pass
    globals()["PvResultCode"] = Enum("PvResultCode",tmpD) 


# Create Enum and documentation here
makeEnum('PvAccessType')
PvAccessType.__doc__ = '''
GigE Vision device access type.

The PvAccessType indicates whether (and to what degree) a second PC can connect to a GigE Vision
device after the first one connects. The GigE Vision device stores the value in the GenICam GevCCP feature.

The value can be set at connection time using :func:`PvDevice.Connect` (recommended) 
or altered using the GenICam GevCCP feature, programmatically or through a GenICam browser dialog. 

===================  ===========================================================================
Enum
===================  ===========================================================================
PvAccessUnknown       Value not known; You can\'t set the value with :func:`PvDevice.Connect`. 
PvAccessOpen          Open access; the GigE Vision device isn\'t connected to any other PC. You can\'t set this value with :func:`PvDevice.Connect`. 
PvAccessControl       | Shared access; a main controller has read-write access to the device and any other PvDevice can have read-only access to the device.
                      | See also
                      | :py:const:`~PvAccessType.PvAccessReadOnly`
PvAccessExclusive     Exclusive access. The controller has full read-write access and any other requests but discovery or resent packets are denied. 
PvAccessReadOnly      Can be used with :func:`PvDevice.Connect` when requesting read-only access to a device currently on PvAccessOpen or PvAccessControl.
===================  ===========================================================================
'''

makeEnum('PvActionAckStatusEnum')
PvActionAckStatusEnum.__doc__ = '''
Action command status enum.

==========================   ====================================================
Enum
==========================   ====================================================
PvActionAckStatusOK          The action command was received and executed with success. 
PvActionAckStatusLate        The schedule action command was received after it was supposed to be executed. 
PvActionAckStatusOverflow    The action command was dropped as too many action commands were already queued on the device. 
PvActionAckStatusNoRefTime   The scheduled action command could not be synchronized as a reference time was not available. 
==========================   ==================================================== 
'''

makeEnum('PvBayerFilterType')
PvBayerFilterType.__doc__ = '''
Filter settings for :func:`PvBufferConverter.SetBayerFilter`.

===================  ====================================================
Enum
===================  ====================================================
PvBayerFilterSimple  2x2 nearest neighbor used when converting from Bayer
PvBayerFilter3X3     3x3 kernel considered when converting from Bayer.
===================  ==================================================== 
'''

makeEnum('PvDataReceiverType')
PvDataReceiverType.__doc__ = '''
The eBUS SDK Data Receiver Type.

+-------------------------------+
| Enum                          |
+===============================+
| PvDataReceiverTypeUnknown     |
+-------------------------------+
| PvDataReceiverTypeEBusDriver  |
+-------------------------------+
| PvDataReceiverTypeUserMode    |
+-------------------------------+
| PvDataReceiverTypeTCP         |
+-------------------------------+

'''

makeEnum('PvDeviceClass')
PvDeviceClass.__doc__ = '''
GigE Vision device class. 

==========================    ====================================================
Enum
==========================    ====================================================
PvDeviceClassUnknown	      Device class unknown; indeterminate.
PvDeviceClassTransmitter	  This device is a transmitter. This implies all its streaming channels transmit data.
PvDeviceClassReceiver	      This device is a receiver. This implies all its streaming channels receive data.
PvDeviceClassTransceiver	  This device is a transceiver. This implies that one or more streaming channels transmit data and one or more streaming channels receive data.
PvDeviceClassPeripheral	      This device is a peripheral. This implies that this device does not have any streaming channels. 
==========================    ==================================================== 
'''

makeEnum('PvDeviceInfoType')
PvDeviceInfoType.__doc__ = '''
The type of device the object represents. 

===============================    ====================================================
Enum
===============================    ====================================================
PvDeviceInfoTypeUnknown	           An unknown device type.
PvDeviceInfoTypeGEV	               A GigE Vision compliant device.
PvDeviceInfoTypePleoraProtocol	   A device compliant with Pleora Protocol (before GigE Vision)
PvDeviceInfoTypeUSB	               A USB device
PvDeviceInfoTypeU3V	               A USB3 Vision device 
===============================    ==================================================== 
'''

makeEnum('PvDeviceSerial')
PvDeviceSerial.__doc__ = '''
Device serial port enumeration.

====================    ====================================================
Enum
====================    ====================================================
PvDeviceSerial0	        Serial port 0, or UART0
PvDeviceSerial1	        Serial port 1, or UART1
PvDeviceSerialBulk0     Bulk interface 0, or BULK0. Can be UART, USRT or I2C depending on device configuration.
PvDeviceSerialBulk1     Bulk interface 1, or BULK1. Can be UART, USRT or I2C depending on device configuration.
PvDeviceSerialBulk2     Bulk interface 2, or BULK2. Can be UART, USRT or I2C depending on device configuration.
PvDeviceSerialBulk3	    Bulk interface 3, or BULK3. Can be UART, USRT or I2C depending on device configuration.
PvDeviceSerialBulk4	    Bulk interface 4, or BULK4. Can be UART, USRT or I2C depending on device configuration.
PvDeviceSerialBulk5	    Bulk interface 5, or BULK5. Can be UART, USRT or I2C depending on device configuration.
PvDeviceSerialBulk6	    Bulk interface 6, or BULK6. Can be UART, USRT or I2C depending on device configuration.
PvDeviceSerialBulk7	    Bulk interface 7, or BULK7. Can be UART, USRT or I2C depending on device configuration. 
====================    ==================================================== 
'''

makeEnum('PvDeviceType')
PvDeviceType.__doc__ = '''
The device type. 

===================  ====================================================
Enum
===================  ====================================================
PvDeviceTypeUnknown	 The device is of unknown type
PvDeviceTypeGEV	     The device is GigE Vision compliant
PvDeviceTypeU3V	     The device is USB3 Vision compliant 
===================  ==================================================== 
'''

makeEnum('PvEncodingEnum')
PvEncodingEnum.__doc__ = '''
The encoding used by the PvCompressionFilter.

===================  =================================================================================
Enum
===================  =================================================================================
PvEncodingUnknown	 Value not known, indeterminate. The value is currently not supported.
PvEncodingPTC1	     Pleora Compression Version 1 encoding.
===================  =================================================================================
'''

makeEnum('PvGenAccessMode')
PvGenAccessMode.__doc__ = '''
Access Mode of the register

+-------------------------------+
| Enum                          |
+===============================+
| PvGenAccessModeReadOnly       |
+-------------------------------+
| PvGenAccessModeReadWrite      |
+-------------------------------+
| PvGenAccessModeWriteOnly      |
+-------------------------------+
| PvGenAccessModeNotImplemented |
+-------------------------------+
| PvGenAccessModeNotAvailable   |
+-------------------------------+
| PvGenAccessModeUndefined      |
+-------------------------------+

'''

makeEnum('PvGenCache')
PvGenCache.__doc__ = '''
The cached value of the register behind the feature.

+-------------------------------+
| Enum                          |
+===============================+
| PvGenCacheWriteThrough        |
+-------------------------------+
| PvGenCacheWriteAround         |
+-------------------------------+
| PvGenCacheNone                |
+-------------------------------+
| PvGenCacheUndefined           |
+-------------------------------+

'''

makeEnum('PvGenEndianness')
PvGenEndianness.__doc__ = '''
The Data Endianness for the register.

+-------------------------------+
| Enum                          |
+===============================+
| PvGenEndiannessInvalid        |
+-------------------------------+
| PvGenEndiannessLittle         |
+-------------------------------+
| PvGenEndiannessBig            |
+-------------------------------+

'''

makeEnum('PvGenNameSpace')
PvGenNameSpace.__doc__ = '''
PvGenNameSpace Enum

+------------------------+
| Enum                   |
+========================+
| PvGenNameSpaceStandard |
+------------------------+
| PvGenNameSpaceCustom   |
+------------------------+
| PvGenNameSpaceUndefined|
+------------------------+

'''

makeEnum('PvGenRefresh')
PvGenRefresh.__doc__ = '''
Refresh method for a GenApi browser.

GenApi browsers typically provides different methods for refresh the parameters it is displaying. 

===================  ====================================================
Enum
===================  ====================================================
PvGenRefreshPolling  The polling time provided for parameters in the XML are used to control parameter refreshing.
PvGenRefreshAuto	 A round-robbin refresh is performed on all visible features.
PvGenRefreshManual	 Refresh is disabled. The browser may offer a manual Refresh button that can be used to control parameter refreshing. 
===================  ==================================================== 
'''

makeEnum('PvGenRepresentation')
PvGenRepresentation.__doc__ = '''
PvGenRepresentation suggests how the UI should present a numerical feature (:py:class:`PvGenInteger` or :py:class:`PvGenFloat`).

To get a feature\'s representation, use the following methods:

    :func:`PvGenFloat.GetRepresentation`
    :func:`PvGenInteger.GetRepresentation`


===============================   ====================================================
Enum
===============================   ====================================================
PvGenRepresentationLinear	        Linear. Use a slider.
PvGenRepresentationLogarithmic	  Logarithmic. Use a slider. The GenICam standard doesn\'t specify if the feature\'s value represents x or y in the formula x = n ^ y.
PvGenRepresentationBoolean   	    Boolean. The number might be presented as a check box or enable. Use a similar UI as for features from the PvGenBoolean class.
PvGenRepresentationPureNumber	    Pure number. Use an edit box with a decimal display.
PvGenRepresentationHexNumber	    Hex number. Use an edit box with a hexadecimal display.
PvGenRepresentationUndefined	    Not defined; valid representation not provided. 
===============================   ==================================================== 
'''

makeEnum('PvGenSign')
PvGenSign.__doc__ = '''
PvGenSign Enum.

+-------------------------------+
| Enum                          |
+===============================+
| PvGenSignUndefined            |
+-------------------------------+
| PvGenSignUnsigned             |
+-------------------------------+
| PvGenSignSigned               |
+-------------------------------+

'''

makeEnum('PvGenType')
PvGenType.__doc__ = '''
Feature data type (Boolean, integer, etc.)

Each feature has a type that defines the information it contains and how it can be used.
The type also determines the eBUS SDK class used to represent it (and the methods that are available).

To test for a feature\'s type, use :func:`PvGenParameter.GetType`. 

===================     ====================================================
Enum
===================     ====================================================
PvGenTypeInteger        Type: Integer
                            * :py:class:`PvGenInteger`
PvGenTypeEnum           Type: Enumeration
                            * :py:class:`PvGenEnum`
PvGenTypeBoolean        Type: Boolean    
                            * :py:class:`PvGenBoolean`
PvGenTypeString         Type: String
                            * :py:class:`PvGenString`
PvGenTypeCommand        Type: Command
                            * :py:class:`PvGenCommand`
PvGenTypeFloat          Type: Float
                            * :py:class:`PvGenFloat`
PvGenTypeUndefined	    Type: Not defined; valid type not provided.
===================     ====================================================
'''

makeEnum('PvGenVisibility')
PvGenVisibility.__doc__ = '''
Feature (PvGenParameter object) visibility.

Every feature has a visibility setting that suggests how difficult the feature is to use and when
it shouldn\'t be made available (visible) to the end user. The current visibility might be a program-specific 
variable available, for example, in an options or configuration dialog. When opening the 
program for the first time, the visibility would typically be set to beginner.

You can test the feature-by-feature visibility using the following methods:

    PvGenParameter :func:`PvGenParameter.IsVisible`
    PvGenParameter :func:`PvGenParameter.GetVisibility`
    PvGenEnumEntry :func:`PvGenEnumEntry.IsVisible` (for enumeration entries)
    PvGenEnumEntry :func:`PvGenEnumEntry.GetVisibility` (for enumeration entries)

The visibility levels, from lowest to highest:

    Beginner (PvGenVisibilityBeginner)
    Expert (PvGenVisibilityExpert)
    Guru (PvGenVisibilityGuru)
    Invisible (PvGenVisibilityInvisible)

If a program\'s current visibility were set to Expert, the user would expect to 
see Beginner and Expert-level features, but not Guru or Invisible-level features. 

========================    ====================================================
Enum
========================    ====================================================
PvGenVisibilityBeginner     Always visible, to all users.
PvGenVisibilityExpert       Intended for advanced users.
PvGenVisibilityGuru         Intended for very advanced users.
PvGenVisibilityInvisible    Appears in the API, but not the GUI.
PvGenVisibilityUndefined    Not defined; valid visibility not provided. 
========================    ==================================================== 
'''


makeEnum('PvInterfaceType')
PvInterfaceType.__doc__ = '''
The type of interface the object represents. 

================================    ====================================================
Enum
================================    ====================================================
PvInterfaceTypeUnknown	            interface unknown
PvInterfaceTypeUSBHostController	  A USB host controller. USB devices (:py:class:`PvDeviceInfoUSB` or :py:class:`PvDeviceInfoU3V`) are enumerated through this interface.
PvInterfaceTypeNetworkAdapter	      A network interface. Ethernet devices (:py:class:`PvDeviceInfoGEV` or :py:class:`PvDeviceInfoPleoraProtocol`) are enumerated through this interface. 
================================    ====================================================
'''

makeEnum('PvLogLevelEnum')
PvLogLevelEnum.__doc__ = '''
eBUS Log Level Enum.

===================   ====================================================
Enum
===================   ====================================================
PvLogLevelUnknown     Log Level - Unknown
PvLogLevelInfo        Log Level - Info
PvLogLevelError       Log Level - Error
PvLogLevelWarning     Log Level - Warning
PvLogLevelCritical    Log Level - Critical
PvLogLevelDebug       Log Level - Debug
===================   ====================================================
'''

makeEnum('PvMultiPartDataType')
PvMultiPartDataType.__doc__ = '''
Enumeration reprensenting the data type of a section of a multi-part container.

================================    =====================================================================================
Enum
================================    =====================================================================================
PvMultiPartInvalid                  Invalid or uninitialized value.
PvMultiPart2DImage                  2D image.

                                    Color or monochrome (2D) image. This part carries all the pixel data of the given image
                                    (even if the image is represented by a single-plane pixel format).

PvMultiPart2DPlaneOfBiPlanar        2D plane of a two-plane image.

                                    Single plane of a planar (2D) image. The data should be linked with the other planes to get the complete image.
                                    The complete image consists of 2 planes. The planes of a given planar image MUST be placed as consecutive parts within the payload.

PvMultiPart2DPlaneOfTriPlanar       2D plane of a three-plane image.

                                    Single plane of a planar (2D) image. The data should be linked with the other planes to get the complete image.
                                    The complete image consists of 3 planes. The planes of a given planar image MUST be placed as consecutive parts within the payload. 

PvMultiPart2DPlaneOfQuadPlanar      2D plane of a four-plane image.

                                    Single plane of a planar (2D) image. The data should be linked with the other planes to get the complete image.
                                    The complete image consists of 4 planes.  The planes of a given planar image MUST be placed as consecutive parts within the payload. 

PvMultiPart3DImage                  3D image.

                                    3D image (pixel coordinates). This part carries all the pixel data of the given image
                                    (even if the image is represented by a single-plane pixel format, for example when transferring the depth map only).

PvMultiPart3DPlaneOfBiPlanar        3D plane of a two-plane image.
                                    Single plane of a planar 3D image. The data should be linked with the other coordinate planes to get the complete image.
                                    The complete image consists of 2 planes. The planes of a given planar image MUST be placed as consecutive parts within the payload.

PvMultiPart3DPlaneOfTriPlanar       3D plane of a three-plane image.

                                    Single plane of a planar 3D image. The data should be linked with the other coordinate planes to get the complete image.
                                    The complete image consists of 3 planes. The planes of a given planar image MUST be placed as consecutive parts within the payload. 

PvMultiPart3DPlaneOfQuadPlanar      3D plane of a four-plane image.

                                    Single plane of a planar 3D image. The data should be linked with the other coordinate planes to get the complete image.
                                    The complete image consists of 4 planes.  The planes of a given planar image MUST be placed as consecutive parts within the payload.

PvMultiPartConfidenceMap            Confidence map.

                                    Confidence of the individual pixel values. Expresses the level of validity of given pixel values.

                                    Confidence map is always used together with one or more additional image-based parts matching 1:1 dimension-wise.

                                    Each value in the confidence map expresses level of validity of the image pixel at matching position. The data format must be a Confidence PFNC format.

PvMultiPartChunkData                Chunk data section. Always last in a multi-part container.

                                    Part carrying the chunk data in the Extended Chunk Data Mode. This MUST be always the last part in the payload.
                                    There MUST NOT be more than one chunk data part in the payload. 

PvMultiPartJPEGImage                JPEG image.

                                    JPEG compressed image following the guidelines defined for the GVSP JPEG payload type.

                                    The data_type_specific field is used to carry information found in the JPEG data leader packet.

PvMultiPartJPEG2000Image            JEPG 2000 image.

                                    JPEG 2000 compressed image following the guidelines defined for the GVSP JPEG 2000 payload type.

                                    The data type specific field is used to carry information found in the JPEG 2000 data leader packet.
================================    =====================================================================================
'''

makeEnum('PvPayloadType')
PvPayloadType.__doc__ = '''
GVSP payload type. 

================================    =====================================================================================
Enum
================================    =====================================================================================
PvPayloadTypeUndefined              Undefined or non initialized payload type
PvPayloadTypeNone                   A proprietary type used for GigE Vision Validation Framework testing. Refer to :func:`IPvStreamingChannelSource.SetTestPayloadFormatMode` for more details.
PvPayloadTypeImage                  Image payload type. Access from PvBuffer using :func:`PvBuffer.GetImage`.
PvPayloadTypeRawData	            Raw data payload type. Access from PvBuffer using :func:`PvBuffer.GetRawData`.
PvPayloadTypeFile                   File payload type. Not currently supported.
PvPayloadTypeChunkData	            Chunk data payload type. Not currently supported.
PvPayloadTypeExtendedChunkData	    Extended chunk data payload type. Not currently supported.
PvPayloadTypeJPEG                   JPEG compressed image payload type. Not currently supported.
PvPayloadTypeJPEG2000	            JPEG 2000 compressed image payload type. Not currently supported.
PvPayloadTypeH264                   H.264 compressed video stream payload type. Not currently supported.
PvPayloadTypeMultiZoneImage         Multi-zone image payload type. Not currently supported.
PvPayloadTypeMultiPart	            Multi-part payload type.
PvPayloadTypeDeviceSpecificBase	    Base value for device specific payload type. Not currently supported. 
PvPayloadTypePleoraCompressed       Pleora compressed payload type.
================================    =====================================================================================
'''

makeEnum('PvPixelType')
PvPixelType.__doc__ = '''
Pixel types use by image buffers.

** :py:class:`PvBufferConverter` conversion currently supported to the following pixel types:**

  * PvPixelRGBa
  * PvPixelBGRa
  * PvPixelRGB
  * PvPixelBGR
  * PvPixelRGB565
  * PvPixelMono8


Pre GEV 2.0 pixel types:

  * PvPixelRGB8Packed
  * PvPixelBGR8Packed
  * PvPixelRGBA8Packed
  * PvPixelBGRA8Packed
  * PvPixelRGB10Packed
  * PvPixelBGR10Packed
  * PvPixelRGB12Packed
  * PvPixelBGR12Packed
  * PvPixelRGB16Packed
  * PvPixelBGR10V1Packed
  * PvPixelBGR10V2Packed
  * PvPixelYUV411Packed
  * PvPixelYUV422Packed
  * PvPixelYUV422YUYVPacked
  * PvPixelYUV444Packed
  * PvPixelRGB8Planar
  * PvPixelRGB10Planar
  * PvPixelRGB12Planar
  * PvPixelRGB16Planar

'''

PvResultEnum()
PvResultCode.__doc__ = '''
PvResult Code information about the success or failure of the methods you use.

Most successful methods return PV_OK, however, there are exceptions:

Some methods return immediately, but the ultimate success of the method may not be know for some time after (several seconds or more). 
These methods return PV_PENDING. Pending operations are considered successful.

To use result codes (best coding practices):

1. Call a method.
2. Test the result for success. Use :func:`PvResult.IsSuccess`, :func:`PvResult.IsOK`, or test against specific PvResultCode values.


================================    ==============================================================================================
Enum
================================    ==============================================================================================
PV_OK                               Success! (Immediate.)
PV_NOT_INITIALIZED                  An error code hasn\'t been set.

                                    | When initially created, the PvResult object has the value NOT_INITIALIZED.
                                    | The value only occurs when the object is first created; no method returns NOT_INITIALIZED.

PV_NOT_FOUND                        The expected item wasn\'t found.

                                    Possible causes include:

                                    * Connecting to a GigE Vision device that doesn\'t exist (or isn\'t on the network).
                                    * Accessing a non-existent parameter.

PV_CANNOT_OPEN_FILE	                The file doesn\'t exist or can\'t be opened.
PV_NO_MORE_ITEM	                    No more of what was requested is currently available.
PV_NOT_CONNECTED                    The object (PvDevice or PvStream object) isn\'t connected.

                                    Refer to the documentation of the method being called or call 
                                    :func:`PvResult.GetDescription` for further information.
PV_STATE_ERROR	                    The method is (probably) legal, but the system\'s current state doesn\'t allow the action.

                                    For example, you can\'t queue buffers to a stream (using :func:`PvStream.QueueBuffer`) 
                                    before opening it (using :func:`PvStream.Open`).
PV_THREAD_ERROR	                    An error occurred while attempting to perform an operation on a thread like starting,stopping 
                                    or changing priority.
PV_INVALID_DATA_FORMAT	            The data format is not supported for the requested operation.
PV_ABORTED	                        The operation was aborted
PV_NOT_ENOUGH_MEMORY	              Not enough memory. An operation failed to complete as not enough memory was available.
PV_GENERIC_ERROR                    An undefined error occurred.

                                    Refer to the documentation of the method being called or call :func:`PvResult.GetDescription` 
                                    for further information.
PV_INVALID_PARAMETER                A parameter passed to the method is invalid.

                                    Possible causes include:

                                    * A value is out-of-bounds.
                                    * An empty string, where a non-empty string is required.
                                    * A null pointer.

PV_CANCEL                           The user closed a dialog and the operation was not performed. This can occur if the "Cancel" 
                                    button is clicked.
PV_PENDING                          Success! (Pending.)

                                    Returned by :func:`PvStream.QueueBuffer` to indicate that a buffer has been successfully queued 
                                    but the operation is still pending (the data has not yet been received).
PV_TIMEOUT                          The operation timed out.

                                    The operation exceeded its specified maximum wait time without succeeding.
PV_NO_LICENSE                       An eBUS SDK license is missing.

                                    To receive data from a GigE Vision device that does not contain a Pleora video interface,
                                    a receiver license is required. A license is also required to transmit data using 
                                    the eBUS SDK using PvTransmitterGEV. When working with images, a watermark is applied
                                    when no license is present. This is so that the SDK can be used for evaluation purposes.
PV_GENICAM_XML_ERROR                The GenICam XML file could not be loaded into GenApi.

                                    The file could be corrupted or simply incorrectly structured. Some third-party vendors use XML 
                                    files that don\'t conform to the GenApi schema.
PV_CANT_READ_MANIFEST               The manifest table of the device could not be read

                                    Device was discovered but the manifest table could not be read. It may have a corrupt firmware 
                                    load or could be powered incorrectly.
PV_NOT_IMPLEMENTED                  The requested feature or functionality is not implemented.

                                    Can happen when a dynamically selected feature or capability is not implemented in the SDK.
PV_NOT_SUPPORTED                    The requested feature or functionality is not supported.
PV_FILE_ERROR                       A file operation error occured.
PV_ERR_OVERFLOW                     Overflow occurred.

                                    Can happen when a counter overflows or when an attempt was made to write past the upper 
                                    boundary of a file or data structure.
PV_IMAGE_ERROR	                    Error with an image.

                                    May be returned when a corrupt image arrives due to discontinuities in data between 
                                    the camera and the hardware responsible for transmitting packets in the GigE Vision device.
                                    | This can include data overrun, partial and full lines missing.

PV_MISSING_PACKETS                  Some packets are missing in the buffer.

                                    Happens when at least one packet of the buffer is missing when it was released
                                    back to the calling application.
PV_BUFFER_TOO_SMALL                 The buffer was not large enough to hold the payload of the block being received.

                                    Call :func:`PvBuffer.GetRequiredSize` to use the information from the
                                    leader packet to determine the size of buffer that would have been required to 
                                    receive the block.

                                    Call :func:`PvBuffer.Alloc` or :func:`PvBuffer.Attach` to allocate or associate 
                                    an a larger area of memory to receive the next block.
PV_TOO_MANY_RESENDS	                Too many resend packets were requested, buffer acquisition failure.
PV_RESENDS_FAILURE	                Failure to receive all missing packets for a buffer through resend packets.
PV_TOO_MANY_CONSECUTIVE_RESENDS     Buffer reception failed, consecutive missing buffers higher than allowed.

                                    The data receiver may stop attempting to receive a block if a set of consecutive
                                    packets exceeding MaximumResendGroupSize.
PV_AUTO_ABORTED	                    Buffer reception failed.

                                    The data receiver entered a state where so many packets and/or blocks were missing
                                    that all queued buffers were automatically aborted on an internal reset.
PV_BAD_VERSION	                    Some component versions are not compatible.
PV_NO_MORE_ENTRY	                  There are no more entries to retrieve/enumerate.
PV_NO_AVAILABLE_DATA	              There is no available data to enumerate.
PV_NETWORK_ERROR	                  A network error occurred while performing the requested operation.
PV_RESYNC	                          Kick out of the driver because of a forced resynchronisation.
PV_BUSY	                            The resource requested is already in use.
PV_CORRUPTED_DATA	                  The data is corrupted. 
================================    ==============================================================================================
'''

makeEnum('PvScanType')
PvScanType.__doc__ = '''
The Image Source Scan Type.
It could be Area scan or line scan in 3D or not.

+-------------------------------+
| Enum                          |
+===============================+
| PvScanTypeInvalid             |
+-------------------------------+
| PvScanTypeArea                |
+-------------------------------+
| PvScanTypeLine                |
+-------------------------------+
| PvScanTypeArea3D              |
+-------------------------------+
| PvScanTypeLine3D              |
+-------------------------------+

'''

makeEnum('PvStreamType')
PvStreamType.__doc__ = '''
The Image Stream Type.

+-------------------------------+
| Enum                          |
+===============================+
| PvStreamTypeUnknown           |
+-------------------------------+
| PvStreamTypeGEV               |
+-------------------------------+
| PvStreamTypeU3V               |
+-------------------------------+
| PvStreamTypeRTP               |
+-------------------------------+

'''


makeEnum('PvUSBSpeed')
PvUSBSpeed.__doc__ = '''
The speed grade of the USB device or interface. 

=======================    ====================================================
Enum
=======================    ====================================================
PvUSBSpeedUnsupported	     An error indicated an unsupported or mismatched speed
PvUSBSpeedUnknown	         The USB speed is not determined
PvUSBSpeedLow	             The USB speed is low (USB 1.1 maximum 1.5Mbps)
PvUSBSpeedFull	           The USB speed is full (USB 1.1 maximum 12Mbps)
PvUSBSpeedHigh             The USB speed is high (USB 2.0 maximum 480Mbps)
PvUSBSpeedSuper	           The USB speed is super (USB 3.0 maximum 5Gbps) 
=======================    ====================================================
'''

makeEnum('PvUSBStatus')
PvUSBStatus.__doc__ = '''
USB device status. 

==============================    ====================================================
Enum
==============================    ====================================================
PvUSBStatusConnected	          USB device successfully enumerated.
PvUSBStatusFailedEnumeration	  Impossible to enumerate the device.
PvUSBStatusGeneralFailure	      General failure of connection to the USB device.
PvUSBStatusCausedOvercurrent	  The device caused an over current situation on the USB bus.
PvUSBStatusNotEnoughPower	      The device lacks power and thus cannot even be enumerated.
PvUSBStatusNotEnoughBandwidth	  Not enough bandwidth on the USB bus to enumerate the device.
PvUSBStatusHubNestedTooDeeply	  The device is nested too deeply in the hub architecture to be properly enumerated.
PvUSBStatusInLegacyHub	          The device cannot be enumerated as is connected in a legacy hub.
PvUSBStatusEnumerating	          The device is currently being enumerated.
PvUSBStatusReset	              The device is currently restarting. 
==============================    ====================================================
'''

makeEnum('PvUserSetState')
PvUserSetState.__doc__ = '''
UserSetState enumeration type. 

==============================    ====================================================
Enum
==============================    ====================================================
PvUserSetStateSaveStart	          The device is about to start a UserSetSave
PvUserSetStateSaveCompleted	      The device has just completed a UserSetSave
PvUserSetStateLoadStart	          The device is about to start a UserSetLoad
PvUserSetStateLoadCompleted	      The device has just completed a UserSetLoad
==============================    ====================================================
'''

del makeEnum  # cleaning up the namespace
del PvResultEnum
del Enum


