#!/bin/sh

# Get the executable's absolute path
DIRNAME=`dirname $0`
DIRNAME=`cd $DIRNAME/..; pwd`

# set env. vars
export PUREGEV_ROOT=$DIRNAME
export GENICAM_ROOT=$DIRNAME/lib/genicam
export GENICAM_ROOT_V3_1=$GENICAM_ROOT
export GENICAM_LOG_CONFIG=$DIRNAME/lib/genicam/log/config/DefaultLogging.properties
export GENICAM_LOG_CONFIG_V3_1=$GENICAM_LOG_CONFIG
export GENICAM_CACHE_V3_1=$HOME/.config/Pleora/genicam_cache_v3_1
export GENICAM_CACHE=$GENICAM_CACHE_V3_1
mkdir -p $GENICAM_CACHE

# add to the LD_LIBRARIES_PATH
if ! echo ${LD_LIBRARY_PATH} | /bin/grep -q $PUREGEV_ROOT/lib; then
   if [ "$LD_LIBRARY_PATH" = "" ]; then
      LD_LIBRARY_PATH=$PUREGEV_ROOT/lib
   else
      LD_LIBRARY_PATH=$PUREGEV_ROOT/lib:${LD_LIBRARY_PATH}
   fi
fi

if [ `uname -m` = "x86_64" ]; then
  GENICAM_LIB_DIR=bin/Linux64_x64
elif [ `uname -m` = "ppc" ]; then
  GENICAM_LIB_DIR=bin/Linux32_PPC
elif [ `uname -m` = "aarch64" ]; then
  GENICAM_LIB_DIR=bin/Linux64_ARM
else
  GENICAM_LIB_DIR=bin/Linux32_i86
fi

if ! echo ${LD_LIBRARY_PATH} | /bin/grep -q $GENICAM_ROOT/$GENICAM_LIB_DIR; then
   LD_LIBRARY_PATH=$GENICAM_ROOT/$GENICAM_LIB_DIR:${LD_LIBRARY_PATH}
fi

export LD_LIBRARY_PATH

if ! echo ${PYTHONPATH} | grep -q ${PUREGEV_ROOT}/lib; then
  PYTHONPATH=${PUREGEV_ROOT}/lib:${PYTHONPATH}
fi

export PYTHONPATH

APPPATH=$PUREGEV_ROOT/bin/$*
if [ -f $APPPATH ]; then
    $APPPATH
fi

